﻿using CocosSharp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;


namespace Xamarin.GameWatch.Fire
{    
    public class MainScene : CCScene
    {
        
        CCLayer layer;

        public MainScene(CCGameView gameView) : base(gameView)
        {
            layer = new CCLayer();
            this.AddChild(layer);

            #region Création de notre décor animé
            CreateBackGround();
            CreateSmoke();
            CreateCastle();
            CreateFire();
            #endregion

            #region Création des acteurs
            CreateMarioLuigiLeft();
            CreateMarioLuigiCenter();
            CreateMarioLuigiRight();
            CreateYoshi();
            CreateGoal();
            #endregion

            //Création du listener
            CreateTouchListener();

            //Logique du jeu
            Schedule(RunGameLogic);
        }

        #region Décor animé
        private void CreateBackGround()
        {
            var sprite = new CCSprite("title.png");
            sprite.AnchorPoint = new CCPoint(0, 0);
            sprite.IsAntialiased = false;
            layer.AddChild(sprite);
        }

        private void CreateCastle()
        {
            var sprite = new CCSprite("castle.png");
            sprite.AnchorPoint = new CCPoint(0, 0);
            sprite.PositionY = layer.ContentSize.Height - sprite.ContentSize.Height;
            sprite.IsAntialiased = false;
            layer.AddChild(sprite);
        }

        private void CreateSmoke()
        {   
            var sprite = CreateAnimationFromSpriteSheet("smoke.plist", "smoke", 0.5f);
            sprite.AnchorPoint = new CCPoint(0, 0);
            sprite.PositionX = 10;
            sprite.PositionY = layer.ContentSize.Height - sprite.ContentSize.Height;
            sprite.IsAntialiased = false;
            layer.AddChild(sprite);
        }

        private void CreateFire()
        {
            var sprite = CreateAnimationFromSpriteSheet("fire.plist", "fire", 0.3f);
            sprite.AnchorPoint = new CCPoint(0, 0);            
            sprite.PositionY = layer.ContentSize.Height - sprite.ContentSize.Height;
            sprite.IsAntialiased = false;
            layer.AddChild(sprite);
        }
        #endregion

        #region Acteurs
        private CCSprite _spriteMLLeft;
        private void CreateMarioLuigiLeft()
        {
            _spriteMLLeft = CreateAnimationFromSpriteSheet("paddlegauche.plist", "paddlegauche", 0.4f);
            _spriteMLLeft.AnchorPoint = new CCPoint(0, 0);
            _spriteMLLeft.PositionX = 43; _spriteMLLeft.PositionY = 35;
            _spriteMLLeft.IsAntialiased = false;
            layer.AddChild(_spriteMLLeft);
        }

        private CCSprite _spriteMLCenter;
        private void CreateMarioLuigiCenter()
        {
            _spriteMLCenter = CreateAnimationFromSpriteSheet("paddlecentre.plist", "paddlecentre", 0.4f);
            _spriteMLCenter.AnchorPoint = new CCPoint(0, 0);
            _spriteMLCenter.PositionX = 90; _spriteMLCenter.PositionY = 35;
            _spriteMLCenter.IsAntialiased = false;
            layer.AddChild(_spriteMLCenter);
            _spriteMLCenter.RunAction(new CCHide());
        }

        private CCSprite _spriteMLRight;
        private void CreateMarioLuigiRight()
        {
            _spriteMLRight = CreateAnimationFromSpriteSheet("paddledroite.plist", "paddledroite", 0.4f);
            _spriteMLRight.AnchorPoint = new CCPoint(0, 0);
            _spriteMLRight.PositionX = 137; _spriteMLRight.PositionY = 35;
            _spriteMLRight.IsAntialiased = false;
            layer.AddChild(_spriteMLRight);
            _spriteMLRight.RunAction(new CCHide());
        }

        private CCSprite _spriteGoal;
        private void CreateGoal()
        {
            _spriteGoal = CreateAnimationFromSpriteSheet("goal.plist", "goal", 0.4f, false);
            _spriteGoal.AnchorPoint = new CCPoint(0, 0);
            _spriteGoal.PositionX = 190; _spriteGoal.PositionY = 41;
            _spriteGoal.IsAntialiased = false;
            layer.AddChild(_spriteGoal);            
        }

        private CCSprite _spriteYoshi;
        private void CreateYoshi()
        {
            _spriteYoshi = CreateAnimationFromSpriteSheet("yoshi.plist", "yoshi", 0.2f);
            _spriteYoshi.AnchorPoint = new CCPoint(0, 0);
            _spriteYoshi.PositionX = 2; _spriteYoshi.PositionY = 113;
            _spriteYoshi.IsAntialiased = false;
            layer.AddChild(_spriteYoshi);
            _spriteYoshi.RunAction(new CCHide());
        }

        private void JumpYoshi()
        {
            totalFrame = 2;            
            _spriteYoshi.PositionX = 2; _spriteYoshi.PositionY = 113;
            _spriteYoshi.RunAction(new CCShow());
        }

        private CCSprite _spriteYoshiBoum;
        private void CreateYoshiBoom(float positionX)
        {
            _spriteYoshiBoum = CreateAnimationFromSpriteSheet("yoshiboum.plist", "yoshiboum", 0.3f);
            _spriteYoshiBoum.AnchorPoint = new CCPoint(0, 0);
            _spriteYoshiBoum.PositionX = positionX; _spriteYoshiBoum.PositionY = 30;
            _spriteYoshiBoum.IsAntialiased = false;
            layer.AddChild(_spriteYoshiBoum);            
        }
        #endregion

        #region Listener
        private void CreateTouchListener()
        {
            var touchListener = new CCEventListenerTouchAllAtOnce();
            touchListener.OnTouchesBegan = HandleTouchesBegan;
            layer.AddEventListener(touchListener);
        }

        private void HandleTouchesBegan(List<CCTouch> touches, CCEvent touchEvent)
        {
            if (touches.Count > 0)
            {                
                //Tap a droite ou a gauche de l'écran
                if (touches[0].Location.X > 120)    //Droite
                {
                    if (_spriteMLLeft.Visible)
                    {
                        _spriteMLLeft.RunAction(new CCHide());
                        _spriteMLCenter.RunAction(new CCShow());
                        _spriteMLRight.RunAction(new CCHide());
                    }
                    else if (_spriteMLCenter.Visible)
                    {
                        _spriteMLLeft.RunAction(new CCHide());
                        _spriteMLCenter.RunAction(new CCHide());
                        _spriteMLRight.RunAction(new CCShow());
                    }
                }
                else                                //Gauche
                {   
                    if (_spriteMLCenter.Visible)
                    {
                        _spriteMLLeft.RunAction(new CCShow());
                        _spriteMLCenter.RunAction(new CCHide());
                        _spriteMLRight.RunAction(new CCHide());
                    }
                    else if (_spriteMLRight.Visible)
                    {
                        _spriteMLLeft.RunAction(new CCHide());
                        _spriteMLCenter.RunAction(new CCShow());
                        _spriteMLRight.RunAction(new CCHide());
                    }
                }
            }
        }
        #endregion

        //Constante de vitesse de jeu
        float totalFrame = 2;

        void RunGameLogic(float frameTimeInSeconds)
        {
            //Définition de la vitesse de jeu
            totalFrame += (frameTimeInSeconds * 20);

            //Yoshi doit sauter
            if (!_spriteYoshi.Visible) JumpYoshi();

            //OOn trace un rectangle invisible autour de Mario et Luigi
            //Cela nous permettra de gérer la collision avec Yoshi pour le faire rebondir ou non
            CCRect smRect;
            if (_spriteMLCenter.Visible)
                smRect = new CCRect(_spriteMLCenter.PositionX, _spriteMLCenter.PositionY,
                                    _spriteMLCenter.ContentSize.Width, _spriteMLCenter.ContentSize.Height - 13);
            else if (_spriteMLRight.Visible)
                smRect = new CCRect(_spriteMLRight.PositionX, _spriteMLRight.PositionY,
                                    _spriteMLRight.ContentSize.Width, _spriteMLRight.ContentSize.Height - 13);
            else
                smRect = new CCRect(_spriteMLLeft.PositionX, _spriteMLLeft.PositionY, 
                                    _spriteMLLeft.ContentSize.Width, _spriteMLLeft.ContentSize.Height - 13);

            //PREMIERE BOUCLE DU SAUT
            if (Math.Floor(totalFrame) > _spriteYoshi.PositionX && _spriteYoshi.PositionX < 59)
            {
                _spriteYoshi.PositionX += 1;
                _spriteYoshi.PositionY = (float)((Math.Abs(Math.Cos((_spriteYoshi.PositionX - 20)
                    * ((Math.PI / 2) / (58 - 20)))))
                    * (120 - 52) + 52);
            }

            //DEUXIEME BOUCLE DU SAUT
            if (Math.Floor(totalFrame) > _spriteYoshi.PositionX && (_spriteYoshi.PositionX >= 59 && _spriteYoshi.PositionX < 105))
            {
                _spriteYoshi.PositionX += 1;
                _spriteYoshi.PositionY = (float)((Math.Abs(Math.Cos(((_spriteYoshi.PositionX - 59)
                    * Math.PI / (105 - 59)) + (Math.PI / 2))))
                    * (105 - 52) + 52);
            }

            //TROISIEME BOUCLE DU SAUT
            if (Math.Floor(totalFrame) > _spriteYoshi.PositionX && (_spriteYoshi.PositionX >= 105 && _spriteYoshi.PositionX < 152))
            {
                _spriteYoshi.PositionX += 1;
                _spriteYoshi.PositionY = (float)((Math.Abs(Math.Cos(((_spriteYoshi.PositionX - 105)
                    * Math.PI / (152 - 105)) + (Math.PI / 2))))
                    * (85 - 52) + 52);
            }

            //DERNIERE BOUCLE POUR ALLER DANS LE CARROSSE
            if (Math.Floor(totalFrame) > _spriteYoshi.PositionX && (_spriteYoshi.PositionX >= 152 && _spriteYoshi.PositionX < 202))
            {
                _spriteYoshi.PositionX += 1;
                _spriteYoshi.PositionY = (float)((Math.Abs(Math.Cos(((_spriteYoshi.PositionX - 152)
                    * Math.PI / (202 - 152)) + (Math.PI / 2))))
                    * (75 - 52) + 52);
            }

            //YOSHI EST DANS LE CARROSSE :-)
            if (_spriteYoshi.PositionX >= 202)
            {
                _spriteYoshi.RunAction(new CCHide());                
            }            
            else if (_spriteYoshi.PositionY <= 53)
            {
                //YOSHI EST PROCHE DU SOL, TRAMPOLINE PRESENT ?
                if (!_spriteYoshi.BoundingBoxTransformedToWorld.IntersectsRect(smRect))
                    GameOver(_spriteYoshi.PositionX);
            }
        }

        private void GameOver(float positionX)
        {
            UnscheduleAll();
            _spriteYoshi.RunAction(new CCHide());
            CreateYoshiBoom(positionX);
        }

        private CCSprite CreateAnimationFromSpriteSheet(string plist, string frame, float delay, bool launchAnimation=true)
        {
            //Déclaration de notre animation et du mode de répétition
            //Ici RepeatForever = animation en boucle infini
            CCAnimation animation;
            CCRepeatForever repeatForever;
            
            var spriteSheet = new CCSpriteSheet(plist);
            var animationFrames = spriteSheet.Frames.FindAll((x) => x.TextureFilename.StartsWith(frame));

            //Le delay est la vitesse d'animation
            animation = new CCAnimation(animationFrames, delay);
            repeatForever = new CCRepeatForever(new CCAnimate(animation));

            var sprite= new CCSprite(animationFrames.First());            
            if (launchAnimation) sprite.RunAction(repeatForever);

            return sprite;
        }

    }
}
