/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Accordion;
import org.apache.pivot.wtk.AccordionAttributeListener;
import org.apache.pivot.wtk.AccordionListener;
import org.apache.pivot.wtk.AccordionSelectionListener;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonGroup;
import org.apache.pivot.wtk.ButtonGroupListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentStateListener;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.content.ButtonData;
import org.apache.pivot.wtk.content.ButtonDataRenderer;
import org.apache.pivot.wtk.effects.ClipDecorator;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.effects.easing.Easing;
import org.apache.pivot.wtk.effects.easing.Quartic;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.ButtonSkin;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraAccordionSkin
extends ContainerSkin
implements AccordionListener,
AccordionSelectionListener,
AccordionAttributeListener {
    private ButtonGroup panelHeaderGroup = new ButtonGroup();
    private ArrayList<PanelHeader> panelHeaders = new ArrayList();
    private Color borderColor;
    private Insets padding;
    private Font buttonFont;
    private Color buttonColor;
    private Color disabledButtonColor;
    private Color buttonBackgroundColor;
    private Insets buttonPadding;
    private Color buttonBevelColor;
    private SelectionChangeTransition selectionChangeTransition = null;
    private ClipDecorator previousSelectedPanelClipDecorator = new ClipDecorator();
    private ClipDecorator selectedPanelClipDecorator = new ClipDecorator();
    private ComponentStateListener panelStateListener = new ComponentStateListener.Adapter(){

        public void enabledChanged(Component component) {
            Accordion accordion = (Accordion)TerraAccordionSkin.this.getComponent();
            int n = accordion.getPanels().indexOf(component);
            ((PanelHeader)((Object)TerraAccordionSkin.this.panelHeaders.get(n))).setEnabled(component.isEnabled());
        }
    };
    public static final int GRADIENT_BEVEL_THICKNESS = 4;
    private static final Button.DataRenderer DEFAULT_DATA_RENDERER = new ButtonDataRenderer(){
        {
            this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
        }

        public void render(Object object, Button button, boolean bl) {
            Component component = (Component)object;
            super.render((Object)new ButtonData(Accordion.getIcon((Component)component), Accordion.getLabel((Component)component)), button, bl);
        }
    };
    private static final int SELECTION_CHANGE_DURATION = 250;
    private static final int SELECTION_CHANGE_RATE = 30;

    public TerraAccordionSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(terraTheme.getColor(4));
        this.borderColor = terraTheme.getColor(7);
        this.padding = new Insets(4);
        this.buttonFont = terraTheme.getFont().deriveFont(1);
        this.buttonColor = terraTheme.getColor(15);
        this.disabledButtonColor = terraTheme.getColor(7);
        this.buttonBackgroundColor = terraTheme.getColor(10);
        this.buttonPadding = new Insets(3, 4, 3, 4);
        this.buttonBevelColor = TerraTheme.brighten(this.buttonBackgroundColor);
        this.panelHeaderGroup.getButtonGroupListeners().add((Object)new ButtonGroupListener.Adapter(){

            public void selectionChanged(ButtonGroup buttonGroup, Button button) {
                Button button2 = TerraAccordionSkin.this.panelHeaderGroup.getSelection();
                int n = button2 == null ? -1 : TerraAccordionSkin.this.panelHeaders.indexOf((Object)((PanelHeader)button2));
                Accordion accordion = (Accordion)TerraAccordionSkin.this.getComponent();
                accordion.setSelectedIndex(n);
            }
        });
    }

    public void setSize(int n, int n2) {
        if (this.selectionChangeTransition != null) {
            this.selectionChangeTransition.end();
        }
        super.setSize(n, n2);
    }

    public void install(Component component) {
        super.install(component);
        Accordion accordion = (Accordion)component;
        accordion.getAccordionListeners().add((Object)this);
        accordion.getAccordionSelectionListeners().add((Object)this);
        accordion.getAccordionAttributeListeners().add((Object)this);
        for (Component component2 : accordion.getPanels()) {
            PanelHeader panelHeader = new PanelHeader(component2);
            panelHeader.setButtonGroup(this.panelHeaderGroup);
            this.panelHeaders.add((Object)panelHeader);
            accordion.add((Component)panelHeader);
            panelHeader.setEnabled(component2.isEnabled());
            component2.getComponentStateListeners().add((Object)this.panelStateListener);
        }
    }

    public int getPreferredWidth(int n) {
        Accordion accordion = (Accordion)this.getComponent();
        int n2 = 0;
        for (Object object : this.panelHeaders) {
            n2 = Math.max(object.getPreferredWidth(), n2);
        }
        int n3 = 0;
        for (Component component : accordion.getPanels()) {
            n3 = Math.max(component.getPreferredWidth(), n3);
        }
        int n4 = Math.max(n2, n3 + (this.padding.left + this.padding.right + 2));
        return n4;
    }

    public int getPreferredHeight(int n) {
        Accordion accordion = (Accordion)this.getComponent();
        int n2 = 0;
        for (Object object : this.panelHeaders) {
            n2 += object.getPreferredHeight(n) - 1;
        }
        if (n != -1) {
            n = Math.max(0, n - (this.padding.left + this.padding.right + 2));
        }
        int n3 = 0;
        for (Component component : accordion.getPanels()) {
            n3 = Math.max(n3, component.getPreferredHeight(n));
        }
        return n2 += n3 + this.padding.top + this.padding.bottom + 2;
    }

    public Dimensions getPreferredSize() {
        Accordion accordion = (Accordion)this.getComponent();
        int n = 0;
        int n2 = 0;
        for (PanelHeader panelHeader : this.panelHeaders) {
            Dimensions dimensions = panelHeader.getPreferredSize();
            n2 = Math.max(dimensions.width, n2);
            n += dimensions.height - 1;
        }
        int n3 = 0;
        int n4 = 0;
        for (Component component : accordion.getPanels()) {
            Dimensions dimensions = component.getPreferredSize();
            n3 = Math.max(dimensions.width, n3);
            n4 = Math.max(n4, dimensions.height);
        }
        int n5 = Math.max(n2, n3 + (this.padding.left + this.padding.right + 2));
        return new Dimensions(n5, n += n4 + this.padding.top + this.padding.bottom + 2);
    }

    public int getBaseline(int n, int n2) {
        int n3 = -1;
        if (this.panelHeaders.getLength() > 0) {
            PanelHeader panelHeader = (PanelHeader)((Object)this.panelHeaders.get(0));
            n3 = panelHeader.getBaseline(n, panelHeader.getPreferredHeight(n));
        }
        return n3;
    }

    public void layout() {
        Accordion accordion = (Accordion)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = Math.max(n - (this.padding.left + this.padding.right + 2), 0);
        int n4 = 0;
        int n5 = 0;
        if (this.selectionChangeTransition == null) {
            n4 = n2;
            for (PanelHeader panelHeader : this.panelHeaders) {
                panelHeader.setSize(n, panelHeader.getPreferredHeight(n));
                n4 -= panelHeader.getHeight() - 1;
            }
            n4 = Math.max(n4 - 2, 0);
            n5 = Math.max(n4 - (this.padding.top + this.padding.bottom), 0);
        } else {
            n4 = this.selectionChangeTransition.toPanel.getHeight() + (this.padding.top + this.padding.bottom);
        }
        Iterator iterator = accordion.getPanels();
        int n6 = 0;
        int n7 = iterator.getLength();
        for (int i = 0; i < n7; ++i) {
            Component component = iterator.get(i);
            PanelHeader panelHeader = (PanelHeader)((Object)this.panelHeaders.get(i));
            panelHeader.setLocation(0, n6);
            n6 += panelHeader.getHeight() - 1;
            if (this.selectionChangeTransition == null) {
                Component component2 = accordion.getSelectedPanel();
                if (component == component2) {
                    component.setVisible(true);
                    component.setSize(n3, n5);
                    component.setLocation(this.padding.left + 1, n6 + this.padding.top + 1);
                    n6 += n4 + 1;
                    continue;
                }
                component.setVisible(false);
                continue;
            }
            if (this.selectionChangeTransition.isRunning()) {
                if (component == this.selectionChangeTransition.fromPanel) {
                    component.setLocation(this.padding.left + 1, n6 + this.padding.top + 1);
                    int n8 = Math.round((float)n4 * (1.0f - this.selectionChangeTransition.getEasedPercentComplete()));
                    this.previousSelectedPanelClipDecorator.setWidth(n3);
                    this.previousSelectedPanelClipDecorator.setHeight(n8);
                    n6 += n8 + 1;
                }
                if (component != this.selectionChangeTransition.toPanel) continue;
                component.setLocation(this.padding.left + 1, n6 + this.padding.top + 1);
                int n9 = Math.round((float)n4 * this.selectionChangeTransition.getEasedPercentComplete());
                this.selectedPanelClipDecorator.setWidth(n3);
                this.selectedPanelClipDecorator.setHeight(n9);
                n6 += n9;
                continue;
            }
            this.selectionChangeTransition.toPanel.setSize(this.selectionChangeTransition.fromPanel.getSize());
            this.selectionChangeTransition.toPanel.setVisible(true);
        }
    }

    public void paint(Graphics2D graphics2D) {
        super.paint(graphics2D);
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setPaint(this.borderColor);
        GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (int)n2);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = color;
        this.repaintComponent();
    }

    public final void setBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public final void setPadding(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(number.intValue());
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)string));
    }

    public Font getButtonFont() {
        return this.buttonFont;
    }

    public void setButtonFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("buttonFont is null.");
        }
        this.buttonFont = font;
        this.invalidateComponent();
    }

    public final void setButtonFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setButtonFont(TerraAccordionSkin.decodeFont((String)string));
    }

    public final void setButtonFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setButtonFont(Theme.deriveFont(dictionary));
    }

    public Color getButtonColor() {
        return this.buttonColor;
    }

    public void setButtonColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("buttonColor is null.");
        }
        this.buttonColor = color;
        this.repaintComponent();
    }

    public final void setButtonColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("buttonColor is null.");
        }
        this.setButtonColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Insets getButtonPadding() {
        return this.buttonPadding;
    }

    public void setButtonPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("buttonPadding is null.");
        }
        this.buttonPadding = insets;
        this.invalidateComponent();
    }

    public final void setButtonPadding(int n) {
        this.setButtonPadding(new Insets(n));
    }

    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = super.keyPressed(component, n, keyLocation);
        if (!bl) {
            Accordion accordion = (Accordion)this.getComponent();
            Accordion.PanelSequence panelSequence = accordion.getPanels();
            Keyboard.Modifier modifier = Platform.getCommandModifier();
            if (Keyboard.isPressed((Keyboard.Modifier)modifier)) {
                int n2 = -1;
                switch (n) {
                    case 49: 
                    case 97: {
                        n2 = 0;
                        break;
                    }
                    case 50: 
                    case 98: {
                        n2 = 1;
                        break;
                    }
                    case 51: 
                    case 99: {
                        n2 = 2;
                        break;
                    }
                    case 52: 
                    case 100: {
                        n2 = 3;
                        break;
                    }
                    case 53: 
                    case 101: {
                        n2 = 4;
                        break;
                    }
                    case 54: 
                    case 102: {
                        n2 = 5;
                        break;
                    }
                    case 55: 
                    case 103: {
                        n2 = 6;
                        break;
                    }
                    case 56: 
                    case 104: {
                        n2 = 7;
                        break;
                    }
                    case 57: 
                    case 105: {
                        n2 = 8;
                    }
                }
                if (n2 >= 0 && n2 < panelSequence.getLength() && panelSequence.get(n2).isEnabled()) {
                    accordion.setSelectedIndex(n2);
                    bl = true;
                }
            } else if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.ALT)) {
                int n3 = panelSequence.getLength();
                int n4 = accordion.getSelectedIndex();
                switch (n) {
                    case 38: {
                        while (--n4 >= 0 && !panelSequence.get(n4).isEnabled()) {
                        }
                        break;
                    }
                    case 40: {
                        while (++n4 < n3 && !panelSequence.get(n4).isEnabled()) {
                        }
                        break;
                    }
                }
                if (n4 >= 0 && n4 < n3 && panelSequence.get(n4).isEnabled()) {
                    accordion.setSelectedIndex(n4);
                    bl = true;
                }
            }
        }
        return bl;
    }

    public void panelInserted(Accordion accordion, int n) {
        if (this.selectionChangeTransition != null) {
            this.selectionChangeTransition.end();
        }
        Component component = accordion.getPanels().get(n);
        PanelHeader panelHeader = new PanelHeader(component);
        panelHeader.setButtonGroup(this.panelHeaderGroup);
        this.panelHeaders.insert((Object)panelHeader, n);
        accordion.add((Component)panelHeader);
        panelHeader.setEnabled(component.isEnabled());
        component.getComponentStateListeners().add((Object)this.panelStateListener);
        if (accordion.getPanels().getLength() == 1) {
            accordion.setSelectedIndex(0);
        }
        this.invalidateComponent();
    }

    public void panelsRemoved(Accordion accordion, int n, Sequence<Component> sequence) {
        if (this.selectionChangeTransition != null) {
            this.selectionChangeTransition.end();
        }
        Sequence sequence2 = this.panelHeaders.remove(n, sequence.getLength());
        int n2 = sequence2.getLength();
        for (int i = 0; i < n2; ++i) {
            PanelHeader panelHeader = (PanelHeader)((Object)sequence2.get(i));
            panelHeader.setButtonGroup(null);
            Component component = (Component)panelHeader.getButtonData();
            component.getComponentStateListeners().remove((Object)this.panelStateListener);
            accordion.remove((Component)panelHeader);
        }
        this.invalidateComponent();
    }

    public Vote previewSelectedIndexChange(final Accordion accordion, final int n) {
        Vote vote = Vote.APPROVE;
        if (accordion.isShowing()) {
            if (this.selectionChangeTransition == null) {
                int n2 = accordion.getSelectedIndex();
                if (n != -1 && n2 != -1) {
                    Component component = accordion.getPanels().get(n2);
                    Component component2 = accordion.getPanels().get(n);
                    this.selectionChangeTransition = new SelectionChangeTransition(component, component2);
                    this.layout();
                    this.selectionChangeTransition.start(new TransitionListener(){

                        public void transitionCompleted(Transition transition) {
                            accordion.setSelectedIndex(n);
                            TerraAccordionSkin.this.selectionChangeTransition = null;
                            TerraAccordionSkin.this.invalidateComponent();
                        }
                    });
                    vote = Vote.DEFER;
                }
            } else if (this.selectionChangeTransition.isRunning()) {
                vote = Vote.DEFER;
            }
        }
        return vote;
    }

    public void selectedIndexChangeVetoed(Accordion accordion, Vote vote) {
        if (vote == Vote.DENY && this.selectionChangeTransition != null) {
            this.selectionChangeTransition.stop();
            this.selectionChangeTransition = null;
            this.invalidateComponent();
        }
    }

    public void selectedIndexChanged(Accordion accordion, int n) {
        int n2 = accordion.getSelectedIndex();
        if (n2 == -1) {
            Button button = this.panelHeaderGroup.getSelection();
            if (button != null) {
                button.setSelected(false);
            }
        } else {
            Button button = (Button)this.panelHeaders.get(n2);
            button.setSelected(true);
            Component component = accordion.getPanels().get(n2);
            component.requestFocus();
        }
        this.invalidateComponent();
    }

    public void labelChanged(Accordion accordion, Component component, String string) {
        this.invalidateComponent();
    }

    public void iconChanged(Accordion accordion, Component component, Image image) {
        this.invalidateComponent();
    }

    public class SelectionChangeTransition
    extends Transition {
        public final Component fromPanel;
        public final Component toPanel;
        private Easing easing;

        public SelectionChangeTransition(Component component, Component component2) {
            super(250, 30, false);
            this.easing = new Quartic();
            this.fromPanel = component;
            this.toPanel = component2;
        }

        public float getEasedPercentComplete() {
            return this.easing.easeOut((float)this.getElapsedTime(), 0.0f, 1.0f, (float)this.getDuration());
        }

        public void start(TransitionListener transitionListener) {
            this.fromPanel.getDecorators().add((Decorator)TerraAccordionSkin.this.previousSelectedPanelClipDecorator);
            this.toPanel.getDecorators().add((Decorator)TerraAccordionSkin.this.selectedPanelClipDecorator);
            TerraAccordionSkin.this.getComponent().setEnabled(false);
            super.start(transitionListener);
        }

        public void stop() {
            this.fromPanel.getDecorators().remove((Decorator)TerraAccordionSkin.this.previousSelectedPanelClipDecorator);
            this.toPanel.getDecorators().remove((Decorator)TerraAccordionSkin.this.selectedPanelClipDecorator);
            TerraAccordionSkin.this.getComponent().setEnabled(true);
            super.stop();
        }

        protected void update() {
            TerraAccordionSkin.this.invalidateComponent();
        }
    }

    protected class PanelHeaderSkin
    extends ButtonSkin {
        protected PanelHeaderSkin() {
        }

        public int getPreferredWidth(int n) {
            PanelHeader panelHeader = (PanelHeader)this.getComponent();
            Button.DataRenderer dataRenderer = panelHeader.getDataRenderer();
            dataRenderer.render(panelHeader.getButtonData(), (Button)panelHeader, false);
            int n2 = dataRenderer.getPreferredWidth(-1) + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.left + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.right + 2;
            return n2;
        }

        public int getPreferredHeight(int n) {
            PanelHeader panelHeader = (PanelHeader)this.getComponent();
            Button.DataRenderer dataRenderer = panelHeader.getDataRenderer();
            dataRenderer.render(panelHeader.getButtonData(), (Button)panelHeader, false);
            int n2 = n;
            if (n2 != -1) {
                n2 = Math.max(n2 - (((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.left + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.right + 2), 0);
            }
            int n3 = dataRenderer.getPreferredHeight(n2) + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.top + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.bottom + 2;
            return n3;
        }

        public Dimensions getPreferredSize() {
            PanelHeader panelHeader = (PanelHeader)this.getComponent();
            Button.DataRenderer dataRenderer = panelHeader.getDataRenderer();
            dataRenderer.render(panelHeader.getButtonData(), (Button)panelHeader, false);
            Dimensions dimensions = dataRenderer.getPreferredSize();
            int n = dimensions.width + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.left + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.right + 2;
            int n2 = dimensions.height + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.top + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.bottom + 2;
            return new Dimensions(n, n2);
        }

        public int getBaseline(int n, int n2) {
            PanelHeader panelHeader = (PanelHeader)this.getComponent();
            Button.DataRenderer dataRenderer = panelHeader.getDataRenderer();
            dataRenderer.render(panelHeader.getButtonData(), (Button)panelHeader, false);
            int n3 = Math.max(n - (((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.left + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.right + 2), 0);
            int n4 = Math.max(n2 - (((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.top + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.bottom + 2), 0);
            int n5 = dataRenderer.getBaseline(n3, n4);
            if (n5 != -1) {
                n5 += ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.top + 1;
            }
            return n5;
        }

        public void paint(Graphics2D graphics2D) {
            PanelHeader panelHeader = (PanelHeader)this.getComponent();
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics2D.setPaint(new GradientPaint((float)n / 2.0f, 0.0f, TerraAccordionSkin.this.buttonBevelColor, (float)n / 2.0f, n2, TerraAccordionSkin.this.buttonBackgroundColor));
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setPaint(TerraAccordionSkin.this.borderColor);
            GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (int)n2);
            Button.DataRenderer dataRenderer = panelHeader.getDataRenderer();
            dataRenderer.render(panelHeader.getButtonData(), (Button)panelHeader, this.highlighted);
            dataRenderer.setSize(Math.max(n - (((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.left + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.right + 2), 0), Math.max(this.getHeight() - (((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.top + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.bottom + 2), 0));
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.translate(((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.left + 1, ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.top + 1);
            graphics2D2.clipRect(0, 0, dataRenderer.getWidth(), dataRenderer.getHeight());
            dataRenderer.paint(graphics2D2);
            graphics2D2.dispose();
        }

        public boolean isFocusable() {
            return false;
        }

        public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
            PanelHeader panelHeader = (PanelHeader)this.getComponent();
            panelHeader.press();
            return true;
        }

        public Font getFont() {
            return TerraAccordionSkin.this.buttonFont;
        }

        public Color getColor() {
            return TerraAccordionSkin.this.buttonColor;
        }

        public Color getDisabledColor() {
            return TerraAccordionSkin.this.disabledButtonColor;
        }
    }

    protected class PanelHeader
    extends Button {
        public PanelHeader(Component component) {
            super((Object)component);
            super.setToggleButton(true);
            this.setDataRenderer(DEFAULT_DATA_RENDERER);
            this.setSkin((Skin)new PanelHeaderSkin());
        }

        public void setToggleButton(boolean bl) {
            throw new UnsupportedOperationException();
        }

        public void setTriState(boolean bl) {
            throw new UnsupportedOperationException();
        }

        public void press() {
            this.setSelected(true);
            super.press();
        }
    }
}

