/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Map;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.wtk.Alert;
import org.apache.pivot.wtk.AlertListener;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.skin.terra.TerraDialogSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;
import org.apache.pivot.wtkx.WTKXSerializer;

public class TerraAlertSkin
extends TerraDialogSkin
implements AlertListener {
    private ArrayList<Button> optionButtons = new ArrayList();
    private static Map<String, ?> commandButtonStyles;

    public TerraAlertSkin() {
        this.setResizable(false);
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(terraTheme.getColor(9));
    }

    @Override
    public void install(Component component) {
        super.install(component);
        Alert alert = (Alert)component;
        alert.getAlertListeners().add((Object)this);
        WTKXSerializer wTKXSerializer = new WTKXSerializer();
        Component component2 = null;
        try {
            component2 = (Component)wTKXSerializer.readObject((Object)this, "terra_alert_skin.wtkx");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        alert.setContent(component2);
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        ImageView imageView = (ImageView)wTKXSerializer.get("typeImageView");
        imageView.setImage(terraTheme.getMessageIcon(alert.getMessageType()));
        Label label = (Label)wTKXSerializer.get("messageLabel");
        String string = alert.getMessage();
        label.setText(string);
        BoxPane boxPane = (BoxPane)wTKXSerializer.get("messageBoxPane");
        Component component3 = alert.getBody();
        if (component3 != null) {
            boxPane.add(component3);
        }
        BoxPane boxPane2 = (BoxPane)wTKXSerializer.get("buttonBoxPane");
        int n = alert.getOptionCount();
        for (int i = 0; i < n; ++i) {
            Object object = alert.getOption(i);
            PushButton pushButton = new PushButton(object);
            pushButton.setStyles(commandButtonStyles);
            pushButton.getButtonPressListeners().add((Object)new ButtonPressListener(){

                public void buttonPressed(Button button) {
                    int n = TerraAlertSkin.this.optionButtons.indexOf((Object)button);
                    if (n >= 0) {
                        Alert alert = (Alert)TerraAlertSkin.this.getComponent();
                        alert.setSelectedOption(n);
                        alert.close(true);
                    }
                }
            });
            boxPane2.add((Component)pushButton);
            this.optionButtons.add((Object)pushButton);
        }
    }

    @Override
    public void windowOpened(Window window) {
        super.windowOpened(window);
        Alert alert = (Alert)window;
        int n = alert.getSelectedOption();
        if (n >= 0) {
            ((Button)this.optionButtons.get(n)).requestFocus();
        } else {
            window.requestFocus();
        }
    }

    public void selectedOptionChanged(Alert alert, int n) {
        int n2 = alert.getSelectedOption();
        if (alert.isOpen() && n2 >= 0) {
            ((Button)this.optionButtons.get(n2)).requestFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        URL uRL = TerraAlertSkin.class.getResource("command_button.json");
        try {
            InputStream inputStream = uRL.openStream();
            try {
                JSONSerializer jSONSerializer = new JSONSerializer();
                commandButtonStyles = (Map)jSONSerializer.readObject(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (SerializationException serializationException) {
            throw new RuntimeException(serializationException);
        }
    }
}

