/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.util.CalendarDate;
import org.apache.pivot.util.Filter;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonGroup;
import org.apache.pivot.wtk.ButtonGroupListener;
import org.apache.pivot.wtk.Calendar;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Spinner;
import org.apache.pivot.wtk.SpinnerSelectionListener;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.content.ButtonDataRenderer;
import org.apache.pivot.wtk.content.NumericSpinnerData;
import org.apache.pivot.wtk.content.SpinnerItemRenderer;
import org.apache.pivot.wtk.skin.ButtonSkin;
import org.apache.pivot.wtk.skin.CalendarSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraCalendarSkin
extends CalendarSkin {
    private TablePane calendarTablePane;
    private Spinner monthSpinner;
    private Spinner yearSpinner;
    private DateButton[][] dateButtons = new DateButton[6][7];
    private ButtonGroup dateButtonGroup;
    private Button.DataRenderer dateButtonDataRenderer = new DateButtonDataRenderer();
    private CalendarDate today = null;
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color selectionColor;
    private Color selectionBackgroundColor;
    private Color highlightColor;
    private Color highlightBackgroundColor;
    private Color dividerColor;
    private int padding = 4;
    private Color selectionBevelColor;

    public TerraCalendarSkin() {
        int n;
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.font = terraTheme.getFont();
        this.color = terraTheme.getColor(1);
        this.disabledColor = terraTheme.getColor(7);
        this.selectionColor = terraTheme.getColor(4);
        this.selectionBackgroundColor = terraTheme.getColor(19);
        this.highlightColor = terraTheme.getColor(1);
        this.highlightBackgroundColor = terraTheme.getColor(10);
        this.dividerColor = terraTheme.getColor(9);
        this.selectionBevelColor = TerraTheme.brighten(this.selectionBackgroundColor);
        this.calendarTablePane = new TablePane();
        for (int i = 0; i < 7; ++i) {
            this.calendarTablePane.getColumns().add(new TablePane.Column(1, true));
        }
        this.monthSpinner = new Spinner();
        this.monthSpinner.setSpinnerData((List)new NumericSpinnerData(0, 11));
        this.monthSpinner.setItemRenderer((Spinner.ItemRenderer)new MonthSpinnerItemRenderer());
        this.monthSpinner.setCircular(true);
        this.monthSpinner.getStyles().put("sizeToContent", (Object)true);
        this.monthSpinner.getSpinnerSelectionListeners().add((Object)new SpinnerSelectionListener(){

            public void selectedIndexChanged(Spinner spinner, int n) {
                Calendar calendar = (Calendar)TerraCalendarSkin.this.getComponent();
                calendar.setMonth(((Integer)spinner.getSelectedItem()).intValue());
            }
        });
        this.yearSpinner = new Spinner();
        this.yearSpinner.setSpinnerData((List)new NumericSpinnerData(0, Short.MAX_VALUE));
        this.yearSpinner.getSpinnerSelectionListeners().add((Object)new SpinnerSelectionListener(){

            public void selectedIndexChanged(Spinner spinner, int n) {
                Calendar calendar = (Calendar)TerraCalendarSkin.this.getComponent();
                calendar.setYear(((Integer)spinner.getSelectedItem()).intValue());
            }
        });
        ComponentMouseButtonListener.Adapter adapter = new ComponentMouseButtonListener.Adapter(){

            public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
                return true;
            }
        };
        this.monthSpinner.getComponentMouseButtonListeners().add((Object)adapter);
        this.yearSpinner.getComponentMouseButtonListeners().add((Object)adapter);
        TablePane tablePane = new TablePane();
        tablePane.getStyles().put("padding", (Object)3);
        tablePane.getStyles().put("horizontalSpacing", (Object)4);
        tablePane.getColumns().add(new TablePane.Column(1, true));
        tablePane.getColumns().add(new TablePane.Column(-1));
        TablePane.Row row = new TablePane.Row(-1);
        tablePane.getRows().add(row);
        row.add((Component)this.monthSpinner);
        row.add((Component)this.yearSpinner);
        TablePane.Row row2 = new TablePane.Row();
        row2.add((Component)tablePane);
        this.calendarTablePane.getRows().add(row2);
        TablePane.setColumnSpan((Component)tablePane, (int)7);
        row2 = new TablePane.Row();
        Font font = terraTheme.getFont();
        font = font.deriveFont(1);
        for (n = 0; n < 7; ++n) {
            Label label = new Label();
            label.getStyles().put("font", (Object)font);
            label.getStyles().put("padding", (Object)new Insets(2, 2, 4, 2));
            label.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.CENTER);
            row2.add((Component)label);
        }
        this.calendarTablePane.getRows().add(row2);
        this.dateButtonGroup = new ButtonGroup();
        this.dateButtonGroup.getButtonGroupListeners().add((Object)new ButtonGroupListener.Adapter(){

            public void selectionChanged(ButtonGroup buttonGroup, Button button) {
                Calendar calendar = (Calendar)TerraCalendarSkin.this.getComponent();
                Button button2 = buttonGroup.getSelection();
                if (button2 == null) {
                    CalendarDate calendarDate = calendar.getSelectedDate();
                    if (calendarDate == null || calendarDate.year == TerraCalendarSkin.this.yearSpinner.getSelectedIndex() && calendarDate.month == TerraCalendarSkin.this.monthSpinner.getSelectedIndex()) {
                        calendar.setSelectedDate((CalendarDate)null);
                    }
                } else {
                    calendar.setSelectedDate((CalendarDate)button2.getButtonData());
                }
            }
        });
        for (n = 0; n < 6; ++n) {
            row2 = new TablePane.Row(1, true);
            for (int i = 0; i < 7; ++i) {
                DateButton dateButton;
                this.dateButtons[n][i] = dateButton = new DateButton();
                dateButton.setButtonGroup(this.dateButtonGroup);
                row2.add((Component)dateButton);
            }
            this.calendarTablePane.getRows().add(row2);
        }
    }

    public void install(Component component) {
        super.install(component);
        Calendar calendar = (Calendar)component;
        calendar.add((Component)this.calendarTablePane);
        this.yearSpinner.setSelectedIndex(calendar.getYear());
        this.monthSpinner.setSelectedIndex(calendar.getMonth());
        this.updateLabels();
        this.updateCalendar();
    }

    public int getPreferredWidth(int n) {
        return this.calendarTablePane.getPreferredWidth(n);
    }

    public int getPreferredHeight(int n) {
        return this.calendarTablePane.getPreferredHeight(n);
    }

    public Dimensions getPreferredSize() {
        return this.calendarTablePane.getPreferredSize();
    }

    public int getBaseline(int n, int n2) {
        return this.calendarTablePane.getBaseline(n, n2);
    }

    public void layout() {
        this.calendarTablePane.setSize(this.getWidth(), this.getHeight());
        this.calendarTablePane.setLocation(0, 0);
    }

    public void paint(Graphics2D graphics2D) {
        super.paint(graphics2D);
        int n = this.getWidth();
        Bounds bounds = this.calendarTablePane.getRowBounds(0);
        graphics2D.setColor(this.highlightBackgroundColor);
        graphics2D.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        Bounds bounds2 = this.calendarTablePane.getRowBounds(1);
        graphics2D.setColor(this.dividerColor);
        int n2 = bounds2.y + bounds2.height - 2;
        GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)2, (int)n2, (int)Math.max(0, n - 4), (Orientation)Orientation.HORIZONTAL);
    }

    private void updateLabels() {
        TablePane.Row row = this.calendarTablePane.getRows().get(1);
        Calendar calendar = (Calendar)this.getComponent();
        Locale locale = calendar.getLocale();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E", locale);
        int n = gregorianCalendar.getFirstDayOfWeek();
        for (int i = 0; i < 7; ++i) {
            Label label = (Label)row.get(i);
            gregorianCalendar.set(7, n + i);
            String string = simpleDateFormat.format(gregorianCalendar.getTime());
            string = Character.toString(string.charAt(0));
            label.setText(string);
        }
    }

    private void updateCalendar() {
        Calendar calendar = (Calendar)this.getComponent();
        int n = calendar.getMonth();
        int n2 = calendar.getYear();
        Filter filter = calendar.getDisabledDateFilter();
        this.monthSpinner.setSelectedIndex(n);
        this.yearSpinner.setSelectedIndex(n2);
        Locale locale = calendar.getLocale();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        gregorianCalendar.set(n2, n, 1);
        int n3 = gregorianCalendar.get(7) - gregorianCalendar.getFirstDayOfWeek();
        int n4 = n3 + gregorianCalendar.getActualMaximum(5);
        gregorianCalendar.add(2, -1);
        int n5 = gregorianCalendar.getActualMaximum(5);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                int n6;
                n = calendar.getMonth();
                n2 = calendar.getYear();
                int n7 = i * 7 + j;
                DateButton dateButton = this.dateButtons[i][j];
                boolean bl = false;
                if (n7 < n3) {
                    if (--n < 0) {
                        n = 11;
                        --n2;
                    }
                    n6 = n5 - (n3 - n7);
                } else if (n7 >= n4) {
                    if (++n > 11) {
                        n = 0;
                        ++n2;
                    }
                    n6 = n7 - n4;
                } else {
                    n6 = n7 - n3;
                    bl = true;
                }
                CalendarDate calendarDate = new CalendarDate(n2, n, n6);
                dateButton.setButtonData(calendarDate);
                dateButton.setEnabled(bl && (filter == null || !filter.include((Object)calendarDate)));
            }
        }
        this.calendarTablePane.getRows().get(7).setVisible(this.dateButtons[5][0].isEnabled());
        this.today = new CalendarDate();
        this.updateSelection(calendar.getSelectedDate());
    }

    private void updateSelection(CalendarDate calendarDate) {
        Calendar calendar = (Calendar)this.getComponent();
        Button button = this.dateButtonGroup.getSelection();
        if (calendarDate == null) {
            if (button != null) {
                button.setSelected(false);
            }
        } else {
            int n = calendarDate.year;
            int n2 = calendarDate.month;
            if (n == calendar.getYear() && n2 == calendar.getMonth()) {
                int n3 = calendarDate.day;
                int n4 = TerraCalendarSkin.getCellIndex(n, n2, n3, calendar.getLocale());
                int n5 = n4 / 7;
                int n6 = n4 % 7;
                TablePane.Row row = this.calendarTablePane.getRows().get(n5 + 2);
                DateButton dateButton = (DateButton)row.get(n6);
                dateButton.setSelected(true);
            } else if (button != null) {
                button.setSelected(false);
            }
        }
    }

    private static int getCellIndex(int n, int n2, int n3, Locale locale) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        gregorianCalendar.set(n, n2, 1);
        int n4 = gregorianCalendar.get(7) - gregorianCalendar.getFirstDayOfWeek();
        int n5 = n4 + n3;
        return n5;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraCalendarSkin.decodeFont((String)string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = color;
        this.repaintComponent();
    }

    public final void setDisabledColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.selectionColor = color;
        this.repaintComponent();
    }

    public final void setSelectionColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.setSelectionColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.selectionBackgroundColor = color;
        this.selectionBevelColor = TerraTheme.brighten(color);
        this.repaintComponent();
    }

    public final void setSelectionBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.setSelectionBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("highlightColor is null.");
        }
        this.highlightColor = color;
        this.repaintComponent();
    }

    public final void setHighlightColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("highlightColor is null.");
        }
        this.setHighlightColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getHighlightBackgroundColor() {
        return this.highlightBackgroundColor;
    }

    public void setHighlightBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.highlightBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setHighlightBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.setHighlightBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getDividerColor() {
        return this.dividerColor;
    }

    public void setDividerColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("dividerColor is null.");
        }
        this.dividerColor = color;
        this.repaintComponent();
    }

    public final void setDividerColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("dividerColor is null.");
        }
        this.setDividerColor(GraphicsUtilities.decodeColor((String)string));
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("padding is negative.");
        }
        this.padding = n;
        this.invalidateComponent();
    }

    public final void setPadding(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(number.intValue());
    }

    public void yearChanged(Calendar calendar, int n) {
        this.yearSpinner.setSelectedIndex(calendar.getYear());
        this.updateCalendar();
    }

    public void monthChanged(Calendar calendar, int n) {
        this.monthSpinner.setSelectedIndex(calendar.getMonth());
        this.updateCalendar();
    }

    public void localeChanged(Calendar calendar, Locale locale) {
        this.invalidateComponent();
        this.updateLabels();
        this.updateCalendar();
    }

    public void disabledDateFilterChanged(Calendar calendar, Filter<CalendarDate> filter) {
        this.updateCalendar();
    }

    public void selectedDateChanged(Calendar calendar, CalendarDate calendarDate) {
        this.updateSelection(calendar.getSelectedDate());
    }

    private static class DateButtonDataRenderer
    extends ButtonDataRenderer {
        private DateButtonDataRenderer() {
        }

        public void render(Object object, Button button, boolean bl) {
            CalendarDate calendarDate = (CalendarDate)object;
            super.render((Object)(calendarDate.day + 1), button, bl);
            if (button.isSelected()) {
                this.label.getStyles().put("color", button.getStyles().get("selectionColor"));
            }
        }
    }

    public class MonthSpinnerItemRenderer
    extends SpinnerItemRenderer {
        public void render(Object object, Spinner spinner) {
            Calendar calendar = (Calendar)TerraCalendarSkin.this.getComponent();
            CalendarDate calendarDate = new CalendarDate(2000, ((Integer)object).intValue(), 0);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM", calendar.getLocale());
            object = simpleDateFormat.format(calendarDate.toCalendar().getTime());
            super.render(object, spinner);
        }
    }

    public class DateButtonSkin
    extends ButtonSkin {
        public void install(Component component) {
            super.install(component);
            component.setCursor(Cursor.DEFAULT);
        }

        public int getPreferredWidth(int n) {
            DateButton dateButton = (DateButton)this.getComponent();
            int n2 = 0;
            Button.DataRenderer dataRenderer = dateButton.getDataRenderer();
            dataRenderer.render(dateButton.getButtonData(), (Button)dateButton, false);
            n2 = dataRenderer.getPreferredWidth(n) + TerraCalendarSkin.this.padding * 2;
            return n2;
        }

        public int getPreferredHeight(int n) {
            int n2 = 0;
            DateButton dateButton = (DateButton)this.getComponent();
            Button.DataRenderer dataRenderer = dateButton.getDataRenderer();
            dataRenderer.render(dateButton.getButtonData(), (Button)dateButton, false);
            n2 = dataRenderer.getPreferredHeight(n) + TerraCalendarSkin.this.padding * 2;
            return n2;
        }

        public Dimensions getPreferredSize() {
            DateButton dateButton = (DateButton)this.getComponent();
            Button.DataRenderer dataRenderer = dateButton.getDataRenderer();
            dataRenderer.render(dateButton.getButtonData(), (Button)dateButton, false);
            Dimensions dimensions = dataRenderer.getPreferredSize();
            return new Dimensions(dimensions.width + TerraCalendarSkin.this.padding * 2, dimensions.height + TerraCalendarSkin.this.padding * 2);
        }

        public void paint(Graphics2D graphics2D) {
            DateButton dateButton = (DateButton)this.getComponent();
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (dateButton.isSelected()) {
                graphics2D.setPaint(new GradientPaint((float)n / 2.0f, 0.0f, TerraCalendarSkin.this.selectionBevelColor, (float)n / 2.0f, n2, TerraCalendarSkin.this.selectionBackgroundColor));
                graphics2D.fillRect(0, 0, n, n2);
            } else if (this.highlighted) {
                graphics2D.setColor(TerraCalendarSkin.this.highlightBackgroundColor);
                graphics2D.fillRect(0, 0, n, n2);
            }
            CalendarDate calendarDate = (CalendarDate)dateButton.getButtonData();
            if (calendarDate.equals((Object)TerraCalendarSkin.this.today)) {
                graphics2D.setColor(TerraCalendarSkin.this.dividerColor);
                GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (int)n2);
            }
            Button.DataRenderer dataRenderer = dateButton.getDataRenderer();
            dataRenderer.render((Object)calendarDate, (Button)dateButton, this.highlighted);
            dataRenderer.setSize(Math.max(n - TerraCalendarSkin.this.padding * 2, 0), Math.max(n2 - TerraCalendarSkin.this.padding * 2, 0));
            graphics2D.translate(TerraCalendarSkin.this.padding, TerraCalendarSkin.this.padding);
            dataRenderer.paint(graphics2D);
        }

        public Font getFont() {
            return TerraCalendarSkin.this.font;
        }

        public Color getColor() {
            return TerraCalendarSkin.this.color;
        }

        public Color getDisabledColor() {
            return TerraCalendarSkin.this.disabledColor;
        }

        public Color getSelectionColor() {
            return TerraCalendarSkin.this.selectionColor;
        }

        public void focusedChanged(Component component, Component component2) {
            this.highlighted = component.isFocused();
            super.focusedChanged(component, component2);
        }

        public void mouseOver(Component component) {
            super.mouseOver(component);
            Calendar calendar = (Calendar)TerraCalendarSkin.this.getComponent();
            if (calendar.containsFocus()) {
                component.requestFocus();
            }
        }

        public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
            boolean bl = super.mouseClick(component, button, n, n2, n3);
            DateButton dateButton = (DateButton)this.getComponent();
            dateButton.requestFocus();
            dateButton.press();
            return bl;
        }

        public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
            boolean bl = false;
            DateButton dateButton = (DateButton)this.getComponent();
            if (n == 10) {
                dateButton.press();
            } else if (n == 38 || n == 40 || n == 37 || n == 39) {
                CalendarDate calendarDate = (CalendarDate)dateButton.getButtonData();
                Calendar calendar = (Calendar)TerraCalendarSkin.this.getComponent();
                int n2 = TerraCalendarSkin.getCellIndex(calendarDate.year, calendarDate.month, calendarDate.day, calendar.getLocale());
                int n3 = n2 / 7;
                int n4 = n2 % 7;
                switch (n) {
                    case 38: {
                        TablePane.Row row;
                        Component component2;
                        do {
                            if (--n3 >= 0) continue;
                            n3 = 5;
                        } while (!(component2 = (row = TerraCalendarSkin.this.calendarTablePane.getRows().get(n3 + 2)).get(n4)).isEnabled());
                        component2.requestFocus();
                        break;
                    }
                    case 40: {
                        TablePane.Row row;
                        Component component3;
                        do {
                            if (++n3 <= 5) continue;
                            n3 = 0;
                        } while (!(component3 = (row = TerraCalendarSkin.this.calendarTablePane.getRows().get(n3 + 2)).get(n4)).isEnabled());
                        component3.requestFocus();
                        break;
                    }
                    case 37: {
                        Component component4;
                        TablePane.Row row = TerraCalendarSkin.this.calendarTablePane.getRows().get(n3 + 2);
                        do {
                            if (--n4 >= 0) continue;
                            n4 = 6;
                        } while (!(component4 = row.get(n4)).isEnabled());
                        component4.requestFocus();
                        break;
                    }
                    case 39: {
                        Component component5;
                        TablePane.Row row = TerraCalendarSkin.this.calendarTablePane.getRows().get(n3 + 2);
                        do {
                            if (++n4 <= 6) continue;
                            n4 = 0;
                        } while (!(component5 = row.get(n4)).isEnabled());
                        component5.requestFocus();
                        break;
                    }
                }
                bl = true;
            } else {
                bl = super.keyPressed(component, n, keyLocation);
            }
            return bl;
        }

        public boolean keyReleased(Component component, int n, Keyboard.KeyLocation keyLocation) {
            boolean bl = false;
            DateButton dateButton = (DateButton)this.getComponent();
            if (n == 32) {
                dateButton.press();
                bl = true;
            } else {
                bl = super.keyReleased(component, n, keyLocation);
            }
            return bl;
        }
    }

    public class DateButton
    extends Button {
        public DateButton() {
            super(null);
            super.setToggleButton(true);
            this.setDataRenderer(TerraCalendarSkin.this.dateButtonDataRenderer);
            this.setSkin((Skin)new DateButtonSkin());
        }

        public void press() {
            this.setSelected(true);
            super.press();
        }

        public void setToggleButton(boolean bl) {
            throw new UnsupportedOperationException();
        }

        public void setTriState(boolean bl) {
            throw new UnsupportedOperationException();
        }
    }
}

