/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Checkbox;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.CheckboxSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraCheckboxSkin
extends CheckboxSkin {
    private Font font;
    private Color color;
    private Color disabledColor;
    private int spacing;
    private Color buttonColor;
    private Color buttonBorderColor;
    private Color buttonSelectionColor;
    private Color disabledButtonColor;
    private Color disabledButtonBorderColor;
    private Color disabledButtonSelectionColor;
    private static final int CHECKBOX_SIZE = 14;
    private static final int CHECKMARK_SIZE = 10;

    public TerraCheckboxSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.font = terraTheme.getFont();
        this.color = terraTheme.getColor(1);
        this.disabledColor = terraTheme.getColor(7);
        this.spacing = 3;
        this.buttonColor = terraTheme.getColor(4);
        this.buttonBorderColor = terraTheme.getColor(7);
        this.buttonSelectionColor = terraTheme.getColor(13);
        this.disabledButtonColor = terraTheme.getColor(3);
        this.disabledButtonBorderColor = terraTheme.getColor(7);
        this.disabledButtonSelectionColor = terraTheme.getColor(7);
    }

    public int getPreferredWidth(int n) {
        Checkbox checkbox = (Checkbox)this.getComponent();
        Button.DataRenderer dataRenderer = checkbox.getDataRenderer();
        int n2 = 14;
        Object object = checkbox.getButtonData();
        if (object != null) {
            dataRenderer.render(object, (Button)checkbox, false);
            n2 += dataRenderer.getPreferredWidth(n) + this.spacing * 2;
        }
        return n2;
    }

    public int getPreferredHeight(int n) {
        Checkbox checkbox = (Checkbox)this.getComponent();
        Button.DataRenderer dataRenderer = checkbox.getDataRenderer();
        int n2 = 14;
        Object object = checkbox.getButtonData();
        if (object != null) {
            if (n != -1) {
                n = Math.max(n - (14 + this.spacing), 0);
            }
            dataRenderer.render(checkbox.getButtonData(), (Button)checkbox, false);
            n2 = Math.max(n2, dataRenderer.getPreferredHeight(n));
        }
        return n2;
    }

    public Dimensions getPreferredSize() {
        Checkbox checkbox = (Checkbox)this.getComponent();
        Button.DataRenderer dataRenderer = checkbox.getDataRenderer();
        dataRenderer.render(checkbox.getButtonData(), (Button)checkbox, false);
        int n = 14;
        int n2 = 14;
        Object object = checkbox.getButtonData();
        if (object != null) {
            dataRenderer.render(object, (Button)checkbox, false);
            n += dataRenderer.getPreferredWidth(-1) + this.spacing * 2;
            n2 = Math.max(n2, dataRenderer.getPreferredHeight(-1));
        }
        return new Dimensions(n, n2);
    }

    public int getBaseline(int n, int n2) {
        Checkbox checkbox = (Checkbox)this.getComponent();
        int n3 = -1;
        Button.DataRenderer dataRenderer = checkbox.getDataRenderer();
        dataRenderer.render(checkbox.getButtonData(), (Button)checkbox, false);
        int n4 = Math.max(n - (14 + this.spacing), 0);
        n3 = dataRenderer.getBaseline(n4, n2);
        return n3;
    }

    public void paint(Graphics2D graphics2D) {
        Checkbox checkbox = (Checkbox)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        this.paintButton(graphics2D2, checkbox, n2);
        graphics2D2.dispose();
        Button.DataRenderer dataRenderer = checkbox.getDataRenderer();
        dataRenderer.render(checkbox.getButtonData(), (Button)checkbox, false);
        dataRenderer.setSize(Math.max(n - (14 + this.spacing * 2), 0), n2);
        Graphics2D graphics2D3 = (Graphics2D)graphics2D.create();
        graphics2D3.translate(14 + this.spacing, 0);
        graphics2D3.clipRect(0, 0, dataRenderer.getWidth(), dataRenderer.getHeight());
        dataRenderer.paint(graphics2D3);
        graphics2D3.dispose();
        if (checkbox.isFocused()) {
            BasicStroke basicStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{0.0f, 2.0f}, 0.0f);
            graphics2D.setStroke(basicStroke);
            graphics2D.setColor(this.buttonBorderColor);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.draw(new Rectangle2D.Double(15.0, 0.5, dataRenderer.getWidth() + this.spacing * 2 - 2, dataRenderer.getHeight() - 1));
        }
    }

    private void paintButton(Graphics2D graphics2D, Checkbox checkbox, int n) {
        Color color;
        Color color2;
        Paint paint;
        if (checkbox.isEnabled()) {
            paint = new GradientPaint(7.0f, 0.0f, TerraTheme.darken(this.buttonColor), 7.0f, 14.0f, this.buttonColor);
            color2 = this.buttonBorderColor;
            color = this.buttonSelectionColor;
        } else {
            paint = this.disabledButtonColor;
            color2 = this.disabledButtonBorderColor;
            color = this.disabledButtonSelectionColor;
        }
        graphics2D.translate(0, (n - 14) / 2);
        graphics2D.setPaint(paint);
        graphics2D.fillRect(0, 0, 14, 14);
        graphics2D.setPaint(color2);
        GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)0, (int)0, (int)14, (int)14);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Button.State state = checkbox.getState();
        if (state == Button.State.SELECTED) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(2.5f));
            int n2 = 5;
            int n3 = 2;
            int n4 = (14 - (n2 + n3)) / 2;
            int n5 = (14 - n2) / 2;
            graphics2D.drawLine(n4, n2 - n3 + n5, n3 + n4, n2 + n5);
            graphics2D.drawLine(n3 + n4, n2 + n5, n3 + n2 + n4, n5);
        } else if (state == Button.State.MIXED) {
            graphics2D.setColor(color);
            GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)4, (int)6, (int)6, (Orientation)Orientation.HORIZONTAL, (int)2);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraCheckboxSkin.decodeFont((String)string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = color;
        this.repaintComponent();
    }

    public final void setDisabledColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)string));
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("spacing is negative.");
        }
        this.spacing = n;
        this.invalidateComponent();
    }

    public final void setSpacing(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("spacing is null.");
        }
        this.setSpacing(number.intValue());
    }
}

