/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Expander;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.LinkButton;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.content.ButtonDataRenderer;
import org.apache.pivot.wtk.effects.ClipDecorator;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.effects.easing.Easing;
import org.apache.pivot.wtk.effects.easing.Quadratic;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.ExpanderSkin;
import org.apache.pivot.wtk.skin.terra.TerraLinkButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraExpanderSkin
extends ExpanderSkin
implements ButtonPressListener {
    private Image collapseImage = new CollapseImage();
    private Image expandImage = new ExpandImage();
    private TablePane titleBarTablePane = null;
    private BoxPane titleBoxPane = null;
    private BoxPane buttonBoxPane = null;
    private Label titleLabel = new Label();
    private ShadeButton shadeButton = null;
    private Color titleBarBackgroundColor;
    private Color titleBarBorderColor;
    private Color shadeButtonColor;
    private Color borderColor;
    private Insets padding;
    private Color titleBarBevelColor;
    private ExpandTransition expandTransition = null;
    private ClipDecorator clipDecorator = new ClipDecorator();
    private ComponentMouseButtonListener titleBarMouseListener = new ComponentMouseButtonListener.Adapter(){

        public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
            Expander expander;
            boolean bl = false;
            if (n3 == 2 && (expander = (Expander)TerraExpanderSkin.this.getComponent()).isCollapsible()) {
                expander.setExpanded(!expander.isExpanded());
                bl = true;
            }
            return bl;
        }
    };
    private static final int EXPAND_DURATION = 250;
    private static final int EXPAND_RATE = 30;

    public TerraExpanderSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(terraTheme.getColor(4));
        this.titleBarBackgroundColor = terraTheme.getColor(10);
        this.titleBarBorderColor = terraTheme.getColor(7);
        this.shadeButtonColor = terraTheme.getColor(7);
        this.borderColor = terraTheme.getColor(7);
        this.padding = new Insets(4);
        this.titleBarBevelColor = TerraTheme.brighten(this.titleBarBackgroundColor);
        this.titleBarTablePane = new TablePane();
        this.titleBarTablePane.getColumns().add(new TablePane.Column(1, true));
        this.titleBarTablePane.getColumns().add(new TablePane.Column(-1));
        this.titleBarTablePane.getStyles().put("padding", (Object)new Insets(3));
        this.titleBarTablePane.getStyles().put("horizontalSpacing", (Object)3);
        TablePane.Row row = new TablePane.Row(-1);
        this.titleBarTablePane.getRows().add(row);
        this.titleBoxPane = new BoxPane(Orientation.HORIZONTAL);
        this.titleBoxPane.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
        this.buttonBoxPane = new BoxPane(Orientation.HORIZONTAL);
        this.buttonBoxPane.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.RIGHT);
        this.buttonBoxPane.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        row.add((Component)this.titleBoxPane);
        row.add((Component)this.buttonBoxPane);
        this.titleLabel.getStyles().put("color", (Object)terraTheme.getColor(15));
        Font font = terraTheme.getFont().deriveFont(1);
        this.titleLabel.getStyles().put("font", (Object)font);
        this.titleBoxPane.add((Component)this.titleLabel);
        this.titleBarTablePane.getComponentMouseButtonListeners().add((Object)this.titleBarMouseListener);
    }

    public void install(Component component) {
        super.install(component);
        Expander expander = (Expander)component;
        expander.add((Component)this.titleBarTablePane);
        Image image = expander.isExpanded() ? this.collapseImage : this.expandImage;
        this.shadeButton = new ShadeButton(image);
        this.buttonBoxPane.add((Component)this.shadeButton);
        this.shadeButton.getButtonPressListeners().add((Object)this);
        this.titleChanged(expander, null);
        this.collapsibleChanged(expander);
    }

    public int getPreferredWidth(int n) {
        Expander expander = (Expander)this.getComponent();
        Component component = expander.getContent();
        int n2 = this.titleBarTablePane.getPreferredWidth(-1);
        if (component != null) {
            int n3 = -1;
            if (n >= 0) {
                int n4 = 2 + this.padding.top + this.padding.bottom + this.titleBarTablePane.getPreferredHeight(-1);
                if (expander.isExpanded()) {
                    ++n4;
                }
                n3 = Math.max(n - n4, 0);
            }
            n2 = Math.max(component.getPreferredWidth(n3) + (this.padding.left + this.padding.right), n2);
        }
        return n2 += 2;
    }

    public int getPreferredHeight(int n) {
        Expander expander = (Expander)this.getComponent();
        Component component = expander.getContent();
        int n2 = this.titleBarTablePane.getPreferredHeight(-1);
        if (component != null && (expander.isExpanded() || this.expandTransition != null)) {
            ++n2;
            int n3 = -1;
            if (n >= 0) {
                n3 = Math.max(n - (2 + this.padding.left + this.padding.right), 0);
            }
            if (this.expandTransition == null) {
                n2 += this.padding.top + this.padding.bottom + component.getPreferredHeight(n3);
            } else {
                float f = this.expandTransition.getScale();
                n2 += (int)(f * (float)(this.padding.top + this.padding.bottom + component.getPreferredHeight(n3)));
            }
        }
        return n2 += 2;
    }

    public Dimensions getPreferredSize() {
        Expander expander = (Expander)this.getComponent();
        Component component = expander.getContent();
        Dimensions dimensions = this.titleBarTablePane.getPreferredSize();
        int n = dimensions.width;
        int n2 = dimensions.height;
        if (component != null) {
            Dimensions dimensions2 = component.getPreferredSize();
            n = Math.max(dimensions2.width + (this.padding.left + this.padding.right), n);
            if (expander.isExpanded() || this.expandTransition != null) {
                ++n2;
                if (this.expandTransition == null) {
                    n2 += this.padding.top + this.padding.bottom + dimensions2.height;
                } else {
                    float f = this.expandTransition.getScale();
                    n2 += (int)(f * (float)(this.padding.top + this.padding.bottom + dimensions2.height));
                }
            }
        }
        return new Dimensions(n += 2, n2 += 2);
    }

    public int getBaseline(int n, int n2) {
        int n3;
        int n4;
        Expander expander = (Expander)this.getComponent();
        Component component = expander.getContent();
        int n5 = -1;
        if (component != null && (n5 = this.titleBarTablePane.getBaseline(n4 = Math.max(n - 2, 0), n3 = this.titleBarTablePane.getPreferredHeight(-1))) != -1) {
            ++n5;
        }
        return n5;
    }

    public void layout() {
        Expander expander = (Expander)this.getComponent();
        Component component = expander.getContent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.titleBarTablePane.getPreferredHeight(-1);
        this.titleBarTablePane.setSize(Math.max(n - 2, 0), n3);
        this.titleBarTablePane.setLocation(1, 1);
        if (component != null) {
            int n4 = Math.max(n - (2 + this.padding.left + this.padding.right), 0);
            int n5 = Math.max(n2 - (3 + this.padding.top + this.padding.bottom + n3), 0);
            this.clipDecorator.setSize(n4, n5);
            component.setSize(n4, component.getPreferredHeight(n4));
            int n6 = 1 + this.padding.left;
            int n7 = 2 + this.padding.top + n3;
            component.setLocation(n6, n7);
        }
    }

    public void paint(Graphics2D graphics2D) {
        super.paint(graphics2D);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.titleBarTablePane.getX();
        int n4 = this.titleBarTablePane.getY();
        int n5 = this.titleBarTablePane.getWidth();
        int n6 = this.titleBarTablePane.getHeight();
        graphics2D.setPaint(this.titleBarBorderColor);
        GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)0, (int)(1 + n6), (int)n, (Orientation)Orientation.HORIZONTAL);
        graphics2D.setPaint(new GradientPaint(n3 + n5 / 2, n4, this.titleBarBevelColor, n3 + n5 / 2, n4 + n6, this.titleBarBackgroundColor));
        graphics2D.fillRect(n3, n4, n5, n6);
        graphics2D.setPaint(this.borderColor);
        GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (int)n2);
    }

    public Font getTitleBarFont() {
        return (Font)this.titleLabel.getStyles().get("font");
    }

    public void setTitleBarFont(Font font) {
        this.titleLabel.getStyles().put("font", (Object)font);
    }

    public final void setTitleBarFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("titleBarFont is null.");
        }
        this.setTitleBarFont(TerraExpanderSkin.decodeFont((String)string));
    }

    public final void setTitleBarFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("titleBarFont is null.");
        }
        this.setTitleBarFont(Theme.deriveFont(dictionary));
    }

    public Color getTitleBarColor() {
        return (Color)this.titleLabel.getStyles().get("color");
    }

    public void setTitleBarColor(Color color) {
        this.titleLabel.getStyles().put("color", (Object)color);
    }

    public final void setTitleBarColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("titleBarColor is null.");
        }
        this.setTitleBarColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getTitleBarBackgroundColor() {
        return this.titleBarBackgroundColor;
    }

    public void setTitleBarBackgroundColor(Color color) {
        this.titleBarBackgroundColor = color;
        this.titleBarBevelColor = TerraTheme.brighten(color);
        this.repaintComponent();
    }

    public final void setTitleBarBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("titleBarBackgroundColor is null.");
        }
        this.setTitleBarBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getTitleBarBorderColor() {
        return this.titleBarBorderColor;
    }

    public void setTitleBarBorderColor(Color color) {
        this.titleBarBorderColor = color;
        this.repaintComponent();
    }

    public final void setTitleBarBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("titleBarBorderColor is null.");
        }
        this.setTitleBarBorderColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getShadeButtonColor() {
        return this.shadeButtonColor;
    }

    public void setShadeButtonColor(Color color) {
        this.shadeButtonColor = color;
        this.repaintComponent();
    }

    public final void setShadeButtonColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("shadeButtonColor is null.");
        }
        this.setShadeButtonColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
        this.repaintComponent();
    }

    public final void setBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public final void setPadding(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(number.intValue());
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)string));
    }

    public void buttonPressed(Button button) {
        Expander expander = (Expander)this.getComponent();
        if (expander.isCollapsible()) {
            expander.setExpanded(!expander.isExpanded());
        }
    }

    public void titleChanged(Expander expander, String string) {
        String string2 = expander.getTitle();
        this.titleLabel.setVisible(string2 != null);
        this.titleLabel.setText(string2);
    }

    public void collapsibleChanged(Expander expander) {
        this.buttonBoxPane.setVisible(expander.isCollapsible());
    }

    public Vote previewExpandedChange(final Expander expander) {
        if (expander.isShowing() && this.expandTransition == null && expander.getContent() != null) {
            final boolean bl = expander.isExpanded();
            this.shadeButton.setButtonData(bl ? this.collapseImage : this.expandImage);
            this.expandTransition = new ExpandTransition(bl);
            this.expandTransition.start(new TransitionListener(){

                public void transitionCompleted(Transition transition) {
                    expander.setExpanded(!bl);
                    TerraExpanderSkin.this.expandTransition = null;
                }
            });
        }
        Vote vote = this.expandTransition == null || !this.expandTransition.isRunning() ? Vote.APPROVE : Vote.DEFER;
        return vote;
    }

    public void expandedChangeVetoed(Expander expander, Vote vote) {
        if (vote == Vote.DENY && this.expandTransition != null) {
            this.expandTransition.stop();
            this.expandTransition = null;
            this.shadeButton.setButtonData(expander.isExpanded() ? this.collapseImage : this.expandImage);
            this.invalidateComponent();
        }
    }

    public void expandedChanged(Expander expander) {
        this.shadeButton.setButtonData(expander.isExpanded() ? this.collapseImage : this.expandImage);
        this.invalidateComponent();
    }

    public void contentChanged(Expander expander, Component component) {
        if (this.expandTransition != null) {
            this.expandTransition.end();
        }
        this.invalidateComponent();
    }

    protected class ExpandImage
    extends ButtonImage {
        protected ExpandImage() {
        }

        public void paint(Graphics2D graphics2D) {
            graphics2D.setStroke(new BasicStroke(0.0f));
            graphics2D.setPaint(TerraExpanderSkin.this.shadeButtonColor);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int[] nArray = new int[]{3, 6, 9};
            int[] nArray2 = new int[]{3, 9, 3};
            graphics2D.fillPolygon(nArray, nArray2, 3);
            graphics2D.drawPolygon(nArray, nArray2, 3);
        }
    }

    protected class CollapseImage
    extends ButtonImage {
        protected CollapseImage() {
        }

        public void paint(Graphics2D graphics2D) {
            graphics2D.setStroke(new BasicStroke(0.0f));
            graphics2D.setPaint(TerraExpanderSkin.this.shadeButtonColor);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int[] nArray = new int[]{3, 6, 9};
            int[] nArray2 = new int[]{9, 3, 9};
            graphics2D.fillPolygon(nArray, nArray2, 3);
            graphics2D.drawPolygon(nArray, nArray2, 3);
        }
    }

    protected abstract class ButtonImage
    extends Image {
        protected ButtonImage() {
        }

        public int getWidth() {
            return 11;
        }

        public int getHeight() {
            return 11;
        }
    }

    public class ShadeButtonSkin
    extends TerraLinkButtonSkin {
        public boolean isFocusable() {
            return false;
        }
    }

    public class ShadeButton
    extends LinkButton {
        public ShadeButton() {
            this(null);
        }

        public ShadeButton(Object object) {
            super(object);
            this.setSkin((Skin)new ShadeButtonSkin());
            this.setDataRenderer((Button.DataRenderer)new ButtonDataRenderer());
        }
    }

    public class ExpandTransition
    extends Transition {
        private Easing easing;

        public ExpandTransition(boolean bl) {
            super(250, 30, false, bl);
            this.easing = new Quadratic();
        }

        public float getScale() {
            int n = this.getElapsedTime();
            int n2 = this.getDuration();
            float f = this.isReversed() ? this.easing.easeIn((float)n, 0.0f, 1.0f, (float)n2) : this.easing.easeOut((float)n, 0.0f, 1.0f, (float)n2);
            return f;
        }

        public void start(TransitionListener transitionListener) {
            Expander expander = (Expander)TerraExpanderSkin.this.getComponent();
            Component component = expander.getContent();
            component.getDecorators().add((Decorator)TerraExpanderSkin.this.clipDecorator);
            expander.setEnabled(false);
            super.start(transitionListener);
        }

        public void stop() {
            Expander expander = (Expander)TerraExpanderSkin.this.getComponent();
            Component component = expander.getContent();
            component.getDecorators().remove((Decorator)TerraExpanderSkin.this.clipDecorator);
            expander.setEnabled(true);
            super.stop();
        }

        protected void update() {
            TerraExpanderSkin.this.invalidateComponent();
        }
    }
}

