/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.io.File;
import java.io.IOException;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.Resources;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.FileBrowser;
import org.apache.pivot.wtk.FileBrowserListener;
import org.apache.pivot.wtk.FileBrowserSheet;
import org.apache.pivot.wtk.FileBrowserSheetListener;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.Sheet;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.TextInputTextListener;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.skin.terra.TerraSheetSkin;
import org.apache.pivot.wtkx.WTKX;
import org.apache.pivot.wtkx.WTKXSerializer;

public class TerraFileBrowserSheetSkin
extends TerraSheetSkin
implements FileBrowserSheetListener {
    @WTKX
    private BoxPane saveAsBoxPane = null;
    @WTKX
    private TextInput saveAsTextInput = null;
    @WTKX
    private FileBrowser fileBrowser = null;
    @WTKX
    private PushButton okButton = null;
    @WTKX
    private PushButton cancelButton = null;
    private boolean updatingSelection = false;
    private int selectedDirectoryCount = 0;

    public TerraFileBrowserSheetSkin() {
        this.setResizable(true);
    }

    @Override
    public void install(Component component) {
        Component component2;
        Resources resources;
        super.install(component);
        final FileBrowserSheet fileBrowserSheet = (FileBrowserSheet)component;
        fileBrowserSheet.setMinimumPreferredWidth(360);
        fileBrowserSheet.setMinimumPreferredHeight(180);
        final FileBrowserSheet.Mode mode = fileBrowserSheet.getMode();
        try {
            resources = new Resources(((Object)((Object)this)).getClass().getName());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (SerializationException serializationException) {
            throw new RuntimeException(serializationException);
        }
        WTKXSerializer wTKXSerializer = new WTKXSerializer(resources);
        try {
            component2 = (Component)wTKXSerializer.readObject((Object)this, "terra_file_browser_sheet_skin.wtkx");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (SerializationException serializationException) {
            throw new RuntimeException(serializationException);
        }
        fileBrowserSheet.setContent(component2);
        wTKXSerializer.bind((Object)this, TerraFileBrowserSheetSkin.class);
        this.saveAsTextInput.getTextInputTextListeners().add((Object)new TextInputTextListener(){

            public void textChanged(TextInput textInput) {
                TerraFileBrowserSheetSkin.this.updateOKButtonState();
            }
        });
        this.fileBrowser.getStyles().put("keyboardFolderTraversalEnabled", (Object)(mode != FileBrowserSheet.Mode.SAVE_TO ? 1 : 0));
        this.fileBrowser.getFileBrowserListeners().add((Object)new FileBrowserListener.Adapter(){

            public void rootDirectoryChanged(FileBrowser fileBrowser, File file) {
                TerraFileBrowserSheetSkin.this.updatingSelection = true;
                fileBrowserSheet.setRootDirectory(fileBrowser.getRootDirectory());
                TerraFileBrowserSheetSkin.this.updatingSelection = false;
                TerraFileBrowserSheetSkin.this.selectedDirectoryCount = 0;
                TerraFileBrowserSheetSkin.this.updateOKButtonState();
            }

            public void selectedFileAdded(FileBrowser fileBrowser, File file) {
                if (file.isDirectory()) {
                    TerraFileBrowserSheetSkin.this.selectedDirectoryCount++;
                }
                TerraFileBrowserSheetSkin.this.updateOKButtonState();
            }

            public void selectedFileRemoved(FileBrowser fileBrowser, File file) {
                if (file.isDirectory()) {
                    TerraFileBrowserSheetSkin.this.selectedDirectoryCount--;
                }
                TerraFileBrowserSheetSkin.this.updateOKButtonState();
            }

            public void selectedFilesChanged(FileBrowser fileBrowser, Sequence<File> sequence) {
                File file;
                TerraFileBrowserSheetSkin.this.selectedDirectoryCount = 0;
                Sequence sequence2 = fileBrowser.getSelectedFiles();
                int n = sequence2.getLength();
                for (int i = 0; i < n; ++i) {
                    File file2 = (File)sequence2.get(i);
                    if (!file2.isDirectory()) continue;
                    TerraFileBrowserSheetSkin.this.selectedDirectoryCount++;
                }
                if (!fileBrowser.isMultiSelect() && (file = fileBrowser.getSelectedFile()) != null && !file.isDirectory()) {
                    TerraFileBrowserSheetSkin.this.saveAsTextInput.setText(file.getName());
                }
                TerraFileBrowserSheetSkin.this.updateOKButtonState();
            }
        });
        this.fileBrowser.getComponentMouseButtonListeners().add((Object)new ComponentMouseButtonListener.Adapter(){
            private File file = null;

            public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
                File file;
                boolean bl = super.mouseClick(component, button, n, n2, n3);
                if (n3 == 1) {
                    this.file = TerraFileBrowserSheetSkin.this.fileBrowser.getFileAt(n, n2);
                } else if (n3 == 2 && (file = TerraFileBrowserSheetSkin.this.fileBrowser.getFileAt(n, n2)) != null && this.file != null && file.equals(this.file) && TerraFileBrowserSheetSkin.this.fileBrowser.isFileSelected(file) && (mode == FileBrowserSheet.Mode.OPEN || mode == FileBrowserSheet.Mode.OPEN_MULTIPLE) && !file.isDirectory()) {
                    fileBrowserSheet.close(true);
                    bl = true;
                }
                return bl;
            }
        });
        this.okButton.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                fileBrowserSheet.close(true);
            }
        });
        this.cancelButton.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                fileBrowserSheet.close(false);
            }
        });
        fileBrowserSheet.getFileBrowserSheetListeners().add((Object)this);
        switch (mode) {
            case OPEN: {
                this.saveAsBoxPane.setVisible(false);
                this.fileBrowser.setMultiSelect(false);
                break;
            }
            case OPEN_MULTIPLE: {
                this.saveAsBoxPane.setVisible(false);
                this.fileBrowser.setMultiSelect(true);
                break;
            }
            case SAVE_AS: {
                this.saveAsBoxPane.setVisible(true);
                this.fileBrowser.setMultiSelect(false);
                break;
            }
            case SAVE_TO: {
                this.saveAsBoxPane.setVisible(false);
                this.fileBrowser.setMultiSelect(false);
            }
        }
        this.rootDirectoryChanged(fileBrowserSheet, null);
        this.selectedFilesChanged(fileBrowserSheet, null);
        this.disabledFileFilterChanged(fileBrowserSheet, null);
    }

    public boolean isHideDisabledFiles() {
        return (Boolean)this.fileBrowser.getStyles().get("hideDisabledFiles");
    }

    public void setHideDisabledFiles(boolean bl) {
        this.fileBrowser.getStyles().put("hideDisabledFiles", (Object)bl);
    }

    @Override
    public void windowOpened(Window window) {
        super.windowOpened(window);
        if (window.isOpen()) {
            window.requestFocus();
        }
    }

    @Override
    public Vote previewSheetClose(Sheet sheet, boolean bl) {
        Vote vote = bl && !this.okButton.isEnabled() ? Vote.DENY : super.previewSheetClose(sheet, bl);
        if (vote == Vote.APPROVE) {
            this.updatingSelection = true;
            FileBrowserSheet fileBrowserSheet = (FileBrowserSheet)sheet;
            FileBrowserSheet.Mode mode = fileBrowserSheet.getMode();
            switch (mode) {
                case OPEN: 
                case OPEN_MULTIPLE: 
                case SAVE_TO: {
                    fileBrowserSheet.setSelectedFiles(this.fileBrowser.getSelectedFiles());
                    break;
                }
                case SAVE_AS: {
                    String string = this.saveAsTextInput.getText();
                    File file = new File(this.fileBrowser.getRootDirectory(), string);
                    fileBrowserSheet.setSelectedFiles((Sequence)new ArrayList((Object[])new File[]{file}));
                    break;
                }
            }
            this.updatingSelection = false;
        }
        return vote;
    }

    public void rootDirectoryChanged(FileBrowserSheet fileBrowserSheet, File file) {
        if (!this.updatingSelection) {
            this.fileBrowser.setRootDirectory(fileBrowserSheet.getRootDirectory());
        }
    }

    public void selectedFilesChanged(FileBrowserSheet fileBrowserSheet, Sequence<File> sequence) {
        if (!this.updatingSelection) {
            this.fileBrowser.setSelectedFiles(fileBrowserSheet.getSelectedFiles());
        }
    }

    public void disabledFileFilterChanged(FileBrowserSheet fileBrowserSheet, Filter<File> filter) {
        Filter filter2 = fileBrowserSheet.getDisabledFileFilter();
        FileBrowserSheet.Mode mode = fileBrowserSheet.getMode();
        if (mode == FileBrowserSheet.Mode.SAVE_TO) {
            filter2 = new SaveToFileFilter((Filter<File>)filter2);
        }
        this.fileBrowser.setDisabledFileFilter(filter2);
    }

    private void updateOKButtonState() {
        FileBrowserSheet fileBrowserSheet = (FileBrowserSheet)this.getComponent();
        FileBrowserSheet.Mode mode = fileBrowserSheet.getMode();
        Sequence sequence = this.fileBrowser.getSelectedFiles();
        switch (mode) {
            case OPEN: 
            case OPEN_MULTIPLE: {
                this.okButton.setEnabled(sequence.getLength() > 0 && this.selectedDirectoryCount == 0);
                break;
            }
            case SAVE_AS: {
                this.okButton.setEnabled(this.saveAsTextInput.getTextLength() > 0);
                break;
            }
            case SAVE_TO: {
                this.okButton.setEnabled(this.selectedDirectoryCount > 0);
            }
        }
    }

    private static class SaveToFileFilter
    implements Filter<File> {
        public final Filter<File> sourceFilter;

        public SaveToFileFilter(Filter<File> filter) {
            this.sourceFilter = filter;
        }

        public boolean include(File file) {
            return !file.isDirectory() || this.sourceFilter != null && this.sourceFilter.include((Object)file);
        }
    }
}

