/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Form;
import org.apache.pivot.wtk.FormAttributeListener;
import org.apache.pivot.wtk.FormListener;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.MessageType;
import org.apache.pivot.wtk.Separator;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraFormSkin
extends ContainerSkin
implements FormListener,
FormAttributeListener {
    private ArrayList<Separator> separators = new ArrayList();
    private ArrayList<ArrayList<Label>> labels = new ArrayList();
    private ArrayList<ArrayList<ImageView>> flagImageViews = new ArrayList();
    private boolean rightAlignLabels = false;
    private boolean fill = false;
    private int horizontalSpacing = 6;
    private int verticalSpacing = 6;
    private int flagImageOffset = 4;
    private boolean showFirstSectionHeading = false;
    private String delimiter = ":";
    private static final int FLAG_IMAGE_SIZE = 16;
    private static final String DEFAULT_DELIMITER = ":";

    public void install(Component component) {
        super.install(component);
        Form form = (Form)component;
        form.getFormListeners().add((Object)this);
        form.getFormAttributeListeners().add((Object)this);
        Form.SectionSequence sectionSequence = form.getSections();
        int n = sectionSequence.getLength();
        for (int i = 0; i < n; ++i) {
            this.insertSection(sectionSequence.get(i), i);
        }
    }

    public int getPreferredWidth(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Form form = (Form)this.getComponent();
        Form.SectionSequence sectionSequence = form.getSections();
        int n6 = sectionSequence.getLength();
        for (int i = 0; i < n6; ++i) {
            Form.Section section = sectionSequence.get(i);
            if (this.showFirstSectionHeading || i > 0) {
                Separator separator = (Separator)this.separators.get(i);
                n5 = Math.max(n5, separator.getPreferredWidth());
            }
            int n7 = section.getLength();
            for (int j = 0; j < n7; ++j) {
                Component component = section.get(j);
                if (!component.isVisible()) continue;
                Label label = (Label)((ArrayList)this.labels.get(i)).get(j);
                n3 = Math.max(n3, label.getPreferredWidth(-1));
                n4 = Math.max(n4, component.getPreferredWidth(-1));
            }
        }
        n2 = Math.max(n3 + this.horizontalSpacing + n4 + this.flagImageOffset + 16, n5);
        return n2;
    }

    public int getPreferredHeight(int n) {
        Label label;
        Component component;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        Form form = (Form)this.getComponent();
        Form.SectionSequence sectionSequence = form.getSections();
        int n6 = -1;
        if (this.fill && n != -1) {
            n4 = 0;
            int n7 = sectionSequence.getLength();
            for (n3 = 0; n3 < n7; ++n3) {
                Form.Section section = sectionSequence.get(n3);
                int n8 = section.getLength();
                for (n2 = 0; n2 < n8; ++n2) {
                    component = section.get(n2);
                    if (!component.isVisible()) continue;
                    label = (Label)((ArrayList)this.labels.get(n3)).get(n2);
                    n4 = Math.max(n4, label.getPreferredWidth(-1));
                }
            }
            n6 = Math.max(0, n - (n4 + this.horizontalSpacing + this.flagImageOffset + 16));
        }
        n3 = sectionSequence.getLength();
        for (n4 = 0; n4 < n3; ++n4) {
            Form.Section section = sectionSequence.get(n4);
            if (this.showFirstSectionHeading || n4 > 0) {
                Separator separator = (Separator)this.separators.get(n4);
                n5 += separator.getPreferredHeight(n);
                n5 += this.verticalSpacing;
            }
            n2 = section.getLength();
            for (int i = 0; i < n2; ++i) {
                Component component2 = section.get(i);
                if (!component2.isVisible()) continue;
                component = (Label)((ArrayList)this.labels.get(n4)).get(i);
                label = component.getPreferredSize();
                int n9 = component.getBaseline(label.width, label.height);
                if (n9 == -1) {
                    n9 = label.height;
                }
                int n10 = label.height - n9;
                Dimensions dimensions = this.fill && n6 != -1 ? new Dimensions(n6, component2.getPreferredHeight(n6)) : component2.getPreferredSize();
                int n11 = component2.getBaseline(dimensions.width, dimensions.height);
                if (n11 == -1) {
                    n11 = dimensions.height;
                }
                int n12 = dimensions.height - n11;
                int n13 = Math.max(n9, n11);
                int n14 = Math.max(n13 + Math.max(n10, n12), 16);
                n5 += n14;
                if (i <= 0) continue;
                n5 += this.verticalSpacing;
            }
        }
        return n5;
    }

    public Dimensions getPreferredSize() {
        return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
    }

    public int getBaseline(int n, int n2) {
        Label label;
        int n3;
        int n4;
        int n5;
        int n6;
        Form form = (Form)this.getComponent();
        Form.SectionSequence sectionSequence = form.getSections();
        int n7 = -1;
        if (this.fill) {
            n6 = 0;
            n5 = sectionSequence.getLength();
            for (n4 = 0; n4 < n5; ++n4) {
                Form.Section section = sectionSequence.get(n4);
                n3 = section.getLength();
                for (int i = 0; i < n3; ++i) {
                    Component component = section.get(i);
                    if (!component.isVisible()) continue;
                    label = (Label)((ArrayList)this.labels.get(n4)).get(i);
                    n6 = Math.max(n6, label.getPreferredWidth(-1));
                }
            }
            n7 = Math.max(0, n - (n6 + this.horizontalSpacing + this.flagImageOffset + 16));
        }
        n6 = -1;
        n4 = sectionSequence.getLength();
        int n8 = 0;
        for (n5 = 0; n5 < n4 && n6 == -1; ++n5) {
            Form.Section section = sectionSequence.get(n5);
            if (this.showFirstSectionHeading || n5 > 0) {
                Separator separator = (Separator)this.separators.get(n5);
                n8 += separator.getPreferredHeight(n);
                n8 += this.verticalSpacing;
            }
            n3 = section.getLength();
            for (int i = 0; i < n3 && n6 == -1; ++i) {
                label = section.get(i);
                if (!label.isVisible()) continue;
                Label label2 = (Label)((ArrayList)this.labels.get(n5)).get(i);
                Dimensions dimensions = label2.getPreferredSize();
                int n9 = label2.getBaseline(dimensions.width, dimensions.height);
                if (n9 == -1) {
                    n9 = dimensions.height;
                }
                Dimensions dimensions2 = this.fill && n7 != -1 ? new Dimensions(n7, label.getPreferredHeight(n7)) : label.getPreferredSize();
                int n10 = label.getBaseline(dimensions2.width, dimensions2.height);
                if (n10 == -1) {
                    n10 = dimensions2.height;
                }
                n6 = n8 + Math.max(n9, n10);
            }
        }
        return n6;
    }

    public void layout() {
        Label label;
        Component component;
        int n;
        int n2;
        int n3;
        Form form = (Form)this.getComponent();
        Form.SectionSequence sectionSequence = form.getSections();
        int n4 = 0;
        int n5 = sectionSequence.getLength();
        for (n3 = 0; n3 < n5; ++n3) {
            Form.Section section = sectionSequence.get(n3);
            n2 = section.getLength();
            for (n = 0; n < n2; ++n) {
                component = section.get(n);
                if (!component.isVisible()) continue;
                label = (Label)((ArrayList)this.labels.get(n3)).get(n);
                n4 = Math.max(n4, label.getPreferredWidth(-1));
            }
        }
        n3 = this.getWidth();
        n5 = Math.max(0, n3 - (n4 + this.horizontalSpacing + this.flagImageOffset + 16));
        int n6 = 0;
        n2 = sectionSequence.getLength();
        for (n = 0; n < n2; ++n) {
            component = sectionSequence.get(n);
            label = (Separator)this.separators.get(n);
            if (n == 0 && !this.showFirstSectionHeading) {
                label.setVisible(false);
            } else {
                label.setVisible(true);
                label.setSize(n3, label.getPreferredHeight(n3));
                label.setLocation(0, n6);
                n6 += label.getHeight();
            }
            int n7 = component.getLength();
            for (int i = 0; i < n7; ++i) {
                Component component2 = component.get(i);
                Label label2 = (Label)((ArrayList)this.labels.get(n)).get(i);
                ImageView imageView = (ImageView)((ArrayList)this.flagImageViews.get(n)).get(i);
                if (component2.isVisible()) {
                    label2.setVisible(true);
                    imageView.setVisible(true);
                    Dimensions dimensions = label2.getPreferredSize();
                    label2.setSize(dimensions);
                    int n8 = label2.getBaseline(dimensions.width, dimensions.height);
                    if (n8 == -1) {
                        n8 = dimensions.height;
                    }
                    int n9 = dimensions.height - n8;
                    Dimensions dimensions2 = this.fill ? new Dimensions(n5, component2.getPreferredHeight(n5)) : component2.getPreferredSize();
                    component2.setSize(dimensions2);
                    int n10 = component2.getBaseline(dimensions2.width, dimensions2.height);
                    if (n10 == -1) {
                        n10 = dimensions2.height;
                    }
                    int n11 = dimensions2.height - n10;
                    int n12 = Math.max(n8, n10);
                    int n13 = Math.max(n12 + Math.max(n9, n11), 16);
                    int n14 = this.rightAlignLabels ? n4 - label2.getWidth() : 0;
                    int n15 = n6 + (n12 - n8);
                    label2.setLocation(n14, n15);
                    int n16 = n4 + this.horizontalSpacing;
                    int n17 = n6 + (n12 - n10);
                    component2.setLocation(n16, n17);
                    imageView.setSize(imageView.getPreferredSize());
                    int n18 = n15 + (dimensions.height - imageView.getHeight()) / 2;
                    imageView.setLocation(n16 + component2.getWidth() + this.flagImageOffset, n18);
                    n6 += n13 + this.verticalSpacing;
                    continue;
                }
                label2.setVisible(false);
                imageView.setVisible(false);
            }
        }
    }

    public boolean getRightAlignLabels() {
        return this.rightAlignLabels;
    }

    public void setRightAlignLabels(boolean bl) {
        this.rightAlignLabels = bl;
        this.invalidateComponent();
    }

    public boolean getFill() {
        return this.fill;
    }

    public void setFill(boolean bl) {
        this.fill = bl;
        this.invalidateComponent();
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("horizontalSpacing is negative.");
        }
        this.horizontalSpacing = n;
        this.invalidateComponent();
    }

    public final void setHorizontalSpacing(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("horizontalSpacing is null.");
        }
        this.setHorizontalSpacing(number.intValue());
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("verticalSpacing is negative.");
        }
        this.verticalSpacing = n;
        this.invalidateComponent();
    }

    public final void setVerticalSpacing(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("verticalSpacing is null.");
        }
        this.setVerticalSpacing(number.intValue());
    }

    public int getFlagImageOffset() {
        return this.flagImageOffset;
    }

    public void setFlagImageOffset(int n) {
        this.flagImageOffset = n;
        this.invalidateComponent();
    }

    public final void setFlagImageOffset(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("flagImageOffset is null.");
        }
        this.setFlagImageOffset(number.intValue());
    }

    public boolean isShowFirstSectionHeading() {
        return this.showFirstSectionHeading;
    }

    public void setShowFirstSectionHeading(boolean bl) {
        this.showFirstSectionHeading = bl;
        this.invalidateComponent();
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String string) {
        if (string == null) {
            throw new IllegalArgumentException("delimiter is null.");
        }
        this.delimiter = string;
        Form form = (Form)this.getComponent();
        Form.SectionSequence sectionSequence = form.getSections();
        int n = sectionSequence.getLength();
        for (int i = 0; i < n; ++i) {
            Form.Section section = sectionSequence.get(i);
            int n2 = section.getLength();
            for (int j = 0; j < n2; ++j) {
                this.updateFieldLabel(section, j);
            }
        }
        this.invalidateComponent();
    }

    public void sectionInserted(Form form, int n) {
        this.insertSection(form.getSections().get(n), n);
    }

    public void sectionsRemoved(Form form, int n, Sequence<Form.Section> sequence) {
        this.removeSections(n, sequence);
    }

    public void sectionHeadingChanged(Form.Section section) {
        this.updateSectionHeading(section);
    }

    public void fieldInserted(Form.Section section, int n) {
        this.insertField(section, section.get(n), n);
    }

    public void fieldsRemoved(Form.Section section, int n, Sequence<Component> sequence) {
        Form form = (Form)this.getComponent();
        this.removeFields(form.getSections().indexOf(section), n, sequence);
    }

    public void labelChanged(Form form, Component component, String string) {
        Form.Section section = Form.getSection((Component)component);
        this.updateFieldLabel(section, section.indexOf(component));
    }

    public void flagChanged(Form form, Component component, Form.Flag flag) {
        Form.Section section = Form.getSection((Component)component);
        this.updateFieldFlag(section, section.indexOf(component));
    }

    private void insertSection(Form.Section section, int n) {
        Form form = (Form)this.getComponent();
        Separator separator = new Separator(section.getHeading());
        this.separators.insert((Object)separator, n);
        form.add((Component)separator);
        ArrayList arrayList = new ArrayList();
        this.labels.insert((Object)arrayList, n);
        ArrayList arrayList2 = new ArrayList();
        this.flagImageViews.insert((Object)arrayList2, n);
        int n2 = section.getLength();
        for (int i = 0; i < n2; ++i) {
            this.insertField(section, section.get(i), i);
        }
        this.invalidateComponent();
    }

    private void removeSections(int n, Sequence<Form.Section> sequence) {
        Form form = (Form)this.getComponent();
        int n2 = sequence.getLength();
        for (int i = 0; i < n2; ++i) {
            this.removeFields(n + i, 0, (Sequence<Component>)((Sequence)sequence.get(i)));
        }
        this.labels.remove(n, n2);
        this.flagImageViews.remove(n, n2);
        Sequence sequence2 = this.separators.remove(n, n2);
        for (int i = 0; i < n2; ++i) {
            form.remove((Component)sequence2.get(i));
        }
        this.invalidateComponent();
    }

    private void insertField(Form.Section section, Component component, int n) {
        Form form = (Form)this.getComponent();
        int n2 = form.getSections().indexOf(section);
        Label label = new Label();
        ((ArrayList)this.labels.get(n2)).insert((Object)label, n);
        form.add((Component)label);
        this.updateFieldLabel(section, n);
        ImageView imageView = new ImageView();
        ((ArrayList)this.flagImageViews.get(n2)).insert((Object)imageView, n);
        form.add((Component)imageView);
        this.updateFieldFlag(section, n);
        this.invalidateComponent();
    }

    private void removeFields(int n, int n2, Sequence<Component> sequence) {
        Form form = (Form)this.getComponent();
        int n3 = sequence.getLength();
        Sequence sequence2 = ((ArrayList)this.labels.get(n)).remove(n2, n3);
        for (int i = 0; i < n3; ++i) {
            form.remove((Component)sequence2.get(i));
        }
        Sequence sequence3 = ((ArrayList)this.flagImageViews.get(n)).remove(n2, n3);
        for (int i = 0; i < n3; ++i) {
            form.remove((Component)sequence3.get(i));
        }
        this.invalidateComponent();
    }

    private void updateSectionHeading(Form.Section section) {
        Form form = (Form)this.getComponent();
        int n = form.getSections().indexOf(section);
        Separator separator = (Separator)this.separators.get(n);
        separator.setHeading(section.getHeading());
    }

    private void updateFieldLabel(Form.Section section, int n) {
        Form form = (Form)this.getComponent();
        Component component = section.get(n);
        int n2 = form.getSections().indexOf(section);
        Label label = (Label)((ArrayList)this.labels.get(n2)).get(n);
        String string = Form.getLabel((Component)component);
        label.setText(string == null ? "" : string + this.delimiter);
    }

    private void updateFieldFlag(Form.Section section, int n) {
        Form form = (Form)this.getComponent();
        Component component = section.get(n);
        int n2 = form.getSections().indexOf(section);
        ImageView imageView = (ImageView)((ArrayList)this.flagImageViews.get(n2)).get(n);
        Form.Flag flag = Form.getFlag((Component)component);
        Image image = null;
        String string = null;
        if (flag != null) {
            TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
            MessageType messageType = flag.getMessageType();
            image = terraTheme.getSmallMessageIcon(messageType);
            string = flag.getMessage();
        }
        imageView.setImage(image);
        imageView.setTooltipText(string);
    }
}

