/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.LinkButton;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.LinkButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraLinkButtonSkin
extends LinkButtonSkin {
    private Font font;
    private Color color;
    private Color disabledColor;

    public TerraLinkButtonSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.font = terraTheme.getFont();
        this.color = terraTheme.getColor(13);
        this.disabledColor = terraTheme.getColor(7);
    }

    public int getPreferredWidth(int n) {
        LinkButton linkButton = (LinkButton)this.getComponent();
        Button.DataRenderer dataRenderer = linkButton.getDataRenderer();
        dataRenderer.render(linkButton.getButtonData(), (Button)linkButton, false);
        return dataRenderer.getPreferredWidth(n);
    }

    public int getPreferredHeight(int n) {
        LinkButton linkButton = (LinkButton)this.getComponent();
        Button.DataRenderer dataRenderer = linkButton.getDataRenderer();
        dataRenderer.render(linkButton.getButtonData(), (Button)linkButton, false);
        return dataRenderer.getPreferredHeight(n);
    }

    public Dimensions getPreferredSize() {
        LinkButton linkButton = (LinkButton)this.getComponent();
        Button.DataRenderer dataRenderer = linkButton.getDataRenderer();
        dataRenderer.render(linkButton.getButtonData(), (Button)linkButton, false);
        return dataRenderer.getPreferredSize();
    }

    public int getBaseline(int n, int n2) {
        LinkButton linkButton = (LinkButton)this.getComponent();
        Button.DataRenderer dataRenderer = linkButton.getDataRenderer();
        dataRenderer.render(linkButton.getButtonData(), (Button)linkButton, false);
        return dataRenderer.getBaseline(n, n2);
    }

    public void paint(Graphics2D graphics2D) {
        LinkButton linkButton = (LinkButton)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Button.DataRenderer dataRenderer = linkButton.getDataRenderer();
        dataRenderer.render(linkButton.getButtonData(), (Button)linkButton, this.highlighted);
        dataRenderer.setSize(n, n2);
        dataRenderer.paint(graphics2D);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraLinkButtonSkin.decodeFont((String)string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = color;
        this.repaintComponent();
    }

    public final void setDisabledColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)string));
    }
}

