/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Border;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.ListButton;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.Panorama;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.DropShadowDecorator;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.skin.ListButtonSkin;
import org.apache.pivot.wtk.skin.terra.FadeWindowTransition;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraListButtonSkin
extends ListButtonSkin {
    private WindowStateListener listViewPopupStateListener = new WindowStateListener.Adapter(){

        public Vote previewWindowClose(final Window window) {
            Vote vote = Vote.APPROVE;
            if (TerraListButtonSkin.this.closeTransition == null) {
                TerraListButtonSkin.this.closeTransition = (Transition)new FadeWindowTransition((Component)window, 250, 30, TerraListButtonSkin.this.dropShadowDecorator);
                TerraListButtonSkin.this.closeTransition.start(new TransitionListener(){

                    public void transitionCompleted(Transition transition) {
                        window.close();
                    }
                });
                vote = Vote.DEFER;
            } else {
                vote = TerraListButtonSkin.this.closeTransition.isRunning() ? Vote.DEFER : Vote.APPROVE;
            }
            return vote;
        }

        public void windowCloseVetoed(Window window, Vote vote) {
            if (vote == Vote.DENY && TerraListButtonSkin.this.closeTransition != null) {
                TerraListButtonSkin.this.closeTransition.stop();
                TerraListButtonSkin.this.closeTransition = null;
            }
        }

        public void windowClosed(Window window, Display display, Window window2) {
            TerraListButtonSkin.this.closeTransition = null;
        }
    };
    private Panorama listViewPanorama;
    private Border listViewBorder;
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color backgroundColor;
    private Color disabledBackgroundColor;
    private Color borderColor;
    private Color disabledBorderColor;
    private Insets padding;
    private int listSize = -1;
    private Color bevelColor;
    private Color pressedBevelColor;
    private Color disabledBevelColor;
    private Transition closeTransition = null;
    private DropShadowDecorator dropShadowDecorator = null;
    private static final int TRIGGER_WIDTH = 14;
    private static final int CLOSE_TRANSITION_DURATION = 250;
    private static final int CLOSE_TRANSITION_RATE = 30;

    public TerraListButtonSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.font = terraTheme.getFont();
        this.color = terraTheme.getColor(1);
        this.disabledColor = terraTheme.getColor(7);
        this.backgroundColor = terraTheme.getColor(10);
        this.disabledBackgroundColor = terraTheme.getColor(10);
        this.borderColor = terraTheme.getColor(7);
        this.disabledBorderColor = terraTheme.getColor(7);
        this.padding = new Insets(2, 3, 2, 3);
        this.bevelColor = TerraTheme.brighten(this.backgroundColor);
        this.pressedBevelColor = TerraTheme.darken(this.backgroundColor);
        this.disabledBevelColor = this.disabledBackgroundColor;
        this.listViewPopup.getWindowStateListeners().add((Object)this.listViewPopupStateListener);
        this.listViewPanorama = new Panorama((Component)this.listView);
        this.listViewPanorama.getStyles().put("buttonBackgroundColor", this.listView.getStyles().get("backgroundColor"));
        this.listViewPanorama.getStyles().put("alwaysShowScrollButtons", (Object)true);
        this.listViewBorder = new Border((Component)this.listViewPanorama);
        this.listViewBorder.getStyles().put("padding", (Object)0);
        this.listViewBorder.getStyles().put("color", (Object)this.borderColor);
        this.listViewPopup.setContent((Component)this.listViewBorder);
        this.dropShadowDecorator = new DropShadowDecorator(3, 3, 3);
        this.listViewPopup.getDecorators().add((Decorator)this.dropShadowDecorator);
    }

    public int getPreferredWidth(int n) {
        ListButton listButton = (ListButton)this.getComponent();
        Button.DataRenderer dataRenderer = listButton.getDataRenderer();
        dataRenderer.render(listButton.getButtonData(), (Button)listButton, false);
        int n2 = dataRenderer.getPreferredWidth(-1);
        List list = listButton.getListData();
        for (Object e : list) {
            dataRenderer.render(e, (Button)listButton, false);
            n2 = Math.max(n2, dataRenderer.getPreferredWidth(-1));
        }
        return n2 += 14 + this.padding.left + this.padding.right + 2;
    }

    public int getPreferredHeight(int n) {
        ListButton listButton = (ListButton)this.getComponent();
        Button.DataRenderer dataRenderer = listButton.getDataRenderer();
        dataRenderer.render(listButton.getButtonData(), (Button)listButton, false);
        int n2 = dataRenderer.getPreferredHeight(-1) + this.padding.top + this.padding.bottom + 2;
        return n2;
    }

    public Dimensions getPreferredSize() {
        ListButton listButton = (ListButton)this.getComponent();
        Button.DataRenderer dataRenderer = listButton.getDataRenderer();
        dataRenderer.render(listButton.getButtonData(), (Button)listButton, false);
        Dimensions dimensions = dataRenderer.getPreferredSize();
        int n = dimensions.width;
        int n2 = dimensions.height + this.padding.top + this.padding.bottom + 2;
        List list = listButton.getListData();
        for (Object e : list) {
            dataRenderer.render(e, (Button)listButton, false);
            n = Math.max(n, dataRenderer.getPreferredWidth(-1));
        }
        return new Dimensions(n += 14 + this.padding.left + this.padding.right + 2, n2);
    }

    public int getBaseline(int n, int n2) {
        ListButton listButton = (ListButton)this.getComponent();
        Button.DataRenderer dataRenderer = listButton.getDataRenderer();
        dataRenderer.render(listButton.getButtonData(), (Button)listButton, false);
        int n3 = Math.max(n - (14 + this.padding.left + this.padding.right + 2), 0);
        int n4 = Math.max(n2 - (this.padding.top + this.padding.bottom + 2), 0);
        int n5 = dataRenderer.getBaseline(n3, n4);
        if (n5 != -1) {
            n5 += this.padding.top + 1;
        }
        return n5;
    }

    public void layout() {
    }

    public void paint(Graphics2D graphics2D) {
        Object object;
        ListButton listButton = (ListButton)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        if (listButton.isEnabled()) {
            color = this.backgroundColor;
            color2 = this.pressed || this.listViewPopup.isOpen() && this.closeTransition == null ? this.pressedBevelColor : this.bevelColor;
            color3 = this.borderColor;
        } else {
            color = this.disabledBackgroundColor;
            color2 = this.disabledBevelColor;
            color3 = this.disabledBorderColor;
        }
        graphics2D.setStroke(new BasicStroke());
        graphics2D.setPaint(new GradientPaint((float)n / 2.0f, 0.0f, color2, (float)n / 2.0f, (float)n2 / 2.0f, color));
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setPaint(color3);
        Bounds bounds = new Bounds(0, 0, Math.max(n - 14 - 1, 0), Math.max(n2 - 1, 0));
        GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)bounds.x, (int)bounds.y, (int)(bounds.width + 1), (int)(bounds.height + 1));
        Bounds bounds2 = new Bounds(Math.max(n - 14 - 1, 0), 0, 14, Math.max(n2 - 1, 0));
        GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)bounds2.x, (int)bounds2.y, (int)(bounds2.width + 1), (int)(bounds2.height + 1));
        Button.DataRenderer dataRenderer = listButton.getDataRenderer();
        dataRenderer.render(listButton.getButtonData(), (Button)listButton, false);
        dataRenderer.setSize(Math.max(bounds.width - (this.padding.left + this.padding.right + 2) + 1, 0), Math.max(bounds.height - (this.padding.top + this.padding.bottom + 2) + 1, 0));
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.translate(this.padding.left + 1, this.padding.top + 1);
        graphics2D2.clipRect(0, 0, dataRenderer.getWidth(), dataRenderer.getHeight());
        dataRenderer.paint(graphics2D2);
        graphics2D2.dispose();
        if (listButton.isFocused()) {
            object = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{0.0f, 2.0f}, 0.0f);
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(color3);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.draw(new Rectangle2D.Double(2.5, 2.5, Math.max(bounds.width - 4, 0), Math.max(bounds.height - 4, 0)));
        }
        object = new GeneralPath(0);
        ((Path2D.Float)object).moveTo(0.0f, 0.0f);
        ((Path2D.Float)object).lineTo(3.0f, 3.0f);
        ((Path2D.Float)object).lineTo(6.0f, 0.0f);
        ((Path2D)object).closePath();
        Graphics2D graphics2D3 = (Graphics2D)graphics2D.create();
        graphics2D3.setStroke(new BasicStroke(0.0f));
        graphics2D3.setPaint(this.color);
        int n3 = bounds2.x + Math.round((float)(bounds2.width - ((Path2D)object).getBounds().width) / 2.0f);
        int n4 = bounds2.y + Math.round((float)(bounds2.height - ((Path2D)object).getBounds().height) / 2.0f);
        graphics2D3.translate(n3, n4);
        graphics2D3.draw((Shape)object);
        graphics2D3.fill((Shape)object);
        graphics2D3.dispose();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraListButtonSkin.decodeFont((String)string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = color;
        this.repaintComponent();
    }

    public final void setDisabledColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.backgroundColor = color;
        this.bevelColor = TerraTheme.brighten(color);
        this.pressedBevelColor = TerraTheme.darken(color);
        this.repaintComponent();
    }

    public final void setBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getDisabledBackgroundColor() {
        return this.disabledBackgroundColor;
    }

    public void setDisabledBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.disabledBackgroundColor = color;
        this.disabledBevelColor = color;
        this.repaintComponent();
    }

    public final void setDisabledBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.setDisabledBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = color;
        this.listViewBorder.getStyles().put("color", (Object)color);
        this.repaintComponent();
    }

    public final void setBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.disabledBorderColor = color;
        this.repaintComponent();
    }

    public final void setDisabledBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.setDisabledBorderColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public final void setPadding(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(number.intValue());
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)string));
    }

    public int getListSize() {
        return this.listSize;
    }

    public void setListSize(int n) {
        if (n < -1) {
            throw new IllegalArgumentException("Invalid list size.");
        }
        this.listSize = n;
        this.listViewBorder.setPreferredHeight(-1);
    }

    public Object getListFont() {
        return this.listView.getStyles().get("font");
    }

    public void setListFont(Object object) {
        this.listView.getStyles().put("font", object);
    }

    public Object getListColor() {
        return this.listView.getStyles().get("color");
    }

    public void setListColor(Object object) {
        this.listView.getStyles().put("color", object);
    }

    public Object getListDisabledColor() {
        return this.listView.getStyles().get("disabledColor");
    }

    public void setListDisabledColor(Object object) {
        this.listView.getStyles().put("disabledColor", object);
    }

    public Object getListBackgroundColor() {
        return this.listView.getStyles().get("backgroundColor");
    }

    public void setListBackgroundColor(Object object) {
        this.listView.getStyles().put("backgroundColor", object);
        this.listViewPanorama.getStyles().put("buttonBackgroundColor", object);
    }

    public Object getListSelectionColor() {
        return this.listView.getStyles().get("selectionColor");
    }

    public void setListSelectionColor(Object object) {
        this.listView.getStyles().put("selectionColor", object);
    }

    public Object getListSelectionBackgroundColor() {
        return this.listView.getStyles().get("selectionBackgroundColor");
    }

    public void setListSelectionBackgroundColor(Object object) {
        this.listView.getStyles().put("selectionBackgroundColor", object);
    }

    public Object getListInactiveSelectionColor() {
        return this.listView.getStyles().get("inactiveSelectionColor");
    }

    public void setListInactiveSelectionColor(Object object) {
        this.listView.getStyles().put("inactiveSelectionColor", object);
    }

    public Object getListInactiveSelectionBackgroundColor() {
        return this.listView.getStyles().get("inactiveSelectionBackgroundColor");
    }

    public void setListInactiveSelectionBackgroundColor(Object object) {
        this.listView.getStyles().put("inactiveSelectionBackgroundColor", object);
    }

    public Object getListHighlightColor() {
        return this.listView.getStyles().get("highlightColor");
    }

    public void setListHighlightColor(Object object) {
        this.listView.getStyles().put("highlightColor", object);
    }

    public Object getListHighlightBackgroundColor() {
        return this.listView.getStyles().get("highlightBackgroundColor");
    }

    public void setListHighlightBackgroundColor(Object object) {
        this.listView.getStyles().put("highlightBackgroundColor", object);
    }

    public void buttonPressed(Button button) {
        if (this.listViewPopup.isOpen()) {
            this.listViewPopup.close();
        } else {
            Display display;
            ListButton listButton = (ListButton)button;
            if (listButton.getListData().getLength() > 0 && (display = listButton.getDisplay()) != null) {
                int n;
                ListView.ItemRenderer itemRenderer;
                int n2 = this.getWidth();
                int n3 = this.getHeight();
                if (this.listSize == -1) {
                    this.listViewBorder.setPreferredHeight(-1);
                } else if (!this.listViewBorder.isPreferredHeightSet()) {
                    itemRenderer = this.listView.getItemRenderer();
                    int n4 = itemRenderer.getPreferredHeight(-1) * this.listSize + 2;
                    if (this.listViewBorder.getPreferredHeight() > n4) {
                        this.listViewBorder.setPreferredHeight(n4);
                    } else {
                        this.listViewBorder.setPreferredHeight(-1);
                    }
                }
                itemRenderer = listButton.mapPointToAncestor((Container)display, 0, 0);
                Dimensions dimensions = display.getSize();
                this.listViewPopup.setPreferredSize(-1, -1);
                Dimensions dimensions2 = this.listViewPopup.getPreferredSize();
                int n5 = Math.max(dimensions2.width, listButton.getWidth() - 14 - 1);
                int n6 = dimensions2.height;
                int n7 = itemRenderer.x;
                if (n5 > n2 && n7 + n5 > dimensions.width) {
                    n7 = itemRenderer.x + n2 - n5;
                }
                if ((n = itemRenderer.y + n3 - 1) + dimensions2.height > dimensions.height) {
                    if (itemRenderer.y - dimensions2.height > 0) {
                        n = itemRenderer.y - dimensions2.height + 1;
                    } else {
                        n6 = dimensions.height - n;
                    }
                } else {
                    n6 = -1;
                }
                this.listViewPopup.setLocation(n7, n);
                this.listViewPopup.setPreferredSize(n5, n6);
                this.listViewPopup.open(listButton.getWindow());
                ApplicationContext.queueCallback((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        int n = TerraListButtonSkin.this.listView.getSelectedIndex();
                        if (n >= 0) {
                            Bounds bounds = TerraListButtonSkin.this.listView.getItemBounds(n);
                            TerraListButtonSkin.this.listView.scrollAreaToVisible(bounds);
                        }
                    }
                });
                this.listView.requestFocus();
            }
        }
    }
}

