/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.Filter;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Checkbox;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.ListViewItemListener;
import org.apache.pivot.wtk.ListViewItemStateListener;
import org.apache.pivot.wtk.ListViewListener;
import org.apache.pivot.wtk.ListViewSelectionListener;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraListViewSkin
extends ComponentSkin
implements ListView.Skin,
ListViewListener,
ListViewItemListener,
ListViewItemStateListener,
ListViewSelectionListener {
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color backgroundColor;
    private Color selectionColor;
    private Color selectionBackgroundColor;
    private Color inactiveSelectionColor;
    private Color inactiveSelectionBackgroundColor;
    private Color highlightColor;
    private Color highlightBackgroundColor;
    private boolean showHighlight;
    private boolean variableItemHeight;
    private Insets checkboxPadding = new Insets(2, 2, 2, 0);
    private int highlightedIndex = -1;
    private int editIndex = -1;
    private ArrayList<Integer> itemHeights;
    private int fixedItemHeight;
    private static final Checkbox CHECKBOX = new Checkbox();

    public TerraListViewSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.font = terraTheme.getFont();
        this.color = terraTheme.getColor(1);
        this.disabledColor = terraTheme.getColor(7);
        this.backgroundColor = terraTheme.getColor(4);
        this.selectionColor = terraTheme.getColor(4);
        this.selectionBackgroundColor = terraTheme.getColor(19);
        this.inactiveSelectionColor = terraTheme.getColor(1);
        this.inactiveSelectionBackgroundColor = terraTheme.getColor(9);
        this.highlightColor = terraTheme.getColor(1);
        this.highlightBackgroundColor = terraTheme.getColor(10);
        this.showHighlight = true;
    }

    public void install(Component component) {
        super.install(component);
        ListView listView = (ListView)component;
        listView.getListViewListeners().add((Object)this);
        listView.getListViewItemListeners().add((Object)this);
        listView.getListViewItemStateListeners().add((Object)this);
        listView.getListViewSelectionListeners().add((Object)this);
    }

    public int getPreferredWidth(int n) {
        int n2 = 0;
        ListView listView = (ListView)this.getComponent();
        List list = listView.getListData();
        ListView.ItemRenderer itemRenderer = listView.getItemRenderer();
        int n3 = 0;
        for (Object e : list) {
            itemRenderer.render(e, n3++, listView, false, false, false, false);
            n2 = Math.max(n2, itemRenderer.getPreferredWidth(-1));
        }
        if (listView.getCheckmarksEnabled()) {
            n2 += CHECKBOX.getWidth() + (this.checkboxPadding.left + this.checkboxPadding.right);
        }
        return n2;
    }

    public int getPreferredHeight(int n) {
        int n2 = 0;
        ListView listView = (ListView)this.getComponent();
        List list = listView.getListData();
        ListView.ItemRenderer itemRenderer = listView.getItemRenderer();
        if (this.variableItemHeight) {
            int n3 = n;
            if (listView.getCheckmarksEnabled()) {
                n3 = Math.max(n3 - (CHECKBOX.getWidth() + (this.checkboxPadding.left + this.checkboxPadding.right)), 0);
            }
            int n4 = 0;
            for (Object e : list) {
                itemRenderer.render(e, n4++, listView, false, false, false, false);
                n2 += itemRenderer.getPreferredHeight(n3);
            }
        } else {
            itemRenderer.render(null, -1, listView, false, false, false, false);
            int n5 = itemRenderer.getPreferredHeight(-1);
            if (listView.getCheckmarksEnabled()) {
                n5 = Math.max(CHECKBOX.getHeight() + (this.checkboxPadding.top + this.checkboxPadding.bottom), n5);
            }
            n2 = list.getLength() * n5;
        }
        return n2;
    }

    public int getBaseline(int n, int n2) {
        ListView listView = (ListView)this.getComponent();
        int n3 = -1;
        int n4 = n;
        if (listView.getCheckmarksEnabled()) {
            n4 = Math.max(n4 - (CHECKBOX.getWidth() + (this.checkboxPadding.left + this.checkboxPadding.right)), 0);
        }
        ListView.ItemRenderer itemRenderer = listView.getItemRenderer();
        List list = listView.getListData();
        if (this.variableItemHeight && list.getLength() > 0) {
            itemRenderer.render(list.get(0), 0, listView, false, false, false, false);
            int n5 = itemRenderer.getPreferredHeight(n4);
            if (listView.getCheckmarksEnabled()) {
                n5 = Math.max(CHECKBOX.getHeight() + (this.checkboxPadding.top + this.checkboxPadding.bottom), n5);
            }
            n3 = itemRenderer.getBaseline(n4, n5);
        } else {
            itemRenderer.render(null, -1, listView, false, false, false, false);
            int n6 = itemRenderer.getPreferredHeight(-1);
            if (listView.getCheckmarksEnabled()) {
                n6 = Math.max(CHECKBOX.getHeight() + (this.checkboxPadding.top + this.checkboxPadding.bottom), n6);
            }
            n3 = itemRenderer.getBaseline(n4, n6);
        }
        return n3;
    }

    public void layout() {
        ListView listView = (ListView)this.getComponent();
        List list = listView.getListData();
        ListView.ItemRenderer itemRenderer = listView.getItemRenderer();
        if (this.variableItemHeight) {
            int n = this.getWidth();
            int n2 = list.getLength() - 1;
            int n3 = 0;
            if (listView.getCheckmarksEnabled()) {
                n3 = CHECKBOX.getHeight() + (this.checkboxPadding.top + this.checkboxPadding.bottom);
            }
            this.itemHeights = new ArrayList(list.getLength() + 1);
            int n4 = 0;
            for (int i = 0; i <= n2; ++i) {
                Object object = list.get(i);
                boolean bl = i == this.highlightedIndex && listView.getSelectMode() != ListView.SelectMode.NONE;
                boolean bl2 = listView.isItemSelected(i);
                boolean bl3 = listView.isItemDisabled(i);
                int n5 = n;
                int n6 = 0;
                boolean bl4 = false;
                if (listView.getCheckmarksEnabled()) {
                    bl4 = listView.isItemChecked(i);
                    n6 = CHECKBOX.getWidth() + (this.checkboxPadding.left + this.checkboxPadding.right);
                    n5 -= n6;
                }
                itemRenderer.render(object, i, listView, bl2, bl4, bl, bl3);
                int n7 = itemRenderer.getPreferredHeight(n5);
                if (listView.getCheckmarksEnabled()) {
                    n7 = Math.max(n7, n3);
                }
                this.itemHeights.add((Object)n4);
                n4 += n7;
            }
            this.itemHeights.add((Object)n4);
        } else {
            itemRenderer.render(null, -1, listView, false, false, false, false);
            this.fixedItemHeight = itemRenderer.getPreferredHeight(-1);
            if (listView.getCheckmarksEnabled()) {
                this.fixedItemHeight = Math.max(CHECKBOX.getHeight() + (this.checkboxPadding.top + this.checkboxPadding.bottom), this.fixedItemHeight);
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        ListView listView = (ListView)this.getComponent();
        List list = listView.getListData();
        ListView.ItemRenderer itemRenderer = listView.getItemRenderer();
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.backgroundColor != null) {
            graphics2D.setPaint(this.backgroundColor);
            graphics2D.fillRect(0, 0, n, n2);
        }
        int n3 = 0;
        int n4 = list.getLength() - 1;
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle != null) {
            if (this.variableItemHeight) {
                n3 = this.getItemAt(rectangle.y);
                n4 = this.getItemAt(rectangle.y + rectangle.height - 1);
            } else {
                n3 = Math.max(n3, (int)Math.floor((double)rectangle.y / (double)this.fixedItemHeight));
                n4 = Math.min(n4, (int)Math.ceil((double)(rectangle.y + rectangle.height) / (double)this.fixedItemHeight) - 1);
            }
        }
        int n5 = this.variableItemHeight ? (Integer)this.itemHeights.get(n3) : n3 * this.fixedItemHeight;
        for (int i = n3; i <= n4; ++i) {
            Object object = list.get(i);
            boolean bl = i == this.highlightedIndex && listView.getSelectMode() != ListView.SelectMode.NONE;
            boolean bl2 = listView.isItemSelected(i);
            boolean bl3 = listView.isItemDisabled(i);
            int n6 = this.variableItemHeight ? (Integer)this.itemHeights.get(i + 1) - (Integer)this.itemHeights.get(i) : this.fixedItemHeight;
            Color color = null;
            if (bl2) {
                color = listView.isFocused() ? this.selectionBackgroundColor : this.inactiveSelectionBackgroundColor;
            } else if (bl && this.showHighlight && !bl3) {
                color = this.highlightBackgroundColor;
            }
            if (color != null) {
                graphics2D.setPaint(color);
                graphics2D.fillRect(0, n5, n, n6);
            }
            int n7 = 0;
            int n8 = n;
            boolean bl4 = false;
            if (listView.getCheckmarksEnabled()) {
                bl4 = listView.isItemChecked(i);
                int n9 = (n6 - CHECKBOX.getHeight()) / 2;
                Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(this.checkboxPadding.left, n5 + n9, CHECKBOX.getWidth(), CHECKBOX.getHeight());
                CHECKBOX.setSelected(bl4);
                CHECKBOX.setEnabled(!bl3 && !listView.isCheckmarkDisabled(i));
                CHECKBOX.paint(graphics2D2);
                graphics2D2.dispose();
                n7 = CHECKBOX.getWidth() + (this.checkboxPadding.left + this.checkboxPadding.right);
                n8 -= n7;
            }
            Graphics2D graphics2D3 = (Graphics2D)graphics2D.create(n7, n5, n8, n6);
            itemRenderer.render(object, i, listView, bl2, bl4, bl, bl3);
            itemRenderer.setSize(n8, n6);
            itemRenderer.paint(graphics2D3);
            graphics2D3.dispose();
            n5 += n6;
        }
    }

    public int getItemAt(int n) {
        List list;
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("y is negative");
        }
        ListView listView = (ListView)this.getComponent();
        if (this.variableItemHeight) {
            n2 = ArrayList.binarySearch(this.itemHeights, (Comparable)Integer.valueOf(n));
            if (n2 < 0) {
                n2 = -n2 - 2;
            }
        } else {
            n2 = n / this.fixedItemHeight;
        }
        if (n2 >= (list = listView.getListData()).getLength()) {
            n2 = -1;
        }
        return n2;
    }

    public Bounds getItemBounds(int n) {
        return new Bounds(0, this.getItemY(n), this.getWidth(), this.getItemHeight(n));
    }

    public int getItemIndent() {
        int n = 0;
        ListView listView = (ListView)this.getComponent();
        if (listView.getCheckmarksEnabled()) {
            n = CHECKBOX.getWidth() + this.checkboxPadding.left + this.checkboxPadding.right;
        }
        return n;
    }

    private int getItemY(int n) {
        int n2 = this.variableItemHeight ? (Integer)this.itemHeights.get(n) : n * this.fixedItemHeight;
        return n2;
    }

    private int getItemHeight(int n) {
        int n2 = this.variableItemHeight ? (Integer)this.itemHeights.get(n + 1) - (Integer)this.itemHeights.get(n) : this.fixedItemHeight;
        return n2;
    }

    public boolean isFocusable() {
        ListView listView = (ListView)this.getComponent();
        return listView.getSelectMode() != ListView.SelectMode.NONE;
    }

    public boolean isOpaque() {
        return this.backgroundColor != null && this.backgroundColor.getTransparency() == 1;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraListViewSkin.decodeFont((String)string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = color;
        this.repaintComponent();
    }

    public final void setDisabledColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.repaintComponent();
    }

    public final void setBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.selectionColor = color;
        this.repaintComponent();
    }

    public final void setSelectionColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.setSelectionColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.selectionBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setSelectionBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.setSelectionBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getInactiveSelectionColor() {
        return this.inactiveSelectionColor;
    }

    public void setInactiveSelectionColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.inactiveSelectionColor = color;
        this.repaintComponent();
    }

    public final void setInactiveSelectionColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.setInactiveSelectionColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getInactiveSelectionBackgroundColor() {
        return this.inactiveSelectionBackgroundColor;
    }

    public void setInactiveSelectionBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.inactiveSelectionBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setInactiveSelectionBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.setInactiveSelectionBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("highlightColor is null.");
        }
        this.highlightColor = color;
        this.repaintComponent();
    }

    public final void setHighlightColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("highlightColor is null.");
        }
        this.setHighlightColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getHighlightBackgroundColor() {
        return this.highlightBackgroundColor;
    }

    public void setHighlightBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.highlightBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setHighlightBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.setHighlightBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public boolean getShowHighlight() {
        return this.showHighlight;
    }

    public void setShowHighlight(boolean bl) {
        this.showHighlight = bl;
        this.repaintComponent();
    }

    public Insets getCheckboxPadding() {
        return this.checkboxPadding;
    }

    public void setCheckboxPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("checkboxPadding is null.");
        }
        this.checkboxPadding = insets;
        this.invalidateComponent();
    }

    public final void setCheckboxPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("checkboxPadding is null.");
        }
        this.setCheckboxPadding(new Insets(dictionary));
    }

    public final void setCheckboxPadding(int n) {
        this.setCheckboxPadding(new Insets(n));
    }

    public final void setCheckboxPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("checkboxPadding is null.");
        }
        this.setCheckboxPadding(Insets.decode((String)string));
    }

    public boolean isVariableItemHeight() {
        return this.variableItemHeight;
    }

    public void setVariableItemHeight(boolean bl) {
        this.variableItemHeight = bl;
        this.invalidateComponent();
    }

    public boolean mouseMove(Component component, int n, int n2) {
        boolean bl = super.mouseMove(component, n, n2);
        ListView listView = (ListView)this.getComponent();
        int n3 = this.highlightedIndex;
        this.highlightedIndex = this.getItemAt(n2);
        if (n3 != this.highlightedIndex && listView.getSelectMode() != ListView.SelectMode.NONE && this.showHighlight) {
            if (n3 != -1) {
                this.repaintComponent(this.getItemBounds(n3));
            }
            if (this.highlightedIndex != -1) {
                this.repaintComponent(this.getItemBounds(this.highlightedIndex));
            }
        }
        return bl;
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        ListView listView = (ListView)this.getComponent();
        if (this.highlightedIndex != -1 && listView.getSelectMode() != ListView.SelectMode.NONE && this.showHighlight) {
            Bounds bounds = this.getItemBounds(this.highlightedIndex);
            this.repaintComponent(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        this.highlightedIndex = -1;
        this.editIndex = -1;
    }

    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseDown(component, button, n, n2);
        ListView listView = (ListView)this.getComponent();
        List list = listView.getListData();
        int n3 = this.getItemAt(n2);
        if (n3 != -1 && n3 < list.getLength() && !listView.isItemDisabled(n3)) {
            int n4 = this.getItemBounds((int)n3).y;
            if (!listView.getCheckmarksEnabled() || n <= this.checkboxPadding.left || n >= this.checkboxPadding.left + CHECKBOX.getWidth() || n2 <= n4 + this.checkboxPadding.top || n2 >= n4 + this.checkboxPadding.top + CHECKBOX.getHeight()) {
                ListView.SelectMode selectMode = listView.getSelectMode();
                if (button == Mouse.Button.RIGHT) {
                    if (!listView.isItemSelected(n3) && selectMode != ListView.SelectMode.NONE) {
                        listView.setSelectedIndex(n3);
                    }
                } else {
                    Keyboard.Modifier modifier = Platform.getCommandModifier();
                    if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && selectMode == ListView.SelectMode.MULTI) {
                        Filter filter = listView.getDisabledItemFilter();
                        if (filter == null) {
                            ArrayList arrayList = new ArrayList();
                            int n5 = listView.getFirstSelectedIndex();
                            int n6 = listView.getLastSelectedIndex();
                            Span span = n3 > n5 ? new Span(n5, n3) : new Span(n3, n6);
                            arrayList.add((Object)span);
                            listView.setSelectedRanges((Sequence)arrayList);
                        }
                    } else if (Keyboard.isPressed((Keyboard.Modifier)modifier) && selectMode == ListView.SelectMode.MULTI) {
                        if (listView.isItemSelected(n3)) {
                            listView.removeSelectedIndex(n3);
                        } else {
                            listView.addSelectedIndex(n3);
                        }
                    } else if (selectMode != ListView.SelectMode.NONE) {
                        if (listView.isItemSelected(n3) && listView.isFocused()) {
                            this.editIndex = n3;
                        }
                        listView.setSelectedIndex(n3);
                    }
                }
            }
        }
        listView.requestFocus();
        return bl;
    }

    public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
        boolean bl = super.mouseClick(component, button, n, n2, n3);
        ListView listView = (ListView)this.getComponent();
        List list = listView.getListData();
        int n4 = this.getItemAt(n2);
        if (n4 < list.getLength() && !listView.isItemDisabled(n4)) {
            int n5 = this.getItemBounds((int)n4).y;
            if (listView.getCheckmarksEnabled() && !listView.isCheckmarkDisabled(n4) && n > this.checkboxPadding.left && n < this.checkboxPadding.left + CHECKBOX.getWidth() && n2 > n5 + this.checkboxPadding.top && n2 < n5 + this.checkboxPadding.top + CHECKBOX.getHeight()) {
                listView.setItemChecked(n4, !listView.isItemChecked(n4));
            } else {
                ListView.ItemEditor itemEditor;
                if (this.editIndex != -1 && n3 == 1 && (itemEditor = listView.getItemEditor()) != null) {
                    itemEditor.editItem(listView, this.editIndex);
                }
                this.editIndex = -1;
            }
        }
        return bl;
    }

    public boolean mouseWheel(Component component, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
        ListView listView = (ListView)this.getComponent();
        if (this.highlightedIndex != -1) {
            Bounds bounds = this.getItemBounds(this.highlightedIndex);
            this.highlightedIndex = -1;
            if (listView.getSelectMode() != ListView.SelectMode.NONE && this.showHighlight) {
                this.repaintComponent(bounds.x, bounds.y, bounds.width, bounds.height, true);
            }
        }
        return super.mouseWheel(component, scrollType, n, n2, n3, n4);
    }

    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = super.keyPressed(component, n, keyLocation);
        ListView listView = (ListView)this.getComponent();
        switch (n) {
            case 38: {
                int n2 = listView.getFirstSelectedIndex();
                while (--n2 >= 0 && listView.isItemDisabled(n2)) {
                }
                if (n2 >= 0) {
                    if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && listView.getSelectMode() == ListView.SelectMode.MULTI) {
                        listView.addSelectedIndex(n2);
                    } else {
                        listView.setSelectedIndex(n2);
                    }
                    listView.scrollAreaToVisible(this.getItemBounds(n2));
                }
                bl = true;
                break;
            }
            case 40: {
                int n3 = listView.getLastSelectedIndex();
                int n4 = listView.getListData().getLength();
                while (++n3 < n4 && listView.isItemDisabled(n3)) {
                }
                if (n3 < n4) {
                    if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && listView.getSelectMode() == ListView.SelectMode.MULTI) {
                        listView.addSelectedIndex(n3);
                    } else {
                        listView.setSelectedIndex(n3);
                    }
                    listView.scrollAreaToVisible(this.getItemBounds(n3));
                }
                bl = true;
                break;
            }
        }
        if (this.highlightedIndex != -1 && listView.getSelectMode() != ListView.SelectMode.NONE && this.showHighlight) {
            this.repaintComponent(this.getItemBounds(this.highlightedIndex));
        }
        this.highlightedIndex = -1;
        return bl;
    }

    public boolean keyReleased(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = super.keyReleased(component, n, keyLocation);
        ListView listView = (ListView)this.getComponent();
        switch (n) {
            case 32: {
                int n2;
                if (!listView.getCheckmarksEnabled() || listView.getSelectMode() != ListView.SelectMode.SINGLE || listView.isCheckmarkDisabled(n2 = listView.getSelectedIndex())) break;
                listView.setItemChecked(n2, !listView.isItemChecked(n2));
                bl = true;
            }
        }
        return bl;
    }

    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.repaintComponent();
    }

    public void focusedChanged(Component component, Component component2) {
        super.focusedChanged(component, component2);
        this.repaintComponent();
    }

    public void listDataChanged(ListView listView, List<?> list) {
        this.invalidateComponent();
    }

    public void itemRendererChanged(ListView listView, ListView.ItemRenderer itemRenderer) {
        this.invalidateComponent();
    }

    public void itemEditorChanged(ListView listView, ListView.ItemEditor itemEditor) {
    }

    public void selectModeChanged(ListView listView, ListView.SelectMode selectMode) {
        this.repaintComponent();
    }

    public void checkmarksEnabledChanged(ListView listView) {
        this.invalidateComponent();
    }

    public void disabledItemFilterChanged(ListView listView, Filter<?> filter) {
        this.repaintComponent();
    }

    public void disabledCheckmarkFilterChanged(ListView listView, Filter<?> filter) {
        this.repaintComponent();
    }

    public void selectedItemKeyChanged(ListView listView, String string) {
    }

    public void selectedItemsKeyChanged(ListView listView, String string) {
    }

    public void itemInserted(ListView listView, int n) {
        this.invalidateComponent();
    }

    public void itemsRemoved(ListView listView, int n, int n2) {
        this.invalidateComponent();
    }

    public void itemUpdated(ListView listView, int n) {
        this.invalidateComponent();
    }

    public void itemsCleared(ListView listView) {
        this.invalidateComponent();
    }

    public void itemsSorted(ListView listView) {
        if (this.variableItemHeight) {
            this.invalidateComponent();
        } else {
            this.repaintComponent();
        }
    }

    public void itemCheckedChanged(ListView listView, int n) {
        this.repaintComponent(this.getItemBounds(n));
    }

    public void selectedRangeAdded(ListView listView, int n, int n2) {
        this.repaintComponent(0, this.getItemY(n), this.getWidth(), this.getItemY(n2) + this.getItemHeight(n2));
    }

    public void selectedRangeRemoved(ListView listView, int n, int n2) {
        this.repaintComponent(0, this.getItemY(n), this.getWidth(), this.getItemY(n2) + this.getItemHeight(n2));
    }

    public void selectedRangesChanged(ListView listView, Sequence<Span> sequence) {
        List list = listView.getListData();
        int n = 0;
        int n2 = list.getLength() - 1;
        for (int i = 0; i < sequence.getLength(); ++i) {
            Span span = (Span)sequence.get(i);
            n = Math.min(n, span.start);
            n2 = Math.max(n2, span.end);
        }
        Sequence sequence2 = listView.getSelectedRanges();
        for (int i = 0; i < sequence2.getLength(); ++i) {
            Span span = (Span)sequence2.get(i);
            n = Math.min(n, span.start);
            n2 = Math.max(n2, span.end);
        }
        this.repaintComponent(0, this.getItemY(n), this.getWidth(), this.getItemY(n2) + this.getItemHeight(n2));
    }

    static {
        CHECKBOX.setSize(CHECKBOX.getPreferredSize());
    }
}

