/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.MenuItemSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraMenuItemSkin
extends MenuItemSkin {
    private Image checkmarkImage = new CheckmarkImage();
    public static final int EXPANDER_SIZE = 11;
    public static final int EXPANDER_ICON_SIZE = 5;

    public void install(Component component) {
        super.install(component);
        Menu.Item item = (Menu.Item)component;
        item.setCursor(Cursor.DEFAULT);
    }

    public int getPreferredWidth(int n) {
        Menu.Item item = (Menu.Item)this.getComponent();
        Button.DataRenderer dataRenderer = item.getDataRenderer();
        dataRenderer.render(item.getButtonData(), (Button)item, false);
        return dataRenderer.getPreferredWidth(n) + 11;
    }

    public int getPreferredHeight(int n) {
        Menu.Item item = (Menu.Item)this.getComponent();
        Button.DataRenderer dataRenderer = item.getDataRenderer();
        dataRenderer.render(item.getButtonData(), (Button)item, false);
        return Math.max(dataRenderer.getPreferredHeight(n), 11);
    }

    public Dimensions getPreferredSize() {
        Menu.Item item = (Menu.Item)this.getComponent();
        Button.DataRenderer dataRenderer = item.getDataRenderer();
        dataRenderer.render(item.getButtonData(), (Button)item, false);
        Dimensions dimensions = dataRenderer.getPreferredSize();
        return new Dimensions(dimensions.width + 11, Math.max(dimensions.height, 11));
    }

    public void layout() {
    }

    public void paint(Graphics2D graphics2D) {
        Object object;
        Menu.Item item = (Menu.Item)this.getComponent();
        Menu menu = (Menu)item.getParent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        boolean bl = item.isActive();
        if (bl) {
            object = (Color)menu.getStyles().get("activeBackgroundColor");
            graphics2D.setPaint(new GradientPaint((float)n / 2.0f, 0.0f, TerraTheme.brighten((Color)object), (float)n / 2.0f, n2, (Color)object));
            graphics2D.fillRect(0, 0, n, n2);
        }
        object = item.getDataRenderer();
        object.render(item.getButtonData(), (Button)item, bl);
        object.setSize(Math.max(n - 11, 0), n2);
        object.paint(graphics2D);
        if (item.getMenu() != null) {
            Color color = (Color)(bl ? menu.getStyles().get("activeColor") : menu.getStyles().get("color"));
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(0.0f));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.translate(object.getWidth() + 3, (n2 - 5) / 2);
            int[] nArray = new int[]{0, 5, 0};
            int[] nArray2 = new int[]{0, 2, 5};
            graphics2D.fillPolygon(nArray, nArray2, 3);
            graphics2D.drawPolygon(nArray, nArray2, 3);
        }
    }

    public boolean isOpaque() {
        boolean bl = false;
        Menu.Item item = (Menu.Item)this.getComponent();
        if (item.isActive()) {
            Menu menu = (Menu)item.getParent();
            Color color = (Color)menu.getStyles().get("activeBackgroundColor");
            bl = color.getTransparency() == 1;
        }
        return bl;
    }

    public Image getCheckmarkImage() {
        return this.checkmarkImage;
    }

    public Color getPopupBorderColor() {
        return (Color)this.menuPopup.getStyles().get("borderColor");
    }

    public void setPopupBorderColor(Color color) {
        this.menuPopup.getStyles().put("borderColor", (Object)color);
    }

    public void setPopupBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("popupBorderColor is null.");
        }
        this.menuPopup.getStyles().put("borderColor", (Object)string);
    }

    public final class CheckmarkImage
    extends Image {
        public static final int SIZE = 14;
        public static final int CHECKMARK_SIZE = 10;

        public int getWidth() {
            return 14;
        }

        public int getHeight() {
            return 14;
        }

        public void paint(Graphics2D graphics2D) {
            Menu.Item item = (Menu.Item)TerraMenuItemSkin.this.getComponent();
            Menu menu = (Menu)item.getParent();
            Color color = (Color)menu.getStyles().get("color");
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(2.5f));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n = 5;
            int n2 = 2;
            int n3 = (14 - (n + n2)) / 2;
            int n4 = (14 - n) / 2;
            graphics2D.drawLine(n3, n - n2 + n4, n2 + n3, n + n4);
            graphics2D.drawLine(n2 + n3, n + n4, n2 + n + n3, n4);
        }
    }
}

