/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Border;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuItemSelectionListener;
import org.apache.pivot.wtk.MenuPopup;
import org.apache.pivot.wtk.MenuPopupListener;
import org.apache.pivot.wtk.MenuPopupStateListener;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Panorama;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.DropShadowDecorator;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.skin.WindowSkin;
import org.apache.pivot.wtk.skin.terra.FadeWindowTransition;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraMenuPopupSkin
extends WindowSkin
implements MenuPopupListener,
MenuPopupStateListener {
    private Panorama panorama;
    private Border border;
    private DropShadowDecorator dropShadowDecorator = null;
    private Transition closeTransition = null;
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener.Adapter(){

        public boolean mouseDown(Container container, Mouse.Button button, int n, int n2) {
            Display display;
            Component component;
            MenuPopup menuPopup = (MenuPopup)TerraMenuPopupSkin.this.getComponent();
            if (menuPopup.isContextMenu() && (component = (display = (Display)container).getDescendantAt(n, n2)) != display) {
                Window window = component.getWindow();
                if (!(menuPopup.isAncestor(component) || window != null && menuPopup.isOwner(window))) {
                    menuPopup.close();
                }
            }
            return false;
        }

        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
            MenuPopup menuPopup;
            boolean bl = false;
            Display display = (Display)container;
            Window window = (Window)display.getComponentAt(n3, n4);
            if (!(window == (menuPopup = (MenuPopup)TerraMenuPopupSkin.this.getComponent()) || window != null && menuPopup.isOwner(window))) {
                bl = true;
            }
            return bl;
        }
    };
    private MenuItemSelectionListener menuItemSelectionListener = new MenuItemSelectionListener(){

        public void itemSelected(Menu.Item item) {
            MenuPopup menuPopup = (MenuPopup)TerraMenuPopupSkin.this.getComponent();
            menuPopup.close();
        }
    };
    private static final int CLOSE_TRANSITION_DURATION = 200;
    private static final int CLOSE_TRANSITION_RATE = 30;

    public TerraMenuPopupSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(null);
        this.panorama = new Panorama();
        this.panorama.getStyles().put("buttonBackgroundColor", (Object)Color.WHITE);
        this.border = new Border((Component)this.panorama);
        this.border.getStyles().put("color", (Object)terraTheme.getColor(7));
        this.border.getStyles().put("backgroundColor", null);
        this.border.getStyles().put("padding", (Object)0);
    }

    public void install(Component component) {
        super.install(component);
        MenuPopup menuPopup = (MenuPopup)component;
        menuPopup.getMenuPopupListeners().add((Object)this);
        menuPopup.getMenuPopupStateListeners().add((Object)this);
        Menu menu = menuPopup.getMenu();
        if (menu != null) {
            menu.getMenuItemSelectionListeners().add((Object)this.menuItemSelectionListener);
        }
        this.panorama.setView((Component)menu);
        menuPopup.setContent((Component)this.border);
        this.dropShadowDecorator = new DropShadowDecorator(3, 3, 3);
        menuPopup.getDecorators().add((Decorator)this.dropShadowDecorator);
    }

    public Color getBorderColor() {
        return (Color)this.border.getStyles().get("color");
    }

    public void setBorderColor(Color color) {
        this.border.getStyles().put("color", (Object)color);
    }

    public void setBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.border.getStyles().put("color", (Object)string);
    }

    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = super.keyPressed(component, n, keyLocation);
        if (n == 27) {
            MenuPopup menuPopup = (MenuPopup)this.getComponent();
            menuPopup.close();
        }
        return bl;
    }

    public void windowOpened(Window window) {
        super.windowOpened(window);
        Display display = window.getDisplay();
        display.getContainerMouseListeners().add((Object)this.displayMouseListener);
        MenuPopup menuPopup = (MenuPopup)window;
        Menu menu = menuPopup.getMenu();
        if (menu != null) {
            Menu.Item item = menu.getActiveItem();
            if (item != null) {
                item.setActive(false);
            }
            menu.requestFocus();
        }
        if (menuPopup.isContextMenu()) {
            ApplicationContext.queueCallback((Runnable)new RepositionCallback());
        }
    }

    public void windowClosed(Window window, Display display, Window window2) {
        super.windowClosed(window, display, window2);
        display.getContainerMouseListeners().remove((Object)this.displayMouseListener);
        if (window2 != null && window2.isOpen()) {
            window2.moveToFront();
        }
    }

    public void menuChanged(MenuPopup menuPopup, Menu menu) {
        Menu menu2;
        if (menu != null) {
            menu.getMenuItemSelectionListeners().remove((Object)this.menuItemSelectionListener);
        }
        if ((menu2 = menuPopup.getMenu()) != null) {
            menu2.getMenuItemSelectionListeners().add((Object)this.menuItemSelectionListener);
        }
        this.panorama.setView((Component)menu2);
    }

    public Vote previewMenuPopupClose(final MenuPopup menuPopup, boolean bl) {
        if (!bl && this.closeTransition == null) {
            this.border.setEnabled(false);
            this.closeTransition = new FadeWindowTransition((Component)menuPopup, 200, 30, this.dropShadowDecorator);
            this.closeTransition.start(new TransitionListener(){

                public void transitionCompleted(Transition transition) {
                    menuPopup.close();
                }
            });
        }
        return this.closeTransition != null && this.closeTransition.isRunning() ? Vote.DEFER : Vote.APPROVE;
    }

    public void menuPopupCloseVetoed(MenuPopup menuPopup, Vote vote) {
        if (vote == Vote.DENY && this.closeTransition != null) {
            this.closeTransition.stop();
            this.border.setEnabled(true);
            this.closeTransition = null;
        }
    }

    public void menuPopupClosed(MenuPopup menuPopup) {
        this.border.setEnabled(true);
        this.closeTransition = null;
    }

    private class RepositionCallback
    implements Runnable {
        private RepositionCallback() {
        }

        @Override
        public void run() {
            int n;
            MenuPopup menuPopup = (MenuPopup)TerraMenuPopupSkin.this.getComponent();
            Display display = menuPopup.getDisplay();
            Point point = menuPopup.getLocation();
            Dimensions dimensions = menuPopup.getSize();
            int n2 = point.x;
            if (n2 + dimensions.width > display.getWidth()) {
                n2 -= dimensions.width;
            }
            if ((n = point.y) + dimensions.height > display.getHeight()) {
                n -= dimensions.height;
            }
            menuPopup.setLocation(n2, n);
        }
    }
}

