/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Meter;
import org.apache.pivot.wtk.MeterListener;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraMeterSkin
extends ComponentSkin
implements MeterListener {
    private Color fillColor;
    private Color gridColor;
    private float gridFrequency;
    private Font font;
    private Color textColor;
    private Color textFillColor;
    private static final FontRenderContext FONT_RENDER_CONTEXT = new FontRenderContext(null, true, false);
    private static final int DEFAULT_WIDTH = 100;
    private static final int DEFAULT_HEIGHT = 12;

    public TerraMeterSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.fillColor = terraTheme.getColor(16);
        this.gridColor = terraTheme.getColor(10);
        this.gridFrequency = 0.25f;
        this.font = terraTheme.getFont().deriveFont(1);
        this.textColor = terraTheme.getColor(1);
        this.textFillColor = terraTheme.getColor(4);
    }

    public void install(Component component) {
        super.install(component);
        Meter meter = (Meter)component;
        meter.getMeterListeners().add((Object)this);
    }

    public boolean isFocusable() {
        return false;
    }

    public int getPreferredWidth(int n) {
        int n2;
        Meter meter = (Meter)this.getComponent();
        if (meter.getOrientation() == Orientation.HORIZONTAL) {
            String string = meter.getText();
            if (string != null && string.length() > 0) {
                Rectangle2D rectangle2D = this.font.getStringBounds(string, FONT_RENDER_CONTEXT);
                n2 = (int)Math.ceil(rectangle2D.getWidth()) + 2;
            } else {
                n2 = 0;
            }
            n2 = Math.max(n2, 100);
        } else {
            n2 = this.getPreferredHeight(-1);
        }
        return n2;
    }

    public int getPreferredHeight(int n) {
        int n2;
        Meter meter = (Meter)this.getComponent();
        if (meter.getOrientation() == Orientation.HORIZONTAL) {
            n2 = this.getPreferredWidth(n);
        } else {
            String string = meter.getText();
            if (string != null && string.length() > 0) {
                LineMetrics lineMetrics = this.font.getLineMetrics("", FONT_RENDER_CONTEXT);
                n2 = (int)Math.ceil(lineMetrics.getHeight()) + 2;
            } else {
                n2 = 0;
            }
            n2 = Math.max(n2, 12);
        }
        return n2;
    }

    public Dimensions getPreferredSize() {
        Rectangle2D rectangle2D;
        Meter meter = (Meter)this.getComponent();
        String string = meter.getText();
        int n = 0;
        int n2 = 0;
        if (string != null && string.length() > 0) {
            rectangle2D = this.font.getStringBounds(string, FONT_RENDER_CONTEXT);
            n = (int)Math.ceil(rectangle2D.getWidth()) + 2;
            LineMetrics lineMetrics = this.font.getLineMetrics("", FONT_RENDER_CONTEXT);
            n2 = (int)Math.ceil(lineMetrics.getHeight()) + 2;
        }
        n = Math.max(n, 100);
        n2 = Math.max(n2, 12);
        rectangle2D = meter.getOrientation() == Orientation.HORIZONTAL ? new Dimensions(n, n2) : new Dimensions(n2, n);
        return rectangle2D;
    }

    public int getBaseline(int n, int n2) {
        String string;
        int n3 = -1;
        Meter meter = (Meter)this.getComponent();
        if (meter.getOrientation() == Orientation.HORIZONTAL && (string = meter.getText()) != null && string.length() > 0) {
            LineMetrics lineMetrics = this.font.getLineMetrics("", FONT_RENDER_CONTEXT);
            float f = lineMetrics.getAscent();
            float f2 = lineMetrics.getHeight();
            n3 = Math.round(((float)n2 - f2) / 2.0f + f);
        }
        return n3;
    }

    public void layout() {
    }

    public void paint(Graphics2D graphics2D) {
        Meter meter = (Meter)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (FONT_RENDER_CONTEXT.isAntiAliased()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, Platform.getTextAntialiasingHint());
        }
        if (FONT_RENDER_CONTEXT.usesFractionalMetrics()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        if (meter.getOrientation() == Orientation.HORIZONTAL) {
            this.drawMeter(meter, graphics2D, n, n2);
        } else {
            graphics2D.rotate(-1.5707963267948966);
            graphics2D.translate(-n2, 0);
            this.drawMeter(meter, graphics2D, n2, n);
        }
    }

    private void drawMeter(Meter meter, Graphics2D graphics2D, int n, int n2) {
        int n3 = (int)(meter.getPercentage() * (double)n);
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, TerraTheme.brighten(this.fillColor), 0.0f, n2, TerraTheme.darken(this.fillColor)));
        graphics2D.fillRect(0, 0, n3, n2);
        graphics2D.setPaint(this.gridColor);
        GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (int)n2);
        int n4 = (int)Math.ceil(1.0f / this.gridFrequency) - 1;
        float f = (float)n * this.gridFrequency;
        for (int i = 0; i < n4; ++i) {
            int n5 = (int)((float)(i + 1) * f);
            GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)n5, (int)0, (int)n2, (Orientation)Orientation.VERTICAL);
        }
        String string = meter.getText();
        if (string != null && string.length() > 0) {
            LineMetrics lineMetrics = this.font.getLineMetrics("", FONT_RENDER_CONTEXT);
            float f2 = lineMetrics.getAscent();
            Rectangle2D rectangle2D = this.font.getStringBounds(string, FONT_RENDER_CONTEXT);
            float f3 = (float)rectangle2D.getWidth();
            float f4 = (float)rectangle2D.getHeight();
            float f5 = ((float)n - f3) / 2.0f;
            float f6 = ((float)n2 - f4) / 2.0f;
            Shape shape = graphics2D.getClip();
            graphics2D.clipRect(0, 0, n3, n2);
            graphics2D.setPaint(this.textFillColor);
            graphics2D.setFont(this.font);
            graphics2D.drawString(meter.getText(), f5, f6 + f2);
            graphics2D.setClip(shape);
            graphics2D.clipRect(n3, 0, n, n2);
            graphics2D.setPaint(this.textColor);
            graphics2D.setFont(this.font);
            graphics2D.drawString(meter.getText(), f5, f6 + f2);
        }
    }

    public Color getColor() {
        return this.fillColor;
    }

    public void setColor(Color color) {
        this.fillColor = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
        this.repaintComponent();
    }

    public final void setGridColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("gridColor is null.");
        }
        this.setGridColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
        this.repaintComponent();
    }

    public final void setTextColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setTextColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getTextFillColor() {
        return this.textFillColor;
    }

    public void setTextFillColor(Color color) {
        this.textFillColor = color;
        this.repaintComponent();
    }

    public final void setTextFillColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setTextFillColor(GraphicsUtilities.decodeColor((String)string));
    }

    public float getGridFrequency() {
        return this.gridFrequency;
    }

    public void setGridFrequency(float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("gridFrequency must be > 0 and <= 1");
        }
        this.gridFrequency = f;
        this.repaintComponent();
    }

    public final void setGridFrequency(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("gridFrequency is null.");
        }
        this.setGridFrequency(number.floatValue());
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraMeterSkin.decodeFont((String)string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public void percentageChanged(Meter meter, double d) {
        this.repaintComponent();
    }

    public void textChanged(Meter meter, String string) {
        this.invalidateComponent();
    }

    public void orientationChanged(Meter meter) {
        this.invalidateComponent();
    }
}

