/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.LinkButton;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Palette;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowClassListener;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.DropShadowDecorator;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.WindowSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraPaletteSkin
extends WindowSkin {
    private Image closeImage = new CloseImage();
    private Image resizeImage = new ResizeImage();
    private TablePane titleBarTablePane = new TablePane();
    private BoxPane titleBoxPane = new BoxPane();
    private BoxPane buttonBoxPane = new BoxPane();
    private Label titleLabel = new Label();
    private LinkButton closeButton = new LinkButton((Object)this.closeImage);
    private ImageView resizeHandle = new ImageView(this.resizeImage);
    private DropShadowDecorator dropShadowDecorator = null;
    private Point dragOffset = null;
    private Point resizeOffset = null;
    private Insets padding = new Insets(1);
    private WindowClassListener windowClassListener = new WindowClassListener(){

        public void activeWindowChanged(Window window) {
            Palette palette = (Palette)TerraPaletteSkin.this.getComponent();
            Window window2 = palette.getOwner();
            Window window3 = Window.getActiveWindow();
            palette.setVisible(window3 != null && (window2 == window3 || window2.isOwner(window3)));
        }
    };
    private Color titleBarColor;
    private Color titleBarBackgroundColor;
    private Color titleBarBorderColor;
    private Color contentBorderColor;
    private Color titleBarBevelColor;
    private Color contentBevelColor;

    public TerraPaletteSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(terraTheme.getColor(10));
        this.titleBarColor = terraTheme.getColor(4);
        this.titleBarBackgroundColor = terraTheme.getColor(16);
        this.titleBarBorderColor = terraTheme.getColor(13);
        this.contentBorderColor = terraTheme.getColor(7);
        this.titleBarBevelColor = TerraTheme.brighten(this.titleBarBackgroundColor);
        this.titleBarTablePane.getColumns().add(new TablePane.Column(1, true));
        this.titleBarTablePane.getColumns().add(new TablePane.Column(-1));
        TablePane.Row row = new TablePane.Row(-1);
        this.titleBarTablePane.getRows().add(row);
        row.add((Component)this.titleBoxPane);
        row.add((Component)this.buttonBoxPane);
        this.titleBarTablePane.getStyles().put("padding", (Object)new Insets(2, 3, 2, 3));
        this.titleBoxPane.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.titleBoxPane.add((Component)this.titleLabel);
        this.titleBoxPane.getStyles().put("padding", (Object)new Insets(0, 0, 0, 3));
        Font font = terraTheme.getFont();
        font = font.deriveFont(1, Math.round(font.getSize2D() * 0.8f));
        this.titleLabel.getStyles().put("font", (Object)font);
        this.titleLabel.getStyles().put("color", (Object)this.titleBarColor);
        this.buttonBoxPane.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.RIGHT);
        this.buttonBoxPane.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.buttonBoxPane.add((Component)this.closeButton);
        this.closeButton.getComponentMouseButtonListeners().add((Object)new ComponentMouseButtonListener.Adapter(){

            public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
                return true;
            }
        });
        this.closeButton.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                Palette palette = (Palette)TerraPaletteSkin.this.getComponent();
                palette.close();
            }
        });
    }

    public void install(Component component) {
        super.install(component);
        Palette palette = (Palette)component;
        palette.add((Component)this.titleBarTablePane);
        this.dropShadowDecorator = new DropShadowDecorator(3, 3, 3);
        palette.getDecorators().add((Decorator)this.dropShadowDecorator);
        palette.add((Component)this.resizeHandle);
        this.titleChanged((Window)palette, null);
    }

    public int getPreferredWidth(int n) {
        int n2 = 0;
        Palette palette = (Palette)this.getComponent();
        Component component = palette.getContent();
        Dimensions dimensions = this.titleBarTablePane.getPreferredSize();
        n2 = dimensions.width;
        if (component != null) {
            if (n != -1) {
                n = Math.max(n - dimensions.height - 4 - this.padding.top - this.padding.bottom, 0);
            }
            n2 = Math.max(n2, component.getPreferredWidth(n));
        }
        return n2 += this.padding.left + this.padding.right + 2;
    }

    public int getPreferredHeight(int n) {
        int n2 = 0;
        Palette palette = (Palette)this.getComponent();
        Component component = palette.getContent();
        if (n != -1) {
            n = Math.max(n - 2, 0);
        }
        n2 = this.titleBarTablePane.getPreferredHeight(n);
        if (component != null) {
            if (n != -1) {
                n = Math.max(n - this.padding.left - this.padding.right, 0);
            }
            n2 += component.getPreferredHeight(n);
        }
        return n2 += this.padding.top + this.padding.bottom + 4;
    }

    public Dimensions getPreferredSize() {
        int n = 0;
        int n2 = 0;
        Palette palette = (Palette)this.getComponent();
        Component component = palette.getContent();
        Dimensions dimensions = this.titleBarTablePane.getPreferredSize();
        n = dimensions.width;
        n2 = dimensions.height;
        if (component != null) {
            Dimensions dimensions2 = component.getPreferredSize();
            n = Math.max(n, dimensions2.width);
            n2 += dimensions2.height;
        }
        return new Dimensions(n += this.padding.left + this.padding.right + 2, n2 += this.padding.top + this.padding.bottom + 4);
    }

    public void layout() {
        Palette palette = (Palette)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = 1;
        int n4 = 1;
        int n5 = Math.max(n - 2, 0);
        int n6 = Math.max(n2 - 2, 0);
        this.titleBarTablePane.setLocation(n3, n4);
        this.titleBarTablePane.setSize(n5, this.titleBarTablePane.getPreferredHeight());
        this.resizeHandle.setSize(this.resizeHandle.getPreferredSize());
        this.resizeHandle.setLocation(n5 - this.resizeHandle.getWidth(), n6 - this.resizeHandle.getHeight());
        this.resizeHandle.setVisible(palette.isPreferredWidthSet() || palette.isPreferredHeightSet());
        Component component = palette.getContent();
        if (component != null) {
            component.setLocation(this.padding.left + 1, this.titleBarTablePane.getHeight() + this.padding.top + 3);
            int n7 = Math.max(n - (this.padding.left + this.padding.right + 2), 0);
            int n8 = Math.max(n2 - (this.titleBarTablePane.getHeight() + this.padding.top + this.padding.bottom + 4), 0);
            component.setSize(n7, n8);
        }
    }

    public void paint(Graphics2D graphics2D) {
        super.paint(graphics2D);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.titleBarTablePane.getHeight();
        graphics2D.setStroke(new BasicStroke());
        graphics2D.setPaint(new GradientPaint((float)n / 2.0f, 0.0f, this.titleBarBevelColor, (float)n / 2.0f, n3 + 1, this.titleBarBackgroundColor));
        graphics2D.fillRect(0, 0, n, n3 + 1);
        graphics2D.setPaint(this.titleBarBorderColor);
        GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (int)(n3 + 1));
        Bounds bounds = new Bounds(0, n3 + 2, n, n2 - (n3 + 2));
        graphics2D.setPaint(this.contentBorderColor);
        GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height);
        graphics2D.setPaint(this.contentBevelColor);
        GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)(bounds.x + 1), (int)(bounds.y + 1), (int)(bounds.width - 2), (Orientation)Orientation.HORIZONTAL);
    }

    public Bounds getClientArea() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.titleBarTablePane.getHeight();
        return new Bounds(0, n3 + 2, n, n2 - (n3 + 2));
    }

    public void setBackgroundColor(Color color) {
        super.setBackgroundColor(color);
        this.contentBevelColor = TerraTheme.brighten(color);
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public final void setPadding(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(number.intValue());
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)string));
    }

    public boolean mouseMove(Component component, int n, int n2) {
        boolean bl = super.mouseMove(component, n, n2);
        if (Mouse.getCapturer() == component) {
            Palette palette = (Palette)this.getComponent();
            Display display = palette.getDisplay();
            Point point = palette.mapPointToAncestor((Container)display, n, n2);
            point = new Point(Math.min(Math.max(point.x, 0), display.getWidth() - 1), Math.min(Math.max(point.y, 0), display.getHeight() - 1));
            if (this.dragOffset != null) {
                palette.setLocation(point.x - this.dragOffset.x, point.y - this.dragOffset.y);
            } else if (this.resizeOffset != null) {
                int n3 = -1;
                int n4 = -1;
                if (palette.isPreferredWidthSet()) {
                    n3 = Math.max(point.x - palette.getX() + this.resizeOffset.x, this.titleBarTablePane.getPreferredWidth(-1) + 2);
                    n3 = Math.min(n3, palette.getMaximumPreferredWidth());
                    n3 = Math.max(n3, palette.getMinimumPreferredWidth());
                }
                if (palette.isPreferredHeightSet()) {
                    n4 = Math.max(point.y - palette.getY() + this.resizeOffset.y, this.titleBarTablePane.getHeight() + this.resizeHandle.getHeight() + 7);
                    n4 = Math.min(n4, palette.getMaximumPreferredHeight());
                    n4 = Math.max(n4, palette.getMinimumPreferredHeight());
                }
                palette.setPreferredSize(n3, n4);
            }
        } else {
            Cursor cursor = null;
            if (this.resizeHandle.isVisible() && n > this.resizeHandle.getX() && n2 > this.resizeHandle.getY()) {
                boolean bl2 = component.isPreferredWidthSet();
                boolean bl3 = component.isPreferredHeightSet();
                if (bl2 && bl3) {
                    cursor = Cursor.RESIZE_SOUTH_EAST;
                } else if (bl2) {
                    cursor = Cursor.RESIZE_EAST;
                } else if (bl3) {
                    cursor = Cursor.RESIZE_SOUTH;
                }
            }
            component.setCursor(cursor);
        }
        return bl;
    }

    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseDown(component, button, n, n2);
        Window window = (Window)this.getComponent();
        boolean bl2 = window.isMaximized();
        if (button == Mouse.Button.LEFT && !bl2) {
            Bounds bounds = this.titleBarTablePane.getBounds();
            if (bounds.contains(n, n2)) {
                this.dragOffset = new Point(n, n2);
                Mouse.capture((Component)component);
            } else {
                Bounds bounds2 = this.resizeHandle.getBounds();
                if (bounds2.contains(n, n2)) {
                    this.resizeOffset = new Point(this.getWidth() - n, this.getHeight() - n2);
                    Mouse.capture((Component)component);
                }
            }
        }
        return bl;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseUp(component, button, n, n2);
        if (Mouse.getCapturer() == component) {
            this.dragOffset = null;
            this.resizeOffset = null;
            Mouse.release();
        }
        return bl;
    }

    public void titleChanged(Window window, String string) {
        super.titleChanged(window, string);
        String string2 = window.getTitle();
        this.titleLabel.setVisible(string2 != null);
        this.titleLabel.setText(string2);
    }

    public void windowOpened(Window window) {
        super.windowOpened(window);
        Window.getWindowClassListeners().add((Object)this.windowClassListener);
    }

    public void windowClosed(Window window, Display display, Window window2) {
        super.windowClosed(window, display, window2);
        Window.getWindowClassListeners().remove((Object)this.windowClassListener);
    }

    protected class ResizeImage
    extends Image {
        public static final int ALPHA = 64;

        protected ResizeImage() {
        }

        public int getWidth() {
            return 5;
        }

        public int getHeight() {
            return 5;
        }

        public void paint(Graphics2D graphics2D) {
            graphics2D.setPaint(new Color(0, 0, 0, 64));
            graphics2D.fillRect(3, 0, 2, 1);
            graphics2D.fillRect(0, 3, 2, 1);
            graphics2D.fillRect(3, 3, 2, 1);
            graphics2D.setPaint(new Color(TerraPaletteSkin.this.contentBorderColor.getRed(), TerraPaletteSkin.this.contentBorderColor.getGreen(), TerraPaletteSkin.this.contentBorderColor.getBlue(), 64));
            graphics2D.fillRect(3, 1, 2, 1);
            graphics2D.fillRect(0, 4, 2, 1);
            graphics2D.fillRect(3, 4, 2, 1);
        }
    }

    protected class CloseImage
    extends Image {
        protected CloseImage() {
        }

        public int getWidth() {
            return 6;
        }

        public int getHeight() {
            return 6;
        }

        public void paint(Graphics2D graphics2D) {
            graphics2D.setPaint(TerraPaletteSkin.this.titleBarColor);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.draw(new Line2D.Double(0.5, 0.5, 5.5, 5.5));
            graphics2D.draw(new Line2D.Double(0.5, 5.5, 5.5, 0.5));
        }
    }
}

