/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Map;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.Prompt;
import org.apache.pivot.wtk.PromptListener;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.skin.terra.TerraSheetSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;
import org.apache.pivot.wtkx.WTKXSerializer;

public class TerraPromptSkin
extends TerraSheetSkin
implements PromptListener {
    private ArrayList<Button> optionButtons = new ArrayList();
    private static Map<String, ?> commandButtonStyles;

    @Override
    public void install(Component component) {
        super.install(component);
        Prompt prompt = (Prompt)component;
        prompt.getPromptListeners().add((Object)this);
        WTKXSerializer wTKXSerializer = new WTKXSerializer();
        Component component2 = null;
        try {
            component2 = (Component)wTKXSerializer.readObject((Object)this, "terra_prompt_skin.wtkx");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        prompt.setContent(component2);
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        ImageView imageView = (ImageView)wTKXSerializer.get("typeImageView");
        imageView.setImage(terraTheme.getMessageIcon(prompt.getMessageType()));
        Label label = (Label)wTKXSerializer.get("messageLabel");
        String string = prompt.getMessage();
        label.setText(string);
        BoxPane boxPane = (BoxPane)wTKXSerializer.get("messageBoxPane");
        Component component3 = prompt.getBody();
        if (component3 != null) {
            boxPane.add(component3);
        }
        BoxPane boxPane2 = (BoxPane)wTKXSerializer.get("buttonBoxPane");
        int n = prompt.getOptionCount();
        for (int i = 0; i < n; ++i) {
            Object object = prompt.getOption(i);
            PushButton pushButton = new PushButton(object);
            pushButton.setStyles(commandButtonStyles);
            pushButton.getButtonPressListeners().add((Object)new ButtonPressListener(){

                public void buttonPressed(Button button) {
                    int n = TerraPromptSkin.this.optionButtons.indexOf((Object)button);
                    if (n >= 0) {
                        Prompt prompt = (Prompt)TerraPromptSkin.this.getComponent();
                        prompt.setSelectedOption(n);
                        prompt.close(true);
                    }
                }
            });
            boxPane2.add((Component)pushButton);
            this.optionButtons.add((Object)pushButton);
        }
    }

    @Override
    public void windowOpened(Window window) {
        super.windowOpened(window);
        Prompt prompt = (Prompt)window;
        int n = prompt.getSelectedOption();
        if (n >= 0) {
            ((Button)this.optionButtons.get(n)).requestFocus();
        } else {
            window.requestFocus();
        }
    }

    public void selectedOptionChanged(Prompt prompt, int n) {
        int n2 = prompt.getSelectedOption();
        if (prompt.isOpen() && n2 >= 0) {
            ((Button)this.optionButtons.get(n2)).requestFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        URL uRL = TerraPromptSkin.class.getResource("command_button.json");
        try {
            InputStream inputStream = uRL.openStream();
            try {
                JSONSerializer jSONSerializer = new JSONSerializer();
                commandButtonStyles = (Map)jSONSerializer.readObject(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (SerializationException serializationException) {
            throw new RuntimeException(serializationException);
        }
    }
}

