/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Rollup;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.effects.easing.Easing;
import org.apache.pivot.wtk.effects.easing.Quadratic;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.RollupSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraRollupSkin
extends RollupSkin {
    private RollupButton rollupButton = null;
    private Color buttonColor;
    private int spacing;
    private int buffer;
    private boolean fill;
    private boolean headingToggles;
    private ExpandTransition expandTransition = null;
    private ComponentMouseButtonListener headingMouseButtonListener = new ComponentMouseButtonListener.Adapter(){

        public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
            boolean bl = false;
            Rollup rollup = (Rollup)TerraRollupSkin.this.getComponent();
            if (TerraRollupSkin.this.headingToggles && rollup.isCollapsible()) {
                rollup.setExpanded(!rollup.isExpanded());
                bl = true;
            }
            return bl;
        }
    };
    private static final int EXPAND_DURATION = 250;
    private static final int EXPAND_RATE = 30;

    public TerraRollupSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.buttonColor = terraTheme.getColor(9);
        this.spacing = 4;
        this.buffer = 4;
        this.fill = false;
        this.headingToggles = true;
    }

    public void install(Component component) {
        super.install(component);
        Rollup rollup = (Rollup)component;
        this.rollupButton = new RollupButton();
        rollup.add((Component)this.rollupButton);
        this.headingChanged(rollup, null);
        this.contentChanged(rollup, null);
        this.collapsibleChanged(rollup);
    }

    public int getPreferredWidth(int n) {
        Rollup rollup = (Rollup)this.getComponent();
        Component component = rollup.getHeading();
        Component component2 = rollup.getContent();
        int n2 = 0;
        if (component != null) {
            n2 = component.getPreferredWidth(-1);
        }
        if (component2 != null && (rollup.isExpanded() || this.expandTransition != null && !this.expandTransition.isReversed())) {
            n2 = Math.max(n2, component2.getPreferredWidth(-1));
        }
        return n2 += this.rollupButton.getPreferredWidth(-1) + this.buffer;
    }

    public int getPreferredHeight(int n) {
        Rollup rollup = (Rollup)this.getComponent();
        Component component = rollup.getHeading();
        Component component2 = rollup.getContent();
        int n2 = 0;
        n = this.fill && n >= 0 ? Math.max(n - this.rollupButton.getPreferredWidth(-1) - this.buffer, 0) : -1;
        if (component != null) {
            n2 += component.getPreferredHeight(n);
        }
        if (component2 != null) {
            if (this.expandTransition == null) {
                if (rollup.isExpanded()) {
                    n2 += this.spacing + component2.getPreferredHeight(n);
                }
            } else {
                float f = this.expandTransition.getScale();
                n2 += (int)(f * (float)(this.spacing + component2.getPreferredHeight(n)));
            }
        }
        n2 = Math.max(n2, this.rollupButton.getPreferredHeight(-1));
        return n2;
    }

    public int getBaseline(int n, int n2) {
        Rollup rollup = (Rollup)this.getComponent();
        Component component = rollup.getHeading();
        int n3 = -1;
        if (component != null) {
            int n4;
            int n5;
            if (this.fill) {
                n5 = Math.max(n - this.rollupButton.getPreferredWidth(-1) - this.buffer, 0);
                n4 = component.getPreferredHeight(n5);
            } else {
                Dimensions dimensions = component.getPreferredSize();
                n5 = dimensions.width;
                n4 = dimensions.height;
            }
            n3 = component.getBaseline(n5, n4);
        }
        return n3;
    }

    public void layout() {
        Dimensions dimensions;
        int n;
        int n2;
        Rollup rollup = (Rollup)this.getComponent();
        Component component = rollup.getHeading();
        Component component2 = rollup.getContent();
        Dimensions dimensions2 = this.rollupButton.getPreferredSize();
        this.rollupButton.setSize(dimensions2.width, dimensions2.height);
        int n3 = dimensions2.width + this.buffer;
        int n4 = 0;
        int n5 = Math.max(this.getWidth() - dimensions2.width - this.buffer, 0);
        if (component != null) {
            if (this.fill) {
                n2 = n5;
                n = component.getPreferredHeight(n2);
            } else {
                dimensions = component.getPreferredSize();
                n2 = dimensions.width;
                n = dimensions.height;
            }
            component.setLocation(n3, n4);
            component.setSize(n2, n);
            n4 += n + this.spacing;
        }
        if (component2 != null) {
            if (rollup.isExpanded() || this.expandTransition != null && !this.expandTransition.isReversed()) {
                if (this.fill) {
                    n2 = n5;
                    n = component2.getPreferredHeight(n2);
                } else {
                    dimensions = component2.getPreferredSize();
                    n2 = dimensions.width;
                    n = dimensions.height;
                }
                component2.setLocation(n3, n4);
                component2.setSize(n2, n);
                component2.setVisible(true);
            } else {
                component2.setVisible(false);
            }
        }
        n4 = component == null ? 0 : (component.getHeight() - dimensions2.height) / 2 + 1;
        this.rollupButton.setLocation(0, n4);
    }

    public Color getButtonColor() {
        return this.buttonColor;
    }

    public void setButtonColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("buttonColor is null.");
        }
        this.buttonColor = color;
        this.rollupButton.repaint();
    }

    public final void setButtonColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("buttonColor is null.");
        }
        this.setButtonColor(GraphicsUtilities.decodeColor((String)string));
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("spacing is negative.");
        }
        this.spacing = n;
        Rollup rollup = (Rollup)this.getComponent();
        if (rollup.isExpanded()) {
            this.invalidateComponent();
        }
    }

    public int getBuffer() {
        return this.buffer;
    }

    public void setBuffer(int n) {
        this.buffer = n;
        this.invalidateComponent();
    }

    public boolean getFill() {
        return this.fill;
    }

    public void setFill(boolean bl) {
        this.fill = bl;
        this.invalidateComponent();
    }

    public boolean getHeadingToggles() {
        return this.headingToggles;
    }

    public void setHeadingToggles(boolean bl) {
        this.headingToggles = bl;
    }

    public void headingChanged(Rollup rollup, Component component) {
        Component component2;
        if (component != null) {
            component.getComponentMouseButtonListeners().remove((Object)this.headingMouseButtonListener);
        }
        if ((component2 = rollup.getHeading()) != null) {
            component2.getComponentMouseButtonListeners().add((Object)this.headingMouseButtonListener);
        }
        this.invalidateComponent();
    }

    public void contentChanged(Rollup rollup, Component component) {
        this.invalidateComponent();
    }

    public Vote previewExpandedChange(final Rollup rollup) {
        if (rollup.isShowing() && this.expandTransition == null && rollup.getContent() != null) {
            final boolean bl = rollup.isExpanded();
            this.expandTransition = new ExpandTransition(bl);
            this.expandTransition.start(new TransitionListener(){

                public void transitionCompleted(Transition transition) {
                    rollup.setExpanded(!bl);
                    TerraRollupSkin.this.expandTransition = null;
                }
            });
        }
        Vote vote = this.expandTransition == null || !this.expandTransition.isRunning() ? Vote.APPROVE : Vote.DEFER;
        return vote;
    }

    public void expandedChangeVetoed(Rollup rollup, Vote vote) {
        if (vote == Vote.DENY && this.expandTransition != null) {
            this.expandTransition.stop();
            this.expandTransition = null;
            this.invalidateComponent();
        }
    }

    public void expandedChanged(Rollup rollup) {
        this.invalidateComponent();
    }

    public void collapsibleChanged(Rollup rollup) {
        if (rollup.isCollapsible()) {
            this.rollupButton.setCursor(Cursor.HAND);
        } else {
            this.rollupButton.setCursor(Cursor.DEFAULT);
        }
        this.invalidateComponent();
    }

    protected class RollupButtonSkin
    extends ComponentSkin {
        protected RollupButtonSkin() {
        }

        public boolean isFocusable() {
            return false;
        }

        public int getPreferredWidth(int n) {
            return 7;
        }

        public int getPreferredHeight(int n) {
            return 7;
        }

        public Dimensions getPreferredSize() {
            return new Dimensions(7, 7);
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics2D) {
            Rollup rollup = (Rollup)TerraRollupSkin.this.getComponent();
            graphics2D.setStroke(new BasicStroke(0.0f));
            graphics2D.setPaint(TerraRollupSkin.this.buttonColor);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (rollup.isCollapsible()) {
                if (rollup.isExpanded()) {
                    int[] nArray = new int[]{0, 3, 6};
                    int[] nArray2 = new int[]{0, 6, 0};
                    graphics2D.fillPolygon(nArray, nArray2, 3);
                    graphics2D.drawPolygon(nArray, nArray2, 3);
                } else {
                    int[] nArray = new int[]{0, 6, 0};
                    int[] nArray3 = new int[]{0, 3, 6};
                    graphics2D.fillPolygon(nArray, nArray3, 3);
                    graphics2D.drawPolygon(nArray, nArray3, 3);
                }
            } else {
                RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(1.0, 1.0, 4.0, 4.0, 2.0, 2.0);
                graphics2D.draw(double_);
                graphics2D.fill(double_);
            }
        }

        public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
            Rollup rollup;
            rollup.setExpanded(!(rollup = (Rollup)TerraRollupSkin.this.getComponent()).isExpanded());
            return true;
        }
    }

    protected class RollupButton
    extends Component {
        public RollupButton() {
            this.setSkin((Skin)new RollupButtonSkin());
        }
    }

    public class ExpandTransition
    extends Transition {
        private Easing easing;

        public ExpandTransition(boolean bl) {
            super(250, 30, false, bl);
            this.easing = new Quadratic();
        }

        public float getScale() {
            int n = this.getElapsedTime();
            int n2 = this.getDuration();
            float f = this.isReversed() ? this.easing.easeIn((float)n, 0.0f, 1.0f, (float)n2) : this.easing.easeOut((float)n, 0.0f, 1.0f, (float)n2);
            return f;
        }

        public void start(TransitionListener transitionListener) {
            TerraRollupSkin.this.getComponent().setEnabled(false);
            super.start(transitionListener);
        }

        public void stop() {
            TerraRollupSkin.this.getComponent().setEnabled(true);
            super.stop();
        }

        protected void update() {
            TerraRollupSkin.this.invalidateComponent();
        }
    }
}

