/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Sheet;
import org.apache.pivot.wtk.SheetStateListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.DropShadowDecorator;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.effects.TranslationDecorator;
import org.apache.pivot.wtk.effects.easing.Quadratic;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.WindowSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraSheetSkin
extends WindowSkin
implements SheetStateListener {
    private Image resizeImage = new ResizeImage();
    private ImageView resizeHandle = new ImageView(this.resizeImage);
    private Point resizeOffset = null;
    private Color borderColor;
    private Insets padding;
    private boolean resizable;
    private Color bevelColor;
    private OpenTransition openTransition = null;
    private Quadratic easing = new Quadratic();
    private TranslationDecorator translationDecorator = new TranslationDecorator(true);
    private ComponentListener ownerListener = new ComponentListener.Adapter(){

        public void locationChanged(Component component, int n, int n2) {
            TerraSheetSkin.this.alignToOwner();
        }

        public void sizeChanged(Component component, int n, int n2) {
            TerraSheetSkin.this.alignToOwner();
        }
    };
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener(){

        public boolean mouseMove(Container container, int n, int n2) {
            return this.isMouseOverOwnerClientArea(container, n, n2);
        }

        public boolean mouseDown(Container container, Mouse.Button button, int n, int n2) {
            boolean bl = false;
            if (this.isMouseOverOwnerClientArea(container, n, n2)) {
                Sheet sheet = (Sheet)TerraSheetSkin.this.getComponent();
                Window window = sheet.getOwner();
                window.moveToFront();
                bl = true;
                Toolkit.getDefaultToolkit().beep();
            }
            return bl;
        }

        public boolean mouseUp(Container container, Mouse.Button button, int n, int n2) {
            return this.isMouseOverOwnerClientArea(container, n, n2);
        }

        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
            return this.isMouseOverOwnerClientArea(container, n3, n4);
        }

        private boolean isMouseOverOwnerClientArea(Container container, int n, int n2) {
            boolean bl = false;
            Sheet sheet = (Sheet)TerraSheetSkin.this.getComponent();
            Component component = container.getDescendantAt(n, n2);
            if (component != container) {
                Window window = component.getWindow();
                if (sheet.getOwner() == window) {
                    Bounds bounds = window.getClientArea();
                    Point point = window.mapPointFromAncestor(container, n, n2);
                    bl = bounds.contains(point);
                }
            }
            return bl;
        }
    };
    private DropShadowDecorator dropShadowDecorator = null;
    private static final int TRANSITION_DURATION = 300;
    private static final int TRANSITION_RATE = 30;

    public TerraSheetSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        Color color = terraTheme.getColor(11);
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 235);
        this.setBackgroundColor(color);
        this.borderColor = terraTheme.getColor(7);
        this.padding = new Insets(8);
        this.resizable = false;
        this.bevelColor = TerraTheme.darken(color);
    }

    public void install(Component component) {
        super.install(component);
        Sheet sheet = (Sheet)component;
        sheet.getSheetStateListeners().add((Object)this);
        this.dropShadowDecorator = new DropShadowDecorator(3, 3, 3);
        sheet.getDecorators().add((Decorator)this.dropShadowDecorator);
        sheet.add((Component)this.resizeHandle);
    }

    public int getPreferredWidth(int n) {
        int n2 = 0;
        Sheet sheet = (Sheet)this.getComponent();
        Component component = sheet.getContent();
        if (component != null) {
            if (n != -1) {
                n = Math.max(n - (this.padding.top + this.padding.bottom + 2), 0);
            }
            n2 = component.getPreferredWidth(n);
        }
        return n2 += this.padding.left + this.padding.right + 2;
    }

    public int getPreferredHeight(int n) {
        int n2 = 0;
        Sheet sheet = (Sheet)this.getComponent();
        Component component = sheet.getContent();
        if (component != null) {
            if (n != -1) {
                n = Math.max(n - (this.padding.left + this.padding.right + 2), 0);
            }
            n2 = component.getPreferredHeight(n);
        }
        return n2 += this.padding.top + this.padding.bottom + 2;
    }

    public Dimensions getPreferredSize() {
        Dimensions dimensions;
        int n = 0;
        int n2 = 0;
        Sheet sheet = (Sheet)this.getComponent();
        Component component = sheet.getContent();
        if (component != null) {
            dimensions = component.getPreferredSize();
            n = dimensions.width;
            n2 = dimensions.height;
        }
        dimensions = new Dimensions(n += this.padding.left + this.padding.right + 2, n2 += this.padding.top + this.padding.bottom + 2);
        return dimensions;
    }

    public void layout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Sheet sheet = (Sheet)this.getComponent();
        this.resizeHandle.setSize(this.resizeHandle.getPreferredSize());
        this.resizeHandle.setLocation(n - this.resizeHandle.getWidth() - 2, n2 - this.resizeHandle.getHeight() - 2);
        this.resizeHandle.setVisible(this.resizable);
        Component component = sheet.getContent();
        if (component != null) {
            component.setLocation(this.padding.left + 1, this.padding.top + 1);
            int n3 = Math.max(n - (this.padding.left + this.padding.right + 2), 0);
            int n4 = Math.max(n2 - (this.padding.top + this.padding.bottom + 2), 0);
            component.setSize(n3, n4);
        }
    }

    public void paint(Graphics2D graphics2D) {
        super.paint(graphics2D);
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setPaint(this.borderColor);
        GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (int)n2);
        graphics2D.setPaint(this.bevelColor);
        GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)1, (int)(n2 - 2), (int)(n - 2), (Orientation)Orientation.HORIZONTAL);
    }

    public void sizeChanged(Component component, int n, int n2) {
        super.sizeChanged(component, n, n2);
        this.alignToOwner();
    }

    public boolean mouseMove(Component component, int n, int n2) {
        boolean bl = super.mouseMove(component, n, n2);
        if (Mouse.getCapturer() == component) {
            Sheet sheet = (Sheet)this.getComponent();
            Display display = sheet.getDisplay();
            Point point = sheet.mapPointToAncestor((Container)display, n, n2);
            point = new Point(Math.min(Math.max(point.x, 0), display.getWidth() - 1), Math.min(Math.max(point.y, 0), display.getHeight() - 1));
            if (this.resizeOffset != null) {
                boolean bl2;
                int n3 = -1;
                int n4 = -1;
                boolean bl3 = component.isPreferredWidthSet();
                boolean bl4 = component.isPreferredHeightSet();
                boolean bl5 = bl2 = !bl3 && !bl4;
                if (bl3 || bl2) {
                    n3 = Math.max(point.x - sheet.getX() + this.resizeOffset.x, 2);
                    n3 = Math.min(n3, sheet.getMaximumPreferredWidth());
                    n3 = Math.max(n3, sheet.getMinimumPreferredWidth());
                }
                if (bl4 || bl2) {
                    n4 = Math.max(point.y - sheet.getY() + this.resizeOffset.y, this.resizeHandle.getHeight() + 7);
                    n4 = Math.min(n4, sheet.getMaximumPreferredHeight());
                    n4 = Math.max(n4, sheet.getMinimumPreferredHeight());
                }
                sheet.setPreferredSize(n3, n4);
            }
        } else {
            Cursor cursor = null;
            Bounds bounds = this.resizeHandle.getBounds();
            if (this.resizable && bounds.contains(n, n2)) {
                boolean bl6 = component.isPreferredWidthSet();
                boolean bl7 = component.isPreferredHeightSet();
                cursor = bl6 && bl7 ? Cursor.RESIZE_SOUTH_EAST : (bl6 ? Cursor.RESIZE_EAST : (bl7 ? Cursor.RESIZE_SOUTH : Cursor.RESIZE_SOUTH_EAST));
            }
            component.setCursor(cursor);
        }
        return bl;
    }

    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        Bounds bounds;
        Sheet sheet = (Sheet)component;
        Window window = sheet.getOwner();
        window.moveToFront();
        boolean bl = super.mouseDown(component, button, n, n2);
        if (this.resizable && button == Mouse.Button.LEFT && (bounds = this.resizeHandle.getBounds()).contains(n, n2)) {
            this.resizeOffset = new Point(this.getWidth() - n, this.getHeight() - n2);
            Mouse.capture((Component)component);
        }
        return bl;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseUp(component, button, n, n2);
        if (Mouse.getCapturer() == component) {
            this.resizeOffset = null;
            Mouse.release();
        }
        return bl;
    }

    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = false;
        Sheet sheet = (Sheet)this.getComponent();
        if (n == 10) {
            sheet.close(true);
            bl = true;
        } else if (n == 27) {
            sheet.close(false);
            bl = true;
        } else {
            bl = super.keyPressed(component, n, keyLocation);
        }
        return bl;
    }

    public void setBackgroundColor(Color color) {
        super.setBackgroundColor(color);
        this.bevelColor = TerraTheme.darken(color);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = color;
        this.repaintComponent();
    }

    public final void setBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public final void setPadding(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(number.intValue());
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)string));
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
        this.invalidateComponent();
    }

    public void windowOpened(Window window) {
        super.windowOpened(window);
        Display display = window.getDisplay();
        display.getContainerMouseListeners().add((Object)this.displayMouseListener);
        display.reenterMouse();
        this.dropShadowDecorator.setShadowOpacity(0.25f);
        this.alignToOwner();
        Window window2 = window.getOwner();
        window2.getComponentListeners().add((Object)this.ownerListener);
        this.openTransition = new OpenTransition(false);
        this.openTransition.start(new TransitionListener(){

            public void transitionCompleted(Transition transition) {
                TerraSheetSkin.this.openTransition = null;
            }
        });
        if (!window.requestFocus()) {
            Component.clearFocus();
        }
    }

    public void windowClosed(Window window, Display display, Window window2) {
        super.windowClosed(window, display, window2);
        display.getContainerMouseListeners().remove((Object)this.displayMouseListener);
        window2.getComponentListeners().remove((Object)this.ownerListener);
    }

    public Vote previewSheetClose(final Sheet sheet, final boolean bl) {
        Vote vote = Vote.APPROVE;
        Window window = sheet.getOwner();
        if (!window.isClosing() && !window.isClosed()) {
            TransitionListener transitionListener = new TransitionListener(){

                public void transitionCompleted(Transition transition) {
                    sheet.close(bl);
                    TerraSheetSkin.this.openTransition = null;
                }
            };
            if (this.openTransition == null) {
                this.openTransition = new OpenTransition(true);
                this.openTransition.start(transitionListener);
            } else if (!this.openTransition.isReversed() && this.openTransition.isRunning()) {
                this.openTransition.reverse(transitionListener);
            }
            vote = this.openTransition != null && this.openTransition.isRunning() ? Vote.DEFER : Vote.APPROVE;
        }
        return vote;
    }

    public void sheetCloseVetoed(Sheet sheet, Vote vote) {
        if (vote == Vote.DENY && this.openTransition != null) {
            this.openTransition.stop();
            this.openTransition = null;
        }
    }

    public void sheetClosed(Sheet sheet) {
    }

    public void alignToOwner() {
        Sheet sheet = (Sheet)this.getComponent();
        Window window = sheet.getOwner();
        Bounds bounds = window.getClientArea();
        Point point = window.mapPointToAncestor((Container)window.getDisplay(), bounds.x, bounds.y);
        sheet.setLocation(point.x + (bounds.width - this.getWidth()) / 2, point.y);
    }

    protected class ResizeImage
    extends Image {
        public static final int ALPHA = 64;

        protected ResizeImage() {
        }

        public int getWidth() {
            return 5;
        }

        public int getHeight() {
            return 5;
        }

        public void paint(Graphics2D graphics2D) {
            graphics2D.setPaint(new Color(0, 0, 0, 64));
            graphics2D.fillRect(3, 0, 2, 1);
            graphics2D.fillRect(0, 3, 2, 1);
            graphics2D.fillRect(3, 3, 2, 1);
            graphics2D.setPaint(new Color(TerraSheetSkin.this.borderColor.getRed(), TerraSheetSkin.this.borderColor.getGreen(), TerraSheetSkin.this.borderColor.getBlue(), 64));
            graphics2D.fillRect(3, 1, 2, 1);
            graphics2D.fillRect(0, 4, 2, 1);
            graphics2D.fillRect(3, 4, 2, 1);
        }
    }

    public class OpenTransition
    extends Transition {
        private int dy;

        public OpenTransition(boolean bl) {
            super(300, 30, false, bl);
            this.dy = 0;
        }

        public void start(TransitionListener transitionListener) {
            Sheet sheet = (Sheet)TerraSheetSkin.this.getComponent();
            sheet.getDecorators().add((Decorator)TerraSheetSkin.this.translationDecorator);
            this.dy = 0;
            super.start(transitionListener);
        }

        public void stop() {
            Sheet sheet = (Sheet)TerraSheetSkin.this.getComponent();
            sheet.getDecorators().remove((Decorator)TerraSheetSkin.this.translationDecorator);
            super.stop();
        }

        public void update() {
            Sheet sheet = (Sheet)TerraSheetSkin.this.getComponent();
            float f = this.isReversed() ? TerraSheetSkin.this.easing.easeIn((float)this.getElapsedTime(), 1.0f, -1.0f, (float)this.getDuration()) : TerraSheetSkin.this.easing.easeOut((float)this.getElapsedTime(), 1.0f, -1.0f, (float)this.getDuration());
            Display display = sheet.getDisplay();
            if (display != null) {
                Bounds bounds = sheet.getDecoratedBounds();
                display.repaint(bounds.x, bounds.y, bounds.width, bounds.height + this.dy);
                Dimensions dimensions = sheet.getPreferredSize();
                this.dy = -((int)((float)dimensions.height * f));
                TerraSheetSkin.this.translationDecorator.setY(this.dy);
                display.repaint(bounds.x, bounds.y, bounds.width, bounds.height + this.dy);
            }
        }
    }
}

