/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.SplitPane;
import org.apache.pivot.wtk.SplitPaneListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraSplitPaneSkin
extends ContainerSkin
implements SplitPaneListener {
    private Splitter splitter = new Splitter();
    private Color splitterHandlePrimaryColor;
    private Color splitterHandleSecondaryColor;
    private int splitterThickness;
    private boolean useShadow;

    public TerraSplitPaneSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.splitterHandlePrimaryColor = terraTheme.getColor(9);
        this.splitterHandleSecondaryColor = terraTheme.getColor(10);
        this.splitterThickness = 6;
        this.useShadow = false;
    }

    public void install(Component component) {
        super.install(component);
        SplitPane splitPane = (SplitPane)component;
        splitPane.getSplitPaneListeners().add((Object)this);
        splitPane.add((Component)this.splitter);
        this.updateSplitterCursor();
    }

    public void setSize(int n, int n2) {
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        super.setSize(n, n2);
        SplitPane splitPane = (SplitPane)this.getComponent();
        Orientation orientation = splitPane.getOrientation();
        if (splitPane.getResizeMode() == SplitPane.ResizeMode.PRIMARY_REGION && (n3 != n && orientation == Orientation.HORIZONTAL || n4 != n2 && orientation == Orientation.VERTICAL)) {
            SplitPane.Region region = splitPane.getPrimaryRegion();
            float f = splitPane.getSplitRatio();
            if (orientation == Orientation.HORIZONTAL) {
                int n5 = (int)(f * (float)n3);
                if (region == SplitPane.Region.BOTTOM_RIGHT) {
                    n5 += n - n3;
                }
                f = (float)this.limitSplitLocation(n5) / (float)n;
            } else {
                int n6 = (int)(f * (float)n4);
                if (region == SplitPane.Region.BOTTOM_RIGHT) {
                    n6 += n2 - n4;
                }
                f = (float)this.limitSplitLocation(n6) / (float)n2;
            }
            splitPane.setSplitRatio(f);
        }
    }

    public int getPreferredWidth(int n) {
        return 0;
    }

    public int getPreferredHeight(int n) {
        return 0;
    }

    public Dimensions getPreferredSize() {
        return new Dimensions(0, 0);
    }

    public void layout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        SplitPane splitPane = (SplitPane)this.getComponent();
        float f = splitPane.getSplitRatio();
        Component component = splitPane.getTopLeft();
        Component component2 = splitPane.getBottomRight();
        if (splitPane.getOrientation() == Orientation.HORIZONTAL) {
            int n3 = this.limitSplitLocation((int)(f * (float)n));
            int n4 = n3 + this.splitterThickness;
            this.splitter.setLocation(n3, 0);
            this.splitter.setSize(this.splitterThickness, n2);
            if (component != null) {
                component.setLocation(0, 0);
                component.setSize(n3, n2);
            }
            if (component2 != null) {
                component2.setLocation(n4, 0);
                component2.setSize(Math.max(n - n4, 0), n2);
            }
        } else {
            int n5 = this.limitSplitLocation((int)(f * (float)n2));
            int n6 = n5 + this.splitterThickness;
            this.splitter.setLocation(0, n5);
            this.splitter.setSize(n, this.splitterThickness);
            if (component != null) {
                component.setLocation(0, 0);
                component.setSize(n, n5);
            }
            if (component2 != null) {
                component2.setLocation(0, n6);
                component2.setSize(n, Math.max(n2 - n6, 0));
            }
        }
    }

    public Color getSplitterHandlePrimaryColor() {
        return this.splitterHandlePrimaryColor;
    }

    public void setSplitterHandlePrimaryColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("splitterHandlePrimaryColor is null.");
        }
        this.splitterHandlePrimaryColor = color;
        this.splitter.repaint();
    }

    public final void setSplitterHandlePrimaryColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("splitterHandlePrimaryColor is null.");
        }
        this.setSplitterHandlePrimaryColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setSplitterHandlePrimaryColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setSplitterHandlePrimaryColor(terraTheme.getColor(n));
    }

    public Color getSplitterHandleSecondaryColor() {
        return this.splitterHandleSecondaryColor;
    }

    public void setSplitterHandleSecondaryColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("splitterHandleSecondaryColor is null.");
        }
        this.splitterHandleSecondaryColor = color;
        this.splitter.repaint();
    }

    public final void setSplitterHandleSecondaryColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("splitterHandleSecondaryColor is null.");
        }
        this.setSplitterHandleSecondaryColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setSplitterHandleSecondaryColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setSplitterHandleSecondaryColor(terraTheme.getColor(n));
    }

    public int getSplitterThickness() {
        return this.splitterThickness;
    }

    public void setSplitterThickness(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("splitterThickness is negative.");
        }
        this.splitterThickness = n;
        this.invalidateComponent();
    }

    public boolean getUseShadow() {
        return this.useShadow;
    }

    public void setUseShadow(boolean bl) {
        if (Mouse.getCapturer() == this.getComponent()) {
            throw new IllegalStateException("Cannot set useShadow while the splitter is being dragged.");
        }
        this.useShadow = bl;
    }

    public void topLeftChanged(SplitPane splitPane, Component component) {
        this.invalidateComponent();
    }

    public void bottomRightChanged(SplitPane splitPane, Component component) {
        this.invalidateComponent();
    }

    public void orientationChanged(SplitPane splitPane) {
        this.updateSplitterCursor();
        this.invalidateComponent();
    }

    public void primaryRegionChanged(SplitPane splitPane) {
        this.updateSplitterCursor();
    }

    public void splitRatioChanged(SplitPane splitPane, float f) {
        this.invalidateComponent();
    }

    public void lockedChanged(SplitPane splitPane) {
        this.updateSplitterCursor();
    }

    public void resizeModeChanged(SplitPane splitPane, SplitPane.ResizeMode resizeMode) {
    }

    private void updateSplitterCursor() {
        Cursor cursor = Cursor.DEFAULT;
        SplitPane splitPane = (SplitPane)this.getComponent();
        if (!splitPane.isLocked()) {
            block0 : switch (splitPane.getOrientation()) {
                case HORIZONTAL: {
                    switch (splitPane.getPrimaryRegion()) {
                        case TOP_LEFT: {
                            cursor = Cursor.RESIZE_EAST;
                            break;
                        }
                        case BOTTOM_RIGHT: {
                            cursor = Cursor.RESIZE_WEST;
                        }
                    }
                    break;
                }
                case VERTICAL: {
                    switch (splitPane.getPrimaryRegion()) {
                        case TOP_LEFT: {
                            cursor = Cursor.RESIZE_SOUTH;
                            break block0;
                        }
                        case BOTTOM_RIGHT: {
                            cursor = Cursor.RESIZE_NORTH;
                        }
                    }
                }
            }
        }
        this.splitter.setCursor(cursor);
    }

    private int limitSplitLocation(int n) {
        int n2;
        int n3;
        SplitPane splitPane = (SplitPane)this.getComponent();
        Component component = splitPane.getTopLeft();
        Component component2 = splitPane.getBottomRight();
        if (splitPane.getOrientation() == Orientation.HORIZONTAL) {
            int n4;
            n3 = 0;
            n2 = Math.max(this.getWidth() - this.splitterThickness, 0);
            if (component != null && (n4 = component.getMinimumPreferredWidth()) >= 0) {
                n3 = Math.min(n4, n2);
            }
            if (component2 != null && (n4 = component2.getMinimumPreferredWidth()) >= 0) {
                n2 = Math.max(n2 - n4, n3);
            }
        } else {
            int n5;
            n3 = 0;
            n2 = Math.max(this.getHeight() - this.splitterThickness, 0);
            if (component != null && (n5 = component.getMinimumPreferredHeight()) >= 0) {
                n3 = Math.min(n5, n2);
            }
            if (component2 != null && (n5 = component2.getMinimumPreferredHeight()) >= 0) {
                n2 = Math.max(n2 - n5, n3);
            }
        }
        if (n < n3) {
            n = n3;
        } else if (n > n2) {
            n = n2;
        }
        return n;
    }

    protected class SplitterShadowSkin
    extends ComponentSkin {
        protected SplitterShadowSkin() {
        }

        public int getPreferredWidth(int n) {
            return 0;
        }

        public int getPreferredHeight(int n) {
            return 0;
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics2D) {
            graphics2D.setPaint(new Color(0, 0, 0, 64));
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected class SplitterShadow
    extends Component {
        public SplitterShadow() {
            this.setSkin((Skin)new SplitterShadowSkin());
        }
    }

    protected class SplitterSkin
    extends ComponentSkin {
        private int dragOffset;
        private SplitterShadow shadow = null;

        protected SplitterSkin() {
        }

        public boolean isFocusable() {
            return false;
        }

        public int getPreferredWidth(int n) {
            return 0;
        }

        public int getPreferredHeight(int n) {
            return 0;
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics2D) {
            int n;
            int n2;
            SplitPane splitPane = (SplitPane)TerraSplitPaneSkin.this.getComponent();
            Orientation orientation = splitPane.getOrientation();
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            if (orientation == Orientation.HORIZONTAL) {
                n2 = n3 - 4;
                n = Math.min(n4 - 4, 8);
            } else {
                n2 = Math.min(n3 - 4, 8);
                n = n4 - 4;
            }
            if (n2 > 0 && n > 0) {
                int n5 = (n3 - n2) / 2;
                int n6 = (n4 - n) / 2;
                graphics2D.translate(n5, n6);
                Color color = TerraSplitPaneSkin.this.splitterHandlePrimaryColor;
                Color color2 = TerraSplitPaneSkin.this.splitterHandleSecondaryColor;
                if (orientation == Orientation.HORIZONTAL) {
                    graphics2D.setStroke(new BasicStroke());
                    graphics2D.setPaint(color);
                    graphics2D.drawLine(0, 0, n2 - 1, 0);
                    graphics2D.drawLine(0, 3, n2 - 1, 3);
                    graphics2D.drawLine(0, 6, n2 - 1, 6);
                    graphics2D.setPaint(color2);
                    graphics2D.drawLine(0, 1, n2 - 1, 1);
                    graphics2D.drawLine(0, 4, n2 - 1, 4);
                    graphics2D.drawLine(0, 7, n2 - 1, 7);
                } else {
                    int n7 = n / 2;
                    graphics2D.setPaint(color);
                    graphics2D.fillRect(0, 0, 2, n7);
                    graphics2D.fillRect(3, 0, 2, n7);
                    graphics2D.fillRect(6, 0, 2, n7);
                    graphics2D.setPaint(color2);
                    graphics2D.fillRect(0, n7, 2, n7);
                    graphics2D.fillRect(3, n7, 2, n7);
                    graphics2D.fillRect(6, n7, 2, n7);
                }
            }
        }

        public boolean mouseMove(Component component, int n, int n2) {
            boolean bl = super.mouseMove(component, n, n2);
            if (Mouse.getCapturer() == component) {
                float f;
                int n3;
                SplitPane splitPane = (SplitPane)TerraSplitPaneSkin.this.getComponent();
                Orientation orientation = splitPane.getOrientation();
                if (orientation == Orientation.HORIZONTAL) {
                    n3 = TerraSplitPaneSkin.this.limitSplitLocation(component.getX() + n - this.dragOffset);
                    f = (float)n3 / (float)splitPane.getWidth();
                } else {
                    n3 = TerraSplitPaneSkin.this.limitSplitLocation(component.getY() + n2 - this.dragOffset);
                    f = (float)n3 / (float)splitPane.getHeight();
                }
                if (this.shadow == null) {
                    splitPane.setSplitRatio(f);
                } else if (orientation == Orientation.HORIZONTAL) {
                    this.shadow.setLocation(n3, 0);
                } else {
                    this.shadow.setLocation(0, n3);
                }
            }
            return bl;
        }

        public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
            boolean bl = super.mouseDown(component, button, n, n2);
            SplitPane splitPane = (SplitPane)TerraSplitPaneSkin.this.getComponent();
            if (button == Mouse.Button.LEFT && !splitPane.isLocked()) {
                Orientation orientation = splitPane.getOrientation();
                if (TerraSplitPaneSkin.this.useShadow) {
                    this.shadow = new SplitterShadow();
                    splitPane.add((Component)this.shadow);
                    if (orientation == Orientation.HORIZONTAL) {
                        this.shadow.setLocation(component.getX(), 0);
                    } else {
                        this.shadow.setLocation(0, component.getY());
                    }
                    this.shadow.setSize(this.getWidth(), this.getHeight());
                }
                this.dragOffset = orientation == Orientation.HORIZONTAL ? n : n2;
                Mouse.capture((Component)component);
                bl = true;
            }
            return bl;
        }

        public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
            boolean bl = super.mouseUp(component, button, n, n2);
            if (button == Mouse.Button.LEFT && Mouse.getCapturer() == component) {
                if (this.shadow != null) {
                    float f;
                    SplitPane splitPane = (SplitPane)TerraSplitPaneSkin.this.getComponent();
                    if (splitPane.getOrientation() == Orientation.HORIZONTAL) {
                        int n3 = this.shadow.getX();
                        f = (float)n3 / (float)splitPane.getWidth();
                    } else {
                        int n4 = this.shadow.getY();
                        f = (float)n4 / (float)splitPane.getHeight();
                    }
                    splitPane.setSplitRatio(f);
                    splitPane.remove((Component)this.shadow);
                    this.shadow = null;
                }
                Mouse.release();
            }
            return bl;
        }
    }

    protected class Splitter
    extends Component {
        public Splitter() {
            this.setSkin((Skin)new SplitterSkin());
        }
    }
}

