/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Direction;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.TextInputCharacterListener;
import org.apache.pivot.wtk.TextInputListener;
import org.apache.pivot.wtk.TextInputSelectionListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;
import org.apache.pivot.wtk.text.TextNode;
import org.apache.pivot.wtk.text.validation.Validator;

public class TerraTextInputSkin
extends ComponentSkin
implements TextInput.Skin,
TextInputListener,
TextInputCharacterListener,
TextInputSelectionListener {
    private GlyphVector glyphVector = null;
    private int anchor = -1;
    private Rectangle caret = new Rectangle();
    private Rectangle selection = null;
    private int scrollLeft = 0;
    private boolean caretOn = true;
    private Direction scrollDirection = null;
    private BlinkCaretCallback blinkCaretCallback = new BlinkCaretCallback();
    private ApplicationContext.ScheduledCallback scheduledBlinkCaretCallback = null;
    private ScrollSelectionCallback scrollSelectionCallback = new ScrollSelectionCallback();
    private ApplicationContext.ScheduledCallback scheduledScrollSelectionCallback = null;
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color promptColor;
    private Color backgroundColor;
    private Color disabledBackgroundColor;
    private Color invalidColor;
    private Color invalidBackgroundColor;
    private Color borderColor;
    private Color disabledBorderColor;
    private Insets padding;
    private boolean strictValidation;
    private Color selectionColor;
    private Color selectionBackgroundColor;
    private Color inactiveSelectionColor;
    private Color inactiveSelectionBackgroundColor;
    private Color bevelColor;
    private Color disabledBevelColor;
    private Color invalidBevelColor;
    private Dimensions averageCharacterSize;
    private static final FontRenderContext FONT_RENDER_CONTEXT = new FontRenderContext(null, true, false);
    private static final int SCROLL_RATE = 50;
    private static final char BULLET = '\u2022';

    public TerraTextInputSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setFont(terraTheme.getFont());
        this.color = terraTheme.getColor(1);
        this.promptColor = terraTheme.getColor(7);
        this.disabledColor = terraTheme.getColor(7);
        this.backgroundColor = terraTheme.getColor(11);
        this.disabledBackgroundColor = terraTheme.getColor(10);
        this.invalidColor = terraTheme.getColor(4);
        this.invalidBackgroundColor = terraTheme.getColor(22);
        this.borderColor = terraTheme.getColor(7);
        this.disabledBorderColor = terraTheme.getColor(7);
        this.padding = new Insets(2);
        this.strictValidation = false;
        this.selectionColor = terraTheme.getColor(4);
        this.selectionBackgroundColor = terraTheme.getColor(19);
        this.inactiveSelectionColor = terraTheme.getColor(1);
        this.inactiveSelectionBackgroundColor = terraTheme.getColor(9);
        this.bevelColor = TerraTheme.darken(this.backgroundColor);
        this.disabledBevelColor = this.disabledBackgroundColor;
        this.invalidBevelColor = TerraTheme.darken(this.invalidBackgroundColor);
    }

    public void install(Component component) {
        super.install(component);
        TextInput textInput = (TextInput)component;
        textInput.getTextInputListeners().add((Object)this);
        textInput.getTextInputCharacterListeners().add((Object)this);
        textInput.getTextInputSelectionListeners().add((Object)this);
        textInput.setCursor(Cursor.TEXT);
        TextNode textNode = textInput.getTextNode();
        if (textNode != null) {
            this.updateSelection();
        }
    }

    public int getPreferredWidth(int n) {
        TextInput textInput = (TextInput)this.getComponent();
        int n2 = textInput.getTextSize();
        return this.averageCharacterSize.width * n2 + (this.padding.left + this.padding.right) + 2;
    }

    public int getPreferredHeight(int n) {
        return this.averageCharacterSize.height + (this.padding.top + this.padding.bottom) + 2;
    }

    public Dimensions getPreferredSize() {
        return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
    }

    public int getBaseline(int n, int n2) {
        LineMetrics lineMetrics = this.font.getLineMetrics("", FONT_RENDER_CONTEXT);
        float f = lineMetrics.getAscent();
        float f2 = lineMetrics.getHeight();
        int n3 = Math.round(((float)n2 - f2) / 2.0f + f);
        return n3;
    }

    public void layout() {
        TextInput textInput = (TextInput)this.getComponent();
        TextNode textNode = textInput.getTextNode();
        this.glyphVector = null;
        if (textNode != null) {
            int n = textNode.getCharacterCount();
            if (n > 0) {
                int n2;
                Object object;
                CharacterIterator characterIterator = null;
                if (textInput.isPassword()) {
                    object = new StringBuilder(n);
                    for (n2 = 0; n2 < n; ++n2) {
                        ((StringBuilder)object).append('\u2022');
                    }
                    characterIterator = new StringCharacterIterator(((StringBuilder)object).toString());
                } else {
                    characterIterator = textNode.getCharacterIterator();
                }
                this.glyphVector = this.font.createGlyphVector(FONT_RENDER_CONTEXT, characterIterator);
                object = this.glyphVector.getLogicalBounds();
                n2 = (int)((RectangularShape)object).getWidth();
                int n3 = this.getWidth();
                if (n2 - this.scrollLeft + this.padding.left + 1 < n3 - this.padding.right - 1) {
                    this.scrollLeft = Math.max(n2 + (this.padding.left + this.padding.right + 2) - n3, 0);
                } else {
                    int n4 = textInput.getSelectionStart();
                    if (n4 < n && textInput.isFocused()) {
                        this.scrollCharacterToVisible(n4);
                    }
                }
            }
        } else {
            this.scrollLeft = 0;
            this.updateSelection();
        }
        this.updateSelection();
        this.showCaret(textInput.isFocused() && textInput.getSelectionLength() == 0);
    }

    public void paint(Graphics2D graphics2D) {
        Color color;
        Color color2;
        Color color3;
        TextInput textInput = (TextInput)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (textInput.isEnabled()) {
            if (textInput.isTextValid()) {
                color3 = this.backgroundColor;
                color2 = this.bevelColor;
            } else {
                color3 = this.invalidBackgroundColor;
                color2 = this.invalidBevelColor;
            }
            color = this.borderColor;
        } else {
            color3 = this.disabledBackgroundColor;
            color = this.disabledBorderColor;
            color2 = this.disabledBevelColor;
        }
        graphics2D.setStroke(new BasicStroke());
        graphics2D.setColor(color3);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(color2);
        GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (Orientation)Orientation.HORIZONTAL);
        if (FONT_RENDER_CONTEXT.isAntiAliased()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, Platform.getTextAntialiasingHint());
        }
        if (FONT_RENDER_CONTEXT.usesFractionalMetrics()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        LineMetrics lineMetrics = this.font.getLineMetrics("", FONT_RENDER_CONTEXT);
        float f = lineMetrics.getAscent();
        float f2 = lineMetrics.getHeight();
        String string = textInput.getPrompt();
        if (this.glyphVector == null && string != null && !textInput.isFocused()) {
            graphics2D.setFont(this.font);
            graphics2D.setColor(this.promptColor);
            graphics2D.drawString(string, (float)(this.padding.left - this.scrollLeft + 1), ((float)n2 - f2) / 2.0f + f);
        } else {
            boolean bl = textInput.isTextValid();
            Color color4 = textInput.isEnabled() ? (!bl ? this.invalidColor : this.color) : this.disabledColor;
            if (this.glyphVector != null) {
                graphics2D.setFont(this.font);
                if (this.selection == null) {
                    graphics2D.setColor(color4);
                    graphics2D.drawGlyphVector(this.glyphVector, this.padding.left - this.scrollLeft + 1, ((float)n2 - f2) / 2.0f + f);
                } else {
                    Color color5;
                    Color color6;
                    Area area = new Area();
                    area.add(new Area(new Rectangle(0, 0, n, n2)));
                    area.subtract(new Area(this.selection));
                    Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
                    graphics2D2.setColor(color4);
                    graphics2D2.clip(area);
                    graphics2D2.drawGlyphVector(this.glyphVector, this.padding.left - this.scrollLeft + 1, ((float)n2 - f2) / 2.0f + f);
                    graphics2D2.dispose();
                    if (textInput.isFocused()) {
                        color6 = this.selectionColor;
                        color5 = this.selectionBackgroundColor;
                    } else {
                        color6 = this.inactiveSelectionColor;
                        color5 = this.inactiveSelectionBackgroundColor;
                    }
                    graphics2D.setColor(color5);
                    graphics2D.fill(this.selection);
                    Graphics2D graphics2D3 = (Graphics2D)graphics2D.create();
                    graphics2D3.setColor(color6);
                    graphics2D3.clip(this.selection.getBounds());
                    graphics2D3.drawGlyphVector(this.glyphVector, this.padding.left - this.scrollLeft + 1, ((float)n2 - f2) / 2.0f + f);
                    graphics2D3.dispose();
                }
            }
            if (this.selection == null && this.caretOn && textInput.isFocused()) {
                graphics2D.setColor(color4);
                graphics2D.fill(this.caret);
            }
        }
        graphics2D.setColor(color);
        GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (int)n2);
    }

    public int getInsertionPoint(int n) {
        int n2 = -1;
        if (this.glyphVector == null) {
            n2 = 0;
        } else {
            Rectangle2D rectangle2D = this.glyphVector.getLogicalBounds();
            if ((n -= this.padding.left - this.scrollLeft + 1) < 0) {
                n2 = 0;
            } else if ((double)n > rectangle2D.getWidth()) {
                n2 = this.glyphVector.getNumGlyphs();
            } else {
                int n3 = this.glyphVector.getNumGlyphs();
                for (int i = 0; i < n3; ++i) {
                    Shape shape = this.glyphVector.getGlyphLogicalBounds(i);
                    Rectangle2D rectangle2D2 = shape.getBounds2D();
                    float f = (float)rectangle2D2.getX();
                    float f2 = (float)rectangle2D2.getWidth();
                    if (!((float)n >= f) || !((float)n < f + f2)) continue;
                    if ((float)n - f > f2 / 2.0f) {
                        ++i;
                    }
                    n2 = i;
                    break;
                }
            }
        }
        return n2;
    }

    public Bounds getCharacterBounds(int n) {
        Bounds bounds = null;
        if (this.glyphVector != null) {
            Shape shape = this.glyphVector.getGlyphLogicalBounds(n);
            Rectangle2D rectangle2D = shape.getBounds2D();
            int n2 = (int)Math.floor(rectangle2D.getX()) + this.padding.left - this.scrollLeft + 1;
            int n3 = this.padding.top + 1;
            int n4 = (int)Math.ceil(rectangle2D.getWidth());
            int n5 = this.getHeight() - (this.padding.top + this.padding.bottom + 2);
            bounds = new Bounds(n2, n3, n4, n5);
        }
        return bounds;
    }

    private void setScrollLeft(int n) {
        this.scrollLeft = n;
        this.updateSelection();
        this.repaintComponent();
    }

    private void scrollCharacterToVisible(int n) {
        int n2 = this.getWidth();
        Bounds bounds = this.getCharacterBounds(n);
        if (bounds != null) {
            int n3 = bounds.x - (this.padding.left + 1) + this.scrollLeft;
            if (bounds.x < this.padding.left + 1) {
                this.setScrollLeft(n3);
            } else if (bounds.x + bounds.width > n2 - (this.padding.right + 1)) {
                this.setScrollLeft(n3 + (this.padding.left + this.padding.right + 2) + bounds.width - n2);
            }
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        int n = font.getMissingGlyphCode();
        GlyphVector glyphVector = font.createGlyphVector(FONT_RENDER_CONTEXT, new int[]{n});
        Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
        Rectangle2D rectangle2D2 = font.getMaxCharBounds(FONT_RENDER_CONTEXT);
        this.averageCharacterSize = new Dimensions((int)Math.ceil(rectangle2D.getWidth()), (int)Math.ceil(rectangle2D2.getHeight()));
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraTextInputSkin.decodeFont((String)string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setColor(terraTheme.getColor(n));
    }

    public Color getPromptColor() {
        return this.promptColor;
    }

    public void setPromptColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("promptColor is null.");
        }
        this.promptColor = color;
        this.repaintComponent();
    }

    public final void setPromptColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("promptColor is null.");
        }
        this.setPromptColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setPromptColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setPromptColor(terraTheme.getColor(n));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = color;
        this.repaintComponent();
    }

    public final void setDisabledColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setDisabledColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setDisabledColor(terraTheme.getColor(n));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.backgroundColor = color;
        this.bevelColor = TerraTheme.darken(color);
        this.repaintComponent();
    }

    public final void setBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(terraTheme.getColor(n));
    }

    public Color getInvalidColor() {
        return this.invalidColor;
    }

    public void setInvalidColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.invalidColor = color;
        this.repaintComponent();
    }

    public final void setInvalidColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setInvalidColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setInvalidColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setInvalidColor(terraTheme.getColor(n));
    }

    public Color getInvalidBackgroundColor() {
        return this.invalidBackgroundColor;
    }

    public void setInvalidBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.invalidBackgroundColor = color;
        this.invalidBevelColor = TerraTheme.darken(color);
        this.repaintComponent();
    }

    public final void setInvalidBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("invalidBackgroundColor is null.");
        }
        this.setInvalidBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setInvalidBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setInvalidBackgroundColor(terraTheme.getColor(n));
    }

    public Color getDisabledBackgroundColor() {
        return this.disabledBackgroundColor;
    }

    public void setDisabledBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.disabledBackgroundColor = color;
        this.disabledBevelColor = color;
        this.repaintComponent();
    }

    public final void setDisabledBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.setDisabledBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setDisabledBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setDisabledBackgroundColor(terraTheme.getColor(n));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = color;
        this.repaintComponent();
    }

    public final void setBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setBorderColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBorderColor(terraTheme.getColor(n));
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.disabledBorderColor = color;
        this.repaintComponent();
    }

    public final void setDisabledBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.setDisabledBorderColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setDisabledBorderColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setDisabledBorderColor(terraTheme.getColor(n));
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.selectionColor = color;
        this.repaintComponent();
    }

    public final void setSelectionColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.setSelectionColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setSelectionColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setSelectionColor(terraTheme.getColor(n));
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.selectionBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setSelectionBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.setSelectionBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setSelectionBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setSelectionBackgroundColor(terraTheme.getColor(n));
    }

    public Color getInactiveSelectionColor() {
        return this.inactiveSelectionColor;
    }

    public void setInactiveSelectionColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.inactiveSelectionColor = color;
        this.repaintComponent();
    }

    public final void setInactiveSelectionColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.setInactiveSelectionColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setInactiveSelectionColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setInactiveSelectionColor(terraTheme.getColor(n));
    }

    public Color getInactiveSelectionBackgroundColor() {
        return this.inactiveSelectionBackgroundColor;
    }

    public void setInactiveSelectionBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.inactiveSelectionBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setInactiveSelectionBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.setInactiveSelectionBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setInactiveSelectionBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setInactiveSelectionBackgroundColor(terraTheme.getColor(n));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public final void setPadding(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(number.intValue());
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)string));
    }

    public boolean getStrictValidation() {
        return this.strictValidation;
    }

    public void setStrictValidation(boolean bl) {
        this.strictValidation = bl;
    }

    public boolean mouseMove(Component component, int n, int n2) {
        boolean bl = super.mouseMove(component, n, n2);
        if (Mouse.getCapturer() == component) {
            TextInput textInput = (TextInput)this.getComponent();
            int n3 = this.getWidth();
            if (n >= 0 && n < n3) {
                if (this.scheduledScrollSelectionCallback != null) {
                    this.scheduledScrollSelectionCallback.cancel();
                    this.scheduledScrollSelectionCallback = null;
                }
                this.scrollDirection = null;
                int n4 = this.getInsertionPoint(n);
                if (n4 != -1) {
                    if (n4 > this.anchor) {
                        textInput.setSelection(this.anchor, n4 - this.anchor);
                    } else {
                        textInput.setSelection(n4, this.anchor - n4);
                    }
                }
            } else if (this.scheduledScrollSelectionCallback == null) {
                this.scrollDirection = n < 0 ? Direction.BACKWARD : Direction.FORWARD;
                this.scheduledScrollSelectionCallback = ApplicationContext.scheduleRecurringCallback((Runnable)this.scrollSelectionCallback, (long)50L);
                this.scrollSelectionCallback.run();
            }
        } else if (Mouse.isPressed((Mouse.Button)Mouse.Button.LEFT) && Mouse.getCapturer() == null && this.anchor != -1) {
            Mouse.capture((Component)component);
        }
        return bl;
    }

    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseDown(component, button, n, n2);
        if (button == Mouse.Button.LEFT) {
            TextInput textInput = (TextInput)this.getComponent();
            this.anchor = this.getInsertionPoint(n);
            if (this.anchor != -1) {
                if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT)) {
                    int n3 = textInput.getSelectionStart();
                    if (this.anchor > n3) {
                        textInput.setSelection(n3, this.anchor - n3);
                    } else {
                        textInput.setSelection(this.anchor, n3 - this.anchor);
                    }
                } else {
                    textInput.setSelection(this.anchor, 0);
                    bl = true;
                }
            }
            textInput.requestFocus();
        }
        return bl;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseUp(component, button, n, n2);
        if (Mouse.getCapturer() == component) {
            if (this.scheduledScrollSelectionCallback != null) {
                this.scheduledScrollSelectionCallback.cancel();
                this.scheduledScrollSelectionCallback = null;
            }
            Mouse.release();
        }
        this.anchor = -1;
        return bl;
    }

    public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
        TextInput textInput;
        TextNode textNode;
        if (button == Mouse.Button.LEFT && n3 > 1 && (textNode = (textInput = (TextInput)this.getComponent()).getTextNode()) != null) {
            textInput.setSelection(0, textNode.getCharacterCount());
        }
        return super.mouseClick(component, button, n, n2, n3);
    }

    public boolean keyTyped(Component component, char c) {
        TextInput textInput;
        TextNode textNode;
        boolean bl = super.keyTyped(component, c);
        if (c > '\u001f' && c != '\u007f' && !Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.META) && (textNode = (textInput = (TextInput)this.getComponent()).getTextNode()) != null) {
            if (textInput.getSelectionLength() == 0 && textNode.getCharacterCount() == textInput.getMaximumLength()) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                int n = textInput.getSelectionStart();
                Validator validator = textInput.getValidator();
                if (validator != null && this.strictValidation) {
                    StringBuilder stringBuilder = new StringBuilder(textNode.getText());
                    stringBuilder.insert(n, c);
                    if (validator.isValid(stringBuilder.toString())) {
                        textInput.insertText(c, n);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    textInput.insertText(c, n);
                }
            }
        }
        return bl;
    }

    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = super.keyPressed(component, n, keyLocation);
        TextInput textInput = (TextInput)this.getComponent();
        TextNode textNode = textInput.getTextNode();
        if (textNode != null) {
            Keyboard.Modifier modifier = Platform.getCommandModifier();
            if (n == 127 || n == 8) {
                Direction direction = n == 127 ? Direction.FORWARD : Direction.BACKWARD;
                Validator validator = textInput.getValidator();
                if (validator != null && this.strictValidation) {
                    StringBuilder stringBuilder = new StringBuilder(textNode.getText());
                    int n2 = textInput.getSelectionStart();
                    int n3 = textInput.getSelectionLength();
                    if (n3 > 0) {
                        stringBuilder.delete(n2, n2 + n3);
                    } else {
                        if (direction == Direction.BACKWARD) {
                            --n2;
                        }
                        if (n2 >= 0 && n2 < textNode.getCharacterCount()) {
                            stringBuilder.deleteCharAt(n2);
                        }
                    }
                    if (validator.isValid(stringBuilder.toString())) {
                        textInput.delete(direction);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    textInput.delete(direction);
                }
                bl = true;
            } else if (n == 37) {
                int n4 = textInput.getSelectionStart();
                int n5 = textInput.getSelectionLength();
                if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.CTRL)) {
                    n5 = n4 + n5;
                    n4 = 0;
                    bl = true;
                } else if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT)) {
                    if (n4 > 0) {
                        --n4;
                        ++n5;
                    }
                    bl = true;
                } else if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.CTRL)) {
                    n4 = 0;
                    n5 = 0;
                    bl = true;
                } else {
                    if (n5 == 0 && n4 > 0) {
                        --n4;
                        bl = true;
                    }
                    n5 = 0;
                }
                textInput.setSelection(n4, n5);
                if (textNode.getCharacterCount() > 0) {
                    this.scrollCharacterToVisible(n4);
                } else {
                    this.setScrollLeft(0);
                }
            } else if (n == 39) {
                int n6 = textInput.getSelectionStart();
                int n7 = textInput.getSelectionLength();
                if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.CTRL)) {
                    n7 = textNode.getCharacterCount() - n6;
                    bl = true;
                } else if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT)) {
                    if (n6 + n7 < textNode.getCharacterCount()) {
                        ++n7;
                    }
                    bl = true;
                } else if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.CTRL)) {
                    n6 = textNode.getCharacterCount();
                    n7 = 0;
                    bl = true;
                } else {
                    if (n7 == 0 && (n6 += n7) < textNode.getCharacterCount()) {
                        ++n6;
                        bl = true;
                    }
                    n7 = 0;
                }
                textInput.setSelection(n6, n7);
                if (textNode.getCharacterCount() > 0) {
                    this.scrollCharacterToVisible(n6 + n7 - 1);
                } else {
                    this.scrollLeft = 0;
                    this.updateSelection();
                }
            } else if (n == 36) {
                if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT)) {
                    textInput.setSelection(0, textInput.getSelectionStart());
                } else {
                    textInput.setSelection(0, 0);
                }
                bl = true;
            } else if (n == 35) {
                if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT)) {
                    int n8 = textInput.getSelectionStart();
                    textInput.setSelection(n8, textNode.getCharacterCount() - n8);
                } else {
                    textInput.setSelection(textNode.getCharacterCount(), 0);
                }
                bl = true;
            } else if (n == 65 && Keyboard.isPressed((Keyboard.Modifier)modifier)) {
                textInput.setSelection(0, textNode.getCharacterCount());
                bl = true;
            } else if (n == 88 && Keyboard.isPressed((Keyboard.Modifier)modifier)) {
                if (textInput.isPassword()) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    textInput.cut();
                }
                bl = true;
            } else if (n == 67 && Keyboard.isPressed((Keyboard.Modifier)modifier)) {
                if (textInput.isPassword()) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    textInput.copy();
                }
                bl = true;
            } else if (n == 86 && Keyboard.isPressed((Keyboard.Modifier)modifier)) {
                textInput.paste();
                bl = true;
            } else {
                bl = super.keyPressed(component, n, keyLocation);
            }
        }
        return bl;
    }

    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.repaintComponent();
    }

    public void focusedChanged(Component component, Component component2) {
        super.focusedChanged(component, component2);
        TextInput textInput = (TextInput)component;
        Window window = textInput.getWindow();
        if (component.isFocused()) {
            if ((component2 == null || component2.getWindow() == window) && Mouse.getCapturer() != component) {
                textInput.selectAll();
            }
            if (textInput.getSelectionLength() == 0) {
                TextNode textNode = textInput.getTextNode();
                int n = textInput.getSelectionStart();
                if (n < textNode.getCharacterCount()) {
                    this.scrollCharacterToVisible(n);
                }
                this.showCaret(true);
            } else {
                this.showCaret(false);
            }
        } else {
            if (component2 == null || component2.getWindow() == window) {
                textInput.clearSelection();
            }
            this.showCaret(false);
        }
        this.repaintComponent();
    }

    public void textNodeChanged(TextInput textInput, TextNode textNode) {
        this.layout();
        this.repaintComponent();
    }

    public void textSizeChanged(TextInput textInput, int n) {
        this.invalidateComponent();
    }

    public void maximumLengthChanged(TextInput textInput, int n) {
    }

    public void passwordChanged(TextInput textInput) {
        this.layout();
        this.repaintComponent();
    }

    public void promptChanged(TextInput textInput, String string) {
        this.repaintComponent();
    }

    public void textKeyChanged(TextInput textInput, String string) {
    }

    public void textValidChanged(TextInput textInput) {
        this.repaintComponent();
    }

    public void textValidatorChanged(TextInput textInput, Validator validator) {
        this.repaintComponent();
    }

    public void charactersInserted(TextInput textInput, int n, int n2) {
        this.layout();
        this.repaintComponent();
    }

    public void charactersRemoved(TextInput textInput, int n, int n2) {
        this.layout();
        this.repaintComponent();
    }

    public void selectionChanged(TextInput textInput, int n, int n2) {
        if (textInput.isValid()) {
            Rectangle rectangle;
            if (this.caret != null) {
                textInput.repaint(this.caret.x, this.caret.y, this.caret.width, this.caret.height);
            }
            if (this.selection != null) {
                rectangle = this.selection.getBounds();
                textInput.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (textInput.getSelectionLength() == 0) {
                this.updateSelection();
                this.showCaret(textInput.isFocused());
            } else {
                this.updateSelection();
                this.showCaret(false);
                rectangle = this.selection.getBounds();
                textInput.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    private void updateSelection() {
        Bounds bounds;
        TextInput textInput = (TextInput)this.getComponent();
        int n = this.getHeight();
        int n2 = textInput.getSelectionStart();
        int n3 = textInput.getSelectionLength();
        TextNode textNode = textInput.getTextNode();
        int n4 = textNode.getCharacterCount();
        if (n2 < n4) {
            bounds = this.getCharacterBounds(n2);
        } else {
            int n5;
            if (n4 == 0) {
                n5 = this.padding.left - this.scrollLeft + 1;
            } else {
                Rectangle2D rectangle2D = this.glyphVector.getLogicalBounds();
                n5 = (int)Math.ceil(rectangle2D.getWidth()) + (this.padding.left - this.scrollLeft + 1);
            }
            int n6 = this.padding.top + 1;
            bounds = new Bounds(n5, n6, 0, n - (this.padding.top + this.padding.bottom + 2));
        }
        this.caret = bounds.toRectangle();
        this.caret.width = 1;
        if (n3 > 0) {
            Bounds bounds2 = this.getCharacterBounds(n2 + n3 - 1);
            this.selection = new Rectangle(bounds.x, bounds.y, bounds2.x + bounds2.width - bounds.x, bounds2.y + bounds2.height - bounds.y);
        } else {
            this.selection = null;
        }
    }

    public void showCaret(boolean bl) {
        if (this.scheduledBlinkCaretCallback != null) {
            this.scheduledBlinkCaretCallback.cancel();
        }
        if (bl) {
            this.caretOn = true;
            this.scheduledBlinkCaretCallback = ApplicationContext.scheduleRecurringCallback((Runnable)this.blinkCaretCallback, (long)Platform.getCursorBlinkRate());
            this.blinkCaretCallback.run();
        } else {
            this.scheduledBlinkCaretCallback = null;
        }
    }

    private class ScrollSelectionCallback
    implements Runnable {
        private ScrollSelectionCallback() {
        }

        @Override
        public void run() {
            TextInput textInput = (TextInput)TerraTextInputSkin.this.getComponent();
            int n = textInput.getSelectionStart();
            int n2 = textInput.getSelectionLength();
            int n3 = n + n2 - 1;
            switch (TerraTextInputSkin.this.scrollDirection) {
                case FORWARD: {
                    TextNode textNode = textInput.getTextNode();
                    if (n3 >= textNode.getCharacterCount() - 1) break;
                    textInput.setSelection(n, ++n3 - n + 1);
                    TerraTextInputSkin.this.scrollCharacterToVisible(n3);
                    break;
                }
                case BACKWARD: {
                    if (n <= 0) break;
                    textInput.setSelection(--n, n3 - n + 1);
                    TerraTextInputSkin.this.scrollCharacterToVisible(n);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    }

    private class BlinkCaretCallback
    implements Runnable {
        private BlinkCaretCallback() {
        }

        @Override
        public void run() {
            TerraTextInputSkin.this.caretOn = !TerraTextInputSkin.this.caretOn;
            if (TerraTextInputSkin.this.caret != null) {
                TextInput textInput = (TextInput)TerraTextInputSkin.this.getComponent();
                textInput.repaint(((TerraTextInputSkin)TerraTextInputSkin.this).caret.x, ((TerraTextInputSkin)TerraTextInputSkin.this).caret.y, ((TerraTextInputSkin)TerraTextInputSkin.this).caret.width, ((TerraTextInputSkin)TerraTextInputSkin.this).caret.height, true);
            }
        }
    }
}

