/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Map;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.ThreadUtilities;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.wtk.Accordion;
import org.apache.pivot.wtk.ActivityIndicator;
import org.apache.pivot.wtk.Alert;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Border;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Calendar;
import org.apache.pivot.wtk.CalendarButton;
import org.apache.pivot.wtk.Checkbox;
import org.apache.pivot.wtk.ColorChooser;
import org.apache.pivot.wtk.ColorChooserButton;
import org.apache.pivot.wtk.Dialog;
import org.apache.pivot.wtk.Expander;
import org.apache.pivot.wtk.FileBrowser;
import org.apache.pivot.wtk.FileBrowserSheet;
import org.apache.pivot.wtk.Form;
import org.apache.pivot.wtk.Frame;
import org.apache.pivot.wtk.GridPane;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.LinkButton;
import org.apache.pivot.wtk.ListButton;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuBar;
import org.apache.pivot.wtk.MenuButton;
import org.apache.pivot.wtk.MenuPopup;
import org.apache.pivot.wtk.MessageType;
import org.apache.pivot.wtk.Meter;
import org.apache.pivot.wtk.Palette;
import org.apache.pivot.wtk.Panorama;
import org.apache.pivot.wtk.Prompt;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.RadioButton;
import org.apache.pivot.wtk.Rollup;
import org.apache.pivot.wtk.ScrollBar;
import org.apache.pivot.wtk.ScrollPane;
import org.apache.pivot.wtk.Separator;
import org.apache.pivot.wtk.Sheet;
import org.apache.pivot.wtk.Slider;
import org.apache.pivot.wtk.Spinner;
import org.apache.pivot.wtk.SplitPane;
import org.apache.pivot.wtk.TabPane;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.TableViewHeader;
import org.apache.pivot.wtk.TextArea;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Tooltip;
import org.apache.pivot.wtk.TreeView;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.terra.TerraAccordionSkin;
import org.apache.pivot.wtk.skin.terra.TerraActivityIndicatorSkin;
import org.apache.pivot.wtk.skin.terra.TerraAlertSkin;
import org.apache.pivot.wtk.skin.terra.TerraBorderSkin;
import org.apache.pivot.wtk.skin.terra.TerraBoxPaneSkin;
import org.apache.pivot.wtk.skin.terra.TerraCalendarButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraCalendarSkin;
import org.apache.pivot.wtk.skin.terra.TerraCheckboxSkin;
import org.apache.pivot.wtk.skin.terra.TerraColorChooserButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraColorChooserSkin;
import org.apache.pivot.wtk.skin.terra.TerraDialogSkin;
import org.apache.pivot.wtk.skin.terra.TerraExpanderSkin;
import org.apache.pivot.wtk.skin.terra.TerraFileBrowserSheetSkin;
import org.apache.pivot.wtk.skin.terra.TerraFileBrowserSkin;
import org.apache.pivot.wtk.skin.terra.TerraFormSkin;
import org.apache.pivot.wtk.skin.terra.TerraFrameSkin;
import org.apache.pivot.wtk.skin.terra.TerraGridPaneSkin;
import org.apache.pivot.wtk.skin.terra.TerraLabelSkin;
import org.apache.pivot.wtk.skin.terra.TerraLinkButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraListButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraListViewSkin;
import org.apache.pivot.wtk.skin.terra.TerraMenuBarItemSkin;
import org.apache.pivot.wtk.skin.terra.TerraMenuBarSkin;
import org.apache.pivot.wtk.skin.terra.TerraMenuButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraMenuItemSkin;
import org.apache.pivot.wtk.skin.terra.TerraMenuPopupSkin;
import org.apache.pivot.wtk.skin.terra.TerraMenuSkin;
import org.apache.pivot.wtk.skin.terra.TerraMeterSkin;
import org.apache.pivot.wtk.skin.terra.TerraPaletteSkin;
import org.apache.pivot.wtk.skin.terra.TerraPanoramaSkin;
import org.apache.pivot.wtk.skin.terra.TerraPromptSkin;
import org.apache.pivot.wtk.skin.terra.TerraPushButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraRadioButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraRollupSkin;
import org.apache.pivot.wtk.skin.terra.TerraScrollBarSkin;
import org.apache.pivot.wtk.skin.terra.TerraScrollPaneCornerSkin;
import org.apache.pivot.wtk.skin.terra.TerraScrollPaneSkin;
import org.apache.pivot.wtk.skin.terra.TerraSeparatorSkin;
import org.apache.pivot.wtk.skin.terra.TerraSheetSkin;
import org.apache.pivot.wtk.skin.terra.TerraSliderSkin;
import org.apache.pivot.wtk.skin.terra.TerraSpinnerSkin;
import org.apache.pivot.wtk.skin.terra.TerraSplitPaneSkin;
import org.apache.pivot.wtk.skin.terra.TerraTabPaneSkin;
import org.apache.pivot.wtk.skin.terra.TerraTablePaneSkin;
import org.apache.pivot.wtk.skin.terra.TerraTableViewHeaderSkin;
import org.apache.pivot.wtk.skin.terra.TerraTableViewSkin;
import org.apache.pivot.wtk.skin.terra.TerraTextAreaSkin;
import org.apache.pivot.wtk.skin.terra.TerraTextInputSkin;
import org.apache.pivot.wtk.skin.terra.TerraTooltipSkin;
import org.apache.pivot.wtk.skin.terra.TerraTreeViewSkin;

public final class TerraTheme
extends Theme {
    private Font font = null;
    private Color[] colors = null;
    public static final String LOCATION_PROPERTY = "org.apache.pivot.wtk.skin.terra.location";

    public TerraTheme() {
        this.componentSkinMap.put(Accordion.class, TerraAccordionSkin.class);
        this.componentSkinMap.put(ActivityIndicator.class, TerraActivityIndicatorSkin.class);
        this.componentSkinMap.put(Alert.class, TerraAlertSkin.class);
        this.componentSkinMap.put(Border.class, TerraBorderSkin.class);
        this.componentSkinMap.put(Checkbox.class, TerraCheckboxSkin.class);
        this.componentSkinMap.put(Calendar.class, TerraCalendarSkin.class);
        this.componentSkinMap.put(CalendarButton.class, TerraCalendarButtonSkin.class);
        this.componentSkinMap.put(ColorChooser.class, TerraColorChooserSkin.class);
        this.componentSkinMap.put(ColorChooserButton.class, TerraColorChooserButtonSkin.class);
        this.componentSkinMap.put(Dialog.class, TerraDialogSkin.class);
        this.componentSkinMap.put(Expander.class, TerraExpanderSkin.class);
        this.componentSkinMap.put(FileBrowser.class, TerraFileBrowserSkin.class);
        this.componentSkinMap.put(FileBrowserSheet.class, TerraFileBrowserSheetSkin.class);
        this.componentSkinMap.put(Form.class, TerraFormSkin.class);
        this.componentSkinMap.put(BoxPane.class, TerraBoxPaneSkin.class);
        this.componentSkinMap.put(Frame.class, TerraFrameSkin.class);
        this.componentSkinMap.put(GridPane.class, TerraGridPaneSkin.class);
        this.componentSkinMap.put(Label.class, TerraLabelSkin.class);
        this.componentSkinMap.put(LinkButton.class, TerraLinkButtonSkin.class);
        this.componentSkinMap.put(ListButton.class, TerraListButtonSkin.class);
        this.componentSkinMap.put(ListView.class, TerraListViewSkin.class);
        this.componentSkinMap.put(Menu.class, TerraMenuSkin.class);
        this.componentSkinMap.put(Menu.Item.class, TerraMenuItemSkin.class);
        this.componentSkinMap.put(MenuBar.class, TerraMenuBarSkin.class);
        this.componentSkinMap.put(MenuBar.Item.class, TerraMenuBarItemSkin.class);
        this.componentSkinMap.put(MenuButton.class, TerraMenuButtonSkin.class);
        this.componentSkinMap.put(MenuPopup.class, TerraMenuPopupSkin.class);
        this.componentSkinMap.put(Meter.class, TerraMeterSkin.class);
        this.componentSkinMap.put(Palette.class, TerraPaletteSkin.class);
        this.componentSkinMap.put(Panorama.class, TerraPanoramaSkin.class);
        this.componentSkinMap.put(Prompt.class, TerraPromptSkin.class);
        this.componentSkinMap.put(PushButton.class, TerraPushButtonSkin.class);
        this.componentSkinMap.put(RadioButton.class, TerraRadioButtonSkin.class);
        this.componentSkinMap.put(Rollup.class, TerraRollupSkin.class);
        this.componentSkinMap.put(ScrollBar.class, TerraScrollBarSkin.class);
        this.componentSkinMap.put(ScrollPane.class, TerraScrollPaneSkin.class);
        this.componentSkinMap.put(ScrollPane.Corner.class, TerraScrollPaneCornerSkin.class);
        this.componentSkinMap.put(Separator.class, TerraSeparatorSkin.class);
        this.componentSkinMap.put(Sheet.class, TerraSheetSkin.class);
        this.componentSkinMap.put(Slider.class, TerraSliderSkin.class);
        this.componentSkinMap.put(Spinner.class, TerraSpinnerSkin.class);
        this.componentSkinMap.put(SplitPane.class, TerraSplitPaneSkin.class);
        this.componentSkinMap.put(TablePane.class, TerraTablePaneSkin.class);
        this.componentSkinMap.put(TableViewHeader.class, TerraTableViewHeaderSkin.class);
        this.componentSkinMap.put(TableView.class, TerraTableViewSkin.class);
        this.componentSkinMap.put(TabPane.class, TerraTabPaneSkin.class);
        this.componentSkinMap.put(TextArea.class, TerraTextAreaSkin.class);
        this.componentSkinMap.put(TextInput.class, TerraTextInputSkin.class);
        this.componentSkinMap.put(Tooltip.class, TerraTooltipSkin.class);
        this.componentSkinMap.put(TreeView.class, TerraTreeViewSkin.class);
        this.componentSkinMap.put(TerraCalendarSkin.DateButton.class, TerraCalendarSkin.DateButtonSkin.class);
        this.componentSkinMap.put(TerraExpanderSkin.ShadeButton.class, TerraExpanderSkin.ShadeButtonSkin.class);
        this.componentSkinMap.put(TerraFrameSkin.FrameButton.class, TerraFrameSkin.FrameButtonSkin.class);
        this.componentSkinMap.put(TerraRollupSkin.RollupButton.class, TerraRollupSkin.RollupButtonSkin.class);
        this.componentSkinMap.put(TerraScrollBarSkin.ScrollButton.class, TerraScrollBarSkin.ScrollButtonSkin.class);
        this.componentSkinMap.put(TerraScrollBarSkin.Handle.class, TerraScrollBarSkin.HandleSkin.class);
        this.componentSkinMap.put(TerraSliderSkin.Thumb.class, TerraSliderSkin.ThumbSkin.class);
        this.componentSkinMap.put(TerraSpinnerSkin.SpinButton.class, TerraSpinnerSkin.SpinButtonSkin.class);
        this.componentSkinMap.put(TerraSpinnerSkin.SpinnerContent.class, TerraSpinnerSkin.SpinnerContentSkin.class);
        this.componentSkinMap.put(TerraSplitPaneSkin.Splitter.class, TerraSplitPaneSkin.SplitterSkin.class);
        this.componentSkinMap.put(TerraSplitPaneSkin.SplitterShadow.class, TerraSplitPaneSkin.SplitterShadowSkin.class);
        this.componentSkinMap.put(TerraTabPaneSkin.TabButton.class, TerraTabPaneSkin.TabButtonSkin.class);
        String string = null;
        try {
            string = System.getProperty(LOCATION_PROPERTY);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string == null) {
            this.load(((Object)((Object)this)).getClass().getResource("TerraTheme_default.json"));
        } else {
            this.load(ThreadUtilities.getClassLoader().getResource(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            try {
                JSONSerializer jSONSerializer = new JSONSerializer();
                Map map = (Map)jSONSerializer.readObject(inputStream);
                this.font = Font.decode((String)map.get((Object)"font"));
                List list = (List)map.get((Object)"colors");
                this.colors = new Color[list.getLength() * 3];
                int n = list.getLength();
                for (int i = 0; i < n; ++i) {
                    Color color;
                    int n2 = i * 3 + 1;
                    this.colors[n2] = color = Color.decode((String)list.get(i));
                    this.colors[n2 - 1] = TerraTheme.darken(color);
                    this.colors[n2 + 1] = TerraTheme.brighten(color);
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (SerializationException serializationException) {
            throw new RuntimeException(serializationException);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getColor(int n) {
        return this.colors[n];
    }

    public Image getMessageIcon(MessageType messageType) {
        String string;
        switch (messageType) {
            case ERROR: {
                string = "message_type-error-32x32.png";
                break;
            }
            case WARNING: {
                string = "message_type-warning-32x32.png";
                break;
            }
            case QUESTION: {
                string = "message_type-question-32x32.png";
                break;
            }
            case INFO: {
                string = "message_type-info-32x32.png";
                break;
            }
            case APPLICATION: {
                string = null;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        Image image = null;
        if (string != null) {
            URL uRL = ((Object)((Object)this)).getClass().getResource(string);
            image = (Image)ApplicationContext.getResourceCache().get(uRL);
            if (image == null) {
                try {
                    image = Image.load((URL)uRL);
                }
                catch (TaskExecutionException taskExecutionException) {
                    throw new RuntimeException(taskExecutionException);
                }
                ApplicationContext.getResourceCache().put(uRL, (Object)image);
            }
        }
        return image;
    }

    public Image getSmallMessageIcon(MessageType messageType) {
        String string;
        switch (messageType) {
            case ERROR: {
                string = "message_type-error-16x16.png";
                break;
            }
            case WARNING: {
                string = "message_type-warning-16x16.png";
                break;
            }
            case QUESTION: {
                string = "message_type-question-16x16.png";
                break;
            }
            case INFO: {
                string = "message_type-info-16x16.png";
                break;
            }
            case APPLICATION: {
                string = null;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        Image image = null;
        if (string != null) {
            URL uRL = ((Object)((Object)this)).getClass().getResource(string);
            image = (Image)ApplicationContext.getResourceCache().get(uRL);
            if (image == null) {
                try {
                    image = Image.load((URL)uRL);
                }
                catch (TaskExecutionException taskExecutionException) {
                    throw new RuntimeException(taskExecutionException);
                }
                ApplicationContext.getResourceCache().put(uRL, (Object)image);
            }
        }
        return image;
    }

    public static Color brighten(Color color) {
        return TerraTheme.adjustBrightness(color, 0.1f);
    }

    public static Color darken(Color color) {
        return TerraTheme.adjustBrightness(color, -0.1f);
    }

    private static Color adjustBrightness(Color color, float f) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        fArray[2] = Math.min(Math.max(fArray[2] + f, 0.0f), 1.0f);
        int n = Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]);
        return new Color(color.getAlpha() << 24 | n & 0xFFFFFF);
    }
}

