/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Border;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Tooltip;
import org.apache.pivot.wtk.TooltipListener;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.DropShadowDecorator;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.skin.WindowSkin;
import org.apache.pivot.wtk.skin.terra.FadeWindowTransition;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraTooltipSkin
extends WindowSkin
implements TooltipListener {
    private Label label = new Label();
    private Border border = new Border();
    private boolean fade = true;
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener(){

        public boolean mouseMove(Container container, int n, int n2) {
            Tooltip tooltip = (Tooltip)TerraTooltipSkin.this.getComponent();
            tooltip.close();
            return false;
        }

        public boolean mouseDown(Container container, Mouse.Button button, int n, int n2) {
            Tooltip tooltip = (Tooltip)TerraTooltipSkin.this.getComponent();
            tooltip.close();
            return false;
        }

        public boolean mouseUp(Container container, Mouse.Button button, int n, int n2) {
            Tooltip tooltip = (Tooltip)TerraTooltipSkin.this.getComponent();
            tooltip.close();
            return false;
        }

        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
            TerraTooltipSkin.this.fade = false;
            Tooltip tooltip = (Tooltip)TerraTooltipSkin.this.getComponent();
            tooltip.close();
            return false;
        }
    };
    private ComponentKeyListener displayKeyListener = new ComponentKeyListener.Adapter(){

        public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
            TerraTooltipSkin.this.fade = false;
            Tooltip tooltip = (Tooltip)TerraTooltipSkin.this.getComponent();
            tooltip.close();
            return false;
        }
    };
    private Transition closeTransition = null;
    private DropShadowDecorator dropShadowDecorator = null;
    private static final int CLOSE_TRANSITION_DURATION = 500;
    private static final int CLOSE_TRANSITION_RATE = 30;

    public TerraTooltipSkin() {
        this.setBackgroundColor(null);
        this.border.setContent((Component)this.label);
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        Component.StyleDictionary styleDictionary = this.label.getStyles();
        styleDictionary.put("font", (Object)terraTheme.getFont());
        styleDictionary.put("color", (Object)Color.BLACK);
        Component.StyleDictionary styleDictionary2 = this.border.getStyles();
        styleDictionary2.put("backgroundColor", (Object)new Color(255, 255, 224, 240));
        styleDictionary2.put("color", (Object)Color.BLACK);
        styleDictionary2.put("padding", (Object)new Insets(2));
    }

    public void install(Component component) {
        super.install(component);
        Tooltip tooltip = (Tooltip)component;
        this.dropShadowDecorator = new DropShadowDecorator(5, 2, 2);
        tooltip.getDecorators().add((Decorator)this.dropShadowDecorator);
        tooltip.setContent((Component)this.border);
        tooltip.getTooltipListeners().add((Object)this);
        this.label.setText(tooltip.getText());
    }

    public void windowOpened(Window window) {
        super.windowOpened(window);
        Display display = window.getDisplay();
        display.getContainerMouseListeners().add((Object)this.displayMouseListener);
        display.getComponentKeyListeners().add((Object)this.displayKeyListener);
    }

    public Vote previewWindowClose(final Window window) {
        Vote vote = Vote.APPROVE;
        if (this.fade) {
            if (this.closeTransition == null) {
                this.closeTransition = new FadeWindowTransition((Component)window, 500, 30, this.dropShadowDecorator);
                this.closeTransition.start(new TransitionListener(){

                    public void transitionCompleted(Transition transition) {
                        window.close();
                    }
                });
                vote = Vote.DEFER;
            } else {
                vote = this.closeTransition.isRunning() ? Vote.DEFER : Vote.APPROVE;
            }
        }
        return vote;
    }

    public void windowCloseVetoed(Window window, Vote vote) {
        super.windowCloseVetoed(window, vote);
        if (vote == Vote.DENY && this.closeTransition != null) {
            this.closeTransition.stop();
        }
    }

    public void windowClosed(Window window, Display display, Window window2) {
        super.windowClosed(window, display, window2);
        display.getContainerMouseListeners().remove((Object)this.displayMouseListener);
        display.getComponentKeyListeners().remove((Object)this.displayKeyListener);
        this.closeTransition = null;
    }

    public void textChanged(Tooltip tooltip, String string) {
        this.label.setText(tooltip.getText());
    }
}

