/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.Filter;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Checkbox;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.TreeView;
import org.apache.pivot.wtk.TreeViewBranchListener;
import org.apache.pivot.wtk.TreeViewListener;
import org.apache.pivot.wtk.TreeViewNodeListener;
import org.apache.pivot.wtk.TreeViewNodeStateListener;
import org.apache.pivot.wtk.TreeViewSelectionListener;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraTreeViewSkin
extends ComponentSkin
implements TreeView.Skin,
TreeViewListener,
TreeViewBranchListener,
TreeViewNodeListener,
TreeViewNodeStateListener,
TreeViewSelectionListener {
    private BranchInfo rootBranchInfo = null;
    private List<NodeInfo> visibleNodes = new ArrayList();
    private NodeInfo highlightedNode = null;
    private NodeInfo editNode = null;
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color backgroundColor;
    private Color selectionColor;
    private Color selectionBackgroundColor;
    private Color inactiveSelectionColor;
    private Color inactiveSelectionBackgroundColor;
    private Color highlightColor;
    private Color highlightBackgroundColor;
    private int spacing;
    private int indent;
    private boolean showHighlight;
    private boolean showBranchControls;
    private boolean showEmptyBranchControls;
    private Color branchControlColor;
    private Color branchControlSelectionColor;
    private Color branchControlInactiveSelectionColor;
    private Color gridColor;
    private boolean showGridLines;
    private static final int BRANCH_CONTROL_IMAGE_WIDTH = 8;
    private static final int BRANCH_CONTROL_IMAGE_HEIGHT = 8;
    private static final int VERTICAL_SPACING = 1;
    private static final Checkbox CHECKBOX = new Checkbox();
    private static final int CHECKBOX_VERTICAL_PADDING = 2;

    public TerraTreeViewSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.font = terraTheme.getFont();
        this.color = terraTheme.getColor(1);
        this.disabledColor = terraTheme.getColor(7);
        this.backgroundColor = terraTheme.getColor(4);
        this.selectionColor = terraTheme.getColor(4);
        this.selectionBackgroundColor = terraTheme.getColor(19);
        this.inactiveSelectionColor = terraTheme.getColor(1);
        this.inactiveSelectionBackgroundColor = terraTheme.getColor(10);
        this.highlightColor = terraTheme.getColor(1);
        this.highlightBackgroundColor = terraTheme.getColor(10);
        this.spacing = 6;
        this.indent = 16;
        this.showHighlight = true;
        this.showBranchControls = true;
        this.showEmptyBranchControls = true;
        this.branchControlColor = terraTheme.getColor(18);
        this.branchControlSelectionColor = terraTheme.getColor(4);
        this.branchControlInactiveSelectionColor = terraTheme.getColor(19);
        this.gridColor = terraTheme.getColor(11);
        this.showGridLines = false;
    }

    public void install(Component component) {
        super.install(component);
        TreeView treeView = (TreeView)component;
        treeView.getTreeViewListeners().add((Object)this);
        treeView.getTreeViewBranchListeners().add((Object)this);
        treeView.getTreeViewNodeListeners().add((Object)this);
        treeView.getTreeViewNodeStateListeners().add((Object)this);
        treeView.getTreeViewSelectionListeners().add((Object)this);
        this.treeDataChanged(treeView, null);
    }

    public int getPreferredWidth(int n) {
        TreeView treeView = (TreeView)this.getComponent();
        TreeView.NodeRenderer nodeRenderer = treeView.getNodeRenderer();
        int n2 = 0;
        VisibleNodeIterator visibleNodeIterator = new VisibleNodeIterator();
        while (visibleNodeIterator.hasNext()) {
            NodeInfo nodeInfo = visibleNodeIterator.next();
            int n3 = (nodeInfo.depth - 1) * (this.indent + this.spacing);
            nodeRenderer.render(nodeInfo.data, visibleNodeIterator.getPath(), visibleNodeIterator.getRowIndex(), treeView, false, false, TreeView.NodeCheckState.UNCHECKED, false, false);
            n2 = Math.max(n2, n3 += nodeRenderer.getPreferredWidth(-1));
        }
        if (this.showBranchControls) {
            n2 += this.indent + this.spacing;
        }
        if (treeView.getCheckmarksEnabled()) {
            n2 += Math.max(CHECKBOX.getWidth(), this.indent) + this.spacing;
        }
        return n2;
    }

    public int getPreferredHeight(int n) {
        int n2 = this.getNodeHeight();
        int n3 = this.visibleNodes.getLength();
        int n4 = n2 * n3;
        if (n3 > 1) {
            n4 += 1 * (n3 - 1);
        }
        return n4;
    }

    public int getBaseline(int n, int n2) {
        int n3 = -1;
        if (this.visibleNodes.getLength() > 0) {
            Object object;
            TreeView treeView = (TreeView)this.getComponent();
            TreeView.NodeRenderer nodeRenderer = treeView.getNodeRenderer();
            NodeInfo nodeInfo = (NodeInfo)this.visibleNodes.get(0);
            int n4 = n - (nodeInfo.depth - 1) * (this.indent + this.spacing);
            int n5 = this.getNodeHeight();
            boolean bl = false;
            boolean bl2 = nodeInfo.isSelected();
            boolean bl3 = nodeInfo.isHighlighted();
            boolean bl4 = nodeInfo.isDisabled();
            if (this.showBranchControls) {
                if (nodeInfo instanceof BranchInfo) {
                    object = (BranchInfo)nodeInfo;
                    bl = ((BranchInfo)object).isExpanded();
                }
                n4 -= this.indent + this.spacing;
            }
            object = TreeView.NodeCheckState.UNCHECKED;
            if (treeView.getCheckmarksEnabled()) {
                object = nodeInfo.getCheckState();
                n4 -= Math.max(this.indent, CHECKBOX.getWidth()) + this.spacing;
            }
            nodeRenderer.render(nodeInfo.data, nodeInfo.getPath(), 0, treeView, bl, bl2, (TreeView.NodeCheckState)object, bl3, bl4);
            n3 = nodeRenderer.getBaseline(n4, n5);
        }
        return n3;
    }

    public void layout() {
    }

    public void paint(Graphics2D graphics2D) {
        TreeView treeView = (TreeView)this.getComponent();
        TreeView.NodeRenderer nodeRenderer = treeView.getNodeRenderer();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNodeHeight();
        if (this.backgroundColor != null) {
            graphics2D.setPaint(this.backgroundColor);
            graphics2D.fillRect(0, 0, n, n2);
        }
        int n4 = 0;
        int n5 = this.visibleNodes.getLength() - 1;
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle != null) {
            n4 = Math.max(n4, (int)((double)rectangle.y / (double)(n3 + 1)));
            n5 = Math.min(n5, (int)((double)(rectangle.y + rectangle.height) / (double)(n3 + 1)));
        }
        int n6 = n4 * (n3 + 1);
        VisibleNodeIterator visibleNodeIterator = new VisibleNodeIterator(n4, n5);
        while (visibleNodeIterator.hasNext()) {
            Object object;
            int n7;
            Object object2;
            int n8;
            Object object3;
            NodeInfo nodeInfo = visibleNodeIterator.next();
            boolean bl = false;
            boolean bl2 = nodeInfo.isHighlighted();
            boolean bl3 = nodeInfo.isSelected();
            boolean bl4 = nodeInfo.isDisabled();
            int n9 = (nodeInfo.depth - 1) * (this.indent + this.spacing);
            if (treeView.isEnabled()) {
                if (bl3) {
                    object3 = treeView.isFocused() ? this.selectionBackgroundColor : this.inactiveSelectionBackgroundColor;
                    graphics2D.setPaint((Paint)object3);
                    graphics2D.fillRect(0, n6, n, n3);
                } else if (bl2 && !bl4) {
                    graphics2D.setPaint(this.highlightBackgroundColor);
                    graphics2D.fillRect(0, n6, n, n3);
                }
            }
            if (this.showBranchControls) {
                if (nodeInfo instanceof BranchInfo) {
                    object3 = (BranchInfo)nodeInfo;
                    n8 = 1;
                    if (!this.showEmptyBranchControls) {
                        ((BranchInfo)object3).loadChildren();
                        int n10 = n8 = !((BranchInfo)object3).children.isEmpty() ? 1 : 0;
                    }
                    if (n8 != 0) {
                        bl = ((BranchInfo)object3).isExpanded();
                        object2 = bl3 ? (treeView.isFocused() ? this.branchControlSelectionColor : this.branchControlInactiveSelectionColor) : this.branchControlColor;
                        GeneralPath generalPath = new GeneralPath();
                        n7 = n9 + (this.indent - 8) / 2;
                        int n11 = n6 + (n3 - 8) / 2;
                        if (bl) {
                            generalPath.moveTo(n7, n11 + 1);
                            generalPath.lineTo(n7 + 8, n11 + 1);
                            generalPath.lineTo(n7 + 4, n11 + 7);
                        } else {
                            generalPath.moveTo(n7 + 1, n11);
                            generalPath.lineTo(n7 + 7, n11 + 4);
                            generalPath.lineTo(n7 + 1, n11 + 8);
                        }
                        generalPath.closePath();
                        object = (Graphics2D)graphics2D.create();
                        ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        if (!treeView.isEnabled() || bl4) {
                            ((Graphics2D)object).setComposite(AlphaComposite.getInstance(3, 0.5f));
                        }
                        ((Graphics2D)object).setPaint((Paint)object2);
                        ((Graphics2D)object).fill(generalPath);
                        ((Graphics)object).dispose();
                    }
                }
                n9 += this.indent + this.spacing;
            }
            object3 = TreeView.NodeCheckState.UNCHECKED;
            if (treeView.getCheckmarksEnabled()) {
                object3 = nodeInfo.getCheckState();
                n8 = CHECKBOX.getWidth();
                int n12 = CHECKBOX.getHeight();
                int n13 = Math.max(this.indent - n8, 0) / 2;
                n7 = (n3 - n12) / 2;
                Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(n9 + n13, n6 + n7, n8, n12);
                switch (4.$SwitchMap$org$apache$pivot$wtk$TreeView$NodeCheckState[object3.ordinal()]) {
                    case 1: {
                        object = Button.State.SELECTED;
                        break;
                    }
                    case 2: {
                        object = Button.State.MIXED;
                        break;
                    }
                    default: {
                        object = Button.State.UNSELECTED;
                    }
                }
                CHECKBOX.setState((Button.State)object);
                CHECKBOX.setEnabled(treeView.isEnabled() && !bl4 && !nodeInfo.isCheckmarkDisabled());
                CHECKBOX.paint(graphics2D2);
                graphics2D2.dispose();
                n9 += Math.max(this.indent, n8) + this.spacing;
            }
            n8 = n - n9;
            object2 = (Graphics2D)graphics2D.create(n9, n6, n8, n3);
            nodeRenderer.render(nodeInfo.data, visibleNodeIterator.getPath(), visibleNodeIterator.getRowIndex(), treeView, bl, bl3, (TreeView.NodeCheckState)object3, bl2, bl4);
            nodeRenderer.setSize(n8, n3);
            nodeRenderer.paint((Graphics2D)object2);
            ((Graphics)object2).dispose();
            if (this.showGridLines) {
                graphics2D.setPaint(this.gridColor);
                GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)0, (int)(n6 + n3), (int)n, (Orientation)Orientation.HORIZONTAL);
            }
            n6 += n3 + 1;
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraTreeViewSkin.decodeFont((String)string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setColor(terraTheme.getColor(n));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = color;
        this.repaintComponent();
    }

    public void setDisabledColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setDisabledColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setDisabledColor(terraTheme.getColor(n));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.repaintComponent();
    }

    public void setBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(terraTheme.getColor(n));
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.selectionColor = color;
        this.repaintComponent();
    }

    public void setSelectionColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.setSelectionColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setSelectionColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setSelectionColor(terraTheme.getColor(n));
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.selectionBackgroundColor = color;
        this.repaintComponent();
    }

    public void setSelectionBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.setSelectionBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setSelectionBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setSelectionBackgroundColor(terraTheme.getColor(n));
    }

    public Color getInactiveSelectionColor() {
        return this.inactiveSelectionColor;
    }

    public void setInactiveSelectionColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.inactiveSelectionColor = color;
        this.repaintComponent();
    }

    public void setInactiveSelectionColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.setInactiveSelectionColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setInactiveSelectionColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setInactiveSelectionColor(terraTheme.getColor(n));
    }

    public Color getInactiveSelectionBackgroundColor() {
        return this.inactiveSelectionBackgroundColor;
    }

    public void setInactiveSelectionBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.inactiveSelectionBackgroundColor = color;
        this.repaintComponent();
    }

    public void setInactiveSelectionBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.setInactiveSelectionBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setInactiveSelectionBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setInactiveSelectionBackgroundColor(terraTheme.getColor(n));
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("highlightColor is null.");
        }
        this.highlightColor = color;
        this.repaintComponent();
    }

    public void setHighlightColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("highlightColor is null.");
        }
        this.setHighlightColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setHighlightColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setHighlightColor(terraTheme.getColor(n));
    }

    public Color getHighlightBackgroundColor() {
        return this.highlightBackgroundColor;
    }

    public void setHighlightBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.highlightBackgroundColor = color;
        this.repaintComponent();
    }

    public void setHighlightBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.setHighlightBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setHighlightBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setHighlightBackgroundColor(terraTheme.getColor(n));
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("spacing is negative.");
        }
        this.spacing = n;
        this.invalidateComponent();
    }

    public void setSpacing(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("spacing is null.");
        }
        this.setSpacing(number.intValue());
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("indent is negative.");
        }
        this.indent = n;
        this.invalidateComponent();
    }

    public void setIndent(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("indent is null.");
        }
        this.setIndent(number.intValue());
    }

    public boolean getShowHighlight() {
        return this.showHighlight;
    }

    public void setShowHighlight(boolean bl) {
        this.showHighlight = bl;
        this.repaintComponent();
    }

    public boolean getShowBranchControls() {
        return this.showBranchControls;
    }

    public void setShowBranchControls(boolean bl) {
        this.showBranchControls = bl;
        this.invalidateComponent();
    }

    public boolean getShowEmptyBranchControls() {
        return this.showEmptyBranchControls;
    }

    public void setShowEmptyBranchControls(boolean bl) {
        this.showEmptyBranchControls = bl;
        this.repaintComponent();
    }

    public Color getBranchControlColor() {
        return this.branchControlColor;
    }

    public void setBranchControlColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("branchControlColor is null.");
        }
        this.branchControlColor = color;
        this.repaintComponent();
    }

    public void setBranchControlColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("branchControlColor is null.");
        }
        this.setBranchControlColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setBranchControlColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBranchControlColor(terraTheme.getColor(n));
    }

    public Color getBranchControlSelectionColor() {
        return this.branchControlSelectionColor;
    }

    public void setBranchControlSelectionColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("branchControlSelectionColor is null.");
        }
        this.branchControlSelectionColor = color;
        this.repaintComponent();
    }

    public void setBranchControlSelectionColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("branchControlSelectionColor is null.");
        }
        this.setBranchControlSelectionColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setBranchControlSelectionColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBranchControlSelectionColor(terraTheme.getColor(n));
    }

    public Color getBranchControlInactiveSelectionColor() {
        return this.branchControlInactiveSelectionColor;
    }

    public void setBranchControlInactiveSelectionColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("branchControlInactiveSelectionColor is null.");
        }
        this.branchControlInactiveSelectionColor = color;
        this.repaintComponent();
    }

    public void setBranchControlInactiveSelectionColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("branchControlInactiveSelectionColor is null.");
        }
        this.setBranchControlInactiveSelectionColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setBranchControlInactiveSelectionColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBranchControlInactiveSelectionColor(terraTheme.getColor(n));
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("gridColor is null.");
        }
        this.gridColor = color;
        this.repaintComponent();
    }

    public void setGridColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("gridColor is null.");
        }
        this.setGridColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setGridColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setGridColor(terraTheme.getColor(n));
    }

    public boolean getShowGridLines() {
        return this.showGridLines;
    }

    public void setShowGridLines(boolean bl) {
        this.showGridLines = bl;
        this.repaintComponent();
    }

    protected int getNodeHeight() {
        TreeView treeView = (TreeView)this.getComponent();
        TreeView.NodeRenderer nodeRenderer = treeView.getNodeRenderer();
        nodeRenderer.render(null, null, -1, treeView, false, false, TreeView.NodeCheckState.UNCHECKED, false, false);
        int n = nodeRenderer.getPreferredHeight(-1);
        if (treeView.getCheckmarksEnabled()) {
            n = Math.max(CHECKBOX.getHeight() + 4, n);
        }
        return n;
    }

    protected final NodeInfo getNodeInfoAt(int n) {
        NodeInfo nodeInfo = null;
        int n2 = this.getNodeHeight();
        int n3 = n / (n2 + 1);
        if (n3 >= 0 && n3 < this.visibleNodes.getLength()) {
            nodeInfo = (NodeInfo)this.visibleNodes.get(n3);
        }
        return nodeInfo;
    }

    protected final NodeInfo getNodeInfoAt(Sequence.Tree.Path path) {
        assert (path != null) : "Path is null";
        NodeInfo nodeInfo = null;
        int n = path.getLength();
        if (n == 0) {
            nodeInfo = this.rootBranchInfo;
        } else {
            BranchInfo branchInfo = this.rootBranchInfo;
            for (int i = 0; i < n - 1; ++i) {
                branchInfo.loadChildren();
                NodeInfo nodeInfo2 = (NodeInfo)branchInfo.children.get(path.get(i).intValue());
                assert (nodeInfo2 instanceof BranchInfo) : "Invalid path";
                branchInfo = (BranchInfo)nodeInfo2;
            }
            branchInfo.loadChildren();
            nodeInfo = (NodeInfo)branchInfo.children.get(path.get(n - 1).intValue());
        }
        return nodeInfo;
    }

    protected final Bounds getNodeBounds(NodeInfo nodeInfo) {
        Bounds bounds = null;
        int n = this.visibleNodes.indexOf((Object)nodeInfo);
        if (n >= 0) {
            int n2 = this.getNodeHeight();
            int n3 = n * (n2 + 1);
            bounds = new Bounds(0, n3, this.getWidth(), n2);
        }
        return bounds;
    }

    protected final void accept(NodeInfoVisitor nodeInfoVisitor) {
        ArrayList arrayList = new ArrayList();
        arrayList.add((Object)this.rootBranchInfo);
        while (arrayList.getLength() > 0) {
            BranchInfo branchInfo;
            NodeInfo nodeInfo = (NodeInfo)arrayList.get(0);
            arrayList.remove(0, 1);
            nodeInfoVisitor.visit(nodeInfo);
            if (!(nodeInfo instanceof BranchInfo) || (branchInfo = (BranchInfo)nodeInfo).children == null) continue;
            int n = branchInfo.children.getLength();
            for (int i = 0; i < n; ++i) {
                arrayList.insert(branchInfo.children.get(i), i);
            }
        }
    }

    private void addVisibleNodes(BranchInfo branchInfo) {
        int n = -1;
        if (branchInfo == this.rootBranchInfo) {
            n = 0;
        } else {
            int n2 = this.visibleNodes.indexOf((Object)branchInfo);
            if (n2 >= 0) {
                n = n2 + 1;
            }
        }
        if (n >= 0) {
            ArrayList arrayList = new ArrayList();
            branchInfo.loadChildren();
            int n3 = branchInfo.children.getLength();
            for (int i = 0; i < n3; ++i) {
                arrayList.add(branchInfo.children.get(i));
            }
            while (arrayList.getLength() > 0) {
                BranchInfo branchInfo2;
                NodeInfo nodeInfo = (NodeInfo)arrayList.get(0);
                arrayList.remove(0, 1);
                this.visibleNodes.insert((Object)nodeInfo, n++);
                if (!(nodeInfo instanceof BranchInfo) || !(branchInfo2 = (BranchInfo)nodeInfo).isExpanded()) continue;
                branchInfo2.loadChildren();
                int n4 = branchInfo2.children.getLength();
                for (int i = 0; i < n4; ++i) {
                    arrayList.insert(branchInfo2.children.get(i), i);
                }
            }
            this.invalidateComponent();
        }
    }

    private void addVisibleNode(BranchInfo branchInfo, int n) {
        branchInfo.loadChildren();
        assert (n >= 0) : "Index is too small";
        assert (n < branchInfo.children.getLength()) : "Index is too large";
        int n2 = this.visibleNodes.indexOf((Object)branchInfo);
        if (branchInfo == this.rootBranchInfo || n2 >= 0 && branchInfo.isExpanded()) {
            NodeInfo nodeInfo = (NodeInfo)branchInfo.children.get(n);
            int n3 = n2 + n + 1;
            if (n > 0) {
                NodeInfo nodeInfo2 = (NodeInfo)branchInfo.children.get(n - 1);
                int n4 = this.visibleNodes.getLength();
                int n5 = nodeInfo2.depth;
                for (n3 = this.visibleNodes.indexOf((Object)nodeInfo2) + 1; n3 < n4 && ((NodeInfo)this.visibleNodes.get((int)n3)).depth > n5; ++n3) {
                }
            }
            this.visibleNodes.insert((Object)nodeInfo, n3);
            this.invalidateComponent();
        }
    }

    private void removeVisibleNodes(BranchInfo branchInfo, int n, int n2) {
        branchInfo.loadChildren();
        if (n2 == -1) {
            assert (n == 0) : "Non-zero index with 'remove all' count";
            n2 = branchInfo.children.getLength();
        }
        assert (n + n2 <= branchInfo.children.getLength()) : "Value too big";
        if (n2 > 0) {
            NodeInfo nodeInfo = (NodeInfo)branchInfo.children.get(n);
            NodeInfo nodeInfo2 = (NodeInfo)branchInfo.children.get(n + n2 - 1);
            int n3 = this.visibleNodes.indexOf((Object)nodeInfo);
            if (n3 >= 0) {
                int n4;
                assert (n4 > n3) : "Invalid visible node structure";
                int n5 = this.visibleNodes.getLength();
                int n6 = nodeInfo2.depth;
                for (n4 = this.visibleNodes.indexOf((Object)nodeInfo2) + 1; n4 < n5 && ((NodeInfo)this.visibleNodes.get((int)n4)).depth > n6; ++n4) {
                }
                this.visibleNodes.remove(n3, n4 - n3);
                this.invalidateComponent();
            }
        }
    }

    protected void repaintNode(NodeInfo nodeInfo) {
        Bounds bounds = this.getNodeBounds(nodeInfo);
        if (bounds != null) {
            this.repaintComponent(bounds);
        }
    }

    protected void clearHighlightedNode() {
        if (this.highlightedNode != null) {
            this.highlightedNode.setHighlighted(false);
            this.repaintNode(this.highlightedNode);
            this.highlightedNode = null;
        }
    }

    private void clearFields(final byte by) {
        this.accept(new NodeInfoVisitor(){

            @Override
            public void visit(NodeInfo nodeInfo) {
                nodeInfo.clearField(by);
            }
        });
    }

    public boolean mouseMove(Component component, int n, int n2) {
        boolean bl = super.mouseMove(component, n, n2);
        TreeView treeView = (TreeView)this.getComponent();
        if (this.showHighlight && treeView.getSelectMode() != TreeView.SelectMode.NONE) {
            NodeInfo nodeInfo = this.highlightedNode;
            this.highlightedNode = this.getNodeInfoAt(n2);
            if (this.highlightedNode != nodeInfo) {
                if (nodeInfo != null) {
                    nodeInfo.setHighlighted(false);
                    this.repaintNode(nodeInfo);
                }
                if (this.highlightedNode != null) {
                    this.highlightedNode.setHighlighted(true);
                    this.repaintNode(this.highlightedNode);
                }
            }
        }
        return bl;
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        this.clearHighlightedNode();
        this.editNode = null;
    }

    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseDown(component, button, n, n2);
        if (!bl) {
            TreeView treeView = (TreeView)this.getComponent();
            NodeInfo nodeInfo = this.getNodeInfoAt(n2);
            if (nodeInfo != null && !nodeInfo.isDisabled()) {
                int n3 = this.getNodeHeight();
                int n4 = (nodeInfo.depth - 1) * (this.indent + this.spacing);
                int n5 = n4 + (this.showBranchControls ? this.indent + this.spacing : 0);
                int n6 = n2 / (n3 + 1) * (n3 + 1);
                int n7 = CHECKBOX.getWidth();
                int n8 = CHECKBOX.getHeight();
                int n9 = Math.max(this.indent - n7, 0) / 2;
                int n10 = (n3 - n8) / 2;
                if (!treeView.getCheckmarksEnabled() || nodeInfo.isCheckmarkDisabled() || n < n5 + n9 || n >= n5 + n9 + n7 || n2 < n6 + n10 || n2 >= n6 + n10 + n8) {
                    Object object;
                    Sequence.Tree.Path path = nodeInfo.getPath();
                    if (this.showBranchControls && nodeInfo instanceof BranchInfo && n >= n4 && n < n4 + this.indent) {
                        object = (BranchInfo)nodeInfo;
                        treeView.setBranchExpanded(path, !((BranchInfo)object).isExpanded());
                        bl = true;
                    }
                    if (!bl) {
                        object = treeView.getSelectMode();
                        if (button == Mouse.Button.RIGHT) {
                            if (!treeView.isNodeSelected(path) && object != TreeView.SelectMode.NONE) {
                                treeView.setSelectedPath(path);
                            }
                        } else if (object == TreeView.SelectMode.SINGLE) {
                            if (nodeInfo.isSelected() && treeView.isFocused()) {
                                this.editNode = nodeInfo;
                            } else {
                                treeView.setSelectedPath(path);
                            }
                        } else if (object == TreeView.SelectMode.MULTI) {
                            Keyboard.Modifier modifier = Platform.getCommandModifier();
                            if (Keyboard.isPressed((Keyboard.Modifier)modifier)) {
                                if (nodeInfo.isSelected()) {
                                    treeView.removeSelectedPath(path);
                                } else {
                                    treeView.addSelectedPath(path);
                                }
                            } else {
                                treeView.setSelectedPath(path);
                            }
                        }
                    }
                }
            }
            treeView.requestFocus();
        }
        return bl;
    }

    public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
        boolean bl = super.mouseClick(component, button, n, n2, n3);
        if (!bl) {
            TreeView treeView = (TreeView)this.getComponent();
            NodeInfo nodeInfo = this.getNodeInfoAt(n2);
            if (nodeInfo != null && !nodeInfo.isDisabled()) {
                int n4 = this.getNodeHeight();
                int n5 = (nodeInfo.depth - 1) * (this.indent + this.spacing);
                int n6 = n5 + (this.showBranchControls ? this.indent + this.spacing : 0);
                int n7 = n2 / (n4 + 1) * (n4 + 1);
                int n8 = CHECKBOX.getWidth();
                int n9 = CHECKBOX.getHeight();
                int n10 = Math.max(this.indent - n8, 0) / 2;
                int n11 = (n4 - n9) / 2;
                if (treeView.getCheckmarksEnabled() && !nodeInfo.isCheckmarkDisabled() && n >= n6 + n10 && n < n6 + n10 + n8 && n2 >= n7 + n11 && n2 < n7 + n11 + n9) {
                    Sequence.Tree.Path path = nodeInfo.getPath();
                    treeView.setNodeChecked(path, !nodeInfo.isChecked());
                } else {
                    TreeView.NodeEditor nodeEditor;
                    if (this.editNode != null && n3 == 1 && (nodeEditor = treeView.getNodeEditor()) != null) {
                        nodeEditor.editNode(treeView, nodeInfo.getPath());
                    }
                    this.editNode = null;
                }
            }
        }
        return bl;
    }

    public boolean mouseWheel(Component component, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
        if (this.highlightedNode != null) {
            Bounds bounds = this.getNodeBounds(this.highlightedNode);
            this.highlightedNode.setHighlighted(false);
            this.highlightedNode = null;
            if (bounds != null) {
                this.repaintComponent(bounds.x, bounds.y, bounds.width, bounds.height, true);
            }
        }
        return super.mouseWheel(component, scrollType, n, n2, n3, n4);
    }

    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = false;
        TreeView treeView = (TreeView)this.getComponent();
        TreeView.SelectMode selectMode = treeView.getSelectMode();
        switch (n) {
            case 38: {
                int n2;
                NodeInfo nodeInfo;
                if (selectMode == TreeView.SelectMode.NONE) break;
                Sequence.Tree.Path path = treeView.getFirstSelectedPath();
                if (path != null) {
                    nodeInfo = this.getNodeInfoAt(path);
                    n2 = this.visibleNodes.indexOf((Object)nodeInfo);
                } else {
                    n2 = this.visibleNodes.getLength();
                }
                nodeInfo = null;
                do {
                    NodeInfo nodeInfo2 = nodeInfo = --n2 >= 0 ? (NodeInfo)this.visibleNodes.get(n2) : null;
                } while (nodeInfo != null && nodeInfo.isDisabled());
                if (nodeInfo == null) break;
                treeView.setSelectedPath(nodeInfo.getPath());
                treeView.scrollAreaToVisible(this.getNodeBounds(nodeInfo));
                bl = true;
                break;
            }
            case 40: {
                int n3;
                NodeInfo nodeInfo;
                if (selectMode == TreeView.SelectMode.NONE) break;
                Sequence.Tree.Path path = treeView.getLastSelectedPath();
                if (path != null) {
                    nodeInfo = this.getNodeInfoAt(path);
                    n3 = this.visibleNodes.indexOf((Object)nodeInfo);
                } else {
                    n3 = -1;
                }
                nodeInfo = null;
                int n4 = this.visibleNodes.getLength();
                do {
                    NodeInfo nodeInfo3 = nodeInfo = ++n3 <= n4 - 1 ? (NodeInfo)this.visibleNodes.get(n3) : null;
                } while (nodeInfo != null && nodeInfo.isDisabled());
                if (nodeInfo == null) break;
                treeView.setSelectedPath(nodeInfo.getPath());
                treeView.scrollAreaToVisible(this.getNodeBounds(nodeInfo));
                bl = true;
                break;
            }
            case 37: {
                BranchInfo branchInfo;
                Sequence sequence;
                if (!this.showBranchControls || (sequence = treeView.getSelectedPaths()) == null || sequence.getLength() <= 0) break;
                Sequence.Tree.Path path = (Sequence.Tree.Path)sequence.get(sequence.getLength() - 1);
                NodeInfo nodeInfo = this.getNodeInfoAt(path);
                if (nodeInfo instanceof BranchInfo && (branchInfo = (BranchInfo)nodeInfo).isExpanded()) {
                    treeView.collapseBranch(branchInfo.getPath());
                }
                bl = true;
                break;
            }
            case 39: {
                BranchInfo branchInfo;
                Sequence sequence;
                if (!this.showBranchControls || (sequence = treeView.getSelectedPaths()) == null || sequence.getLength() <= 0) break;
                Sequence.Tree.Path path = (Sequence.Tree.Path)sequence.get(sequence.getLength() - 1);
                NodeInfo nodeInfo = this.getNodeInfoAt(path);
                if (nodeInfo instanceof BranchInfo && !(branchInfo = (BranchInfo)nodeInfo).isExpanded()) {
                    treeView.expandBranch(branchInfo.getPath());
                }
                bl = true;
                break;
            }
            default: {
                bl = super.keyPressed(component, n, keyLocation);
            }
        }
        this.clearHighlightedNode();
        return bl;
    }

    public boolean keyReleased(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = false;
        TreeView treeView = (TreeView)this.getComponent();
        if (n == 32) {
            NodeInfo nodeInfo;
            Sequence.Tree.Path path;
            if (treeView.getCheckmarksEnabled() && treeView.getSelectMode() == TreeView.SelectMode.SINGLE && (path = treeView.getSelectedPath()) != null && !(nodeInfo = this.getNodeInfoAt(path)).isCheckmarkDisabled()) {
                treeView.setNodeChecked(path, !treeView.isNodeChecked(path));
            }
        } else {
            bl = super.keyReleased(component, n, keyLocation);
        }
        return bl;
    }

    public boolean isFocusable() {
        TreeView treeView = (TreeView)this.getComponent();
        return treeView.getSelectMode() != TreeView.SelectMode.NONE;
    }

    public boolean isOpaque() {
        return this.backgroundColor != null && this.backgroundColor.getTransparency() == 1;
    }

    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.repaintComponent();
    }

    public void focusedChanged(Component component, Component component2) {
        super.focusedChanged(component, component2);
        this.repaintComponent();
    }

    public Sequence.Tree.Path getNodeAt(int n) {
        Sequence.Tree.Path path = null;
        NodeInfo nodeInfo = this.getNodeInfoAt(n);
        if (nodeInfo != null) {
            path = nodeInfo.getPath();
        }
        return path;
    }

    public Bounds getNodeBounds(Sequence.Tree.Path path) {
        Bounds bounds = null;
        NodeInfo nodeInfo = this.getNodeInfoAt(path);
        if (nodeInfo != null) {
            bounds = this.getNodeBounds(nodeInfo);
        }
        return bounds;
    }

    public int getNodeIndent(int n) {
        TreeView treeView = (TreeView)this.getComponent();
        int n2 = (n - 1) * (this.indent + this.spacing);
        if (this.showBranchControls) {
            n2 += this.indent + this.spacing;
        }
        if (treeView.getCheckmarksEnabled()) {
            n2 += Math.max(CHECKBOX.getWidth(), this.indent) + this.spacing;
        }
        return n2;
    }

    public int getRowIndex(Sequence.Tree.Path path) {
        int n = -1;
        NodeInfo nodeInfo = this.getNodeInfoAt(path);
        if (nodeInfo != null) {
            n = this.visibleNodes.indexOf((Object)nodeInfo);
        }
        return n;
    }

    public void treeDataChanged(TreeView treeView, List<?> list) {
        List list2 = treeView.getTreeData();
        this.visibleNodes.clear();
        if (list2 == null) {
            this.rootBranchInfo = null;
        } else {
            this.rootBranchInfo = new BranchInfo(treeView, null, list2);
            this.addVisibleNodes(this.rootBranchInfo);
        }
        this.invalidateComponent();
    }

    public void nodeRendererChanged(TreeView treeView, TreeView.NodeRenderer nodeRenderer) {
        this.invalidateComponent();
    }

    public void nodeEditorChanged(TreeView treeView, TreeView.NodeEditor nodeEditor) {
    }

    public void selectModeChanged(TreeView treeView, TreeView.SelectMode selectMode) {
        this.clearFields((byte)2);
        this.repaintComponent();
    }

    public void checkmarksEnabledChanged(TreeView treeView) {
        this.clearFields((byte)48);
        this.invalidateComponent();
    }

    public void showMixedCheckmarkStateChanged(TreeView treeView) {
        if (treeView.getCheckmarksEnabled()) {
            ArrayList arrayList = new ArrayList();
            arrayList.add((Object)this.rootBranchInfo);
            while (arrayList.getLength() > 0) {
                NodeInfo nodeInfo = (NodeInfo)arrayList.get(0);
                arrayList.remove(0, 1);
                if (!(nodeInfo instanceof BranchInfo)) continue;
                BranchInfo branchInfo = (BranchInfo)nodeInfo;
                Sequence.Tree.Path path = branchInfo.getPath();
                branchInfo.setCheckState(treeView.getNodeCheckState(path));
                if (branchInfo.children == null) continue;
                int n = branchInfo.children.getLength();
                for (int i = 0; i < n; ++i) {
                    arrayList.insert(branchInfo.children.get(i), i);
                }
            }
            this.repaintComponent();
        }
    }

    public void disabledNodeFilterChanged(TreeView treeView, Filter<?> filter) {
        final Filter filter2 = treeView.getDisabledNodeFilter();
        this.accept(new NodeInfoVisitor(){

            @Override
            public void visit(NodeInfo nodeInfo) {
                if (nodeInfo != TerraTreeViewSkin.this.rootBranchInfo) {
                    nodeInfo.setDisabled(filter2 != null && filter2.include(nodeInfo.data));
                }
            }
        });
        this.repaintComponent();
    }

    public void disabledCheckmarkFilterChanged(TreeView treeView, Filter<?> filter) {
        final Filter filter2 = treeView.getDisabledCheckmarkFilter();
        this.accept(new NodeInfoVisitor(){

            @Override
            public void visit(NodeInfo nodeInfo) {
                if (nodeInfo != TerraTreeViewSkin.this.rootBranchInfo) {
                    nodeInfo.setCheckmarkDisabled(filter2 != null && filter2.include(nodeInfo.data));
                }
            }
        });
        this.repaintComponent();
    }

    public void branchExpanded(TreeView treeView, Sequence.Tree.Path path) {
        BranchInfo branchInfo = (BranchInfo)this.getNodeInfoAt(path);
        branchInfo.setExpanded(true);
        this.addVisibleNodes(branchInfo);
        this.repaintNode(branchInfo);
    }

    public void branchCollapsed(TreeView treeView, Sequence.Tree.Path path) {
        BranchInfo branchInfo = (BranchInfo)this.getNodeInfoAt(path);
        branchInfo.setExpanded(false);
        this.removeVisibleNodes(branchInfo, 0, -1);
        this.repaintNode(branchInfo);
    }

    public void nodeInserted(TreeView treeView, Sequence.Tree.Path path, int n) {
        BranchInfo branchInfo = (BranchInfo)this.getNodeInfoAt(path);
        List list = (List)branchInfo.data;
        if (branchInfo.children != null) {
            NodeInfo nodeInfo = NodeInfo.newInstance(treeView, branchInfo, list.get(n));
            branchInfo.children.insert((Object)nodeInfo, n);
        }
        this.addVisibleNode(branchInfo, n);
    }

    public void nodesRemoved(TreeView treeView, Sequence.Tree.Path path, int n, int n2) {
        BranchInfo branchInfo = (BranchInfo)this.getNodeInfoAt(path);
        this.removeVisibleNodes(branchInfo, n, n2);
        if (branchInfo.children != null) {
            branchInfo.children.remove(n, n2);
        }
    }

    public void nodeUpdated(TreeView treeView, Sequence.Tree.Path path, int n) {
        BranchInfo branchInfo = (BranchInfo)this.getNodeInfoAt(path);
        List list = (List)branchInfo.data;
        branchInfo.loadChildren();
        NodeInfo nodeInfo = (NodeInfo)branchInfo.children.get(n);
        Object object = nodeInfo.data;
        Object object2 = list.get(n);
        if (object != object2) {
            this.removeVisibleNodes(branchInfo, n, 1);
            nodeInfo = NodeInfo.newInstance(treeView, branchInfo, object2);
            branchInfo.children.update(n, (Object)nodeInfo);
            this.addVisibleNode(branchInfo, n);
        } else {
            Filter filter = treeView.getDisabledNodeFilter();
            nodeInfo.setDisabled(filter != null && filter.include(object2));
            if (this.visibleNodes.indexOf((Object)nodeInfo) >= 0) {
                this.invalidateComponent();
            }
        }
    }

    public void nodesCleared(TreeView treeView, Sequence.Tree.Path path) {
        BranchInfo branchInfo = (BranchInfo)this.getNodeInfoAt(path);
        this.removeVisibleNodes(branchInfo, 0, -1);
        if (branchInfo.children != null) {
            branchInfo.children.clear();
        }
    }

    public void nodesSorted(TreeView treeView, Sequence.Tree.Path path) {
        BranchInfo branchInfo = (BranchInfo)this.getNodeInfoAt(path);
        this.removeVisibleNodes(branchInfo, 0, -1);
        branchInfo.children = null;
        branchInfo.loadChildren();
        this.addVisibleNodes(branchInfo);
    }

    public void nodeCheckStateChanged(TreeView treeView, Sequence.Tree.Path path, TreeView.NodeCheckState nodeCheckState) {
        NodeInfo nodeInfo = this.getNodeInfoAt(path);
        nodeInfo.setCheckState(treeView.getNodeCheckState(path));
        this.repaintNode(nodeInfo);
    }

    public void selectedPathAdded(TreeView treeView, Sequence.Tree.Path path) {
        NodeInfo nodeInfo = this.getNodeInfoAt(path);
        nodeInfo.setSelected(true);
        this.repaintNode(nodeInfo);
    }

    public void selectedPathRemoved(TreeView treeView, Sequence.Tree.Path path) {
        NodeInfo nodeInfo = this.getNodeInfoAt(path);
        nodeInfo.setSelected(false);
        this.repaintNode(nodeInfo);
    }

    public void selectedPathsChanged(TreeView treeView, Sequence<Sequence.Tree.Path> sequence) {
        int n = sequence.getLength();
        for (int i = 0; i < n; ++i) {
            NodeInfo nodeInfo = this.getNodeInfoAt((Sequence.Tree.Path)sequence.get(i));
            nodeInfo.setSelected(false);
            this.repaintNode(nodeInfo);
        }
        Sequence sequence2 = treeView.getSelectedPaths();
        int n2 = sequence2.getLength();
        for (n = 0; n < n2; ++n) {
            NodeInfo nodeInfo = this.getNodeInfoAt((Sequence.Tree.Path)sequence2.get(n));
            nodeInfo.setSelected(true);
            this.repaintNode(nodeInfo);
        }
    }

    static {
        CHECKBOX.setSize(CHECKBOX.getPreferredSize());
        CHECKBOX.setTriState(true);
    }

    protected static final class BranchInfo
    extends NodeInfo {
        private List<NodeInfo> children = null;
        public static final byte EXPANDED_MASK = 64;

        private BranchInfo(TreeView treeView, BranchInfo branchInfo, List<Object> list) {
            super(treeView, branchInfo, list);
        }

        public void loadChildren() {
            if (this.children == null) {
                List list = (List)this.data;
                int n = list.getLength();
                this.children = new ArrayList(n);
                for (int i = 0; i < n; ++i) {
                    Object object = list.get(i);
                    NodeInfo nodeInfo = NodeInfo.newInstance(this.treeView, this, object);
                    this.children.add((Object)nodeInfo);
                }
            }
        }

        public boolean isExpanded() {
            return (this.fields & 0x40) != 0;
        }

        public void setExpanded(boolean bl) {
            this.fields = bl ? (byte)(this.fields | 0x40) : (byte)(this.fields & 0xFFFFFFBF);
        }
    }

    protected static class NodeInfo {
        final TreeView treeView;
        final BranchInfo parent;
        final Object data;
        final int depth;
        byte fields = 0;
        public static final byte HIGHLIGHTED_MASK = 1;
        public static final byte SELECTED_MASK = 2;
        public static final byte DISABLED_MASK = 4;
        public static final byte CHECKMARK_DISABLED_MASK = 8;
        public static final byte CHECK_STATE_CHECKED_MASK = 16;
        public static final byte CHECK_STATE_MIXED_MASK = 32;
        public static final byte CHECK_STATE_MASK = 48;

        private NodeInfo(TreeView treeView, BranchInfo branchInfo, Object object) {
            Filter filter;
            this.treeView = treeView;
            this.parent = branchInfo;
            this.data = object;
            this.depth = branchInfo == null ? 0 : branchInfo.depth + 1;
            Filter filter2 = treeView.getDisabledNodeFilter();
            if (filter2 != null) {
                this.setDisabled(filter2.include(object));
            }
            if ((filter = treeView.getDisabledCheckmarkFilter()) != null) {
                this.setCheckmarkDisabled(filter.include(object));
            }
        }

        private static NodeInfo newInstance(TreeView treeView, BranchInfo branchInfo, Object object) {
            NodeInfo nodeInfo = null;
            nodeInfo = object instanceof List ? new BranchInfo(treeView, branchInfo, (List)object) : new NodeInfo(treeView, branchInfo, object);
            return nodeInfo;
        }

        public Sequence.Tree.Path getPath() {
            Sequence.Tree.Path path = Sequence.Tree.Path.forDepth((int)this.depth);
            NodeInfo nodeInfo = this;
            while (nodeInfo.parent != null) {
                List list = (List)nodeInfo.parent.data;
                int n = list.indexOf(nodeInfo.data);
                path.insert(Integer.valueOf(n), 0);
                nodeInfo = nodeInfo.parent;
            }
            return path;
        }

        public boolean isHighlighted() {
            return (this.fields & 1) != 0;
        }

        public void setHighlighted(boolean bl) {
            this.fields = bl ? (byte)(this.fields | 1) : (byte)(this.fields & 0xFFFFFFFE);
        }

        public boolean isSelected() {
            return (this.fields & 2) != 0;
        }

        public void setSelected(boolean bl) {
            this.fields = bl ? (byte)(this.fields | 2) : (byte)(this.fields & 0xFFFFFFFD);
        }

        public boolean isDisabled() {
            return (this.fields & 4) != 0;
        }

        public void setDisabled(boolean bl) {
            this.fields = bl ? (byte)(this.fields | 4) : (byte)(this.fields & 0xFFFFFFFB);
        }

        public boolean isCheckmarkDisabled() {
            return (this.fields & 8) != 0;
        }

        public void setCheckmarkDisabled(boolean bl) {
            this.fields = bl ? (byte)(this.fields | 8) : (byte)(this.fields & 0xFFFFFFF7);
        }

        public TreeView.NodeCheckState getCheckState() {
            TreeView.NodeCheckState nodeCheckState;
            switch (this.fields & 0x30) {
                case 16: {
                    nodeCheckState = TreeView.NodeCheckState.CHECKED;
                    break;
                }
                case 32: {
                    nodeCheckState = TreeView.NodeCheckState.MIXED;
                    break;
                }
                default: {
                    nodeCheckState = TreeView.NodeCheckState.UNCHECKED;
                }
            }
            return nodeCheckState;
        }

        public boolean isChecked() {
            return (this.fields & 0x10) != 0;
        }

        public void setCheckState(TreeView.NodeCheckState nodeCheckState) {
            this.fields = (byte)(this.fields & 0xFFFFFFCF);
            switch (nodeCheckState) {
                case CHECKED: {
                    this.fields = (byte)(this.fields | 0x10);
                    break;
                }
                case MIXED: {
                    this.fields = (byte)(this.fields | 0x20);
                }
            }
        }

        public void clearField(byte by) {
            this.fields = (byte)(this.fields & ~by);
        }
    }

    protected final class VisibleNodeIterator
    implements Iterator<NodeInfo> {
        private int index;
        private int end;
        private Sequence.Tree.Path path = null;
        private NodeInfo previous = null;

        public VisibleNodeIterator() {
            this(0, terraTreeViewSkin.visibleNodes.getLength() - 1);
        }

        public VisibleNodeIterator(int n, int n2) {
            if (n < 0 || n2 >= TerraTreeViewSkin.this.visibleNodes.getLength()) {
                throw new IndexOutOfBoundsException();
            }
            this.index = n;
            this.end = n2;
        }

        @Override
        public boolean hasNext() {
            return this.index <= this.end;
        }

        @Override
        public NodeInfo next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            NodeInfo nodeInfo = (NodeInfo)TerraTreeViewSkin.this.visibleNodes.get(this.index++);
            if (this.path == null) {
                this.path = nodeInfo.getPath();
            } else if (nodeInfo.parent == this.previous) {
                this.path.add(Integer.valueOf(0));
            } else {
                int n = this.path.getLength();
                while (nodeInfo.parent != this.previous.parent) {
                    this.path.remove(--n, 1);
                    this.previous = this.previous.parent;
                }
                int n2 = this.path.get(n - 1);
                this.path.update(n - 1, Integer.valueOf(n2 + 1));
            }
            this.previous = nodeInfo;
            return nodeInfo;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public int getRowIndex() {
            return this.path == null ? -1 : this.index - 1;
        }

        public Sequence.Tree.Path getPath() {
            return this.path;
        }
    }

    protected static interface NodeInfoVisitor {
        public void visit(NodeInfo var1);
    }
}

