/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.net.URL;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.ThreadUtilities;
import org.apache.pivot.util.Vote;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.wtk.AccordionAttributeListener;
import org.apache.pivot.wtk.AccordionListener;
import org.apache.pivot.wtk.AccordionSelectionListener;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.media.Image;

public class Accordion
extends Container {
    private int selectedIndex = -1;
    private ArrayList<Component> panels = new ArrayList();
    private PanelSequence panelSequence = new PanelSequence();
    private AccordionListenerList accordionListeners = new AccordionListenerList();
    private AccordionSelectionListenerList accordionSelectionListeners = new AccordionSelectionListenerList();
    private AccordionAttributeListenerList accordionAttributeListeners = new AccordionAttributeListenerList();

    public Accordion() {
        this.installThemeSkin(Accordion.class);
    }

    public PanelSequence getPanels() {
        return this.panelSequence;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int n) {
        if (n < -1 || n > this.panels.getLength() - 1) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.selectedIndex;
        if (n2 != n) {
            Vote vote = this.accordionSelectionListeners.previewSelectedIndexChange(this, n);
            if (vote == Vote.APPROVE) {
                this.selectedIndex = n;
                this.accordionSelectionListeners.selectedIndexChanged(this, n2);
            } else {
                this.accordionSelectionListeners.selectedIndexChangeVetoed(this, vote);
            }
        }
    }

    public Component getSelectedPanel() {
        return this.selectedIndex == -1 ? null : (Component)this.panels.get(this.selectedIndex);
    }

    @Override
    public Sequence<Component> remove(int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            Component component = this.get(i);
            if (this.panels.indexOf((Object)component) < 0) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(n, n2);
    }

    public ListenerList<AccordionListener> getAccordionListeners() {
        return this.accordionListeners;
    }

    public ListenerList<AccordionSelectionListener> getAccordionSelectionListeners() {
        return this.accordionSelectionListeners;
    }

    public ListenerList<AccordionAttributeListener> getAccordionAttributeListeners() {
        return this.accordionAttributeListeners;
    }

    public static String getLabel(Component component) {
        Attributes attributes = (Attributes)component.getAttributes();
        return attributes == null ? null : attributes.label;
    }

    public static void setLabel(Component component, String string) {
        Attributes attributes = (Attributes)component.getAttributes();
        if (attributes == null) {
            throw new IllegalStateException();
        }
        String string2 = attributes.label;
        if (string2 != string) {
            attributes.label = string;
            Accordion accordion = (Accordion)component.getParent();
            if (accordion != null) {
                accordion.accordionAttributeListeners.labelChanged(accordion, component, string2);
            }
        }
    }

    public static Image getIcon(Component component) {
        Attributes attributes = (Attributes)component.getAttributes();
        return attributes == null ? null : attributes.icon;
    }

    public static void setIcon(Component component, Image image) {
        Attributes attributes = (Attributes)component.getAttributes();
        if (attributes == null) {
            throw new IllegalStateException();
        }
        Image image2 = attributes.icon;
        if (image2 != image) {
            attributes.icon = image;
            Accordion accordion = (Accordion)component.getParent();
            if (accordion != null) {
                accordion.accordionAttributeListeners.iconChanged(accordion, component, image2);
            }
        }
    }

    public static final void setIcon(Component component, URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("icon is null.");
        }
        Image image = (Image)ApplicationContext.getResourceCache().get(uRL);
        if (image == null) {
            try {
                image = Image.load(uRL);
            }
            catch (TaskExecutionException taskExecutionException) {
                throw new IllegalArgumentException(taskExecutionException);
            }
            ApplicationContext.getResourceCache().put(uRL, (Object)image);
        }
        Accordion.setIcon(component, image);
    }

    public static final void setIcon(Component component, String string) {
        if (string == null) {
            throw new IllegalArgumentException("icon is null.");
        }
        ClassLoader classLoader = ThreadUtilities.getClassLoader();
        Accordion.setIcon(component, classLoader.getResource(string));
    }

    private static class AccordionAttributeListenerList
    extends ListenerList<AccordionAttributeListener>
    implements AccordionAttributeListener {
        private AccordionAttributeListenerList() {
        }

        @Override
        public void labelChanged(Accordion accordion, Component component, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                AccordionAttributeListener accordionAttributeListener = (AccordionAttributeListener)iterator.next();
                accordionAttributeListener.labelChanged(accordion, component, string);
            }
        }

        @Override
        public void iconChanged(Accordion accordion, Component component, Image image) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                AccordionAttributeListener accordionAttributeListener = (AccordionAttributeListener)iterator.next();
                accordionAttributeListener.iconChanged(accordion, component, image);
            }
        }
    }

    private static class AccordionSelectionListenerList
    extends ListenerList<AccordionSelectionListener>
    implements AccordionSelectionListener {
        private AccordionSelectionListenerList() {
        }

        @Override
        public Vote previewSelectedIndexChange(Accordion accordion, int n) {
            Vote vote = Vote.APPROVE;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                AccordionSelectionListener accordionSelectionListener = (AccordionSelectionListener)iterator.next();
                vote = vote.tally(accordionSelectionListener.previewSelectedIndexChange(accordion, n));
            }
            return vote;
        }

        @Override
        public void selectedIndexChangeVetoed(Accordion accordion, Vote vote) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                AccordionSelectionListener accordionSelectionListener = (AccordionSelectionListener)iterator.next();
                accordionSelectionListener.selectedIndexChangeVetoed(accordion, vote);
            }
        }

        @Override
        public void selectedIndexChanged(Accordion accordion, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                AccordionSelectionListener accordionSelectionListener = (AccordionSelectionListener)iterator.next();
                accordionSelectionListener.selectedIndexChanged(accordion, n);
            }
        }
    }

    private static class AccordionListenerList
    extends ListenerList<AccordionListener>
    implements AccordionListener {
        private AccordionListenerList() {
        }

        @Override
        public void panelInserted(Accordion accordion, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                AccordionListener accordionListener = (AccordionListener)iterator.next();
                accordionListener.panelInserted(accordion, n);
            }
        }

        @Override
        public void panelsRemoved(Accordion accordion, int n, Sequence<Component> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                AccordionListener accordionListener = (AccordionListener)iterator.next();
                accordionListener.panelsRemoved(accordion, n, sequence);
            }
        }
    }

    private static class Attributes {
        public String label = null;
        public Image icon = null;

        private Attributes() {
        }
    }

    public final class PanelSequence
    implements Sequence<Component>,
    Iterable<Component> {
        private PanelSequence() {
        }

        public int add(Component component) {
            int n = this.getLength();
            this.insert(component, n);
            return n;
        }

        public void insert(Component component, int n) {
            if (component == null) {
                throw new IllegalArgumentException("panel is null.");
            }
            Accordion.this.add(component);
            Accordion.this.panels.insert((Object)component, n);
            component.setAttributes(new Attributes());
            if (Accordion.this.selectedIndex >= n) {
                Accordion.this.selectedIndex++;
            }
            Accordion.this.accordionListeners.panelInserted(Accordion.this, n);
        }

        public Component update(int n, Component component) {
            throw new UnsupportedOperationException();
        }

        public int remove(Component component) {
            int n = this.indexOf(component);
            if (n != -1) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<Component> remove(int n, int n2) {
            int n3;
            Sequence sequence = Accordion.this.panels.remove(n, n2);
            int n4 = sequence.getLength();
            for (n3 = 0; n3 < n4; ++n3) {
                ((Component)sequence.get(n3)).setAttributes(null);
            }
            if (Accordion.this.selectedIndex >= n) {
                if (Accordion.this.selectedIndex < n + n2) {
                    Accordion.this.selectedIndex = -1;
                } else {
                    Accordion.this.selectedIndex -= n2;
                }
            }
            Accordion.this.accordionListeners.panelsRemoved(Accordion.this, n, (Sequence<Component>)sequence);
            n4 = sequence.getLength();
            for (n3 = 0; n3 < n4; ++n3) {
                Component component = (Component)sequence.get(n3);
                Accordion.this.remove(component);
            }
            return sequence;
        }

        public Component get(int n) {
            return (Component)Accordion.this.panels.get(n);
        }

        public int indexOf(Component component) {
            return Accordion.this.panels.indexOf((Object)component);
        }

        public int getLength() {
            return Accordion.this.panels.getLength();
        }

        @Override
        public Iterator<Component> iterator() {
            return new ImmutableIterator((Iterator)Accordion.this.panels.iterator());
        }
    }
}

