/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.util.Version;
import org.apache.pivot.wtk.Application;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.DragSource;
import org.apache.pivot.wtk.DropAction;
import org.apache.pivot.wtk.DropTarget;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.LocalManifest;
import org.apache.pivot.wtk.LocalManifestAdapter;
import org.apache.pivot.wtk.Manifest;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuPopup;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.RemoteManifest;
import org.apache.pivot.wtk.Visual;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;

public abstract class ApplicationContext {
    private DisplayHost displayHost = new DisplayHost();
    private Display display = new Display(this.displayHost);
    private Application application = null;
    protected static URL origin = null;
    private static HashMap<URI, Object> resourceCache = new HashMap();
    private static ResourceCacheDictionary resourceCacheDictionary = new ResourceCacheDictionary();
    private static Timer timer = null;
    private static ArrayList<Display> displays = new ArrayList();
    private static ArrayList<Application> applications = new ArrayList();
    private static Version jvmVersion = null;

    protected ApplicationContext() {
    }

    protected Application getApplication() {
        return this.application;
    }

    protected void setApplication(Application application) {
        this.application = application;
    }

    protected DisplayHost getDisplayHost() {
        return this.displayHost;
    }

    protected Display getDisplay() {
        return this.display;
    }

    public static URL getOrigin() {
        return origin;
    }

    public static ResourceCacheDictionary getResourceCache() {
        return resourceCacheDictionary;
    }

    public static Version getJVMVersion() {
        return jvmVersion;
    }

    public static ScheduledCallback scheduleCallback(Runnable runnable, long l) {
        ScheduledCallback scheduledCallback = new ScheduledCallback(runnable);
        try {
            try {
                timer.schedule((TimerTask)scheduledCallback, l);
            }
            catch (IllegalStateException illegalStateException) {
                ApplicationContext.createTimer();
                timer.schedule((TimerTask)scheduledCallback, l);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Unable to schedule callback: " + throwable);
        }
        return scheduledCallback;
    }

    public static ScheduledCallback scheduleRecurringCallback(Runnable runnable, long l) {
        return ApplicationContext.scheduleRecurringCallback(runnable, 0L, l);
    }

    public static ScheduledCallback scheduleRecurringCallback(Runnable runnable, long l, long l2) {
        ScheduledCallback scheduledCallback = new ScheduledCallback(runnable);
        try {
            try {
                timer.schedule((TimerTask)scheduledCallback, l, l2);
            }
            catch (IllegalStateException illegalStateException) {
                ApplicationContext.createTimer();
                timer.schedule((TimerTask)scheduledCallback, l, l2);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Unable to schedule callback: " + throwable);
        }
        return scheduledCallback;
    }

    public static QueuedCallback queueCallback(Runnable runnable) {
        return ApplicationContext.queueCallback(runnable, false);
    }

    public static QueuedCallback queueCallback(Runnable runnable, boolean bl) {
        QueuedCallback queuedCallback;
        block6: {
            queuedCallback = new QueuedCallback(runnable);
            try {
                if (bl) {
                    try {
                        EventQueue.invokeAndWait(queuedCallback);
                        break block6;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new RuntimeException(invocationTargetException.getCause());
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException(interruptedException);
                    }
                }
                EventQueue.invokeLater(queuedCallback);
            }
            catch (Throwable throwable) {
                System.err.println("Unable to queue callback: " + throwable);
            }
        }
        return queuedCallback;
    }

    protected static void createTimer() {
        timer = new Timer();
    }

    protected static void destroyTimer() {
        timer.cancel();
        timer = null;
    }

    protected static void addDisplay(Display display) {
        displays.add((Object)display);
    }

    protected static void removeDisplay(Display display) {
        displays.remove((Object)display);
    }

    protected static void addApplication(Application application) {
        applications.add((Object)application);
    }

    protected static void removeApplication(Application application) {
        applications.remove((Object)application);
    }

    private static DropAction getUserDropAction(InputEvent inputEvent) {
        DropAction dropAction = inputEvent.isControlDown() && inputEvent.isShiftDown() || inputEvent.isAltDown() && inputEvent.isMetaDown() ? DropAction.LINK : (inputEvent.isControlDown() || inputEvent.isAltDown() ? DropAction.COPY : (inputEvent.isShiftDown() ? DropAction.MOVE : null));
        return dropAction;
    }

    private static DropAction getDropAction(int n) {
        DropAction dropAction = null;
        switch (n) {
            case 1: {
                dropAction = DropAction.COPY;
                break;
            }
            case 2: {
                dropAction = DropAction.MOVE;
                break;
            }
            case 0x40000000: {
                dropAction = DropAction.LINK;
            }
        }
        return dropAction;
    }

    private static int getSupportedDropActions(int n) {
        int n2 = 0;
        if ((n & 1) > 0) {
            n2 |= DropAction.COPY.getMask();
        }
        if ((n & 2) > 0) {
            n2 |= DropAction.MOVE.getMask();
        }
        if ((n & 0x40000000) > 0) {
            n2 |= DropAction.LINK.getMask();
        }
        return n2;
    }

    private static int getNativeDropAction(DropAction dropAction) {
        int n = 0;
        if (dropAction != null) {
            switch (dropAction) {
                case COPY: {
                    n = 1;
                    break;
                }
                case MOVE: {
                    n = 2;
                    break;
                }
                case LINK: {
                    n = 0x40000000;
                }
            }
        }
        return n;
    }

    private static Cursor getDropCursor(DropAction dropAction) {
        Cursor cursor = Cursor.getDefaultCursor();
        if (dropAction != null) {
            switch (dropAction) {
                case COPY: {
                    cursor = java.awt.dnd.DragSource.DefaultCopyDrop;
                    break;
                }
                case MOVE: {
                    cursor = java.awt.dnd.DragSource.DefaultMoveDrop;
                    break;
                }
                case LINK: {
                    cursor = java.awt.dnd.DragSource.DefaultLinkDrop;
                }
            }
        }
        return cursor;
    }

    static {
        jvmVersion = Version.decode((String)System.getProperty("java.vm.version"));
    }

    public static class QueuedCallback
    implements Runnable {
        private Runnable callback;
        private volatile boolean executed = false;
        private volatile boolean canceled = false;

        private QueuedCallback(Runnable runnable) {
            this.callback = runnable;
        }

        @Override
        public void run() {
            if (!this.canceled) {
                try {
                    this.callback.run();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    for (Application application : applications) {
                        if (!(application instanceof Application.UncaughtExceptionHandler)) continue;
                        Application.UncaughtExceptionHandler uncaughtExceptionHandler = (Application.UncaughtExceptionHandler)((Object)application);
                        uncaughtExceptionHandler.uncaughtExceptionThrown(exception);
                    }
                }
                for (Object object : displays) {
                    ((Component)object).validate();
                }
                this.executed = true;
            }
        }

        public boolean cancel() {
            this.canceled = true;
            return !this.executed;
        }
    }

    public static final class ScheduledCallback
    extends TimerTask {
        private Runnable callback;
        private QueuedCallback queuedCallback = null;

        private ScheduledCallback(Runnable runnable) {
            this.callback = runnable;
        }

        @Override
        public void run() {
            if (this.queuedCallback != null) {
                this.queuedCallback.cancel();
            }
            this.queuedCallback = ApplicationContext.queueCallback(this.callback);
        }

        @Override
        public boolean cancel() {
            if (this.queuedCallback != null) {
                this.queuedCallback.cancel();
            }
            return super.cancel();
        }
    }

    public static final class ResourceCacheDictionary
    implements Dictionary<URL, Object>,
    Iterable<URL> {
        public Object get(URL uRL) {
            try {
                return resourceCache.get((Object)uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        }

        public Object put(URL uRL, Object object) {
            try {
                return resourceCache.put((Object)uRL.toURI(), object);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        }

        public Object remove(URL uRL) {
            try {
                return resourceCache.remove((Object)uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        }

        public boolean containsKey(URL uRL) {
            try {
                return resourceCache.containsKey((Object)uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        }

        @Override
        public Iterator<URL> iterator() {
            return new Iterator<URL>(){
                private Iterator<URI> iterator = ApplicationContext.access$1500().iterator();

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public URL next() {
                    try {
                        return this.iterator.next().toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new RuntimeException(malformedURLException);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public final class DisplayHost
    extends Canvas {
        private static final long serialVersionUID = -815713849595314026L;
        private Component focusedComponent = null;
        private Point dragLocation = null;
        private Component dragDescendant = null;
        private transient Manifest dragManifest = null;
        private DropAction userDropAction = null;
        private Component dropDescendant = null;
        private MenuPopup menuPopup = null;
        private double scale = 1.0;
        private boolean paintPending = false;
        private boolean debugPaint = false;
        private Random random = null;
        private transient DropTargetListener dropTargetListener = new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                if (DisplayHost.this.dragDescendant != null) {
                    throw new IllegalStateException("Local drag already in progress.");
                }
                java.awt.Point point = dropTargetDragEvent.getLocation();
                DisplayHost.this.dragLocation = new Point(point.x, point.y);
                DisplayHost.this.dragManifest = new RemoteManifest(dropTargetDragEvent.getTransferable());
                DisplayHost.this.userDropAction = ApplicationContext.getDropAction(dropTargetDragEvent.getDropAction());
                DisplayHost.this.dropDescendant = DisplayHost.this.getDropDescendant(point.x, point.y);
                DropAction dropAction = null;
                if (DisplayHost.this.dropDescendant != null) {
                    DropTarget dropTarget = DisplayHost.this.dropDescendant.getDropTarget();
                    dropAction = dropTarget.dragEnter(DisplayHost.this.dropDescendant, DisplayHost.this.dragManifest, ApplicationContext.getSupportedDropActions(dropTargetDragEvent.getSourceActions()), DisplayHost.this.userDropAction);
                }
                if (dropAction == null) {
                    dropTargetDragEvent.rejectDrag();
                } else {
                    dropTargetDragEvent.acceptDrag(ApplicationContext.getNativeDropAction(dropAction));
                }
                ApplicationContext.this.display.validate();
            }

            @Override
            public void dragExit(DropTargetEvent dropTargetEvent) {
                DisplayHost.this.dragLocation = null;
                DisplayHost.this.dragManifest = null;
                DisplayHost.this.userDropAction = null;
                if (DisplayHost.this.dropDescendant != null) {
                    DropTarget dropTarget = DisplayHost.this.dropDescendant.getDropTarget();
                    dropTarget.dragExit(DisplayHost.this.dropDescendant);
                }
                DisplayHost.this.dropDescendant = null;
                ApplicationContext.this.display.validate();
            }

            @Override
            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                java.awt.Point point = dropTargetDragEvent.getLocation();
                Component component = DisplayHost.this.dropDescendant;
                DisplayHost.this.dropDescendant = DisplayHost.this.getDropDescendant(point.x, point.y);
                DropAction dropAction = null;
                if (component == DisplayHost.this.dropDescendant) {
                    if (DisplayHost.this.dropDescendant != null) {
                        DropTarget dropTarget = DisplayHost.this.dropDescendant.getDropTarget();
                        Point point2 = DisplayHost.this.dropDescendant.mapPointFromAncestor(ApplicationContext.this.display, point.x, point.y);
                        dropAction = dropTarget.dragMove(DisplayHost.this.dropDescendant, DisplayHost.this.dragManifest, ApplicationContext.getSupportedDropActions(dropTargetDragEvent.getSourceActions()), point2.x, point2.y, DisplayHost.this.userDropAction);
                    }
                } else {
                    DropTarget dropTarget;
                    if (component != null) {
                        dropTarget = component.getDropTarget();
                        dropTarget.dragExit(component);
                    }
                    if (DisplayHost.this.dropDescendant != null) {
                        dropTarget = DisplayHost.this.dropDescendant.getDropTarget();
                        dropAction = dropTarget.dragEnter(DisplayHost.this.dropDescendant, DisplayHost.this.dragManifest, ApplicationContext.getSupportedDropActions(dropTargetDragEvent.getSourceActions()), DisplayHost.this.userDropAction);
                    }
                }
                DisplayHost.this.setCursor(ApplicationContext.getDropCursor(dropAction));
                if (dropAction == null) {
                    dropTargetDragEvent.rejectDrag();
                } else {
                    dropTargetDragEvent.acceptDrag(ApplicationContext.getNativeDropAction(dropAction));
                }
                ApplicationContext.this.display.validate();
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
                DisplayHost.this.userDropAction = ApplicationContext.getDropAction(dropTargetDragEvent.getDropAction());
                DropAction dropAction = null;
                if (DisplayHost.this.dropDescendant != null) {
                    java.awt.Point point = dropTargetDragEvent.getLocation();
                    Point point2 = DisplayHost.this.dropDescendant.mapPointFromAncestor(ApplicationContext.this.display, point.x, point.y);
                    DropTarget dropTarget = DisplayHost.this.dropDescendant.getDropTarget();
                    dropAction = dropTarget.userDropActionChange(DisplayHost.this.dropDescendant, DisplayHost.this.dragManifest, ApplicationContext.getSupportedDropActions(dropTargetDragEvent.getSourceActions()), point2.x, point2.y, DisplayHost.this.userDropAction);
                }
                if (dropAction == null) {
                    dropTargetDragEvent.rejectDrag();
                } else {
                    dropTargetDragEvent.acceptDrag(ApplicationContext.getNativeDropAction(dropAction));
                }
                ApplicationContext.this.display.validate();
            }

            @Override
            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                java.awt.Point point = dropTargetDropEvent.getLocation();
                DisplayHost.this.dropDescendant = DisplayHost.this.getDropDescendant(point.x, point.y);
                DropAction dropAction = null;
                if (DisplayHost.this.dropDescendant != null) {
                    Point point2 = DisplayHost.this.dropDescendant.mapPointFromAncestor(ApplicationContext.this.display, point.x, point.y);
                    DropTarget dropTarget = DisplayHost.this.dropDescendant.getDropTarget();
                    int n = ApplicationContext.getSupportedDropActions(dropTargetDropEvent.getSourceActions());
                    dropAction = dropTarget.userDropActionChange(DisplayHost.this.dropDescendant, DisplayHost.this.dragManifest, n, point2.x, point2.y, DisplayHost.this.userDropAction);
                    if (dropAction != null) {
                        dropTargetDropEvent.acceptDrop(ApplicationContext.getNativeDropAction(dropAction));
                        dropTarget.drop(DisplayHost.this.dropDescendant, DisplayHost.this.dragManifest, n, point2.x, point2.y, DisplayHost.this.userDropAction);
                    }
                }
                if (dropAction == null) {
                    dropTargetDropEvent.rejectDrop();
                }
                dropTargetDropEvent.dropComplete(true);
                DisplayHost.this.setCursor(Cursor.getDefaultCursor());
                DisplayHost.this.dragManifest = null;
                DisplayHost.this.dragLocation = null;
                DisplayHost.this.dropDescendant = null;
                ApplicationContext.this.display.validate();
            }
        };

        protected DisplayHost() {
            this.enableEvents(131133L);
            try {
                System.setProperty("sun.awt.noerasebackground", "true");
                System.setProperty("sun.awt.erasebackgroundonresize", "true");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                this.debugPaint = Boolean.parseBoolean(System.getProperty("org.apache.pivot.wtk.debugpaint"));
                if (this.debugPaint) {
                    this.random = new Random();
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            new java.awt.dnd.DropTarget(this, this.dropTargetListener);
            this.setFocusTraversalKeysEnabled(false);
        }

        public ApplicationContext getApplicationContext() {
            return ApplicationContext.this;
        }

        public double getScale() {
            return this.scale;
        }

        public void setScale(double d) {
            if (d != this.scale) {
                this.scale = d;
                ApplicationContext.this.display.setSize(Math.max((int)Math.ceil((double)this.getWidth() / d), 0), Math.max((int)Math.ceil((double)this.getHeight() / d), 0));
                ApplicationContext.this.display.repaint();
            }
        }

        public void scaleUp() {
            double d = this.scale < 1.0 ? 1.0 : (this.scale < 1.25 ? 1.25 : (this.scale < 1.5 ? 1.5 : (this.scale < 2.0 ? 2.0 : Math.min(Math.floor(this.scale) + 1.0, 12.0))));
            this.setScale(d);
        }

        public void scaleDown() {
            double d = this.scale <= 1.25 ? 1.0 : (this.scale <= 1.5 ? 1.25 : (this.scale <= 2.0 ? 1.5 : Math.ceil(this.scale) - 1.0));
            this.setScale(d);
        }

        @Override
        public void repaint(int n, int n2, int n3, int n4) {
            if (n < 0) {
                n3 = Math.max(n3 + n, 0);
                n = 0;
            }
            if (n2 < 0) {
                n4 = Math.max(n4 + n2, 0);
                n2 = 0;
            }
            if (n3 > 0 && n4 > 0) {
                if (this.scale == 1.0) {
                    super.repaint(n, n2, n3, n4);
                } else {
                    super.repaint((int)Math.floor((double)n * this.scale), (int)Math.floor((double)n2 * this.scale), (int)Math.ceil((double)n3 * this.scale) + 1, (int)Math.ceil((double)n4 * this.scale) + 1);
                }
                this.paintPending = true;
            }
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.clipRect(0, 0, this.getWidth(), this.getHeight());
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle != null && !rectangle.isEmpty()) {
                try {
                    if (!this.paintVolatileBuffered((Graphics2D)graphics) && !this.paintBuffered((Graphics2D)graphics)) {
                        this.paintDisplay((Graphics2D)graphics);
                    }
                    if (this.debugPaint) {
                        graphics.setColor(new Color(this.random.nextInt(256), this.random.nextInt(256), this.random.nextInt(256), 75));
                        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("Exception thrown during paint(): " + runtimeException);
                    throw runtimeException;
                }
            }
            this.paintPending = false;
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean paintBuffered(Graphics2D graphics2D) {
            boolean bl = false;
            GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
            Rectangle rectangle = graphics2D.getClipBounds();
            BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(rectangle.width, rectangle.height, 1);
            if (bufferedImage != null) {
                Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
                graphics2D2.setClip(0, 0, rectangle.width, rectangle.height);
                graphics2D2.translate(-rectangle.x, -rectangle.y);
                try {
                    this.paintDisplay(graphics2D2);
                    graphics2D.drawImage((Image)bufferedImage, rectangle.x, rectangle.y, this);
                }
                finally {
                    graphics2D2.dispose();
                }
                bl = true;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean paintVolatileBuffered(Graphics2D graphics2D) {
            int n;
            boolean bl = false;
            GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
            Rectangle rectangle = graphics2D.getClipBounds();
            VolatileImage volatileImage = graphicsConfiguration.createCompatibleVolatileImage(rectangle.width, rectangle.height, 1);
            if (volatileImage != null && ((n = volatileImage.validate(graphicsConfiguration)) == 0 || n == 1)) {
                Graphics2D graphics2D2 = volatileImage.createGraphics();
                graphics2D2.setClip(0, 0, rectangle.width, rectangle.height);
                graphics2D2.translate(-rectangle.x, -rectangle.y);
                try {
                    this.paintDisplay(graphics2D2);
                    graphics2D.drawImage(volatileImage, rectangle.x, rectangle.y, this);
                }
                finally {
                    graphics2D2.dispose();
                }
                bl = !volatileImage.contentsLost();
            }
            return bl;
        }

        private void paintDisplay(Graphics2D graphics2D) {
            DragSource dragSource;
            Object object;
            int n;
            if (this.scale != 1.0) {
                graphics2D.scale(this.scale, this.scale);
            }
            Graphics2D graphics2D2 = graphics2D;
            Component.DecoratorSequence decoratorSequence = ApplicationContext.this.display.getDecorators();
            int n2 = decoratorSequence.getLength();
            for (n = n2 - 1; n >= 0; --n) {
                object = decoratorSequence.get(n);
                graphics2D2 = object.prepare(ApplicationContext.this.display, graphics2D2);
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            ApplicationContext.this.display.paint(graphics2D);
            for (n = 0; n < n2; ++n) {
                object = decoratorSequence.get(n);
                object.update();
            }
            if (this.dragDescendant != null && (object = (dragSource = this.dragDescendant.getDragSource()).getRepresentation()) != null) {
                Point point = dragSource.getOffset();
                int n3 = this.dragLocation.x - point.x;
                int n4 = this.dragLocation.y - point.y;
                graphics2D.translate(n3, n4);
                object.paint(graphics2D);
            }
        }

        private void repaintDragRepresentation() {
            DragSource dragSource = this.dragDescendant.getDragSource();
            Visual visual = dragSource.getRepresentation();
            if (visual != null) {
                Point point = dragSource.getOffset();
                this.repaint(this.dragLocation.x - point.x, this.dragLocation.y - point.y, visual.getWidth(), visual.getHeight());
            }
        }

        private Component getDropDescendant(int n, int n2) {
            Component component;
            for (component = ApplicationContext.this.display.getDescendantAt(n, n2); component != null && component.getDropTarget() == null; component = component.getParent()) {
            }
            if (component != null && component.isBlocked()) {
                component = null;
            }
            return component;
        }

        private void startNativeDrag(final DragSource dragSource, final Component component, final MouseEvent mouseEvent) {
            java.awt.dnd.DragSource dragSource2 = java.awt.dnd.DragSource.getDefaultDragSource();
            final int n = dragSource.getSupportedDropActions();
            DragGestureRecognizer dragGestureRecognizer = new DragGestureRecognizer(java.awt.dnd.DragSource.getDefaultDragSource(), ApplicationContext.this.displayHost){
                private static final long serialVersionUID = -3204487375572082596L;
                {
                    super(dragSource, component);
                    this.appendEvent(mouseEvent);
                }

                @Override
                public synchronized int getSourceActions() {
                    int n2 = 0;
                    if (DropAction.COPY.isSelected(n)) {
                        n2 |= 1;
                    }
                    if (DropAction.MOVE.isSelected(n)) {
                        n2 |= 2;
                    }
                    if (DropAction.LINK.isSelected(n)) {
                        n2 |= 0x40000000;
                    }
                    return n2;
                }

                @Override
                protected void registerListeners() {
                }

                @Override
                protected void unregisterListeners() {
                }
            };
            java.util.ArrayList<MouseEvent> arrayList = new java.util.ArrayList<MouseEvent>();
            arrayList.add(mouseEvent);
            java.awt.Point point = new java.awt.Point(mouseEvent.getX(), mouseEvent.getY());
            DragGestureEvent dragGestureEvent = new DragGestureEvent(dragGestureRecognizer, 2, point, arrayList);
            LocalManifest localManifest = dragSource.getContent();
            LocalManifestAdapter localManifestAdapter = new LocalManifestAdapter(localManifest);
            dragSource2.startDrag(dragGestureEvent, Cursor.getDefaultCursor(), null, null, localManifestAdapter, new DragSourceListener(){

                @Override
                public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
                    DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
                    dragSourceContext.setCursor(ApplicationContext.getDropCursor(ApplicationContext.getDropAction(dragSourceDragEvent.getDropAction())));
                }

                @Override
                public void dragExit(DragSourceEvent dragSourceEvent) {
                    DragSourceContext dragSourceContext = dragSourceEvent.getDragSourceContext();
                    dragSourceContext.setCursor(Cursor.getDefaultCursor());
                }

                @Override
                public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
                    DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
                    dragSourceContext.setCursor(ApplicationContext.getDropCursor(ApplicationContext.getDropAction(dragSourceDragEvent.getDropAction())));
                }

                @Override
                public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
                    DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
                    dragSourceContext.setCursor(ApplicationContext.getDropCursor(ApplicationContext.getDropAction(dragSourceDragEvent.getDropAction())));
                }

                @Override
                public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
                    DragSourceContext dragSourceContext = dragSourceDropEvent.getDragSourceContext();
                    dragSourceContext.setCursor(Cursor.getDefaultCursor());
                    dragSource.endDrag(component, ApplicationContext.getDropAction(dragSourceDropEvent.getDropAction()));
                }
            });
        }

        @Override
        protected void processEvent(AWTEvent aWTEvent) {
            super.processEvent(aWTEvent);
            ApplicationContext.this.display.validate();
        }

        @Override
        protected void processComponentEvent(ComponentEvent componentEvent) {
            super.processComponentEvent(componentEvent);
            switch (componentEvent.getID()) {
                case 101: {
                    if (this.scale == 1.0) {
                        ApplicationContext.this.display.setSize(Math.max(this.getWidth(), 0), Math.max(this.getHeight(), 0));
                        break;
                    }
                    ApplicationContext.this.display.setSize(Math.max((int)Math.ceil((double)this.getWidth() / this.scale), 0), Math.max((int)Math.ceil((double)this.getHeight() / this.scale), 0));
                    break;
                }
                case 100: {
                    break;
                }
                case 102: {
                    break;
                }
            }
        }

        @Override
        protected void processFocusEvent(FocusEvent focusEvent) {
            super.processFocusEvent(focusEvent);
            switch (focusEvent.getID()) {
                case 1004: {
                    if (this.focusedComponent == null || !this.focusedComponent.isShowing() || this.focusedComponent.isBlocked()) break;
                    this.focusedComponent.requestFocus();
                    break;
                }
                case 1005: {
                    this.focusedComponent = Component.getFocusedComponent();
                    Component.clearFocus();
                }
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            block36: {
                super.processMouseEvent(mouseEvent);
                int n = (int)Math.round((double)mouseEvent.getX() / this.scale);
                int n2 = (int)Math.round((double)mouseEvent.getY() / this.scale);
                int n3 = 0;
                int n4 = mouseEvent.getModifiersEx();
                if ((n4 & 0x400) > 0) {
                    n3 |= Mouse.Button.LEFT.getMask();
                }
                if ((n4 & 0x800) > 0) {
                    n3 |= Mouse.Button.MIDDLE.getMask();
                }
                if ((n4 & 0x1000) > 0) {
                    n3 |= Mouse.Button.RIGHT.getMask();
                }
                Mouse.setButtons(n3);
                Mouse.Button button = null;
                switch (mouseEvent.getButton()) {
                    case 1: {
                        button = Mouse.Button.LEFT;
                        break;
                    }
                    case 2: {
                        button = Mouse.Button.MIDDLE;
                        break;
                    }
                    case 3: {
                        button = Mouse.Button.RIGHT;
                    }
                }
                int n5 = mouseEvent.getID();
                if (n5 == 504 || n5 == 505) {
                    try {
                        switch (n5) {
                            case 504: {
                                ApplicationContext.this.display.mouseOver();
                                break;
                            }
                            case 505: {
                                ApplicationContext.this.display.mouseOut();
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (ApplicationContext.this.application instanceof Application.UncaughtExceptionHandler) {
                            Application.UncaughtExceptionHandler uncaughtExceptionHandler = (Application.UncaughtExceptionHandler)((Object)ApplicationContext.this.application);
                            uncaughtExceptionHandler.uncaughtExceptionThrown(exception);
                            break block36;
                        }
                        exception.printStackTrace();
                    }
                } else {
                    Object object;
                    Component component;
                    Component component2 = Mouse.getCapturer();
                    if (component2 == null) {
                        component = ApplicationContext.this.display;
                    } else {
                        component = component2;
                        object = component.mapPointFromAncestor(ApplicationContext.this.display, n, n2);
                        n = ((Point)object).x;
                        n2 = ((Point)object).y;
                    }
                    try {
                        switch (n5) {
                            case 501: {
                                Container container;
                                Object object2;
                                this.requestFocus();
                                component.mouseDown(button, n, n2);
                                if (button == Mouse.Button.LEFT) {
                                    this.dragLocation = new Point(n, n2);
                                    break;
                                }
                                if (this.menuPopup != null || button != Mouse.Button.RIGHT || !component.isShowing() || component.isBlocked()) break;
                                object = new Menu();
                                Component component3 = component;
                                int n6 = n;
                                int n7 = n2;
                                while ((object2 = component3.getMenuHandler()) == null || !object2.configureContextMenu(component3, (Menu)object, n6, n7)) {
                                    if (component3 instanceof Container) {
                                        container = (Container)component3;
                                        if ((component3 = container.getComponentAt(n6, n7)) != null) {
                                            n6 -= component3.getX();
                                            n7 -= component3.getY();
                                        }
                                    } else {
                                        component3 = null;
                                    }
                                    if (component3 != null && component3.isEnabled()) continue;
                                }
                                if (((Menu)object).getSections().getLength() > 0) {
                                    this.menuPopup = new MenuPopup((Menu)object);
                                    this.menuPopup.getWindowStateListeners().add((Object)new WindowStateListener.Adapter(){

                                        @Override
                                        public void windowClosed(Window window, Display display, Window window2) {
                                            DisplayHost.this.menuPopup.getMenu().getSections().clear();
                                            DisplayHost.this.menuPopup = null;
                                            window.getWindowStateListeners().remove((Object)this);
                                        }
                                    });
                                    object2 = null;
                                    object2 = component == ApplicationContext.this.display ? (Window)ApplicationContext.this.display.getComponentAt(n, n2) : component.getWindow();
                                    container = ((Component)object2).getDisplay();
                                    Point point = component.mapPointToAncestor(container, n, n2);
                                    this.menuPopup.open((Window)object2, point);
                                }
                                break;
                            }
                            case 502: {
                                if (this.dragDescendant == null) {
                                    component.mouseUp(button, n, n2);
                                } else {
                                    object = this.dragDescendant.getDragSource();
                                    this.repaintDragRepresentation();
                                    if (this.dropDescendant == null) {
                                        object.endDrag(this.dragDescendant, null);
                                    } else {
                                        DropTarget dropTarget = this.dropDescendant.getDropTarget();
                                        DropAction dropAction = dropTarget.drop(this.dropDescendant, this.dragManifest, object.getSupportedDropActions(), n, n2, ApplicationContext.getUserDropAction(mouseEvent));
                                        object.endDrag(this.dragDescendant, dropAction);
                                    }
                                    this.setCursor(Cursor.getDefaultCursor());
                                    this.dragDescendant = null;
                                    this.dragManifest = null;
                                    this.userDropAction = null;
                                    this.dropDescendant = null;
                                }
                                this.dragLocation = null;
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (ApplicationContext.this.application instanceof Application.UncaughtExceptionHandler) {
                            Application.UncaughtExceptionHandler uncaughtExceptionHandler = (Application.UncaughtExceptionHandler)((Object)ApplicationContext.this.application);
                            uncaughtExceptionHandler.uncaughtExceptionThrown(exception);
                        }
                        exception.printStackTrace();
                    }
                }
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            super.processMouseMotionEvent(mouseEvent);
            if (!this.paintPending) {
                int n = (int)Math.round((double)mouseEvent.getX() / this.scale);
                int n2 = (int)Math.round((double)mouseEvent.getY() / this.scale);
                try {
                    switch (mouseEvent.getID()) {
                        case 503: 
                        case 506: {
                            if (this.dragDescendant == null) {
                                Component component = Mouse.getCapturer();
                                if (component == null) {
                                    if (!ApplicationContext.this.display.isMouseOver()) {
                                        ApplicationContext.this.display.mouseOver();
                                    }
                                    ApplicationContext.this.display.mouseMove(n, n2);
                                    int n3 = Platform.getDragThreshold();
                                    if (this.dragLocation != null && (Math.abs(n - this.dragLocation.x) > n3 || Math.abs(n2 - this.dragLocation.y) > n3)) {
                                        this.dragDescendant = ApplicationContext.this.display.getDescendantAt(this.dragLocation.x, this.dragLocation.y);
                                        while (this.dragDescendant != null && this.dragDescendant.getDragSource() == null) {
                                            this.dragDescendant = this.dragDescendant.getParent();
                                        }
                                        if (this.dragDescendant == null || this.dragDescendant.isBlocked()) {
                                            this.dragDescendant = null;
                                            this.dragLocation = null;
                                            break;
                                        }
                                        DragSource dragSource = this.dragDescendant.getDragSource();
                                        this.dragLocation = this.dragDescendant.mapPointFromAncestor(ApplicationContext.this.display, n, n2);
                                        if (dragSource.beginDrag(this.dragDescendant, this.dragLocation.x, this.dragLocation.y)) {
                                            if (dragSource.isNative()) {
                                                this.startNativeDrag(dragSource, this.dragDescendant, mouseEvent);
                                                this.dragDescendant = null;
                                                this.dragLocation = null;
                                                break;
                                            }
                                            if (dragSource.getRepresentation() != null && dragSource.getOffset() == null) {
                                                throw new IllegalStateException("Drag offset is required when a  respresentation is specified.");
                                            }
                                            if (ApplicationContext.this.display.isMouseOver()) {
                                                ApplicationContext.this.display.mouseOut();
                                            }
                                            this.dragManifest = dragSource.getContent();
                                            this.userDropAction = ApplicationContext.getUserDropAction(mouseEvent);
                                            this.dragLocation = new Point(n, n2);
                                            this.repaintDragRepresentation();
                                            break;
                                        }
                                        this.dragDescendant = null;
                                        this.dragLocation = null;
                                    }
                                    break;
                                }
                                Point point = component.mapPointFromAncestor(ApplicationContext.this.display, n, n2);
                                component.mouseMove(point.x, point.y);
                                break;
                            }
                            if (this.dragLocation == null) break;
                            DragSource dragSource = this.dragDescendant.getDragSource();
                            Component component = this.dropDescendant;
                            this.dropDescendant = this.getDropDescendant(n, n2);
                            DropAction dropAction = null;
                            if (component == this.dropDescendant) {
                                if (this.dropDescendant != null) {
                                    DropTarget dropTarget = this.dropDescendant.getDropTarget();
                                    Point point = this.dropDescendant.mapPointFromAncestor(ApplicationContext.this.display, n, n2);
                                    dropAction = dropTarget.dragMove(this.dropDescendant, this.dragManifest, dragSource.getSupportedDropActions(), point.x, point.y, this.userDropAction);
                                }
                            } else {
                                DropTarget dropTarget;
                                if (component != null) {
                                    dropTarget = component.getDropTarget();
                                    dropTarget.dragExit(component);
                                }
                                if (this.dropDescendant != null) {
                                    dropTarget = this.dropDescendant.getDropTarget();
                                    dropAction = dropTarget.dragEnter(this.dropDescendant, this.dragManifest, dragSource.getSupportedDropActions(), this.userDropAction);
                                }
                            }
                            this.setCursor(ApplicationContext.getDropCursor(dropAction));
                            this.repaintDragRepresentation();
                            this.dragLocation = new Point(n, n2);
                            this.repaintDragRepresentation();
                        }
                    }
                }
                catch (Exception exception) {
                    if (ApplicationContext.this.application instanceof Application.UncaughtExceptionHandler) {
                        Application.UncaughtExceptionHandler uncaughtExceptionHandler = (Application.UncaughtExceptionHandler)((Object)ApplicationContext.this.application);
                        uncaughtExceptionHandler.uncaughtExceptionThrown(exception);
                    }
                    exception.printStackTrace();
                }
            }
        }

        @Override
        protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
            super.processMouseWheelEvent(mouseWheelEvent);
            int n = (int)Math.round((double)mouseWheelEvent.getX() / this.scale);
            int n2 = (int)Math.round((double)mouseWheelEvent.getY() / this.scale);
            Mouse.ScrollType scrollType = null;
            switch (mouseWheelEvent.getScrollType()) {
                case 1: {
                    scrollType = Mouse.ScrollType.BLOCK;
                    break;
                }
                case 0: {
                    scrollType = Mouse.ScrollType.UNIT;
                }
            }
            try {
                switch (mouseWheelEvent.getID()) {
                    case 507: {
                        Component component;
                        if (Keyboard.isPressed(Keyboard.Modifier.CTRL) && Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                            if (mouseWheelEvent.getWheelRotation() < 0) {
                                this.scaleUp();
                                break;
                            }
                            this.scaleDown();
                            break;
                        }
                        if (this.dragDescendant != null) break;
                        Component component2 = Mouse.getCapturer();
                        if (component2 == null) {
                            component = ApplicationContext.this.display;
                        } else {
                            component = component2;
                            Point point = component.mapPointFromAncestor(ApplicationContext.this.display, n, n2);
                            n = point.x;
                            n2 = point.y;
                        }
                        component.mouseWheel(scrollType, mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation(), n, n2);
                    }
                }
            }
            catch (Exception exception) {
                if (ApplicationContext.this.application instanceof Application.UncaughtExceptionHandler) {
                    Application.UncaughtExceptionHandler uncaughtExceptionHandler = (Application.UncaughtExceptionHandler)((Object)ApplicationContext.this.application);
                    uncaughtExceptionHandler.uncaughtExceptionThrown(exception);
                }
                exception.printStackTrace();
            }
        }

        @Override
        protected void processKeyEvent(KeyEvent keyEvent) {
            super.processKeyEvent(keyEvent);
            int n = 0;
            int n2 = keyEvent.getModifiersEx();
            if ((n2 & 0x40) > 0) {
                n |= Keyboard.Modifier.SHIFT.getMask();
            }
            if ((n2 & 0x80) > 0) {
                n |= Keyboard.Modifier.CTRL.getMask();
            }
            if ((n2 & 0x200) > 0) {
                n |= Keyboard.Modifier.ALT.getMask();
            }
            if ((n2 & 0x100) > 0) {
                n |= Keyboard.Modifier.META.getMask();
            }
            Keyboard.setModifiers(n);
            Keyboard.KeyLocation keyLocation = null;
            switch (keyEvent.getKeyLocation()) {
                case 1: {
                    keyLocation = Keyboard.KeyLocation.STANDARD;
                    break;
                }
                case 2: {
                    keyLocation = Keyboard.KeyLocation.LEFT;
                    break;
                }
                case 3: {
                    keyLocation = Keyboard.KeyLocation.RIGHT;
                    break;
                }
                case 4: {
                    keyLocation = Keyboard.KeyLocation.KEYPAD;
                }
            }
            if (this.dragDescendant == null) {
                Component component = Component.getFocusedComponent();
                switch (keyEvent.getID()) {
                    case 401: {
                        boolean bl = false;
                        int n3 = keyEvent.getKeyCode();
                        if (Keyboard.isPressed(Keyboard.Modifier.CTRL) && Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                            if (n3 == 521 || n3 == 61 || n3 == 107) {
                                this.scaleUp();
                            } else if (n3 == 45 || n3 == 109) {
                                this.scaleDown();
                            }
                        }
                        try {
                            if (component == null) {
                                if (ApplicationContext.this.application instanceof Application.UnprocessedKeyHandler) {
                                    Application.UnprocessedKeyHandler unprocessedKeyHandler = (Application.UnprocessedKeyHandler)((Object)ApplicationContext.this.application);
                                    unprocessedKeyHandler.keyPressed(n3, keyLocation);
                                }
                            } else if (!component.isBlocked()) {
                                bl = component.keyPressed(n3, keyLocation);
                            }
                        }
                        catch (Exception exception) {
                            if (ApplicationContext.this.application instanceof Application.UncaughtExceptionHandler) {
                                Application.UncaughtExceptionHandler uncaughtExceptionHandler = (Application.UncaughtExceptionHandler)((Object)ApplicationContext.this.application);
                                uncaughtExceptionHandler.uncaughtExceptionThrown(exception);
                            }
                            exception.printStackTrace();
                        }
                        if (!bl) break;
                        keyEvent.consume();
                        break;
                    }
                    case 402: {
                        boolean bl = false;
                        int n4 = keyEvent.getKeyCode();
                        try {
                            if (component == null) {
                                if (ApplicationContext.this.application instanceof Application.UnprocessedKeyHandler) {
                                    Application.UnprocessedKeyHandler unprocessedKeyHandler = (Application.UnprocessedKeyHandler)((Object)ApplicationContext.this.application);
                                    unprocessedKeyHandler.keyReleased(n4, keyLocation);
                                }
                            } else if (!component.isBlocked()) {
                                bl = component.keyReleased(n4, keyLocation);
                            }
                        }
                        catch (Exception exception) {
                            if (ApplicationContext.this.application instanceof Application.UncaughtExceptionHandler) {
                                Application.UncaughtExceptionHandler uncaughtExceptionHandler = (Application.UncaughtExceptionHandler)((Object)ApplicationContext.this.application);
                                uncaughtExceptionHandler.uncaughtExceptionThrown(exception);
                            }
                            exception.printStackTrace();
                        }
                        if (!bl) break;
                        keyEvent.consume();
                        break;
                    }
                    case 400: {
                        boolean bl = false;
                        char c = keyEvent.getKeyChar();
                        try {
                            if (component == null) {
                                if (ApplicationContext.this.application instanceof Application.UnprocessedKeyHandler) {
                                    Application.UnprocessedKeyHandler unprocessedKeyHandler = (Application.UnprocessedKeyHandler)((Object)ApplicationContext.this.application);
                                    unprocessedKeyHandler.keyTyped(c);
                                }
                            } else if (!component.isBlocked()) {
                                bl = component.keyTyped(c);
                            }
                        }
                        catch (Exception exception) {
                            if (ApplicationContext.this.application instanceof Application.UncaughtExceptionHandler) {
                                Application.UncaughtExceptionHandler uncaughtExceptionHandler = (Application.UncaughtExceptionHandler)((Object)ApplicationContext.this.application);
                                uncaughtExceptionHandler.uncaughtExceptionThrown(exception);
                            }
                            exception.printStackTrace();
                        }
                        if (!bl) break;
                        keyEvent.consume();
                        break;
                    }
                }
            } else {
                DragSource dragSource = this.dragDescendant.getDragSource();
                if (this.dropDescendant != null) {
                    DropAction dropAction = this.userDropAction;
                    this.userDropAction = ApplicationContext.getUserDropAction(keyEvent);
                    if (dropAction != this.userDropAction) {
                        DropTarget dropTarget = this.dropDescendant.getDropTarget();
                        Point point = this.dragLocation;
                        if (point == null) {
                            point = ApplicationContext.this.display.getMouseLocation();
                        }
                        point = this.dropDescendant.mapPointFromAncestor(ApplicationContext.this.display, point.x, point.y);
                        dropTarget.userDropActionChange(this.dropDescendant, this.dragManifest, dragSource.getSupportedDropActions(), point.x, point.y, this.userDropAction);
                    }
                }
            }
        }
    }
}

