/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Rectangle;
import java.io.Serializable;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Point;

public final class Bounds
implements Serializable {
    private static final long serialVersionUID = -2473226417628417475L;
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    public static final String X_KEY = "x";
    public static final String Y_KEY = "y";
    public static final String WIDTH_KEY = "width";
    public static final String HEIGHT_KEY = "height";

    public Bounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public Bounds(Point point, Dimensions dimensions) {
        if (point == null) {
            throw new IllegalArgumentException("origin is null.");
        }
        if (dimensions == null) {
            throw new IllegalArgumentException("size is null.");
        }
        this.x = point.x;
        this.y = point.y;
        this.width = dimensions.width;
        this.height = dimensions.height;
    }

    public Bounds(Bounds bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds is null.");
        }
        this.x = bounds.x;
        this.y = bounds.y;
        this.width = bounds.width;
        this.height = bounds.height;
    }

    public Bounds(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("bounds is null.");
        }
        this.x = dictionary.containsKey((Object)X_KEY) ? (Integer)dictionary.get((Object)X_KEY) : 0;
        this.y = dictionary.containsKey((Object)Y_KEY) ? (Integer)dictionary.get((Object)Y_KEY) : 0;
        this.width = dictionary.containsKey((Object)WIDTH_KEY) ? (Integer)dictionary.get((Object)WIDTH_KEY) : 0;
        this.height = dictionary.containsKey((Object)HEIGHT_KEY) ? (Integer)dictionary.get((Object)HEIGHT_KEY) : 0;
    }

    public Bounds(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException("rectangle is null.");
        }
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public Dimensions getSize() {
        return new Dimensions(this.width, this.height);
    }

    public Bounds union(int n, int n2, int n3, int n4) {
        int n5 = Math.min(this.x, n);
        int n6 = Math.min(this.y, n2);
        int n7 = Math.max(this.x + this.width, n + n3);
        int n8 = Math.max(this.y + this.height, n2 + n4);
        return new Bounds(n5, n6, n7 - n5, n8 - n6);
    }

    public Bounds union(Bounds bounds) {
        return this.union(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public Bounds intersect(int n, int n2, int n3, int n4) {
        int n5 = Math.max(this.x, n);
        int n6 = Math.max(this.y, n2);
        int n7 = Math.min(this.x + this.width, n + n3);
        int n8 = Math.min(this.y + this.height, n2 + n4);
        return new Bounds(n5, n6, n7 - n5, n8 - n6);
    }

    public Bounds intersect(Bounds bounds) {
        return this.intersect(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public Bounds translate(int n, int n2) {
        return new Bounds(this.x + n, this.y + n2, this.width, this.height);
    }

    public Bounds translate(Point point) {
        return this.translate(point.x, point.y);
    }

    public boolean contains(Point point) {
        if (point == null) {
            throw new IllegalArgumentException("point is null");
        }
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n, int n2) {
        return n >= this.x && n2 >= this.y && n < this.x + this.width && n2 < this.y + this.height;
    }

    public boolean contains(Bounds bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds is null");
        }
        return this.contains(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public boolean contains(int n, int n2, int n3, int n4) {
        return !this.isEmpty() && n >= this.x && n2 >= this.y && n + n3 <= this.x + this.width && n2 + n4 <= this.y + this.height;
    }

    public boolean intersects(Bounds bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds is null");
        }
        return this.intersects(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public boolean intersects(int n, int n2, int n3, int n4) {
        return !this.isEmpty() && n + n3 > this.x && n2 + n4 > this.y && n < this.x + this.width && n2 < this.y + this.height;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Bounds) {
            Bounds bounds = (Bounds)object;
            bl = this.x == bounds.x && this.y == bounds.y && this.width == bounds.width && this.height == bounds.height;
        }
        return bl;
    }

    public int hashCode() {
        return this.x * this.y ^ this.width * this.height;
    }

    public Rectangle toRectangle() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.x + "," + this.y + ";" + this.width + X_KEY + this.height + "]";
    }

    public static Bounds decode(String string) {
        Bounds bounds;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        try {
            bounds = new Bounds((Dictionary<String, ?>)JSONSerializer.parseMap((String)string));
        }
        catch (SerializationException serializationException) {
            throw new IllegalArgumentException(serializationException);
        }
        return bounds;
    }
}

