/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import netscape.javascript.JSObject;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.immutable.ImmutableMap;
import org.apache.pivot.wtk.Alert;
import org.apache.pivot.wtk.Application;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.MessageType;

public final class BrowserApplicationContext
extends ApplicationContext {
    private static ArrayList<HostApplet> hostApplets = new ArrayList();

    public static Application getApplication(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name is null.");
        }
        Application application = null;
        for (HostApplet hostApplet : hostApplets) {
            if (!hostApplet.getName().equals(string)) continue;
            application = hostApplet.getApplication();
            break;
        }
        return application;
    }

    public static Object eval(String string, Application application) {
        if (application == null) {
            throw new IllegalArgumentException("application is null.");
        }
        HostApplet hostApplet = null;
        for (HostApplet hostApplet2 : hostApplets) {
            if (hostApplet2.getApplication() != application) continue;
            hostApplet = hostApplet2;
            break;
        }
        if (hostApplet == null) {
            throw new IllegalArgumentException("No applet is hosting the given application.");
        }
        try {
            JSObject jSObject = JSObject.getWindow(hostApplet);
            return jSObject.eval(string);
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException(throwable);
        }
    }

    public static final class HostApplet
    extends Applet {
        private static final long serialVersionUID = -7710026348576806673L;
        private transient BrowserApplicationContext applicationContext = null;
        private HashMap<String, String> properties = null;
        public static final String APPLICATION_CLASS_NAME_PARAMETER = "application_class_name";
        public static final String STARTUP_PROPERTIES_PARAMETER = "startup_properties";

        public Application getApplication() {
            return this.applicationContext.getApplication();
        }

        @Override
        public void init() {
            InitCallback initCallback = new InitCallback();
            if (EventQueue.isDispatchThread()) {
                initCallback.run();
            } else {
                ApplicationContext.queueCallback(initCallback, true);
            }
        }

        @Override
        public void start() {
            StartCallback startCallback = new StartCallback();
            if (EventQueue.isDispatchThread()) {
                startCallback.run();
            } else {
                ApplicationContext.queueCallback(startCallback, true);
            }
        }

        @Override
        public void stop() {
            StopCallback stopCallback = new StopCallback();
            if (EventQueue.isDispatchThread()) {
                stopCallback.run();
            } else {
                ApplicationContext.queueCallback(stopCallback, true);
            }
        }

        @Override
        public void destroy() {
            DestroyCallback destroyCallback = new DestroyCallback();
            if (EventQueue.isDispatchThread()) {
                destroyCallback.run();
            } else {
                ApplicationContext.queueCallback(destroyCallback, true);
            }
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        private void displayException(Exception exception) {
            exception.printStackTrace();
            String string = exception.getClass().getName();
            Label label = null;
            String string2 = exception.getMessage();
            if (string2 != null && string2.length() > 0) {
                label = new Label(string2);
                label.getStyles().put("wrapText", (Object)true);
            }
            Alert.alert(MessageType.ERROR, string, label, this.applicationContext.getDisplay());
        }

        private class DestroyCallback
        implements Runnable {
            private DestroyCallback() {
            }

            @Override
            public void run() {
                ApplicationContext.removeDisplay(HostApplet.this.applicationContext.getDisplay());
                hostApplets.remove((Object)HostApplet.this);
                if (hostApplets.getLength() == 0) {
                    ApplicationContext.destroyTimer();
                }
            }
        }

        private class StopCallback
        implements Runnable {
            private StopCallback() {
            }

            @Override
            public void run() {
                Application application = HostApplet.this.applicationContext.getApplication();
                if (application != null) {
                    try {
                        application.shutdown(false);
                    }
                    catch (Exception exception) {
                        HostApplet.this.displayException(exception);
                    }
                    ApplicationContext.removeApplication(application);
                }
            }
        }

        private class StartCallback
        implements Runnable {
            private StartCallback() {
            }

            @Override
            public void run() {
                Application application = null;
                String string = HostApplet.this.getParameter(HostApplet.APPLICATION_CLASS_NAME_PARAMETER);
                if (string == null) {
                    Alert.alert(MessageType.ERROR, "Application class name is required.", HostApplet.this.applicationContext.getDisplay());
                } else {
                    try {
                        Class<?> clazz = Class.forName(string);
                        application = (Application)clazz.newInstance();
                        HostApplet.this.applicationContext.setApplication(application);
                    }
                    catch (Throwable throwable) {
                        Alert.alert(MessageType.ERROR, throwable.getMessage(), HostApplet.this.applicationContext.getDisplay());
                        throwable.printStackTrace();
                    }
                }
                if (application != null) {
                    try {
                        application.startup(HostApplet.this.applicationContext.getDisplay(), (Map<String, String>)new ImmutableMap((Map)HostApplet.this.properties));
                    }
                    catch (Exception exception) {
                        HostApplet.this.displayException(exception);
                    }
                    ApplicationContext.addApplication(application);
                }
            }
        }

        private class InitCallback
        implements Runnable {
            private InitCallback() {
            }

            @Override
            public void run() {
                Object object;
                URL uRL = HostApplet.this.getCodeBase();
                if (uRL != null) {
                    if (uRL.getProtocol().equals("file")) {
                        object = null;
                        try {
                            object = new File(System.getProperty("user.home"));
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                        if (object != null) {
                            try {
                                ApplicationContext.origin = ((File)object).toURI().toURL();
                            }
                            catch (MalformedURLException malformedURLException) {}
                        }
                    } else {
                        try {
                            ApplicationContext.origin = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), "");
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                }
                HostApplet.this.properties = new HashMap();
                object = HostApplet.this.getParameter(HostApplet.STARTUP_PROPERTIES_PARAMETER);
                if (object != null) {
                    for (String string : ((String)object).split("&")) {
                        String[] stringArray = string.split("=");
                        if (stringArray.length == 2) {
                            String string2;
                            String string3 = stringArray[0].trim();
                            try {
                                string2 = URLDecoder.decode(stringArray[1].trim(), "UTF-8");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                throw new RuntimeException(unsupportedEncodingException);
                            }
                            HostApplet.this.properties.put((Object)string3, (Object)string2);
                            continue;
                        }
                        System.err.println(string + " is not a valid startup property.");
                    }
                }
                HostApplet.this.applicationContext = new BrowserApplicationContext();
                ApplicationContext.DisplayHost displayHost = HostApplet.this.applicationContext.getDisplayHost();
                HostApplet.this.setLayout(new BorderLayout());
                HostApplet.this.add(displayHost);
                HostApplet.this.setFocusTraversalKeysEnabled(false);
                HostApplet.this.setBackground(null);
                ApplicationContext.addDisplay(HostApplet.this.applicationContext.getDisplay());
                if (hostApplets.getLength() == 0) {
                    ApplicationContext.createTimer();
                }
                hostApplets.add((Object)HostApplet.this);
            }
        }
    }
}

