/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import java.util.Locale;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.CalendarDate;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.CalendarListener;
import org.apache.pivot.wtk.CalendarSelectionListener;
import org.apache.pivot.wtk.Container;

public class Calendar
extends Container {
    private int year;
    private int month;
    private CalendarDate selectedDate = null;
    private Locale locale = Locale.getDefault();
    private Filter<CalendarDate> disabledDateFilter = null;
    private String selectedDateKey = null;
    private CalendarListenerList calendarListeners = new CalendarListenerList();
    private CalendarSelectionListenerList calendarSelectionListeners = new CalendarSelectionListenerList();
    public static final String LANGUAGE_KEY = "language";
    public static final String COUNTRY_KEY = "country";
    public static final String VARIANT_KEY = "variant";

    public Calendar() {
        this(new CalendarDate());
    }

    private Calendar(CalendarDate calendarDate) {
        this(calendarDate.year, calendarDate.month);
    }

    public Calendar(int n, int n2) {
        this.year = n;
        this.month = n2;
        this.installThemeSkin(Calendar.class);
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int n) {
        int n2 = this.year;
        if (n2 != n) {
            this.year = n;
            this.calendarListeners.yearChanged(this, n2);
        }
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int n) {
        int n2 = this.month;
        if (n2 != n) {
            this.month = n;
            this.calendarListeners.monthChanged(this, n2);
        }
    }

    public CalendarDate getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedDate(CalendarDate calendarDate) {
        CalendarDate calendarDate2 = this.selectedDate;
        if (calendarDate2 != calendarDate) {
            this.selectedDate = calendarDate;
            this.calendarSelectionListeners.selectedDateChanged(this, calendarDate2);
        }
    }

    public final void setSelectedDate(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectedDate is null.");
        }
        this.setSelectedDate(CalendarDate.decode((String)string));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale is null.");
        }
        Locale locale2 = this.locale;
        if (locale2 != locale) {
            this.locale = locale;
            this.calendarListeners.localeChanged(this, locale2);
        }
    }

    public void setLocale(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("locale is null.");
        }
        String string = (String)dictionary.get((Object)LANGUAGE_KEY);
        String string2 = (String)dictionary.get((Object)COUNTRY_KEY);
        String string3 = (String)dictionary.get((Object)VARIANT_KEY);
        if (string3 != null) {
            this.setLocale(new Locale(string, string2, string3));
        } else if (string2 != null) {
            this.setLocale(new Locale(string, string2));
        } else {
            this.setLocale(new Locale(string));
        }
    }

    public void setLocale(String string) {
        if (string == null) {
            throw new IllegalArgumentException("locale is null.");
        }
        try {
            this.setLocale((Dictionary<String, ?>)JSONSerializer.parseMap((String)string));
        }
        catch (SerializationException serializationException) {
            throw new IllegalArgumentException(serializationException);
        }
    }

    public Filter<CalendarDate> getDisabledDateFilter() {
        return this.disabledDateFilter;
    }

    public void setDisabledDateFilter(Filter<CalendarDate> filter) {
        Filter<CalendarDate> filter2 = this.disabledDateFilter;
        if (filter2 != filter) {
            this.disabledDateFilter = filter;
            this.calendarListeners.disabledDateFilterChanged(this, filter2);
        }
    }

    public String getSelectedDateKey() {
        return this.selectedDateKey;
    }

    public void setSelectedDateKey(String string) {
        String string2 = this.selectedDateKey;
        if (string != string2) {
            this.selectedDateKey = string;
            this.calendarListeners.selectedDateKeyChanged(this, string2);
        }
    }

    @Override
    public void load(Dictionary<String, ?> dictionary) {
        if (this.selectedDateKey != null && JSONSerializer.containsKey(dictionary, (String)this.selectedDateKey)) {
            Object object = JSONSerializer.get(dictionary, (String)this.selectedDateKey);
            if (object instanceof CalendarDate) {
                this.setSelectedDate((CalendarDate)object);
            } else if (object instanceof String) {
                this.setSelectedDate((String)object);
            } else {
                throw new IllegalArgumentException("Invalid date type: " + object.getClass().getName());
            }
        }
    }

    @Override
    public void store(Dictionary<String, ?> dictionary) {
        if (this.isEnabled() && this.selectedDateKey != null) {
            JSONSerializer.put(dictionary, (String)this.selectedDateKey, (Object)this.selectedDate);
        }
    }

    @Override
    public void clear() {
        if (this.selectedDateKey != null) {
            this.setSelectedDate((CalendarDate)null);
        }
    }

    public ListenerList<CalendarListener> getCalendarListeners() {
        return this.calendarListeners;
    }

    public ListenerList<CalendarSelectionListener> getCalendarSelectionListeners() {
        return this.calendarSelectionListeners;
    }

    private static class CalendarSelectionListenerList
    extends ListenerList<CalendarSelectionListener>
    implements CalendarSelectionListener {
        private CalendarSelectionListenerList() {
        }

        @Override
        public void selectedDateChanged(Calendar calendar, CalendarDate calendarDate) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CalendarSelectionListener calendarSelectionListener = (CalendarSelectionListener)iterator.next();
                calendarSelectionListener.selectedDateChanged(calendar, calendarDate);
            }
        }
    }

    private static class CalendarListenerList
    extends ListenerList<CalendarListener>
    implements CalendarListener {
        private CalendarListenerList() {
        }

        @Override
        public void yearChanged(Calendar calendar, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CalendarListener calendarListener = (CalendarListener)iterator.next();
                calendarListener.yearChanged(calendar, n);
            }
        }

        @Override
        public void monthChanged(Calendar calendar, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CalendarListener calendarListener = (CalendarListener)iterator.next();
                calendarListener.monthChanged(calendar, n);
            }
        }

        @Override
        public void localeChanged(Calendar calendar, Locale locale) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CalendarListener calendarListener = (CalendarListener)iterator.next();
                calendarListener.localeChanged(calendar, locale);
            }
        }

        @Override
        public void disabledDateFilterChanged(Calendar calendar, Filter<CalendarDate> filter) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CalendarListener calendarListener = (CalendarListener)iterator.next();
                calendarListener.disabledDateFilterChanged(calendar, filter);
            }
        }

        @Override
        public void selectedDateKeyChanged(Calendar calendar, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CalendarListener calendarListener = (CalendarListener)iterator.next();
                calendarListener.selectedDateKeyChanged(calendar, string);
            }
        }
    }
}

