/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import org.apache.pivot.wtk.ClipboardContentListener;
import org.apache.pivot.wtk.LocalManifest;
import org.apache.pivot.wtk.LocalManifestAdapter;
import org.apache.pivot.wtk.Manifest;
import org.apache.pivot.wtk.RemoteManifest;

public final class Clipboard {
    private static LocalManifest content = null;
    private static ClipboardContentListener clipboardContentListener = null;

    public static Manifest getContent() {
        Manifest manifest = content;
        if (manifest == null) {
            try {
                java.awt.datatransfer.Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                manifest = new RemoteManifest(clipboard.getContents(null));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return manifest;
    }

    public static void setContent(LocalManifest localManifest) {
        Clipboard.setContent(localManifest, null);
    }

    public static void setContent(LocalManifest localManifest, ClipboardContentListener clipboardContentListener) {
        if (localManifest == null) {
            throw new IllegalArgumentException("content is null");
        }
        try {
            java.awt.datatransfer.Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            LocalManifestAdapter localManifestAdapter = new LocalManifestAdapter(localManifest);
            clipboard.setContents(localManifestAdapter, new ClipboardOwner(){

                @Override
                public void lostOwnership(java.awt.datatransfer.Clipboard clipboard, Transferable transferable) {
                    LocalManifest localManifest = content;
                    content = null;
                    if (clipboardContentListener != null) {
                        clipboardContentListener.contentChanged(localManifest);
                    }
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        content = localManifest;
        Clipboard.clipboardContentListener = clipboardContentListener;
    }
}

