/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Color;
import java.util.Iterator;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.ColorChooserListener;
import org.apache.pivot.wtk.ColorChooserSelectionListener;
import org.apache.pivot.wtk.Container;

public class ColorChooser
extends Container {
    private Color selectedColor = null;
    private String selectedColorKey = null;
    private ColorChooserListenerList colorChooserListeners = new ColorChooserListenerList();
    private ColorChooserSelectionListenerList colorChooserSelectionListeners = new ColorChooserSelectionListenerList();

    public ColorChooser() {
        this.installThemeSkin(ColorChooser.class);
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color color) {
        Color color2 = this.selectedColor;
        if (color != color2) {
            this.selectedColor = color;
            this.colorChooserSelectionListeners.selectedColorChanged(this, color2);
        }
    }

    public void setSelectedColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectedColor is null.");
        }
        this.setSelectedColor(Color.decode(string));
    }

    public String getSelectedColorKey() {
        return this.selectedColorKey;
    }

    public void setSelectedColorKey(String string) {
        String string2 = this.selectedColorKey;
        if (string != string2) {
            this.selectedColorKey = string;
            this.colorChooserListeners.selectedColorKeyChanged(this, string2);
        }
    }

    @Override
    public void load(Dictionary<String, ?> dictionary) {
        if (this.selectedColorKey != null && JSONSerializer.containsKey(dictionary, (String)this.selectedColorKey)) {
            Object object = JSONSerializer.get(dictionary, (String)this.selectedColorKey);
            if (object instanceof Color) {
                this.setSelectedColor((Color)object);
            } else if (object instanceof String) {
                this.setSelectedColor((String)object);
            } else {
                throw new IllegalArgumentException("Invalid color type: " + object.getClass().getName());
            }
        }
    }

    @Override
    public void store(Dictionary<String, ?> dictionary) {
        if (this.isEnabled() && this.selectedColorKey != null) {
            JSONSerializer.put(dictionary, (String)this.selectedColorKey, (Object)this.selectedColor);
        }
    }

    public ListenerList<ColorChooserListener> getColorChooserListeners() {
        return this.colorChooserListeners;
    }

    public ListenerList<ColorChooserSelectionListener> getColorChooserSelectionListeners() {
        return this.colorChooserSelectionListeners;
    }

    private static class ColorChooserSelectionListenerList
    extends ListenerList<ColorChooserSelectionListener>
    implements ColorChooserSelectionListener {
        private ColorChooserSelectionListenerList() {
        }

        @Override
        public void selectedColorChanged(ColorChooser colorChooser, Color color) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ColorChooserSelectionListener colorChooserSelectionListener = (ColorChooserSelectionListener)iterator.next();
                colorChooserSelectionListener.selectedColorChanged(colorChooser, color);
            }
        }
    }

    private static class ColorChooserListenerList
    extends ListenerList<ColorChooserListener>
    implements ColorChooserListener {
        private ColorChooserListenerList() {
        }

        @Override
        public void selectedColorKeyChanged(ColorChooser colorChooser, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ColorChooserListener colorChooserListener = (ColorChooserListener)iterator.next();
                colorChooserListener.selectedColorKeyChanged(colorChooser, string);
            }
        }
    }
}

