/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import org.apache.pivot.beans.BeanDictionary;
import org.apache.pivot.beans.PropertyNotFoundException;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.HashSet;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.ThreadUtilities;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Automation;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.ComponentClassListener;
import org.apache.pivot.wtk.ComponentDataListener;
import org.apache.pivot.wtk.ComponentDecoratorListener;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.ComponentListener;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.ComponentMouseListener;
import org.apache.pivot.wtk.ComponentMouseWheelListener;
import org.apache.pivot.wtk.ComponentStateListener;
import org.apache.pivot.wtk.ConstrainedVisual;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Direction;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.DragSource;
import org.apache.pivot.wtk.DropTarget;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Limits;
import org.apache.pivot.wtk.MenuHandler;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Viewport;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.effects.Decorator;

public abstract class Component
implements ConstrainedVisual {
    private Skin skin = null;
    private BeanDictionary styles = null;
    private StyleDictionary styleDictionary = new StyleDictionary();
    private HashSet<String> customStyles = new HashSet();
    private int preferredWidth = -1;
    private int preferredHeight = -1;
    private int minimumPreferredWidth = 0;
    private int maximumPreferredWidth = Integer.MAX_VALUE;
    private int minimumPreferredHeight = 0;
    private int maximumPreferredHeight = Integer.MAX_VALUE;
    private Dimensions preferredSize = null;
    private Container parent = null;
    private boolean valid = false;
    private int x = 0;
    private int y = 0;
    private boolean visible = true;
    private ArrayList<Decorator> decorators = new ArrayList();
    private DecoratorSequence decoratorSequence = new DecoratorSequence();
    private boolean enabled = true;
    private boolean mouseOver = false;
    private Cursor cursor = null;
    private String tooltipText = null;
    private DragSource dragSource = null;
    private DropTarget dropTarget = null;
    private MenuHandler menuHandler = null;
    private HashMap<String, Object> userData = new HashMap();
    private UserDataDictionary userDataDictionary = new UserDataDictionary();
    private Object attributes = null;
    private String automationID;
    private ComponentListenerList componentListeners = new ComponentListenerList();
    private ComponentStateListenerList componentStateListeners = new ComponentStateListenerList();
    private ComponentDecoratorListenerList componentDecoratorListeners = new ComponentDecoratorListenerList();
    private ComponentMouseListenerList componentMouseListeners = new ComponentMouseListenerList();
    private ComponentMouseButtonListenerList componentMouseButtonListeners = new ComponentMouseButtonListenerList();
    private ComponentMouseWheelListenerList componentMouseWheelListeners = new ComponentMouseWheelListenerList();
    private ComponentKeyListenerList componentKeyListeners = new ComponentKeyListenerList();
    private ComponentDataListenerList componentDataListeners = new ComponentDataListenerList();
    private static Component focusedComponent = null;
    private static ComponentClassListenerList componentClassListeners = new ComponentClassListenerList();

    public String getAutomationID() {
        return this.automationID;
    }

    public void setAutomationID(String string) {
        String string2 = this.automationID;
        this.automationID = string;
        if (this.getDisplay() != null) {
            if (string2 != null) {
                Automation.remove(string2);
            }
            if (string != null) {
                Automation.add(string, this);
            }
        }
    }

    protected Skin getSkin() {
        return this.skin;
    }

    protected void setSkin(Skin skin) {
        if (skin == null) {
            throw new IllegalArgumentException("skin is null.");
        }
        if (this.skin != null) {
            throw new IllegalStateException("Skin is already installed.");
        }
        this.skin = skin;
        this.styles = new BeanDictionary((Object)skin);
        skin.install(this);
        this.invalidate();
        this.repaint();
    }

    protected final void installThemeSkin(Class<? extends Component> clazz) {
        Class<?> clazz2 = this.getClass();
        Theme theme = Theme.getTheme();
        Class<? extends Skin> clazz3 = theme.getSkinClass(clazz2);
        while (clazz3 == null && clazz2 != clazz && clazz2 != Component.class) {
            if ((clazz2 = clazz2.getSuperclass()) == Component.class) continue;
            clazz3 = theme.getSkinClass(clazz2);
        }
        if (clazz2 == Component.class) {
            throw new IllegalArgumentException(clazz.getName() + " is not an ancestor of " + this.getClass().getName());
        }
        if (clazz3 == null) {
            throw new IllegalArgumentException("No skin mapping for " + clazz.getName() + " found.");
        }
        if (clazz2 == clazz) {
            HashMap hashMap = new HashMap();
            for (String string : this.customStyles) {
                hashMap.put((Object)string, this.styleDictionary.get(string));
            }
            try {
                this.setSkin(clazz3.newInstance());
            }
            catch (InstantiationException instantiationException) {
                throw new IllegalArgumentException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException(illegalAccessException);
            }
            this.setStyles((Map<String, ?>)hashMap);
        }
    }

    public Container getParent() {
        return this.parent;
    }

    protected void setParent(Container container) {
        if (container == null && this.isFocused()) {
            Component.clearFocus();
        }
        Container container2 = this.parent;
        this.parent = container;
        if (container2 != null) {
            container2.descendantRemoved(this);
        }
        if (container != null) {
            container.descendantAdded(this);
        }
        this.componentListeners.parentChanged(this, container2);
    }

    public Window getWindow() {
        Component component;
        for (component = this; component != null && !(component instanceof Window); component = component.getParent()) {
        }
        return (Window)component;
    }

    public Display getDisplay() {
        Component component;
        for (component = this; component != null && !(component instanceof Display); component = component.getParent()) {
        }
        return (Display)component;
    }

    @Override
    public int getWidth() {
        return this.skin.getWidth();
    }

    public void setWidth(int n) {
        this.setSize(n, this.getHeight());
    }

    @Override
    public int getHeight() {
        return this.skin.getHeight();
    }

    public void setHeight(int n) {
        this.setSize(this.getWidth(), n);
    }

    public Dimensions getSize() {
        return new Dimensions(this.getWidth(), this.getHeight());
    }

    public final void setSize(Dimensions dimensions) {
        if (dimensions == null) {
            throw new IllegalArgumentException("size is null.");
        }
        this.setSize(dimensions.width, dimensions.height);
    }

    @Override
    public void setSize(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("width is negative.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("height is negative.");
        }
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (n != n3 || n2 != n4) {
            this.invalidate();
            if (this.parent != null) {
                this.parent.repaint(this.getDecoratedBounds());
            }
            this.skin.setSize(n, n2);
            if (this.parent != null) {
                this.parent.repaint(this.getDecoratedBounds());
            }
            this.componentListeners.sizeChanged(this, n3, n4);
        }
    }

    public int getPreferredWidth() {
        return this.getPreferredWidth(-1);
    }

    @Override
    public int getPreferredWidth(int n) {
        int n2;
        if (this.preferredWidth == -1) {
            if (n == -1) {
                n2 = this.getPreferredSize().width;
            } else if (this.preferredSize != null && this.preferredSize.height == n) {
                n2 = this.preferredSize.width;
            } else {
                Limits limits = new Limits(this.minimumPreferredWidth, this.maximumPreferredWidth);
                n2 = limits.limit(this.skin.getPreferredWidth(n));
            }
        } else {
            n2 = this.preferredWidth;
        }
        return n2;
    }

    public void setPreferredWidth(int n) {
        this.setPreferredSize(n, this.preferredHeight);
    }

    public boolean isPreferredWidthSet() {
        return this.preferredWidth != -1;
    }

    public int getPreferredHeight() {
        return this.getPreferredHeight(-1);
    }

    @Override
    public int getPreferredHeight(int n) {
        int n2;
        if (this.preferredHeight == -1) {
            if (n == -1) {
                n2 = this.getPreferredSize().height;
            } else if (this.preferredSize != null && this.preferredSize.width == n) {
                n2 = this.preferredSize.height;
            } else {
                Limits limits = new Limits(this.minimumPreferredHeight, this.maximumPreferredHeight);
                n2 = limits.limit(this.skin.getPreferredHeight(n));
            }
        } else {
            n2 = this.preferredHeight;
        }
        return n2;
    }

    public void setPreferredHeight(int n) {
        this.setPreferredSize(this.preferredWidth, n);
    }

    public boolean isPreferredHeightSet() {
        return this.preferredHeight != -1;
    }

    @Override
    public Dimensions getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = this.preferredWidth == -1 && this.preferredHeight == -1 ? this.skin.getPreferredSize() : (this.preferredWidth == -1 ? new Dimensions(this.skin.getPreferredWidth(this.preferredHeight), this.preferredHeight) : (this.preferredHeight == -1 ? new Dimensions(this.preferredWidth, this.skin.getPreferredHeight(this.preferredWidth)) : new Dimensions(this.preferredWidth, this.preferredHeight)));
            Limits limits = new Limits(this.minimumPreferredWidth, this.maximumPreferredWidth);
            Limits limits2 = new Limits(this.minimumPreferredHeight, this.maximumPreferredHeight);
            this.preferredSize = new Dimensions(limits.limit(this.preferredSize.width), limits2.limit(this.preferredSize.height));
        }
        return this.preferredSize;
    }

    public final void setPreferredSize(Dimensions dimensions) {
        if (dimensions == null) {
            throw new IllegalArgumentException("preferredSize is null.");
        }
        this.setPreferredSize(dimensions.width, dimensions.height);
    }

    public void setPreferredSize(int n, int n2) {
        if (n < -1) {
            throw new IllegalArgumentException(n + " is not a valid value for preferredWidth.");
        }
        if (n2 < -1) {
            throw new IllegalArgumentException(n2 + " is not a valid value for preferredHeight.");
        }
        int n3 = this.preferredWidth;
        int n4 = this.preferredHeight;
        if (n3 != n || n4 != n2) {
            this.preferredWidth = n;
            this.preferredHeight = n2;
            this.invalidate();
            this.componentListeners.preferredSizeChanged(this, n3, n4);
        }
    }

    public boolean isPreferredSizeSet() {
        return this.isPreferredWidthSet() && this.isPreferredHeightSet();
    }

    public int getMinimumPreferredWidth() {
        return this.minimumPreferredWidth;
    }

    public void setMinimumPreferredWidth(int n) {
        this.setPreferredWidthLimits(n, this.getMaximumPreferredWidth());
    }

    public int getMaximumPreferredWidth() {
        return this.maximumPreferredWidth;
    }

    public void setMaximumPreferredWidth(int n) {
        this.setPreferredWidthLimits(this.getMinimumPreferredWidth(), n);
    }

    public Limits getPreferredWidthLimits() {
        return new Limits(this.minimumPreferredWidth, this.maximumPreferredWidth);
    }

    public void setPreferredWidthLimits(int n, int n2) {
        int n3 = this.minimumPreferredWidth;
        int n4 = this.maximumPreferredWidth;
        if (n3 != n || n4 != n2) {
            if (n < 0) {
                throw new IllegalArgumentException("minimumPreferredWidth is negative.");
            }
            if (n > n2) {
                throw new IllegalArgumentException("minimumPreferredWidth > maximumPreferredWidth");
            }
            this.minimumPreferredWidth = n;
            this.maximumPreferredWidth = n2;
            this.invalidate();
            this.componentListeners.preferredWidthLimitsChanged(this, n3, n4);
        }
    }

    public final void setPreferredWidthLimits(Limits limits) {
        if (limits == null) {
            throw new IllegalArgumentException("preferredWidthLimits is null.");
        }
        this.setPreferredWidthLimits(limits.min, limits.max);
    }

    public int getMinimumPreferredHeight() {
        return this.minimumPreferredHeight;
    }

    public void setMinimumPreferredHeight(int n) {
        this.setPreferredHeightLimits(n, this.getMaximumPreferredHeight());
    }

    public int getMaximumPreferredHeight() {
        return this.maximumPreferredHeight;
    }

    public void setMaximumPreferredHeight(int n) {
        this.setPreferredHeightLimits(this.getMinimumPreferredHeight(), n);
    }

    public Limits getPreferredHeightLimits() {
        return new Limits(this.minimumPreferredHeight, this.maximumPreferredHeight);
    }

    public void setPreferredHeightLimits(int n, int n2) {
        int n3 = this.minimumPreferredHeight;
        int n4 = this.maximumPreferredHeight;
        if (n3 != n || n4 != n2) {
            if (n < 0) {
                throw new IllegalArgumentException("minimumPreferredHeight is negative.");
            }
            if (n > n2) {
                throw new IllegalArgumentException("minimumPreferredHeight > maximumPreferredHeight");
            }
            this.minimumPreferredHeight = n;
            this.maximumPreferredHeight = n2;
            this.invalidate();
            this.componentListeners.preferredHeightLimitsChanged(this, n3, n4);
        }
    }

    public final void setPreferredHeightLimits(Limits limits) {
        if (limits == null) {
            throw new IllegalArgumentException("preferredHeightLimits is null.");
        }
        this.setPreferredHeightLimits(limits.min, limits.max);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.setLocation(n, this.getY());
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.setLocation(this.getX(), n);
    }

    public Point getLocation() {
        return new Point(this.getX(), this.getY());
    }

    public void setLocation(int n, int n2) {
        int n3 = this.x;
        int n4 = this.y;
        if (n3 != n || n4 != n2) {
            if (this.parent != null) {
                this.parent.repaint(this.getDecoratedBounds());
            }
            this.x = n;
            this.y = n2;
            if (this.parent != null) {
                this.parent.repaint(this.getDecoratedBounds());
            }
            this.componentListeners.locationChanged(this, n3, n4);
        }
    }

    public final void setLocation(Point point) {
        if (point == null) {
            throw new IllegalArgumentException("location cannot be null.");
        }
        this.setLocation(point.x, point.y);
    }

    @Override
    public int getBaseline() {
        return this.skin.getBaseline();
    }

    @Override
    public int getBaseline(int n, int n2) {
        return this.skin.getBaseline(n, n2);
    }

    public Bounds getBounds() {
        return new Bounds(this.x, this.y, this.getWidth(), this.getHeight());
    }

    public Bounds getDecoratedBounds() {
        Bounds bounds = new Bounds(0, 0, this.getWidth(), this.getHeight());
        for (Decorator decorator : this.decorators) {
            bounds = bounds.union(decorator.getBounds(this));
        }
        return new Bounds(bounds.x + this.x, bounds.y + this.y, bounds.width, bounds.height);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            if (!bl) {
                if (this.isFocused()) {
                    Component.clearFocus();
                }
                if (this.mouseOver) {
                    this.mouseOut();
                }
            }
            if (this.parent != null) {
                this.parent.repaint(this.getDecoratedBounds());
            }
            this.visible = bl;
            if (this.parent != null) {
                this.parent.repaint(this.getDecoratedBounds());
            }
            if (bl && !this.valid) {
                this.validate();
            }
            if (this.parent != null) {
                this.parent.invalidate();
            }
            this.componentListeners.visibleChanged(this);
        }
    }

    public DecoratorSequence getDecorators() {
        return this.decoratorSequence;
    }

    public Point mapPointToAncestor(Container container, int n, int n2) {
        if (container == null) {
            throw new IllegalArgumentException("ancestor is null");
        }
        Point point = null;
        Component component = this;
        while (component != null && point == null) {
            if (component == container) {
                point = new Point(n, n2);
                continue;
            }
            n += component.x;
            n2 += component.y;
            component = component.getParent();
        }
        return point;
    }

    public Point mapPointFromAncestor(Container container, int n, int n2) {
        if (container == null) {
            throw new IllegalArgumentException("ancestor is null");
        }
        Point point = null;
        Component component = this;
        while (component != null && point == null) {
            if (component == container) {
                point = new Point(n, n2);
                continue;
            }
            n -= component.x;
            n2 -= component.y;
            component = component.getParent();
        }
        return point;
    }

    public boolean isShowing() {
        boolean bl;
        Container container;
        Component component = this;
        for (bl = true; component != null && bl; bl &= component.isVisible() && (container != null || component instanceof Display)) {
            container = component.getParent();
            component = container;
        }
        return bl;
    }

    public Bounds getVisibleArea() {
        return this.getVisibleArea(0, 0, this.getWidth(), this.getHeight());
    }

    public Bounds getVisibleArea(Bounds bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException("area is null.");
        }
        return this.getVisibleArea(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public Bounds getVisibleArea(int n, int n2, int n3, int n4) {
        Bounds bounds = null;
        int n5 = n2;
        int n6 = n;
        int n7 = n2 + n4 - 1;
        int n8 = n + n3 - 1;
        int n9 = 0;
        int n10 = 0;
        for (Component component = this; component != null && component.isVisible(); component = component.getParent()) {
            int n11 = 0;
            int n12 = 0;
            int n13 = component.getHeight() - 1;
            int n14 = component.getWidth() - 1;
            if (component instanceof Viewport) {
                Viewport viewport = (Viewport)component;
                Bounds bounds2 = viewport.getViewportBounds();
                n11 = bounds2.y;
                n12 = bounds2.x;
                n13 = bounds2.y + bounds2.height - 1;
                n14 = bounds2.x + bounds2.width - 1;
            }
            n5 = component.y + Math.max(n5, n11);
            n6 = component.x + Math.max(n6, n12);
            n7 = component.y + Math.max(Math.min(n7, n13), -1);
            n8 = component.x + Math.max(Math.min(n8, n14), -1);
            n9 += component.x;
            n10 += component.y;
            if (!(component instanceof Display)) continue;
            bounds = new Bounds(n6 - n9, n5 - n10, n8 - n6 + 1, n7 - n5 + 1);
        }
        return bounds;
    }

    public void scrollAreaToVisible(Bounds bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException("area is null.");
        }
        this.scrollAreaToVisible(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void scrollAreaToVisible(int n, int n2, int n3, int n4) {
        for (Component component = this; component != null; component = component.getParent()) {
            if (component instanceof Viewport) {
                Viewport viewport = (Viewport)component;
                Component component2 = viewport.getView();
                try {
                    int n5;
                    int n6;
                    Bounds bounds = viewport.getViewportBounds();
                    int n7 = 0;
                    int n8 = n - bounds.x;
                    int n9 = n + n3 - (bounds.x + bounds.width);
                    if ((n8 & n9) < 0) {
                        n7 = Math.max(n8, n9);
                    } else if ((n8 | n9) > 0) {
                        n7 = Math.min(n8, n9);
                    }
                    if (n7 != 0) {
                        n6 = component2 == null ? 0 : component2.getWidth();
                        n5 = viewport.getScrollLeft();
                        n5 = Math.min(Math.max(n5 + n7, 0), Math.max(n6 - bounds.width, 0));
                        viewport.setScrollLeft(n5);
                        n -= n7;
                    }
                    n = Math.max(n, bounds.x);
                    n3 = Math.min(n3, Math.max(bounds.width - (n - bounds.x), 0));
                    n6 = 0;
                    n5 = n2 - bounds.y;
                    int n10 = n2 + n4 - (bounds.y + bounds.height);
                    if ((n5 & n10) < 0) {
                        n6 = Math.max(n5, n10);
                    } else if ((n5 | n10) > 0) {
                        n6 = Math.min(n5, n10);
                    }
                    if (n6 != 0) {
                        int n11 = component2 == null ? 0 : component2.getHeight();
                        int n12 = viewport.getScrollTop();
                        n12 = Math.min(Math.max(n12 + n6, 0), Math.max(n11 - bounds.height, 0));
                        viewport.setScrollTop(n12);
                        n2 -= n6;
                    }
                    n2 = Math.max(n2, bounds.y);
                    n4 = Math.min(n4, Math.max(bounds.height - (n2 - bounds.y), 0));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            n += component.x;
            n2 += component.y;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate() {
        this.valid = false;
        this.preferredSize = null;
        if (this.parent != null) {
            this.parent.invalidate();
        }
    }

    public void validate() {
        if (!this.valid && this.visible) {
            this.layout();
            this.valid = true;
        }
    }

    protected void layout() {
        this.skin.layout();
    }

    public final void repaint() {
        this.repaint(false);
    }

    public final void repaint(boolean bl) {
        this.repaint(0, 0, this.getWidth(), this.getHeight(), bl);
    }

    public final void repaint(Bounds bounds) {
        this.repaint(bounds, false);
    }

    public final void repaint(Bounds bounds, boolean bl) {
        if (bounds == null) {
            throw new IllegalArgumentException("area is null.");
        }
        this.repaint(bounds.x, bounds.y, bounds.width, bounds.height, bl);
    }

    public final void repaint(int n, int n2, int n3, int n4) {
        this.repaint(n, n2, n3, n4, false);
    }

    public void repaint(int n, int n2, int n3, int n4, boolean bl) {
        if (this.parent != null) {
            int n5 = n2;
            int n6 = n;
            int n7 = n5 + n4 - 1;
            int n8 = n6 + n3 - 1;
            n = Math.max(n6, 0);
            n2 = Math.max(n5, 0);
            n3 = Math.min(n8, this.getWidth() - 1) - n + 1;
            n4 = Math.min(n7, this.getHeight() - 1) - n2 + 1;
            if (n3 > 0 && n4 > 0) {
                this.parent.repaint(n + this.x, n2 + this.y, n3, n4, bl);
                for (Decorator decorator : this.decorators) {
                    AffineTransform affineTransform = decorator.getTransform(this);
                    if (affineTransform.isIdentity()) continue;
                    Rectangle rectangle = new Rectangle(n, n2, n3, n4);
                    Shape shape = affineTransform.createTransformedShape(rectangle);
                    Bounds bounds = new Bounds(shape.getBounds());
                    bounds = bounds.intersect(decorator.getBounds(this));
                    this.parent.repaint(bounds.x + this.x, bounds.y + this.y, bounds.width, bounds.height, bl);
                }
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        this.skin.paint(graphics2D);
    }

    public Graphics2D getGraphics() {
        Component component;
        Graphics2D graphics2D = null;
        int n = 0;
        int n2 = 0;
        for (component = this; component != null && component.isVisible() && !(component instanceof Display); component = component.getParent()) {
            n += component.x;
            n2 += component.y;
        }
        if (component != null && component.isVisible()) {
            Display display = (Display)component;
            graphics2D = (Graphics2D)display.getDisplayHost().getGraphics();
            double d = display.getDisplayHost().getScale();
            if (d != 1.0) {
                graphics2D.scale(d, d);
            }
            graphics2D.translate(n, n2);
            graphics2D.clipRect(0, 0, this.getWidth(), this.getHeight());
        }
        return graphics2D;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            if (!bl) {
                if (this.isFocused()) {
                    Component.clearFocus();
                }
                if (this.mouseOver) {
                    this.mouseOut();
                }
            }
            this.enabled = bl;
            this.componentStateListeners.enabledChanged(this);
        }
    }

    public boolean isBlocked() {
        boolean bl = false;
        for (Component component = this; component != null && !bl; component = component.getParent()) {
            bl = !component.isEnabled();
        }
        return bl;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) {
        Cursor cursor2 = this.cursor;
        if (cursor2 != cursor) {
            this.cursor = cursor;
            if (this.mouseOver) {
                Mouse.setCursor(this);
            }
            this.componentListeners.cursorChanged(this, cursor2);
        }
    }

    public final void setCursor(String string) {
        if (string == null) {
            this.setCursor((Cursor)null);
        } else {
            this.setCursor(Cursor.valueOf(string.toUpperCase()));
        }
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    public void setTooltipText(String string) {
        String string2 = this.tooltipText;
        if (string2 != string) {
            this.tooltipText = string;
            this.componentListeners.tooltipTextChanged(this, string2);
        }
    }

    public boolean isOpaque() {
        return this.skin.isOpaque();
    }

    public boolean isFocusable() {
        return this.skin.isFocusable() && this.isShowing() && this.isEnabled();
    }

    public boolean isFocused() {
        return focusedComponent == this;
    }

    private void setFocused(boolean bl, Component component) {
        if (bl) {
            this.parent.descendantGainedFocus(this, component);
        } else {
            this.parent.descendantLostFocus(this);
        }
        this.componentStateListeners.focusedChanged(this, component);
    }

    public boolean requestFocus() {
        if (this.isFocusable()) {
            Component.setFocusedComponent(this);
        }
        return this.isFocused();
    }

    public Component transferFocus(Direction direction) {
        Component component = null;
        Container container = this.getParent();
        if (container != null) {
            component = container.transferFocus(this, direction);
        }
        return component;
    }

    public static Component getFocusedComponent() {
        return focusedComponent;
    }

    private static void setFocusedComponent(Component component) {
        Component component2 = focusedComponent;
        if (component2 != component) {
            focusedComponent = component;
            if (component2 != null) {
                component2.setFocused(false, component);
            }
            if (component != null) {
                component.setFocused(true, component2);
            }
            componentClassListeners.focusedComponentChanged(component2);
        }
    }

    public static void clearFocus() {
        Component.setFocusedComponent(null);
    }

    public void load(Dictionary<String, ?> dictionary) {
    }

    public final void load(Object object) {
        this.load((Dictionary<String, ?>)new BeanDictionary(object));
    }

    public void store(Dictionary<String, ?> dictionary) {
    }

    public final void store(Object object) {
        this.store((Dictionary<String, ?>)new BeanDictionary(object));
    }

    public void clear() {
    }

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public void setDragSource(DragSource dragSource) {
        DragSource dragSource2 = this.dragSource;
        if (dragSource2 != dragSource) {
            this.dragSource = dragSource;
            this.componentListeners.dragSourceChanged(this, dragSource2);
        }
    }

    public DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public void setDropTarget(DropTarget dropTarget) {
        DropTarget dropTarget2 = this.dropTarget;
        if (dropTarget2 != dropTarget) {
            this.dropTarget = dropTarget;
            this.componentListeners.dropTargetChanged(this, dropTarget2);
        }
    }

    public MenuHandler getMenuHandler() {
        return this.menuHandler;
    }

    public void setMenuHandler(MenuHandler menuHandler) {
        MenuHandler menuHandler2 = this.menuHandler;
        if (menuHandler2 != menuHandler) {
            this.menuHandler = menuHandler;
            this.componentListeners.menuHandlerChanged(this, menuHandler2);
        }
    }

    public UserDataDictionary getUserData() {
        return this.userDataDictionary;
    }

    public final StyleDictionary getStyles() {
        return this.styleDictionary;
    }

    public void setStyles(Map<String, ?> map) {
        if (map == null) {
            throw new IllegalArgumentException("styles is null.");
        }
        for (String string : map) {
            this.getStyles().put(string, map.get((Object)string));
        }
    }

    public void setStyles(URL uRL) throws IOException, SerializationException {
        if (uRL == null) {
            throw new IllegalArgumentException("styles is null.");
        }
        Map map = (Map)ApplicationContext.getResourceCache().get(uRL);
        if (map == null) {
            JSONSerializer jSONSerializer = new JSONSerializer();
            map = (Map)jSONSerializer.readObject(uRL.openStream());
            ApplicationContext.getResourceCache().put(uRL, (Object)map);
        }
        this.setStyles(map);
    }

    public void setStyles(String string) {
        if (string == null) {
            throw new IllegalArgumentException("styles is null.");
        }
        try {
            if (string.charAt(0) == '{') {
                this.setStyles(JSONSerializer.parseMap((String)string));
            } else {
                this.setStyles(ThreadUtilities.getClassLoader().getResource(string));
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        catch (SerializationException serializationException) {
            throw new IllegalArgumentException(serializationException);
        }
    }

    protected Object getAttributes() {
        return this.attributes;
    }

    protected void setAttributes(Object object) {
        this.attributes = object;
    }

    public void reenterMouse() {
        if (this.isMouseOver()) {
            this.mouseOut();
            Display display = this.getDisplay();
            Point point = display.getMouseLocation();
            point = this.mapPointFromAncestor(display, this.x, this.y);
            this.mouseMove(point.x, point.y);
        }
    }

    protected boolean mouseMove(int n, int n2) {
        boolean bl = false;
        if (this.isEnabled()) {
            bl = this.componentMouseListeners.mouseMove(this, n, n2);
        }
        return bl;
    }

    protected void mouseOver() {
        if (this.isEnabled()) {
            this.mouseOver = true;
            this.componentMouseListeners.mouseOver(this);
        }
    }

    protected void mouseOut() {
        if (this.isEnabled()) {
            this.mouseOver = false;
            this.componentMouseListeners.mouseOut(this);
        }
    }

    protected boolean mouseDown(Mouse.Button button, int n, int n2) {
        boolean bl = false;
        if (this.isEnabled()) {
            bl = this.componentMouseButtonListeners.mouseDown(this, button, n, n2);
        }
        return bl;
    }

    protected boolean mouseUp(Mouse.Button button, int n, int n2) {
        boolean bl = false;
        if (this.isEnabled()) {
            bl = this.componentMouseButtonListeners.mouseUp(this, button, n, n2);
        }
        return bl;
    }

    protected boolean mouseClick(Mouse.Button button, int n, int n2, int n3) {
        boolean bl = false;
        if (this.isEnabled()) {
            bl = this.componentMouseButtonListeners.mouseClick(this, button, n, n2, n3);
        }
        return bl;
    }

    protected boolean mouseWheel(Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (this.isEnabled()) {
            bl = this.componentMouseWheelListeners.mouseWheel(this, scrollType, n, n2, n3, n4);
        }
        return bl;
    }

    protected boolean keyTyped(char c) {
        boolean bl = false;
        if (this.isEnabled() && !(bl = this.componentKeyListeners.keyTyped(this, c)) && this.parent != null) {
            bl = this.parent.keyTyped(c);
        }
        return bl;
    }

    protected boolean keyPressed(int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = false;
        if (this.isEnabled() && !(bl = this.componentKeyListeners.keyPressed(this, n, keyLocation)) && this.parent != null) {
            bl = this.parent.keyPressed(n, keyLocation);
        }
        return bl;
    }

    protected boolean keyReleased(int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = false;
        if (this.isEnabled() && !(bl = this.componentKeyListeners.keyReleased(this, n, keyLocation)) && this.parent != null) {
            bl = this.parent.keyReleased(n, keyLocation);
        }
        return bl;
    }

    public String toString() {
        String string = this.getClass().getName();
        if (this.automationID != null) {
            string = string + "#" + this.automationID;
        }
        return string;
    }

    public ListenerList<ComponentListener> getComponentListeners() {
        return this.componentListeners;
    }

    public ListenerList<ComponentStateListener> getComponentStateListeners() {
        return this.componentStateListeners;
    }

    public ListenerList<ComponentDecoratorListener> getComponentDecoratorListeners() {
        return this.componentDecoratorListeners;
    }

    public ListenerList<ComponentMouseListener> getComponentMouseListeners() {
        return this.componentMouseListeners;
    }

    public ListenerList<ComponentMouseButtonListener> getComponentMouseButtonListeners() {
        return this.componentMouseButtonListeners;
    }

    public ListenerList<ComponentMouseWheelListener> getComponentMouseWheelListeners() {
        return this.componentMouseWheelListeners;
    }

    public ListenerList<ComponentKeyListener> getComponentKeyListeners() {
        return this.componentKeyListeners;
    }

    public ListenerList<ComponentDataListener> getComponentDataListeners() {
        return this.componentDataListeners;
    }

    public static ListenerList<ComponentClassListener> getComponentClassListeners() {
        return componentClassListeners;
    }

    private static class ComponentClassListenerList
    extends ListenerList<ComponentClassListener>
    implements ComponentClassListener {
        private ComponentClassListenerList() {
        }

        @Override
        public void focusedComponentChanged(Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentClassListener componentClassListener = (ComponentClassListener)iterator.next();
                componentClassListener.focusedComponentChanged(component);
            }
        }
    }

    private static class ComponentDataListenerList
    extends ListenerList<ComponentDataListener>
    implements ComponentDataListener {
        private ComponentDataListenerList() {
        }

        @Override
        public void valueAdded(Component component, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentDataListener componentDataListener = (ComponentDataListener)iterator.next();
                componentDataListener.valueAdded(component, string);
            }
        }

        @Override
        public void valueUpdated(Component component, String string, Object object) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentDataListener componentDataListener = (ComponentDataListener)iterator.next();
                componentDataListener.valueUpdated(component, string, object);
            }
        }

        @Override
        public void valueRemoved(Component component, String string, Object object) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentDataListener componentDataListener = (ComponentDataListener)iterator.next();
                componentDataListener.valueRemoved(component, string, object);
            }
        }
    }

    private static class ComponentKeyListenerList
    extends ListenerList<ComponentKeyListener>
    implements ComponentKeyListener {
        private ComponentKeyListenerList() {
        }

        @Override
        public boolean keyTyped(Component component, char c) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentKeyListener componentKeyListener = (ComponentKeyListener)iterator.next();
                bl |= componentKeyListener.keyTyped(component, c);
            }
            return bl;
        }

        @Override
        public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentKeyListener componentKeyListener = (ComponentKeyListener)iterator.next();
                bl |= componentKeyListener.keyPressed(component, n, keyLocation);
            }
            return bl;
        }

        @Override
        public boolean keyReleased(Component component, int n, Keyboard.KeyLocation keyLocation) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentKeyListener componentKeyListener = (ComponentKeyListener)iterator.next();
                bl |= componentKeyListener.keyReleased(component, n, keyLocation);
            }
            return bl;
        }
    }

    private static class ComponentMouseWheelListenerList
    extends ListenerList<ComponentMouseWheelListener>
    implements ComponentMouseWheelListener {
        private ComponentMouseWheelListenerList() {
        }

        @Override
        public boolean mouseWheel(Component component, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentMouseWheelListener componentMouseWheelListener = (ComponentMouseWheelListener)iterator.next();
                bl |= componentMouseWheelListener.mouseWheel(component, scrollType, n, n2, n3, n4);
            }
            return bl;
        }
    }

    private static class ComponentMouseButtonListenerList
    extends ListenerList<ComponentMouseButtonListener>
    implements ComponentMouseButtonListener {
        private ComponentMouseButtonListenerList() {
        }

        @Override
        public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentMouseButtonListener componentMouseButtonListener = (ComponentMouseButtonListener)iterator.next();
                bl |= componentMouseButtonListener.mouseDown(component, button, n, n2);
            }
            return bl;
        }

        @Override
        public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentMouseButtonListener componentMouseButtonListener = (ComponentMouseButtonListener)iterator.next();
                bl |= componentMouseButtonListener.mouseUp(component, button, n, n2);
            }
            return bl;
        }

        @Override
        public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentMouseButtonListener componentMouseButtonListener = (ComponentMouseButtonListener)iterator.next();
                bl |= componentMouseButtonListener.mouseClick(component, button, n, n2, n3);
            }
            return bl;
        }
    }

    private static class ComponentMouseListenerList
    extends ListenerList<ComponentMouseListener>
    implements ComponentMouseListener {
        private ComponentMouseListenerList() {
        }

        @Override
        public boolean mouseMove(Component component, int n, int n2) {
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentMouseListener componentMouseListener = (ComponentMouseListener)iterator.next();
                bl |= componentMouseListener.mouseMove(component, n, n2);
            }
            return bl;
        }

        @Override
        public void mouseOver(Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentMouseListener componentMouseListener = (ComponentMouseListener)iterator.next();
                componentMouseListener.mouseOver(component);
            }
        }

        @Override
        public void mouseOut(Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentMouseListener componentMouseListener = (ComponentMouseListener)iterator.next();
                componentMouseListener.mouseOut(component);
            }
        }
    }

    private static class ComponentDecoratorListenerList
    extends ListenerList<ComponentDecoratorListener>
    implements ComponentDecoratorListener {
        private ComponentDecoratorListenerList() {
        }

        @Override
        public void decoratorInserted(Component component, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentDecoratorListener componentDecoratorListener = (ComponentDecoratorListener)iterator.next();
                componentDecoratorListener.decoratorInserted(component, n);
            }
        }

        @Override
        public void decoratorUpdated(Component component, int n, Decorator decorator) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentDecoratorListener componentDecoratorListener = (ComponentDecoratorListener)iterator.next();
                componentDecoratorListener.decoratorUpdated(component, n, decorator);
            }
        }

        @Override
        public void decoratorsRemoved(Component component, int n, Sequence<Decorator> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentDecoratorListener componentDecoratorListener = (ComponentDecoratorListener)iterator.next();
                componentDecoratorListener.decoratorsRemoved(component, n, sequence);
            }
        }
    }

    private static class ComponentStateListenerList
    extends ListenerList<ComponentStateListener>
    implements ComponentStateListener {
        private ComponentStateListenerList() {
        }

        @Override
        public void enabledChanged(Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentStateListener componentStateListener = (ComponentStateListener)iterator.next();
                componentStateListener.enabledChanged(component);
            }
        }

        @Override
        public void focusedChanged(Component component, Component component2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentStateListener componentStateListener = (ComponentStateListener)iterator.next();
                componentStateListener.focusedChanged(component, component2);
            }
        }
    }

    private static class ComponentListenerList
    extends ListenerList<ComponentListener>
    implements ComponentListener {
        private ComponentListenerList() {
        }

        @Override
        public void parentChanged(Component component, Container container) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentListener componentListener = (ComponentListener)iterator.next();
                componentListener.parentChanged(component, container);
            }
        }

        @Override
        public void sizeChanged(Component component, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentListener componentListener = (ComponentListener)iterator.next();
                componentListener.sizeChanged(component, n, n2);
            }
        }

        @Override
        public void preferredSizeChanged(Component component, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentListener componentListener = (ComponentListener)iterator.next();
                componentListener.preferredSizeChanged(component, n, n2);
            }
        }

        @Override
        public void preferredWidthLimitsChanged(Component component, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentListener componentListener = (ComponentListener)iterator.next();
                componentListener.preferredWidthLimitsChanged(component, n, n2);
            }
        }

        @Override
        public void preferredHeightLimitsChanged(Component component, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentListener componentListener = (ComponentListener)iterator.next();
                componentListener.preferredHeightLimitsChanged(component, n, n2);
            }
        }

        @Override
        public void locationChanged(Component component, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentListener componentListener = (ComponentListener)iterator.next();
                componentListener.locationChanged(component, n, n2);
            }
        }

        @Override
        public void visibleChanged(Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentListener componentListener = (ComponentListener)iterator.next();
                componentListener.visibleChanged(component);
            }
        }

        @Override
        public void styleUpdated(Component component, String string, Object object) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentListener componentListener = (ComponentListener)iterator.next();
                componentListener.styleUpdated(component, string, object);
            }
        }

        @Override
        public void cursorChanged(Component component, Cursor cursor) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentListener componentListener = (ComponentListener)iterator.next();
                componentListener.cursorChanged(component, cursor);
            }
        }

        @Override
        public void tooltipTextChanged(Component component, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentListener componentListener = (ComponentListener)iterator.next();
                componentListener.tooltipTextChanged(component, string);
            }
        }

        @Override
        public void dragSourceChanged(Component component, DragSource dragSource) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentListener componentListener = (ComponentListener)iterator.next();
                componentListener.dragSourceChanged(component, dragSource);
            }
        }

        @Override
        public void dropTargetChanged(Component component, DropTarget dropTarget) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentListener componentListener = (ComponentListener)iterator.next();
                componentListener.dropTargetChanged(component, dropTarget);
            }
        }

        @Override
        public void menuHandlerChanged(Component component, MenuHandler menuHandler) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ComponentListener componentListener = (ComponentListener)iterator.next();
                componentListener.menuHandlerChanged(component, menuHandler);
            }
        }
    }

    public final class DecoratorSequence
    implements Sequence<Decorator>,
    Iterable<Decorator> {
        public int add(Decorator decorator) {
            int n = this.getLength();
            this.insert(decorator, n);
            return n;
        }

        public void insert(Decorator decorator, int n) {
            if (decorator == null) {
                throw new IllegalArgumentException("decorator is null");
            }
            if (Component.this.parent != null) {
                Component.this.parent.repaint(Component.this.getDecoratedBounds());
            }
            Component.this.decorators.insert((Object)decorator, n);
            if (Component.this.parent != null) {
                Component.this.parent.repaint(Component.this.getDecoratedBounds());
            }
            Component.this.componentDecoratorListeners.decoratorInserted(Component.this, n);
        }

        public Decorator update(int n, Decorator decorator) {
            if (decorator == null) {
                throw new IllegalArgumentException("decorator is null.");
            }
            if (Component.this.parent != null) {
                Component.this.parent.repaint(Component.this.getDecoratedBounds());
            }
            Decorator decorator2 = (Decorator)Component.this.decorators.update(n, (Object)decorator);
            if (Component.this.parent != null) {
                Component.this.parent.repaint(Component.this.getDecoratedBounds());
            }
            Component.this.componentDecoratorListeners.decoratorUpdated(Component.this, n, decorator2);
            return decorator2;
        }

        public int remove(Decorator decorator) {
            int n = this.indexOf(decorator);
            if (n != -1) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<Decorator> remove(int n, int n2) {
            if (n2 > 0 && Component.this.parent != null) {
                Component.this.parent.repaint(Component.this.getDecoratedBounds());
            }
            Sequence sequence = Component.this.decorators.remove(n, n2);
            if (n2 > 0) {
                if (Component.this.parent != null) {
                    Component.this.parent.repaint(Component.this.getDecoratedBounds());
                }
                Component.this.componentDecoratorListeners.decoratorsRemoved(Component.this, n, (Sequence<Decorator>)sequence);
            }
            return sequence;
        }

        public Sequence<Decorator> removeAll() {
            return this.remove(0, this.getLength());
        }

        public Decorator get(int n) {
            return (Decorator)Component.this.decorators.get(n);
        }

        public int indexOf(Decorator decorator) {
            return Component.this.decorators.indexOf((Object)decorator);
        }

        public int getLength() {
            return Component.this.decorators.getLength();
        }

        @Override
        public Iterator<Decorator> iterator() {
            return new ImmutableIterator((Iterator)Component.this.decorators.iterator());
        }
    }

    public final class UserDataDictionary
    implements Dictionary<String, Object>,
    Iterable<String> {
        private UserDataDictionary() {
        }

        public Object get(String string) {
            return Component.this.userData.get((Object)string);
        }

        public Object put(String string, Object object) {
            boolean bl = Component.this.userData.containsKey((Object)string);
            Object object2 = Component.this.userData.put((Object)string, object);
            if (bl) {
                Component.this.componentDataListeners.valueUpdated(Component.this, string, object2);
            } else {
                Component.this.componentDataListeners.valueAdded(Component.this, string);
            }
            return object2;
        }

        public Object remove(String string) {
            Object object;
            if (Component.this.userData.containsKey((Object)string)) {
                object = Component.this.userData.remove((Object)string);
                Component.this.componentDataListeners.valueRemoved(Component.this, string, object);
            } else {
                object = null;
            }
            return object;
        }

        public boolean containsKey(String string) {
            return Component.this.userData.containsKey((Object)string);
        }

        @Override
        public Iterator<String> iterator() {
            return new ImmutableIterator(Component.this.userData.iterator());
        }
    }

    public final class StyleDictionary
    implements Dictionary<String, Object>,
    Iterable<String> {
        private StyleDictionary() {
        }

        public Object get(String string) {
            return Component.this.styles.get(string);
        }

        public Object put(String string, Object object) {
            Object object2 = null;
            try {
                object2 = Component.this.styles.put(string, object);
                Component.this.customStyles.add((Object)string);
                Component.this.componentListeners.styleUpdated(Component.this, string, object2);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                System.err.println("\"" + string + "\" is not a valid style for " + Component.this);
            }
            return object2;
        }

        public Object remove(String string) {
            Component.this.customStyles.remove((Object)string);
            return null;
        }

        public boolean containsKey(String string) {
            return Component.this.styles.containsKey(string);
        }

        public boolean isReadOnly(String string) {
            return Component.this.styles.isReadOnly(string);
        }

        public Class<?> getType(String string) {
            return Component.this.styles.getType(string);
        }

        @Override
        public Iterator<String> iterator() {
            return new ImmutableIterator(Component.this.styles.iterator());
        }
    }
}

