/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.Serializable;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;

public final class CornerRadii
implements Serializable {
    private static final long serialVersionUID = -433469769555042467L;
    public final int topLeft;
    public final int topRight;
    public final int bottomLeft;
    public final int bottomRight;
    public static final String TOP_LEFT_KEY = "topLeft";
    public static final String TOP_RIGHT_KEY = "topRight";
    public static final String BOTTOM_LEFT_KEY = "bottomLeft";
    public static final String BOTTOM_RIGHT_KEY = "bottomRight";
    public static final CornerRadii NONE = new CornerRadii(0);

    public CornerRadii(int n) {
        this(n, n, n, n);
    }

    public CornerRadii(CornerRadii cornerRadii) {
        if (cornerRadii == null) {
            throw new IllegalArgumentException("cornerRadii is null.");
        }
        if (cornerRadii.topLeft < 0) {
            throw new IllegalArgumentException("cornerRadii.topLeft is negative.");
        }
        if (cornerRadii.topRight < 0) {
            throw new IllegalArgumentException("cornerRadii.topRight is negative.");
        }
        if (cornerRadii.bottomLeft < 0) {
            throw new IllegalArgumentException("cornerRadii.bottomLeft is negative.");
        }
        if (cornerRadii.bottomRight < 0) {
            throw new IllegalArgumentException("cornerRadii.bottomRight is negative.");
        }
        this.topLeft = cornerRadii.topLeft;
        this.topRight = cornerRadii.topRight;
        this.bottomLeft = cornerRadii.bottomLeft;
        this.bottomRight = cornerRadii.bottomRight;
    }

    public CornerRadii(int n, int n2, int n3, int n4) {
        if (n < 0) {
            throw new IllegalArgumentException("topLeft is negative.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("topRight is negative.");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("bottomLeft is negative.");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("bottomRight is negative.");
        }
        this.topLeft = n;
        this.topRight = n2;
        this.bottomLeft = n3;
        this.bottomRight = n4;
    }

    public CornerRadii(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("cornerRadii is null.");
        }
        if (dictionary.containsKey((Object)TOP_LEFT_KEY)) {
            this.topLeft = (Integer)dictionary.get((Object)TOP_LEFT_KEY);
            if (this.topLeft < 0) {
                throw new IllegalArgumentException("\"topLeft\" is negative.");
            }
        } else {
            this.topLeft = 0;
        }
        if (dictionary.containsKey((Object)TOP_RIGHT_KEY)) {
            this.topRight = (Integer)dictionary.get((Object)TOP_RIGHT_KEY);
            if (this.topRight < 0) {
                throw new IllegalArgumentException("\"topRight\" is negative.");
            }
        } else {
            this.topRight = 0;
        }
        if (dictionary.containsKey((Object)BOTTOM_LEFT_KEY)) {
            this.bottomLeft = (Integer)dictionary.get((Object)BOTTOM_LEFT_KEY);
            if (this.bottomLeft < 0) {
                throw new IllegalArgumentException("\"bottomLeft\" is negative.");
            }
        } else {
            this.bottomLeft = 0;
        }
        if (dictionary.containsKey((Object)BOTTOM_RIGHT_KEY)) {
            this.bottomRight = (Integer)dictionary.get((Object)BOTTOM_RIGHT_KEY);
            if (this.bottomRight < 0) {
                throw new IllegalArgumentException("\"bottomRight\" is negative.");
            }
        } else {
            this.bottomRight = 0;
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof CornerRadii) {
            CornerRadii cornerRadii = (CornerRadii)object;
            bl = this.topLeft == cornerRadii.topLeft && this.topRight == cornerRadii.topRight && this.bottomLeft == cornerRadii.bottomLeft && this.bottomRight == cornerRadii.bottomRight;
        }
        return bl;
    }

    public int hashCode() {
        return this.topLeft * this.topRight ^ this.bottomLeft * this.bottomRight;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.topLeft + ", " + this.topRight + this.bottomLeft + ", " + this.bottomRight + "]";
    }

    public static CornerRadii decode(String string) {
        CornerRadii cornerRadii;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.startsWith("{")) {
            try {
                cornerRadii = new CornerRadii((Dictionary<String, ?>)JSONSerializer.parseMap((String)string));
            }
            catch (SerializationException serializationException) {
                throw new IllegalArgumentException(serializationException);
            }
        } else {
            cornerRadii = new CornerRadii(Integer.parseInt(string));
        }
        return cornerRadii;
    }
}

