/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.immutable.ImmutableMap;
import org.apache.pivot.wtk.Alert;
import org.apache.pivot.wtk.Application;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerListener;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.MessageType;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.media.Picture;

public final class DesktopApplicationContext
extends ApplicationContext {
    private static DesktopApplicationContext applicationContext = null;
    private static String applicationClassName = null;
    private static HashMap<String, String> properties = null;
    private static HostFrame windowedHostFrame = null;
    private static HostFrame fullScreenHostFrame = null;
    private static Runnable updateFrameTitleBarCallback = null;
    private static final String DEFAULT_HOST_FRAME_TITLE = "Apache Pivot";
    private static final String X_ARGUMENT = "x";
    private static final String Y_ARGUMENT = "y";
    private static final String WIDTH_ARGUMENT = "width";
    private static final String HEIGHT_ARGUMENT = "height";
    private static final String CENTER_ARGUMENT = "center";
    private static final String RESIZABLE_ARGUMENT = "resizable";
    private static final String FULL_SCREEN_ARGUMENT = "fullScreen";

    public static boolean exit() {
        boolean bl = false;
        Application application = applicationContext.getApplication();
        if (application != null) {
            try {
                bl = application.shutdown(true);
            }
            catch (Exception exception) {
                DesktopApplicationContext.displayException(exception);
            }
            if (!bl) {
                DesktopApplicationContext.removeApplication(application);
            }
        }
        if (!bl) {
            if (windowedHostFrame.getExtendedState() == 0) {
                try {
                    Preferences preferences = Preferences.userNodeForPackage(DesktopApplicationContext.class);
                    preferences = preferences.node(applicationClassName);
                    preferences.putInt(X_ARGUMENT, windowedHostFrame.getX());
                    preferences.putInt(Y_ARGUMENT, windowedHostFrame.getY());
                    preferences.putInt(WIDTH_ARGUMENT, windowedHostFrame.getWidth());
                    preferences.putInt(HEIGHT_ARGUMENT, windowedHostFrame.getHeight());
                    preferences.flush();
                }
                catch (SecurityException securityException) {
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
            }
            windowedHostFrame.dispose();
            fullScreenHostFrame.dispose();
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (applicationContext != null) {
            throw new IllegalStateException();
        }
        if (stringArray.length == 0) {
            System.err.println("Application class name is required.");
            return;
        }
        applicationClassName = stringArray[0];
        properties = new HashMap();
        int n = 0;
        int n2 = 0;
        int n3 = 800;
        int n4 = 600;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        try {
            Preferences preferences = Preferences.userNodeForPackage(DesktopApplicationContext.class);
            preferences = preferences.node(applicationClassName);
            n = preferences.getInt(X_ARGUMENT, n);
            n2 = preferences.getInt(Y_ARGUMENT, n2);
            n3 = preferences.getInt(WIDTH_ARGUMENT, n3);
            n4 = preferences.getInt(HEIGHT_ARGUMENT, n4);
        }
        catch (SecurityException securityException) {
            System.err.println("Unable to retrieve startup preferences: " + securityException);
        }
        int n5 = stringArray.length;
        for (int i = 1; i < n5; ++i) {
            object4 = stringArray[i];
            if (!((String)object4).startsWith("--")) {
                throw new IllegalArgumentException("Startup property names must begin with \"--\".");
            }
            object3 = ((String)(object4 = ((String)object4).substring(2))).split("=");
            if (((String[])object3).length == 2) {
                object2 = object3[0];
                object = object3[1];
                try {
                    if (((String)object2).equals(X_ARGUMENT)) {
                        n = Integer.parseInt((String)object);
                        continue;
                    }
                    if (((String)object2).equals(Y_ARGUMENT)) {
                        n2 = Integer.parseInt((String)object);
                        continue;
                    }
                    if (((String)object2).equals(WIDTH_ARGUMENT)) {
                        n3 = Integer.parseInt((String)object);
                        continue;
                    }
                    if (((String)object2).equals(HEIGHT_ARGUMENT)) {
                        n4 = Integer.parseInt((String)object);
                        continue;
                    }
                    if (((String)object2).equals(CENTER_ARGUMENT)) {
                        bl = Boolean.parseBoolean((String)object);
                        continue;
                    }
                    if (((String)object2).equals(RESIZABLE_ARGUMENT)) {
                        bl2 = Boolean.parseBoolean((String)object);
                        continue;
                    }
                    if (((String)object2).equals(FULL_SCREEN_ARGUMENT)) {
                        bl3 = Boolean.parseBoolean((String)object);
                        continue;
                    }
                    properties.put(object2, object);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Warning: " + numberFormatException.getClass().getSimpleName() + ": " + numberFormatException.getLocalizedMessage());
                }
                continue;
            }
            System.err.println((String)object4 + " is not a valid startup property.");
        }
        try {
            serializable = Class.forName("javax.jnlp.ServiceManager");
            Method method = ((Class)serializable).getMethod("lookup", String.class);
            object4 = method.invoke(null, "javax.jnlp.BasicService");
            object3 = Class.forName("javax.jnlp.BasicService");
            object2 = ((Class)object3).getMethod("getCodeBase", new Class[0]);
            object = (URL)((Method)object2).invoke(object4, new Object[0]);
            if (object != null) {
                origin = new URL(((URL)object).getProtocol(), ((URL)object).getHost(), ((URL)object).getPort(), "");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (origin == null) {
            serializable = new File(System.getProperty("user.home"));
            try {
                origin = ((File)serializable).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        applicationContext = new DesktopApplicationContext();
        serializable = applicationContext.getDisplayHost();
        windowedHostFrame = new HostFrame();
        windowedHostFrame.add((java.awt.Component)serializable);
        windowedHostFrame.setTitle(DEFAULT_HOST_FRAME_TITLE);
        windowedHostFrame.setSize(n3, n4);
        windowedHostFrame.setResizable(bl2);
        if (bl) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            windowedHostFrame.setLocation((dimension.width - n3) / 2, (dimension.height - n4) / 2);
        } else {
            windowedHostFrame.setLocation(n, n2);
        }
        applicationContext.getDisplay().getContainerListeners().add((Object)new ContainerListener.Adapter(){

            @Override
            public void componentInserted(Container container, int n) {
                if (n == container.getLength() - 1) {
                    this.topWindowChanged((Display)container, n > 0 ? (Window)container.get(n - 1) : null);
                }
            }

            @Override
            public void componentsRemoved(Container container, int n, Sequence<Component> sequence) {
                if (n == container.getLength()) {
                    this.topWindowChanged((Display)container, (Window)sequence.get(sequence.getLength() - 1));
                }
            }

            @Override
            public void componentMoved(Container container, int n, int n2) {
                int n3 = container.getLength();
                if (n == n3) {
                    this.topWindowChanged((Display)container, (Window)container.get(n));
                } else if (n2 == n3) {
                    this.topWindowChanged((Display)container, (Window)container.get(n3 - 1));
                }
            }

            private void topWindowChanged(Display display, Window window) {
                if (updateFrameTitleBarCallback == null) {
                    updateFrameTitleBarCallback = new Runnable(){

                        @Override
                        public void run() {
                            Display display = applicationContext.getDisplay();
                            int n = display.getLength();
                            if (n == 0) {
                                windowedHostFrame.setTitle(DesktopApplicationContext.DEFAULT_HOST_FRAME_TITLE);
                                windowedHostFrame.setIconImage(null);
                            } else {
                                Window window = (Window)display.get(n - 1);
                                Window window2 = window.getRootOwner();
                                DesktopApplicationContext.updateFrameTitleBar(window2);
                            }
                            updateFrameTitleBarCallback = null;
                        }
                    };
                    ApplicationContext.queueCallback(updateFrameTitleBarCallback);
                }
            }
        });
        ((java.awt.Component)serializable).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 70 && (keyEvent.getModifiersEx() & 0x80) > 0 && (keyEvent.getModifiersEx() & 0x40) > 0) {
                    DesktopApplicationContext.setFullScreen(!DesktopApplicationContext.isFullScreen());
                }
            }
        });
        fullScreenHostFrame = new HostFrame();
        fullScreenHostFrame.setUndecorated(true);
        windowedHostFrame.setVisible(true);
        DesktopApplicationContext.setFullScreen(bl3);
    }

    private static void updateFrameTitleBar(Window window) {
        windowedHostFrame.setTitle(window.getTitle());
        Image image = window.getIcon();
        if (image instanceof Picture) {
            Picture picture = (Picture)image;
            windowedHostFrame.setIconImage(picture.getBufferedImage());
        }
    }

    private static void displayException(Exception exception) {
        exception.printStackTrace();
        String string = exception.getClass().getName();
        Label label = null;
        String string2 = exception.getMessage();
        if (string2 != null && string2.length() > 0) {
            label = new Label(string2);
            label.getStyles().put("wrapText", (Object)true);
        }
        Alert.alert(MessageType.ERROR, string, label, applicationContext.getDisplay());
    }

    public static void handleAbout() {
        Application application = applicationContext.getApplication();
        Application.AboutHandler aboutHandler = (Application.AboutHandler)((Object)application);
        aboutHandler.aboutRequested();
    }

    public static boolean isFullScreen() {
        return !windowedHostFrame.isVisible();
    }

    public static void setFullScreen(boolean bl) {
        if (bl != DesktopApplicationContext.isFullScreen()) {
            ApplicationContext.DisplayHost displayHost = applicationContext.getDisplayHost();
            GraphicsDevice graphicsDevice = windowedHostFrame.getGraphicsConfiguration().getDevice();
            if (bl) {
                windowedHostFrame.remove(displayHost);
                windowedHostFrame.setVisible(false);
                fullScreenHostFrame.add(displayHost);
                fullScreenHostFrame.setVisible(true);
                graphicsDevice.setFullScreenWindow(fullScreenHostFrame);
            } else {
                try {
                    graphicsDevice.setFullScreenWindow(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                fullScreenHostFrame.remove(displayHost);
                fullScreenHostFrame.setVisible(false);
                windowedHostFrame.add(displayHost);
                windowedHostFrame.setVisible(true);
            }
            displayHost.requestFocus();
        }
    }

    public static void sizeToFit(Window window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        if (applicationContext == null) {
            throw new IllegalStateException("Desktop application context is not active.");
        }
        if (DesktopApplicationContext.isFullScreen()) {
            DesktopApplicationContext.setFullScreen(false);
        }
        Dimensions dimensions = window.getPreferredSize();
        Insets insets = windowedHostFrame.getInsets();
        windowedHostFrame.setSize(dimensions.width + (insets.left + insets.right), dimensions.height + (insets.top + insets.bottom));
    }

    public static final void main(Class<? extends Application> clazz, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        stringArray2[0] = clazz.getName();
        DesktopApplicationContext.main(stringArray2);
    }

    private static class HostFrame
    extends Frame {
        private static final long serialVersionUID = 5340356674429280196L;

        private HostFrame() {
            this.enableEvents(262208L);
            this.setFocusTraversalKeysEnabled(false);
            this.setBackground(null);
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        @Override
        public void processWindowEvent(WindowEvent windowEvent) {
            super.processWindowEvent(windowEvent);
            if (this == windowedHostFrame) {
                switch (windowEvent.getID()) {
                    case 200: {
                        Serializable serializable;
                        ApplicationContext.addDisplay(applicationContext.getDisplay());
                        ApplicationContext.createTimer();
                        Application application = null;
                        try {
                            serializable = Class.forName(applicationClassName);
                            application = (Application)((Class)serializable).newInstance();
                            applicationContext.setApplication(application);
                        }
                        catch (Exception exception) {
                            Alert.alert(MessageType.ERROR, exception.getMessage(), applicationContext.getDisplay());
                            exception.printStackTrace();
                        }
                        serializable = applicationContext.getDisplayHost();
                        ((java.awt.Component)serializable).requestFocus();
                        if (application == null) break;
                        try {
                            application.startup(applicationContext.getDisplay(), (Map<String, String>)new ImmutableMap((Map)properties));
                        }
                        catch (Exception exception) {
                            DesktopApplicationContext.displayException(exception);
                        }
                        ApplicationContext.addApplication(application);
                        String string = System.getProperty("os.name");
                        if (!string.toLowerCase().startsWith("mac os x")) break;
                        try {
                            Class<?> clazz = Class.forName("com.apple.eawt.Application");
                            Class<?> clazz2 = Class.forName("com.apple.eawt.ApplicationListener");
                            Class<?> clazz3 = Class.forName("com.apple.eawt.ApplicationEvent");
                            Method method = clazz.getMethod("setEnabledAboutMenu", Boolean.TYPE);
                            Method method2 = clazz.getMethod("addApplicationListener", clazz2);
                            final Method method3 = clazz3.getMethod("setHandled", Boolean.TYPE);
                            InvocationHandler invocationHandler = new InvocationHandler(){

                                @Override
                                public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                                    boolean bl = true;
                                    String string = method.getName();
                                    if (string.equals("handleAbout")) {
                                        DesktopApplicationContext.handleAbout();
                                    } else if (string.equals("handleQuit")) {
                                        bl = !DesktopApplicationContext.exit();
                                    }
                                    method3.invoke(objectArray[0], bl);
                                    return null;
                                }
                            };
                            Object obj = clazz.newInstance();
                            method.invoke(obj, application instanceof Application.AboutHandler);
                            Object object = Proxy.newProxyInstance(DesktopApplicationContext.class.getClassLoader(), new Class[]{clazz2}, invocationHandler);
                            method2.invoke(obj, object);
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace(System.err);
                        }
                        break;
                    }
                    case 201: {
                        DesktopApplicationContext.exit();
                        break;
                    }
                    case 202: {
                        ApplicationContext.removeDisplay(applicationContext.getDisplay());
                        ApplicationContext.destroyTimer();
                        System.exit(0);
                        break;
                    }
                    case 206: {
                        java.awt.Window window = windowEvent.getOppositeWindow();
                        if (!(window instanceof Dialog)) break;
                        Dialog dialog = (Dialog)window;
                        switch (dialog.getModalityType()) {
                            case APPLICATION_MODAL: 
                            case DOCUMENT_MODAL: 
                            case TOOLKIT_MODAL: {
                                applicationContext.getDisplay().setEnabled(false);
                                dialog.addWindowListener(new WindowAdapter(){

                                    @Override
                                    public void windowClosed(WindowEvent windowEvent) {
                                        applicationContext.getDisplay().setEnabled(true);
                                        windowEvent.getWindow().removeWindowListener(this);
                                    }
                                });
                            }
                        }
                        break;
                    }
                }
            }
        }

        @Override
        protected void processWindowStateEvent(WindowEvent windowEvent) {
            super.processWindowStateEvent(windowEvent);
            if (this == windowedHostFrame) {
                Application application = applicationContext.getApplication();
                switch (windowEvent.getID()) {
                    case 203: {
                        try {
                            application.suspend();
                        }
                        catch (Exception exception) {
                            DesktopApplicationContext.displayException(exception);
                        }
                        break;
                    }
                    case 204: {
                        try {
                            application.resume();
                            break;
                        }
                        catch (Exception exception) {
                            DesktopApplicationContext.displayException(exception);
                        }
                    }
                }
            }
        }
    }
}

