/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Graphics2D;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Automation;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.FocusTraversalPolicy;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.skin.DisplaySkin;

public final class Display
extends Container {
    private ApplicationContext.DisplayHost displayHost;
    private Point mouseLocation = null;

    public Display(ApplicationContext.DisplayHost displayHost) {
        this.displayHost = displayHost;
        super.setSkin(new DisplaySkin());
    }

    public ApplicationContext.DisplayHost getDisplayHost() {
        return this.displayHost;
    }

    @Override
    protected void setSkin(Skin skin) {
        throw new UnsupportedOperationException("Can't replace Display skin.");
    }

    @Override
    protected void setParent(Container container) {
        throw new UnsupportedOperationException("Display can't have a parent.");
    }

    @Override
    public void setLocation(int n, int n2) {
        throw new UnsupportedOperationException("Can't change the location of the display.");
    }

    @Override
    public void setVisible(boolean bl) {
        throw new UnsupportedOperationException("Can't change the visibility of the display.");
    }

    @Override
    public void repaint(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            Graphics2D graphics2D = (Graphics2D)this.displayHost.getGraphics();
            if (graphics2D != null) {
                double d = this.displayHost.getScale();
                if (d == 1.0) {
                    graphics2D.clipRect(n, n2, n3, n4);
                } else {
                    graphics2D.clipRect((int)Math.floor((double)n * d), (int)Math.floor((double)n2 * d), (int)Math.ceil((double)n3 * d) + 1, (int)Math.ceil((double)n4 * d) + 1);
                }
                this.displayHost.paint(graphics2D);
                graphics2D.dispose();
            }
        } else {
            this.displayHost.repaint(n, n2, n3, n4);
        }
    }

    @Override
    public void insert(Component component, int n) {
        if (!(component instanceof Window)) {
            throw new IllegalArgumentException("component must be an instance of " + Window.class);
        }
        super.insert(component, n);
    }

    @Override
    protected boolean mouseMove(int n, int n2) {
        this.mouseLocation = new Point(n, n2);
        return super.mouseMove(n, n2);
    }

    @Override
    protected void mouseOut() {
        this.mouseLocation = null;
        super.mouseOut();
    }

    public Point getMouseLocation() {
        return this.mouseLocation;
    }

    @Override
    protected void descendantAdded(Component component) {
        super.descendantAdded(component);
        String string = component.getAutomationID();
        if (string != null) {
            Automation.add(string, component);
        }
    }

    @Override
    protected void descendantRemoved(Component component) {
        super.descendantRemoved(component);
        String string = component.getAutomationID();
        if (string != null) {
            Automation.remove(string);
        }
    }

    @Override
    public FocusTraversalPolicy getFocusTraversalPolicy() {
        return null;
    }
}

