/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ExpanderListener;

public class Expander
extends Container {
    private String title = null;
    private boolean collapsible = true;
    private boolean expanded = true;
    private Component content = null;
    private ExpanderListenerList expanderListeners = new ExpanderListenerList();

    public Expander() {
        this.installThemeSkin(Expander.class);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        String string2 = this.title;
        if (string != string2) {
            this.title = string;
            this.expanderListeners.titleChanged(this, string2);
        }
    }

    public boolean isCollapsible() {
        return this.collapsible;
    }

    public void setCollapsible(boolean bl) {
        if (bl != this.collapsible) {
            if (!bl && !this.expanded) {
                throw new IllegalStateException();
            }
            this.collapsible = bl;
            this.expanderListeners.collapsibleChanged(this);
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        if (bl != this.expanded) {
            if (!this.collapsible && !bl) {
                throw new IllegalStateException();
            }
            Vote vote = this.expanderListeners.previewExpandedChange(this);
            if (vote == Vote.APPROVE) {
                this.expanded = bl;
                this.expanderListeners.expandedChanged(this);
            } else {
                this.expanderListeners.expandedChangeVetoed(this, vote);
            }
        }
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component component) {
        Component component2 = this.content;
        if (component != component2) {
            this.content = null;
            if (component2 != null) {
                this.remove(component2);
            }
            if (component != null) {
                this.add(component);
            }
            this.content = component;
            this.expanderListeners.contentChanged(this, component2);
        }
    }

    @Override
    public Sequence<Component> remove(int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            Component component = this.get(i);
            if (component != this.content) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(n, n2);
    }

    public ListenerList<ExpanderListener> getExpanderListeners() {
        return this.expanderListeners;
    }

    private static class ExpanderListenerList
    extends ListenerList<ExpanderListener>
    implements ExpanderListener {
        private ExpanderListenerList() {
        }

        @Override
        public void titleChanged(Expander expander, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ExpanderListener expanderListener = (ExpanderListener)iterator.next();
                expanderListener.titleChanged(expander, string);
            }
        }

        @Override
        public void collapsibleChanged(Expander expander) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ExpanderListener expanderListener = (ExpanderListener)iterator.next();
                expanderListener.collapsibleChanged(expander);
            }
        }

        @Override
        public Vote previewExpandedChange(Expander expander) {
            Vote vote = Vote.APPROVE;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ExpanderListener expanderListener = (ExpanderListener)iterator.next();
                vote = vote.tally(expanderListener.previewExpandedChange(expander));
            }
            return vote;
        }

        @Override
        public void expandedChangeVetoed(Expander expander, Vote vote) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ExpanderListener expanderListener = (ExpanderListener)iterator.next();
                expanderListener.expandedChangeVetoed(expander, vote);
            }
        }

        @Override
        public void expandedChanged(Expander expander) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ExpanderListener expanderListener = (ExpanderListener)iterator.next();
                expanderListener.expandedChanged(expander);
            }
        }

        @Override
        public void contentChanged(Expander expander, Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ExpanderListener expanderListener = (ExpanderListener)iterator.next();
                expanderListener.contentChanged(expander, component);
            }
        }
    }
}

