/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.LinkedList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.FrameListener;
import org.apache.pivot.wtk.MenuBar;
import org.apache.pivot.wtk.MenuHandler;
import org.apache.pivot.wtk.Window;

public class Frame
extends Window {
    private MenuBar menuBar = null;
    private FrameListenerList frameListeners = new FrameListenerList();

    public Frame() {
        this(null, null);
    }

    public Frame(String string) {
        this(string, null);
    }

    public Frame(Component component) {
        this(null, component);
    }

    public Frame(String string, Component component) {
        super(component);
        this.setTitle(string);
        this.installThemeSkin(Frame.class);
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setMenuBar(MenuBar menuBar) {
        MenuBar menuBar2 = this.menuBar;
        if (menuBar2 != menuBar) {
            this.menuBar = menuBar;
            if (menuBar2 != null) {
                this.remove(menuBar2);
            }
            if (menuBar != null) {
                this.add(menuBar);
            }
            this.frameListeners.menuBarChanged(this, menuBar2);
        }
    }

    @Override
    public void moveToFront() {
        super.moveToFront();
        this.requestActive();
    }

    @Override
    protected void descendantGainedFocus(Component component, Component component2) {
        if (this.menuBar != null) {
            LinkedList linkedList = new LinkedList();
            Component component3 = component;
            while (!(component3 instanceof Display)) {
                linkedList.insert((Object)component3, 0);
                component3 = component3.getParent();
            }
            for (Component component4 : linkedList) {
                MenuHandler menuHandler = component4.getMenuHandler();
                if (menuHandler == null) continue;
                menuHandler.configureMenuBar(component4, this.menuBar);
            }
        }
        super.descendantGainedFocus(component, component2);
    }

    @Override
    protected void descendantLostFocus(Component component) {
        if (this.menuBar != null) {
            LinkedList linkedList = new LinkedList();
            Component component2 = component;
            while (!(component2 instanceof Display)) {
                linkedList.insert((Object)component2, 0);
                component2 = component2.getParent();
            }
            for (Component component3 : linkedList) {
                MenuHandler menuHandler = component3.getMenuHandler();
                if (menuHandler == null) continue;
                menuHandler.cleanupMenuBar(component3, this.menuBar);
            }
        }
        super.descendantLostFocus(component);
    }

    @Override
    public Sequence<Component> remove(int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            Component component = this.get(i);
            if (component != this.menuBar) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(n, n2);
    }

    public ListenerList<FrameListener> getFrameListeners() {
        return this.frameListeners;
    }

    private static class FrameListenerList
    extends ListenerList<FrameListener>
    implements FrameListener {
        private FrameListenerList() {
        }

        @Override
        public void menuBarChanged(Frame frame, MenuBar menuBar) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FrameListener frameListener = (FrameListener)iterator.next();
                frameListener.menuBarChanged(frame, menuBar);
            }
        }
    }
}

