/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.GridPaneListener;

public class GridPane
extends Container {
    private int columnCount;
    private ArrayList<Row> rows = new ArrayList();
    private RowSequence rowSequence = new RowSequence();
    private GridPaneListenerList gridPaneListeners = new GridPaneListenerList();

    public GridPane() {
        this(0);
    }

    public GridPane(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("columnCount is negative.");
        }
        this.setColumnCount(n);
        this.installThemeSkin(GridPane.class);
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int n) {
        int n2 = this.columnCount;
        if (n2 != n) {
            this.columnCount = n;
            this.gridPaneListeners.columnCountChanged(this, n2);
        }
    }

    public RowSequence getRows() {
        return this.rowSequence;
    }

    public int getRowAt(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getRowAt(n);
    }

    public Bounds getRowBounds(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getRowBounds(n);
    }

    public int getColumnAt(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getColumnAt(n);
    }

    public Bounds getColumnBounds(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getColumnBounds(n);
    }

    public Component getCellComponent(int n, int n2) {
        Row row = (Row)this.rows.get(n);
        Component component = null;
        if (row.getLength() > n2) {
            component = row.get(n2);
        }
        return component;
    }

    @Override
    public Sequence<Component> remove(int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            Component component = this.get(i);
            for (Row row : this.rows) {
                if (row.indexOf(component) < 0) continue;
                throw new UnsupportedOperationException();
            }
        }
        return super.remove(n, n2);
    }

    public ListenerList<GridPaneListener> getGridPaneListeners() {
        return this.gridPaneListeners;
    }

    private static class GridPaneListenerList
    extends ListenerList<GridPaneListener>
    implements GridPaneListener {
        private GridPaneListenerList() {
        }

        @Override
        public void columnCountChanged(GridPane gridPane, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                GridPaneListener gridPaneListener = (GridPaneListener)iterator.next();
                gridPaneListener.columnCountChanged(gridPane, n);
            }
        }

        @Override
        public void rowInserted(GridPane gridPane, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                GridPaneListener gridPaneListener = (GridPaneListener)iterator.next();
                gridPaneListener.rowInserted(gridPane, n);
            }
        }

        @Override
        public void rowsRemoved(GridPane gridPane, int n, Sequence<Row> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                GridPaneListener gridPaneListener = (GridPaneListener)iterator.next();
                gridPaneListener.rowsRemoved(gridPane, n, sequence);
            }
        }

        @Override
        public void cellInserted(Row row, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                GridPaneListener gridPaneListener = (GridPaneListener)iterator.next();
                gridPaneListener.cellInserted(row, n);
            }
        }

        @Override
        public void cellsRemoved(Row row, int n, Sequence<Component> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                GridPaneListener gridPaneListener = (GridPaneListener)iterator.next();
                gridPaneListener.cellsRemoved(row, n, sequence);
            }
        }

        @Override
        public void cellUpdated(Row row, int n, Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                GridPaneListener gridPaneListener = (GridPaneListener)iterator.next();
                gridPaneListener.cellUpdated(row, n, component);
            }
        }
    }

    public static class Filler
    extends Component {
        public Filler() {
            this.installThemeSkin(Filler.class);
        }
    }

    public final class RowSequence
    implements Sequence<Row>,
    Iterable<Row> {
        private RowSequence() {
        }

        public int add(Row row) {
            int n = this.getLength();
            this.insert(row, n);
            return n;
        }

        public void insert(Row row, int n) {
            if (row == null) {
                throw new IllegalArgumentException("row is null.");
            }
            if (row.getGridPane() != null) {
                throw new IllegalArgumentException("row is already in use by another grid pane.");
            }
            GridPane.this.rows.insert((Object)row, n);
            row.setGridPane(GridPane.this);
            int n2 = row.getLength();
            for (int i = 0; i < n2; ++i) {
                Component component = row.get(i);
                GridPane.this.add(component);
            }
            GridPane.this.gridPaneListeners.rowInserted(GridPane.this, n);
        }

        public Row update(int n, Row row) {
            throw new UnsupportedOperationException();
        }

        public int remove(Row row) {
            int n = this.indexOf(row);
            if (n != -1) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<Row> remove(int n, int n2) {
            Sequence sequence = GridPane.this.rows.remove(n, n2);
            if (n2 > 0) {
                int n3 = sequence.getLength();
                for (int i = 0; i < n3; ++i) {
                    Row row = (Row)sequence.get(i);
                    row.setGridPane(null);
                    int n4 = row.getLength();
                    for (int j = 0; j < n4; ++j) {
                        Component component = row.get(j);
                        GridPane.this.remove(component);
                    }
                }
                GridPane.this.gridPaneListeners.rowsRemoved(GridPane.this, n, (Sequence<Row>)sequence);
            }
            return sequence;
        }

        public Row get(int n) {
            return (Row)GridPane.this.rows.get(n);
        }

        public int indexOf(Row row) {
            return GridPane.this.rows.indexOf((Object)row);
        }

        public int getLength() {
            return GridPane.this.rows.getLength();
        }

        @Override
        public Iterator<Row> iterator() {
            return new ImmutableIterator((Iterator)GridPane.this.rows.iterator());
        }
    }

    public static interface Skin {
        public int getRowAt(int var1);

        public Bounds getRowBounds(int var1);

        public int getColumnAt(int var1);

        public Bounds getColumnBounds(int var1);
    }

    public static final class Row
    implements Sequence<Component>,
    Iterable<Component> {
        private ArrayList<Component> cells = new ArrayList();
        private GridPane gridPane = null;

        public GridPane getGridPane() {
            return this.gridPane;
        }

        private void setGridPane(GridPane gridPane) {
            this.gridPane = gridPane;
        }

        public int add(Component component) {
            int n = this.getLength();
            this.insert(component, n);
            return n;
        }

        public void insert(Component component, int n) {
            if (component == null) {
                throw new IllegalArgumentException("Component is null.");
            }
            if (component.getParent() != null) {
                throw new IllegalArgumentException("Component already has a parent.");
            }
            this.cells.insert((Object)component, n);
            if (this.gridPane != null) {
                this.gridPane.add(component);
                this.gridPane.gridPaneListeners.cellInserted(this, n);
            }
        }

        public Component update(int n, Component component) {
            Component component2 = (Component)this.cells.get(n);
            if (component != component2) {
                if (component == null) {
                    throw new IllegalArgumentException("Component is null.");
                }
                if (component.getParent() != null) {
                    throw new IllegalArgumentException("Component already has a parent.");
                }
                this.cells.update(n, (Object)component);
                if (this.gridPane != null) {
                    this.gridPane.add(component);
                    this.gridPane.gridPaneListeners.cellUpdated(this, n, component2);
                    this.gridPane.remove(component2);
                }
            }
            return component2;
        }

        public int remove(Component component) {
            int n = this.indexOf(component);
            if (n != -1) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<Component> remove(int n, int n2) {
            Sequence sequence = this.cells.remove(n, n2);
            if (this.gridPane != null) {
                this.gridPane.gridPaneListeners.cellsRemoved(this, n, (Sequence<Component>)sequence);
                int n3 = sequence.getLength();
                for (int i = 0; i < n3; ++i) {
                    Component component = (Component)sequence.get(i);
                    this.gridPane.remove(component);
                }
            }
            return sequence;
        }

        public Component get(int n) {
            return (Component)this.cells.get(n);
        }

        public int indexOf(Component component) {
            return this.cells.indexOf((Object)component);
        }

        public int getLength() {
            return this.cells.getLength();
        }

        @Override
        public Iterator<Component> iterator() {
            return new ImmutableIterator((Iterator)this.cells.iterator());
        }
    }
}

