/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.ThreadUtilities;
import org.apache.pivot.util.concurrent.Task;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.util.concurrent.TaskListener;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ImageViewListener;
import org.apache.pivot.wtk.TaskAdapter;
import org.apache.pivot.wtk.media.Image;

public class ImageView
extends Component {
    private Image image = null;
    private boolean asynchronous = false;
    private String imageKey = null;
    private ImageViewListenerList imageViewListeners = new ImageViewListenerList();
    private static HashMap<URI, ArrayList<ImageView>> loadMap = new HashMap();

    public ImageView() {
        this(null);
    }

    public ImageView(Image image) {
        this.setImage(image);
        this.installThemeSkin(ImageView.class);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        Image image2 = this.image;
        if (image2 != image) {
            this.image = image;
            this.imageViewListeners.imageChanged(this, image2);
        }
    }

    public final void setImage(final URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("imageURL is null.");
        }
        Image image = (Image)ApplicationContext.getResourceCache().get(uRL);
        if (image == null) {
            URI uRI;
            try {
                uRI = uRL.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
            if (this.asynchronous) {
                if (loadMap.containsKey((Object)uRI)) {
                    ((ArrayList)loadMap.get((Object)uRI)).add((Object)this);
                } else {
                    Image.load(uRL, new TaskAdapter<Image>(new TaskListener<Image>(){

                        public void taskExecuted(Task<Image> task) {
                            Image image = (Image)task.getResult();
                            for (ImageView imageView : (ArrayList)loadMap.get((Object)uRI)) {
                                imageView.setImage(image);
                            }
                            loadMap.remove((Object)uRI);
                            ApplicationContext.getResourceCache().put(uRL, (Object)image);
                        }

                        public void executeFailed(Task<Image> task) {
                        }
                    }));
                    loadMap.put((Object)uRI, (Object)new ArrayList((Object[])new ImageView[]{this}));
                }
            } else {
                try {
                    image = Image.load(uRL);
                }
                catch (TaskExecutionException taskExecutionException) {
                    throw new IllegalArgumentException(taskExecutionException);
                }
                ApplicationContext.getResourceCache().put(uRL, (Object)image);
            }
        }
        this.setImage(image);
    }

    public final void setImage(String string) {
        if (string == null) {
            throw new IllegalArgumentException("image is null.");
        }
        ClassLoader classLoader = ThreadUtilities.getClassLoader();
        this.setImage(classLoader.getResource(string));
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean bl) {
        if (this.asynchronous != bl) {
            this.asynchronous = bl;
            this.imageViewListeners.asynchronousChanged(this);
        }
    }

    public String getImageKey() {
        return this.imageKey;
    }

    public void setImageKey(String string) {
        String string2 = this.imageKey;
        if (string2 != string) {
            this.imageKey = string;
            this.imageViewListeners.imageKeyChanged(this, string2);
        }
    }

    @Override
    public void load(Dictionary<String, ?> dictionary) {
        if (this.imageKey != null && JSONSerializer.containsKey(dictionary, (String)this.imageKey)) {
            Object object = JSONSerializer.get(dictionary, (String)this.imageKey);
            if (object instanceof Image) {
                this.setImage((Image)object);
            } else if (object instanceof URL) {
                this.setImage((URL)object);
            } else if (object instanceof String) {
                this.setImage((String)object);
            } else {
                throw new IllegalArgumentException(this.getClass().getName() + " can't bind to " + object + ".");
            }
        }
    }

    @Override
    public void store(Dictionary<String, ?> dictionary) {
        if (this.isEnabled() && this.imageKey != null) {
            JSONSerializer.put(dictionary, (String)this.imageKey, (Object)this.getImage());
        }
    }

    public ListenerList<ImageViewListener> getImageViewListeners() {
        return this.imageViewListeners;
    }

    private static class ImageViewListenerList
    extends ListenerList<ImageViewListener>
    implements ImageViewListener {
        private ImageViewListenerList() {
        }

        @Override
        public void imageChanged(ImageView imageView, Image image) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ImageViewListener imageViewListener = (ImageViewListener)iterator.next();
                imageViewListener.imageChanged(imageView, image);
            }
        }

        @Override
        public void asynchronousChanged(ImageView imageView) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ImageViewListener imageViewListener = (ImageViewListener)iterator.next();
                imageViewListener.asynchronousChanged(imageView);
            }
        }

        @Override
        public void imageKeyChanged(ImageView imageView, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ImageViewListener imageViewListener = (ImageViewListener)iterator.next();
                imageViewListener.imageKeyChanged(imageView, string);
            }
        }
    }
}

