/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.Serializable;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;

public final class Insets
implements Serializable {
    private static final long serialVersionUID = -8528862892185591370L;
    public final int top;
    public final int left;
    public final int bottom;
    public final int right;
    public static final String TOP_KEY = "top";
    public static final String LEFT_KEY = "left";
    public static final String BOTTOM_KEY = "bottom";
    public static final String RIGHT_KEY = "right";
    public static final Insets NONE = new Insets(0);

    public Insets(int n) {
        this.top = n;
        this.left = n;
        this.bottom = n;
        this.right = n;
    }

    public Insets(int n, int n2, int n3, int n4) {
        this.top = n;
        this.left = n2;
        this.bottom = n3;
        this.right = n4;
    }

    public Insets(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("insets is null.");
        }
        this.top = insets.top;
        this.left = insets.left;
        this.bottom = insets.bottom;
        this.right = insets.right;
    }

    public Insets(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("insets is null.");
        }
        this.top = dictionary.containsKey((Object)TOP_KEY) ? ((Number)dictionary.get((Object)TOP_KEY)).intValue() : 0;
        this.left = dictionary.containsKey((Object)LEFT_KEY) ? ((Number)dictionary.get((Object)LEFT_KEY)).intValue() : 0;
        this.bottom = dictionary.containsKey((Object)BOTTOM_KEY) ? ((Number)dictionary.get((Object)BOTTOM_KEY)).intValue() : 0;
        this.right = dictionary.containsKey((Object)RIGHT_KEY) ? ((Number)dictionary.get((Object)RIGHT_KEY)).intValue() : 0;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Insets) {
            Insets insets = (Insets)object;
            bl = this.top == insets.top && this.left == insets.left && this.bottom == insets.bottom && this.right == insets.right;
        }
        return bl;
    }

    public int hashCode() {
        return this.top * this.left ^ this.bottom * this.right;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.top + ", " + this.left + ", " + this.bottom + ", " + this.right + "]";
    }

    public static Insets decode(String string) {
        Insets insets;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.startsWith("{")) {
            try {
                insets = new Insets((Dictionary<String, ?>)JSONSerializer.parseMap((String)string));
            }
            catch (SerializationException serializationException) {
                throw new IllegalArgumentException(serializationException);
            }
        } else {
            insets = new Insets(Integer.parseInt(string));
        }
        return insets;
    }
}

