/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.Serializable;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;

public final class Limits
implements Serializable {
    private static final long serialVersionUID = -1420266625812552298L;
    public final int min;
    public final int max;
    public static final String MIN_KEY = "min";
    public static final String MAX_KEY = "max";

    public Limits(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("min > max");
        }
        this.min = n;
        this.max = n2;
    }

    public Limits(Limits limits) {
        if (limits == null) {
            throw new IllegalArgumentException("limits is null.");
        }
        this.min = limits.min;
        this.max = limits.max;
    }

    public Limits(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("limits is null.");
        }
        this.min = dictionary.containsKey((Object)MIN_KEY) ? (Integer)dictionary.get((Object)MIN_KEY) : Integer.MIN_VALUE;
        this.max = dictionary.containsKey((Object)MAX_KEY) ? (Integer)dictionary.get((Object)MAX_KEY) : Integer.MAX_VALUE;
        if (this.min > this.max) {
            throw new IllegalArgumentException("min > max");
        }
    }

    public int limit(int n) {
        if (n < this.min) {
            n = this.min;
        } else if (n > this.max) {
            n = this.max;
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Limits) {
            Limits limits = (Limits)object;
            bl = this.min == limits.min && this.max == limits.max;
        }
        return bl;
    }

    public int hashCode() {
        return 31 * this.min + this.max;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" [");
        if (this.min == Integer.MIN_VALUE) {
            stringBuilder.append("MIN");
        } else {
            stringBuilder.append(this.min);
        }
        stringBuilder.append("-");
        if (this.max == Integer.MAX_VALUE) {
            stringBuilder.append("MAX");
        } else {
            stringBuilder.append(this.max);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static Limits decode(String string) {
        Limits limits;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        try {
            limits = new Limits((Dictionary<String, ?>)JSONSerializer.parseMap((String)string));
        }
        catch (SerializationException serializationException) {
            throw new IllegalArgumentException(serializationException);
        }
        return limits;
    }
}

