/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Editor;
import org.apache.pivot.wtk.ListSelection;
import org.apache.pivot.wtk.ListSelectionSequence;
import org.apache.pivot.wtk.ListViewItemListener;
import org.apache.pivot.wtk.ListViewItemStateListener;
import org.apache.pivot.wtk.ListViewListener;
import org.apache.pivot.wtk.ListViewSelectionListener;
import org.apache.pivot.wtk.Renderer;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.content.ListViewItemRenderer;

public class ListView
extends Component {
    private List<?> listData = null;
    private ListListener<Object> listDataListener = new ListListener<Object>(){

        public void itemInserted(List<Object> list, int n) {
            ListView.this.selectedRanges.insertIndex(n);
            int n2 = ArrayList.binarySearch((ArrayList)ListView.this.checkedIndexes, (Comparable)Integer.valueOf(n));
            if (n2 < 0) {
                n2 = -(n2 + 1);
            }
            int n3 = ListView.this.checkedIndexes.getLength();
            while (n2 < n3) {
                ListView.this.checkedIndexes.update(n2, (Object)((Integer)ListView.this.checkedIndexes.get(n2) + 1));
                ++n2;
            }
            ListView.this.listViewItemListeners.itemInserted(ListView.this, n);
        }

        public void itemsRemoved(List<Object> list, int n, Sequence<Object> sequence) {
            int n2;
            int n3 = sequence.getLength();
            ListView.this.selectedRanges.removeIndexes(n, n3);
            int n4 = ArrayList.binarySearch((ArrayList)ListView.this.checkedIndexes, (Comparable)Integer.valueOf(n));
            if (n4 < 0) {
                n4 = -(n4 + 1);
            }
            n2 = (n2 = ArrayList.binarySearch((ArrayList)ListView.this.checkedIndexes, (Comparable)Integer.valueOf(n + n3 - 1))) < 0 ? -(n2 + 1) : ++n2;
            ListView.this.checkedIndexes.remove(n4, n2 - n4);
            int n5 = ListView.this.checkedIndexes.getLength();
            while (n4 < n5) {
                ListView.this.checkedIndexes.update(n4, (Object)((Integer)ListView.this.checkedIndexes.get(n4) - n3));
                ++n4;
            }
            ListView.this.listViewItemListeners.itemsRemoved(ListView.this, n, n3);
        }

        public void itemUpdated(List<Object> list, int n, Object object) {
            ListView.this.listViewItemListeners.itemUpdated(ListView.this, n);
        }

        public void listCleared(List<Object> list) {
            ListView.this.selectedRanges.clear();
            ListView.this.checkedIndexes.clear();
            ListView.this.listViewItemListeners.itemsCleared(ListView.this);
        }

        public void comparatorChanged(List<Object> list, Comparator<Object> comparator) {
            if (list.getComparator() != null) {
                ListView.this.selectedRanges.clear();
                ListView.this.checkedIndexes.clear();
                ListView.this.listViewItemListeners.itemsSorted(ListView.this);
            }
        }
    };
    private ItemRenderer itemRenderer = null;
    private ItemEditor itemEditor = null;
    private ListSelection selectedRanges = new ListSelection();
    private SelectMode selectMode = SelectMode.SINGLE;
    private boolean checkmarksEnabled = false;
    private ArrayList<Integer> checkedIndexes = new ArrayList();
    private Filter<?> disabledItemFilter = null;
    private Filter<?> disabledCheckmarkFilter = null;
    private String selectedItemKey = null;
    private String selectedItemsKey = null;
    private ListViewListenerList listViewListeners = new ListViewListenerList();
    private ListViewItemListenerList listViewItemListeners = new ListViewItemListenerList();
    private ListViewItemStateListenerList listViewItemStateListeners = new ListViewItemStateListenerList();
    private ListViewSelectionListenerList listViewSelectionListeners = new ListViewSelectionListenerList();
    private static final ItemRenderer DEFAULT_ITEM_RENDERER = new ListViewItemRenderer();

    public ListView() {
        this((List<?>)new ArrayList());
    }

    public ListView(List<?> list) {
        this.setItemRenderer(DEFAULT_ITEM_RENDERER);
        this.setListData(list);
        this.installThemeSkin(ListView.class);
    }

    public List<?> getListData() {
        return this.listData;
    }

    public void setListData(List<?> list) {
        if (list == null) {
            throw new IllegalArgumentException("listData is null.");
        }
        List<?> list2 = this.listData;
        if (list2 != list) {
            if (list2 != null) {
                this.selectedRanges.clear();
                this.checkedIndexes.clear();
                list2.getListListeners().remove(this.listDataListener);
            }
            list.getListListeners().add(this.listDataListener);
            this.listData = list;
            this.listViewListeners.listDataChanged(this, list2);
        }
    }

    public final void setListData(String string) {
        if (string == null) {
            throw new IllegalArgumentException("listData is null.");
        }
        try {
            this.setListData(JSONSerializer.parseList((String)string));
        }
        catch (SerializationException serializationException) {
            throw new IllegalArgumentException(serializationException);
        }
    }

    public void setListData(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("listData is null.");
        }
        JSONSerializer jSONSerializer = new JSONSerializer();
        try {
            this.setListData((List)jSONSerializer.readObject(uRL.openStream()));
        }
        catch (SerializationException serializationException) {
            throw new IllegalArgumentException(serializationException);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public ItemRenderer getItemRenderer() {
        return this.itemRenderer;
    }

    public void setItemRenderer(ItemRenderer itemRenderer) {
        if (itemRenderer == null) {
            throw new IllegalArgumentException("itemRenderer is null.");
        }
        ItemRenderer itemRenderer2 = this.itemRenderer;
        if (itemRenderer2 != itemRenderer) {
            this.itemRenderer = itemRenderer;
            this.listViewListeners.itemRendererChanged(this, itemRenderer2);
        }
    }

    public ItemEditor getItemEditor() {
        return this.itemEditor;
    }

    public void setItemEditor(ItemEditor itemEditor) {
        ItemEditor itemEditor2 = this.itemEditor;
        if (itemEditor2 != itemEditor) {
            this.itemEditor = itemEditor;
            this.listViewListeners.itemEditorChanged(this, itemEditor2);
        }
    }

    public int getSelectedIndex() {
        if (this.selectMode != SelectMode.SINGLE) {
            throw new IllegalStateException("List view is not in single-select mode.");
        }
        return this.selectedRanges.getLength() == 0 ? -1 : this.selectedRanges.get((int)0).start;
    }

    public void setSelectedIndex(int n) {
        if (n == -1) {
            this.clearSelection();
        } else {
            this.setSelectedRange(n, n);
        }
    }

    public void setSelectedRange(int n, int n2) {
        ArrayList arrayList = new ArrayList();
        arrayList.add((Object)new Span(n, n2));
        this.setSelectedRanges((Sequence<Span>)arrayList);
    }

    public Sequence<Span> getSelectedRanges() {
        return new ListSelectionSequence(this.selectedRanges);
    }

    public Sequence<Span> setSelectedRanges(Sequence<Span> sequence) {
        Object object;
        if (sequence == null) {
            throw new IllegalArgumentException("selectedRanges is null.");
        }
        if (this.selectMode == SelectMode.NONE) {
            throw new IllegalArgumentException("Selection is not enabled.");
        }
        if (this.selectMode == SelectMode.SINGLE) {
            int n = sequence.getLength();
            if (n > 1) {
                throw new IllegalArgumentException("Selection length is greater than 1.");
            }
            if (n > 0 && ((Span)(object = (Span)sequence.get(0))).getLength() > 1L) {
                throw new IllegalArgumentException("Selected range length is greater than 1.");
            }
        }
        ListSelectionSequence listSelectionSequence = new ListSelectionSequence(this.selectedRanges);
        object = new ListSelection();
        int n = sequence.getLength();
        for (int i = 0; i < n; ++i) {
            Span span = (Span)sequence.get(i);
            if (span == null) {
                throw new IllegalArgumentException("range is null.");
            }
            if (span.start < 0 || span.end >= this.listData.getLength()) {
                throw new IndexOutOfBoundsException();
            }
            ((ListSelection)object).addRange(span.start, span.end);
        }
        this.selectedRanges = object;
        this.listViewSelectionListeners.selectedRangesChanged(this, listSelectionSequence);
        return this.getSelectedRanges();
    }

    public final Sequence<Span> setSelectedRanges(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectedRanges is null.");
        }
        try {
            this.setSelectedRanges(this.parseSelectedRanges(string));
        }
        catch (SerializationException serializationException) {
            throw new IllegalArgumentException(serializationException);
        }
        return this.getSelectedRanges();
    }

    private Sequence<Span> parseSelectedRanges(String string) throws SerializationException {
        ArrayList arrayList = new ArrayList();
        List list = JSONSerializer.parseList((String)string);
        for (Object e : list) {
            Map map = (Map)e;
            arrayList.add((Object)new Span((Dictionary<String, ?>)map));
        }
        return arrayList;
    }

    public int getFirstSelectedIndex() {
        return this.selectedRanges.getLength() > 0 ? this.selectedRanges.get((int)0).start : -1;
    }

    public int getLastSelectedIndex() {
        return this.selectedRanges.getLength() > 0 ? this.selectedRanges.get((int)(this.selectedRanges.getLength() - 1)).end : -1;
    }

    public boolean addSelectedIndex(int n) {
        Sequence<Span> sequence = this.addSelectedRange(n, n);
        return sequence.getLength() > 0;
    }

    public Sequence<Span> addSelectedRange(int n, int n2) {
        if (this.selectMode != SelectMode.MULTI) {
            throw new IllegalStateException("List view is not in multi-select mode.");
        }
        if (n < 0 || n2 >= this.listData.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        Sequence<Span> sequence = this.selectedRanges.addRange(n, n2);
        int n3 = sequence.getLength();
        for (int i = 0; i < n3; ++i) {
            Span span = (Span)sequence.get(i);
            this.listViewSelectionListeners.selectedRangeAdded(this, span.start, span.end);
        }
        return sequence;
    }

    public Sequence<Span> addSelectedRange(Span span) {
        if (span == null) {
            throw new IllegalArgumentException("range is null.");
        }
        return this.addSelectedRange(span.start, span.end);
    }

    public boolean removeSelectedIndex(int n) {
        Sequence<Span> sequence = this.removeSelectedRange(n, n);
        return sequence.getLength() > 0;
    }

    public Sequence<Span> removeSelectedRange(int n, int n2) {
        if (this.selectMode != SelectMode.MULTI) {
            throw new IllegalStateException("List view is not in multi-select mode.");
        }
        if (n < 0 || n2 >= this.listData.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        Sequence<Span> sequence = this.selectedRanges.removeRange(n, n2);
        int n3 = sequence.getLength();
        for (int i = 0; i < n3; ++i) {
            Span span = (Span)sequence.get(i);
            this.listViewSelectionListeners.selectedRangeRemoved(this, span.start, span.end);
        }
        return sequence;
    }

    public Sequence<Span> removeSelectedRange(Span span) {
        if (span == null) {
            throw new IllegalArgumentException("range is null.");
        }
        return this.removeSelectedRange(span.start, span.end);
    }

    public void selectAll() {
        this.setSelectedRange(0, this.listData.getLength() - 1);
    }

    public void clearSelection() {
        if (this.selectedRanges.getLength() > 0) {
            ListSelectionSequence listSelectionSequence = new ListSelectionSequence(this.selectedRanges);
            this.selectedRanges = new ListSelection();
            this.listViewSelectionListeners.selectedRangesChanged(this, listSelectionSequence);
        }
    }

    public boolean isItemSelected(int n) {
        if (n < 0 || n >= this.listData.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        return this.selectedRanges.containsIndex(n);
    }

    public Object getSelectedItem() {
        int n = this.getSelectedIndex();
        Object object = null;
        if (n >= 0) {
            object = this.listData.get(n);
        }
        return object;
    }

    public void setSelectedItem(Object object) {
        this.setSelectedIndex(object == null ? -1 : this.listData.indexOf(object));
    }

    public Sequence<?> getSelectedItems() {
        ArrayList arrayList = new ArrayList();
        int n = this.selectedRanges.getLength();
        for (int i = 0; i < n; ++i) {
            Span span = this.selectedRanges.get(i);
            for (int j = span.start; j <= span.end; ++j) {
                Object object = this.listData.get(j);
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    public void setSelectedItems(Sequence<Object> sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException();
        }
        ArrayList arrayList = new ArrayList();
        int n = sequence.getLength();
        for (int i = 0; i < n; ++i) {
            Object object = sequence.get(i);
            if (object == null) {
                throw new IllegalArgumentException("item is null");
            }
            int n2 = this.listData.indexOf(object);
            if (n2 == -1) {
                throw new IllegalArgumentException("\"" + object + "\" is not a valid selection.");
            }
            arrayList.add((Object)new Span(n2));
        }
        this.setSelectedRanges((Sequence<Span>)arrayList);
    }

    public SelectMode getSelectMode() {
        return this.selectMode;
    }

    public void setSelectMode(SelectMode selectMode) {
        if (selectMode == null) {
            throw new IllegalArgumentException("selectMode is null.");
        }
        SelectMode selectMode2 = this.selectMode;
        if (selectMode2 != selectMode) {
            this.selectedRanges = new ListSelection();
            this.selectMode = selectMode;
            this.listViewListeners.selectModeChanged(this, selectMode2);
        }
    }

    public void setSelectMode(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectMode is null.");
        }
        this.setSelectMode(SelectMode.valueOf(string.toUpperCase()));
    }

    public boolean getCheckmarksEnabled() {
        return this.checkmarksEnabled;
    }

    public void setCheckmarksEnabled(boolean bl) {
        if (this.checkmarksEnabled != bl) {
            this.checkedIndexes.clear();
            this.checkmarksEnabled = bl;
            this.listViewListeners.checkmarksEnabledChanged(this);
        }
    }

    public boolean isItemChecked(int n) {
        return ArrayList.binarySearch(this.checkedIndexes, (Comparable)Integer.valueOf(n)) >= 0;
    }

    public void setItemChecked(int n, boolean bl) {
        if (!this.checkmarksEnabled) {
            throw new IllegalStateException("Checkmarks are not enabled.");
        }
        int n2 = ArrayList.binarySearch(this.checkedIndexes, (Comparable)Integer.valueOf(n));
        if (n2 < 0 && bl || n2 >= 0 && !bl) {
            if (bl) {
                this.checkedIndexes.insert((Object)n, -(n2 + 1));
            } else {
                this.checkedIndexes.remove(n2, 1);
            }
            this.listViewItemStateListeners.itemCheckedChanged(this, n);
        }
    }

    public Sequence<Integer> getCheckedIndexes() {
        ArrayList arrayList = new ArrayList();
        int n = this.checkedIndexes.getLength();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.checkedIndexes.get(i));
        }
        return arrayList;
    }

    public boolean isCheckmarkDisabled(int n) {
        boolean bl = false;
        if (this.disabledCheckmarkFilter != null) {
            Object object = this.listData.get(n);
            bl = this.disabledCheckmarkFilter.include(object);
        }
        return bl;
    }

    public Filter<?> getDisabledCheckmarkFilter() {
        return this.disabledCheckmarkFilter;
    }

    public void setDisabledCheckmarkFilter(Filter<?> filter) {
        Filter<?> filter2 = this.disabledCheckmarkFilter;
        if (filter2 != filter) {
            this.disabledCheckmarkFilter = filter;
            this.listViewListeners.disabledCheckmarkFilterChanged(this, filter2);
        }
    }

    public boolean isItemDisabled(int n) {
        boolean bl = false;
        if (this.disabledItemFilter != null) {
            Object object = this.listData.get(n);
            bl = this.disabledItemFilter.include(object);
        }
        return bl;
    }

    public Filter<?> getDisabledItemFilter() {
        return this.disabledItemFilter;
    }

    public void setDisabledItemFilter(Filter<?> filter) {
        Filter<?> filter2 = this.disabledItemFilter;
        if (filter2 != filter) {
            this.disabledItemFilter = filter;
            this.listViewListeners.disabledItemFilterChanged(this, filter2);
        }
    }

    public String getSelectedItemKey() {
        return this.selectedItemKey;
    }

    public void setSelectedItemKey(String string) {
        String string2 = this.selectedItemKey;
        if (string2 != string) {
            this.selectedItemKey = string;
            this.listViewListeners.selectedItemKeyChanged(this, string2);
        }
    }

    public String getSelectedItemsKey() {
        return this.selectedItemsKey;
    }

    public void setSelectedItemsKey(String string) {
        String string2 = this.selectedItemsKey;
        if (string2 != string) {
            this.selectedItemsKey = string;
            this.listViewListeners.selectedItemsKeyChanged(this, string2);
        }
    }

    @Override
    public void load(Dictionary<String, ?> dictionary) {
        Object object;
        if (this.selectedItemKey != null && JSONSerializer.containsKey(dictionary, (String)this.selectedItemKey)) {
            object = JSONSerializer.get(dictionary, (String)this.selectedItemKey);
            this.setSelectedItem(object);
        }
        if (this.selectedItemsKey != null && JSONSerializer.containsKey(dictionary, (String)this.selectedItemsKey)) {
            object = (Sequence)JSONSerializer.get(dictionary, (String)this.selectedItemsKey);
            this.setSelectedItems((Sequence<Object>)object);
        }
    }

    @Override
    public void store(Dictionary<String, ?> dictionary) {
        if (this.isEnabled()) {
            Sequence<?> sequence;
            if (this.selectedItemKey != null) {
                sequence = this.getSelectedItem();
                JSONSerializer.put(dictionary, (String)this.selectedItemKey, sequence);
            }
            if (this.selectedItemsKey != null) {
                sequence = this.getSelectedItems();
                JSONSerializer.put(dictionary, (String)this.selectedItemsKey, sequence);
            }
        }
    }

    @Override
    public void clear() {
        if (this.selectedItemKey != null || this.selectedItemsKey != null) {
            this.setSelectedItem(null);
        }
    }

    public int getItemAt(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getItemAt(n);
    }

    public Bounds getItemBounds(int n) {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getItemBounds(n);
    }

    public int getItemIndent() {
        Skin skin = (Skin)((Object)this.getSkin());
        return skin.getItemIndent();
    }

    public ListenerList<ListViewListener> getListViewListeners() {
        return this.listViewListeners;
    }

    public ListenerList<ListViewItemListener> getListViewItemListeners() {
        return this.listViewItemListeners;
    }

    public ListenerList<ListViewItemStateListener> getListViewItemStateListeners() {
        return this.listViewItemStateListeners;
    }

    public ListenerList<ListViewSelectionListener> getListViewSelectionListeners() {
        return this.listViewSelectionListeners;
    }

    private static class ListViewSelectionListenerList
    extends ListenerList<ListViewSelectionListener>
    implements ListViewSelectionListener {
        private ListViewSelectionListenerList() {
        }

        @Override
        public void selectedRangeAdded(ListView listView, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListViewSelectionListener listViewSelectionListener = (ListViewSelectionListener)iterator.next();
                listViewSelectionListener.selectedRangeAdded(listView, n, n2);
            }
        }

        @Override
        public void selectedRangeRemoved(ListView listView, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListViewSelectionListener listViewSelectionListener = (ListViewSelectionListener)iterator.next();
                listViewSelectionListener.selectedRangeRemoved(listView, n, n2);
            }
        }

        @Override
        public void selectedRangesChanged(ListView listView, Sequence<Span> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListViewSelectionListener listViewSelectionListener = (ListViewSelectionListener)iterator.next();
                listViewSelectionListener.selectedRangesChanged(listView, sequence);
            }
        }
    }

    private static class ListViewItemStateListenerList
    extends ListenerList<ListViewItemStateListener>
    implements ListViewItemStateListener {
        private ListViewItemStateListenerList() {
        }

        @Override
        public void itemCheckedChanged(ListView listView, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListViewItemStateListener listViewItemStateListener = (ListViewItemStateListener)iterator.next();
                listViewItemStateListener.itemCheckedChanged(listView, n);
            }
        }
    }

    private static class ListViewItemListenerList
    extends ListenerList<ListViewItemListener>
    implements ListViewItemListener {
        private ListViewItemListenerList() {
        }

        @Override
        public void itemInserted(ListView listView, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListViewItemListener listViewItemListener = (ListViewItemListener)iterator.next();
                listViewItemListener.itemInserted(listView, n);
            }
        }

        @Override
        public void itemsRemoved(ListView listView, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListViewItemListener listViewItemListener = (ListViewItemListener)iterator.next();
                listViewItemListener.itemsRemoved(listView, n, n2);
            }
        }

        @Override
        public void itemUpdated(ListView listView, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListViewItemListener listViewItemListener = (ListViewItemListener)iterator.next();
                listViewItemListener.itemUpdated(listView, n);
            }
        }

        @Override
        public void itemsCleared(ListView listView) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListViewItemListener listViewItemListener = (ListViewItemListener)iterator.next();
                listViewItemListener.itemsCleared(listView);
            }
        }

        @Override
        public void itemsSorted(ListView listView) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListViewItemListener listViewItemListener = (ListViewItemListener)iterator.next();
                listViewItemListener.itemsSorted(listView);
            }
        }
    }

    private static class ListViewListenerList
    extends ListenerList<ListViewListener>
    implements ListViewListener {
        private ListViewListenerList() {
        }

        @Override
        public void listDataChanged(ListView listView, List<?> list) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListViewListener listViewListener = (ListViewListener)iterator.next();
                listViewListener.listDataChanged(listView, list);
            }
        }

        @Override
        public void itemRendererChanged(ListView listView, ItemRenderer itemRenderer) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListViewListener listViewListener = (ListViewListener)iterator.next();
                listViewListener.itemRendererChanged(listView, itemRenderer);
            }
        }

        @Override
        public void itemEditorChanged(ListView listView, ItemEditor itemEditor) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListViewListener listViewListener = (ListViewListener)iterator.next();
                listViewListener.itemEditorChanged(listView, itemEditor);
            }
        }

        @Override
        public void selectModeChanged(ListView listView, SelectMode selectMode) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListViewListener listViewListener = (ListViewListener)iterator.next();
                listViewListener.selectModeChanged(listView, selectMode);
            }
        }

        @Override
        public void checkmarksEnabledChanged(ListView listView) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListViewListener listViewListener = (ListViewListener)iterator.next();
                listViewListener.checkmarksEnabledChanged(listView);
            }
        }

        @Override
        public void disabledItemFilterChanged(ListView listView, Filter<?> filter) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListViewListener listViewListener = (ListViewListener)iterator.next();
                listViewListener.disabledItemFilterChanged(listView, filter);
            }
        }

        @Override
        public void disabledCheckmarkFilterChanged(ListView listView, Filter<?> filter) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListViewListener listViewListener = (ListViewListener)iterator.next();
                listViewListener.disabledCheckmarkFilterChanged(listView, filter);
            }
        }

        @Override
        public void selectedItemKeyChanged(ListView listView, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListViewListener listViewListener = (ListViewListener)iterator.next();
                listViewListener.selectedItemKeyChanged(listView, string);
            }
        }

        @Override
        public void selectedItemsKeyChanged(ListView listView, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ListViewListener listViewListener = (ListViewListener)iterator.next();
                listViewListener.selectedItemsKeyChanged(listView, string);
            }
        }
    }

    public static interface Skin {
        public int getItemAt(int var1);

        public Bounds getItemBounds(int var1);

        public int getItemIndent();
    }

    public static interface ItemEditorListener {
        public Vote previewEditItem(ItemEditor var1, ListView var2, int var3);

        public void editItemVetoed(ItemEditor var1, Vote var2);

        public void itemEditing(ItemEditor var1, ListView var2, int var3);

        public Vote previewSaveChanges(ItemEditor var1, ListView var2, int var3, Object var4);

        public void saveChangesVetoed(ItemEditor var1, Vote var2);

        public void changesSaved(ItemEditor var1, ListView var2, int var3);

        public void editCancelled(ItemEditor var1, ListView var2, int var3);

        public static class Adapter
        implements ItemEditorListener {
            @Override
            public Vote previewEditItem(ItemEditor itemEditor, ListView listView, int n) {
                return Vote.APPROVE;
            }

            @Override
            public void editItemVetoed(ItemEditor itemEditor, Vote vote) {
            }

            @Override
            public void itemEditing(ItemEditor itemEditor, ListView listView, int n) {
            }

            @Override
            public Vote previewSaveChanges(ItemEditor itemEditor, ListView listView, int n, Object object) {
                return Vote.APPROVE;
            }

            @Override
            public void saveChangesVetoed(ItemEditor itemEditor, Vote vote) {
            }

            @Override
            public void changesSaved(ItemEditor itemEditor, ListView listView, int n) {
            }

            @Override
            public void editCancelled(ItemEditor itemEditor, ListView listView, int n) {
            }
        }
    }

    public static interface ItemEditor
    extends Editor {
        public void editItem(ListView var1, int var2);

        public ListenerList<ItemEditorListener> getItemEditorListeners();

        public static class ItemEditorListenerList
        extends ListenerList<ItemEditorListener>
        implements ItemEditorListener {
            @Override
            public Vote previewEditItem(ItemEditor itemEditor, ListView listView, int n) {
                Vote vote = Vote.APPROVE;
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    ItemEditorListener itemEditorListener = (ItemEditorListener)iterator.next();
                    vote = vote.tally(itemEditorListener.previewEditItem(itemEditor, listView, n));
                }
                return vote;
            }

            @Override
            public void editItemVetoed(ItemEditor itemEditor, Vote vote) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    ItemEditorListener itemEditorListener = (ItemEditorListener)iterator.next();
                    itemEditorListener.editItemVetoed(itemEditor, vote);
                }
            }

            @Override
            public void itemEditing(ItemEditor itemEditor, ListView listView, int n) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    ItemEditorListener itemEditorListener = (ItemEditorListener)iterator.next();
                    itemEditorListener.itemEditing(itemEditor, listView, n);
                }
            }

            @Override
            public Vote previewSaveChanges(ItemEditor itemEditor, ListView listView, int n, Object object) {
                Vote vote = Vote.APPROVE;
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    ItemEditorListener itemEditorListener = (ItemEditorListener)iterator.next();
                    vote = vote.tally(itemEditorListener.previewSaveChanges(itemEditor, listView, n, object));
                }
                return vote;
            }

            @Override
            public void saveChangesVetoed(ItemEditor itemEditor, Vote vote) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    ItemEditorListener itemEditorListener = (ItemEditorListener)iterator.next();
                    itemEditorListener.saveChangesVetoed(itemEditor, vote);
                }
            }

            @Override
            public void changesSaved(ItemEditor itemEditor, ListView listView, int n) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    ItemEditorListener itemEditorListener = (ItemEditorListener)iterator.next();
                    itemEditorListener.changesSaved(itemEditor, listView, n);
                }
            }

            @Override
            public void editCancelled(ItemEditor itemEditor, ListView listView, int n) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    ItemEditorListener itemEditorListener = (ItemEditorListener)iterator.next();
                    itemEditorListener.editCancelled(itemEditor, listView, n);
                }
            }
        }
    }

    public static interface ItemRenderer
    extends Renderer {
        public void render(Object var1, int var2, ListView var3, boolean var4, boolean var5, boolean var6, boolean var7);
    }

    public static enum SelectMode {
        NONE,
        SINGLE,
        MULTI;

    }
}

