/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuBarListener;
import org.apache.pivot.wtk.content.MenuBarItemDataRenderer;

public class MenuBar
extends Container {
    private ArrayList<Item> items = new ArrayList();
    private ItemSequence itemSequence = new ItemSequence();
    private Item activeItem = null;
    private MenuBarListenerList menuBarListeners = new MenuBarListenerList();

    public MenuBar() {
        this.installThemeSkin(MenuBar.class);
    }

    public ItemSequence getItems() {
        return this.itemSequence;
    }

    public Item getActiveItem() {
        return this.activeItem;
    }

    private void setActiveItem(Item item) {
        Item item2 = this.activeItem;
        if (item2 != item) {
            this.activeItem = item;
            this.menuBarListeners.activeItemChanged(this, item2);
        }
    }

    public void activateNextItem() {
        int n = this.items.getLength();
        int n2 = this.activeItem == null ? 0 : this.items.indexOf((Object)this.activeItem) + 1;
        while (n2 < n) {
            Item item;
            if (!(item = (Item)this.items.get(n2++)).isEnabled()) continue;
            item.setActive(true);
            break;
        }
    }

    public void activatePreviousItem() {
        int n = this.items.getLength();
        int n2 = this.activeItem == null ? n - 1 : this.items.indexOf((Object)this.activeItem) - 1;
        while (n2 >= 0) {
            Item item;
            if (!(item = (Item)this.items.get(n2--)).isEnabled()) continue;
            item.setActive(true);
            break;
        }
    }

    public ListenerList<MenuBarListener> getMenuBarListeners() {
        return this.menuBarListeners;
    }

    private static class MenuBarListenerList
    extends ListenerList<MenuBarListener>
    implements MenuBarListener {
        private MenuBarListenerList() {
        }

        @Override
        public void itemInserted(MenuBar menuBar, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MenuBarListener menuBarListener = (MenuBarListener)iterator.next();
                menuBarListener.itemInserted(menuBar, n);
            }
        }

        @Override
        public void itemsRemoved(MenuBar menuBar, int n, Sequence<Item> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MenuBarListener menuBarListener = (MenuBarListener)iterator.next();
                menuBarListener.itemsRemoved(menuBar, n, sequence);
            }
        }

        @Override
        public void activeItemChanged(MenuBar menuBar, Item item) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MenuBarListener menuBarListener = (MenuBarListener)iterator.next();
                menuBarListener.activeItemChanged(menuBar, item);
            }
        }
    }

    public final class ItemSequence
    implements Sequence<Item>,
    Iterable<Item> {
        public int add(Item item) {
            int n = this.getLength();
            this.insert(item, n);
            return n;
        }

        public void insert(Item item, int n) {
            MenuBar.this.add(item);
            MenuBar.this.items.insert((Object)item, n);
            MenuBar.this.menuBarListeners.itemInserted(MenuBar.this, n);
        }

        public Item update(int n, Item item) {
            throw new UnsupportedOperationException();
        }

        public int remove(Item item) {
            int n = MenuBar.this.items.indexOf((Object)item);
            if (n != -1) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<Item> remove(int n, int n2) {
            Sequence sequence = MenuBar.this.items.remove(n, n2);
            int n3 = sequence.getLength();
            for (int i = 0; i < n3; ++i) {
                Item item = (Item)sequence.get(i);
                item.setActive(false);
                MenuBar.this.remove(item);
            }
            MenuBar.this.menuBarListeners.itemsRemoved(MenuBar.this, n, (Sequence<Item>)sequence);
            return sequence;
        }

        public Item get(int n) {
            return (Item)MenuBar.this.items.get(n);
        }

        public int indexOf(Item item) {
            return MenuBar.this.items.indexOf((Object)item);
        }

        public int getLength() {
            return MenuBar.this.items.getLength();
        }

        @Override
        public Iterator<Item> iterator() {
            return new ImmutableIterator((Iterator)MenuBar.this.items.iterator());
        }
    }

    public static interface ItemListener {
        public void menuChanged(Item var1, Menu var2);

        public void activeChanged(Item var1);
    }

    public static class Item
    extends Button {
        private Menu menu = null;
        private boolean active = false;
        private ItemListenerList itemListeners = new ItemListenerList();
        private static final Button.DataRenderer DEFAULT_DATA_RENDERER = new MenuBarItemDataRenderer();

        public Item() {
            this(null);
        }

        public Item(Object object) {
            super(object);
            this.setDataRenderer(DEFAULT_DATA_RENDERER);
            this.installThemeSkin(Item.class);
        }

        @Override
        protected void setParent(Container container) {
            if (!(container instanceof MenuBar)) {
                throw new IllegalArgumentException("Parent must be an instance of " + MenuBar.class.getName());
            }
            this.setActive(false);
            super.setParent(container);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            if (!bl) {
                this.setActive(false);
            }
        }

        public Menu getMenu() {
            return this.menu;
        }

        public void setMenu(Menu menu) {
            if (menu != null && menu.getItem() != null) {
                throw new IllegalArgumentException("menu already belongs to an item.");
            }
            Menu menu2 = this.menu;
            if (menu2 != menu) {
                this.menu = menu;
                this.itemListeners.menuChanged(this, menu2);
            }
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean bl) {
            if (bl && (this.getParent() == null || !this.isEnabled())) {
                throw new IllegalStateException();
            }
            if (this.active != bl) {
                this.active = bl;
                MenuBar menuBar = (MenuBar)this.getParent();
                Item item = menuBar.getActiveItem();
                if (bl) {
                    menuBar.setActiveItem(this);
                    if (item != null) {
                        item.setActive(false);
                    }
                } else if (item == this) {
                    menuBar.setActiveItem(null);
                }
                this.itemListeners.activeChanged(this);
            }
        }

        @Override
        public void setToggleButton(boolean bl) {
            throw new UnsupportedOperationException("Menu bar items cannot be toggle buttons.");
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && this.menu != null;
        }

        public ListenerList<ItemListener> getItemListeners() {
            return this.itemListeners;
        }

        private static class ItemListenerList
        extends ListenerList<ItemListener>
        implements ItemListener {
            private ItemListenerList() {
            }

            @Override
            public void menuChanged(Item item, Menu menu) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    ItemListener itemListener = (ItemListener)iterator.next();
                    itemListener.menuChanged(item, menu);
                }
            }

            @Override
            public void activeChanged(Item item) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    ItemListener itemListener = (ItemListener)iterator.next();
                    itemListener.activeChanged(item);
                }
            }
        }
    }
}

