/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuButtonListener;
import org.apache.pivot.wtk.content.ButtonDataRenderer;

public class MenuButton
extends Button {
    private Menu menu = null;
    private boolean repeatable = false;
    private MenuButtonListenerList menuButtonListeners = new MenuButtonListenerList();
    private static final Button.DataRenderer DEFAULT_DATA_RENDERER = new ButtonDataRenderer();

    public MenuButton() {
        this.setDataRenderer(DEFAULT_DATA_RENDERER);
        this.installThemeSkin(MenuButton.class);
    }

    @Override
    public void setToggleButton(boolean bl) {
        throw new UnsupportedOperationException("Menu buttons cannot be toggle buttons.");
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void setMenu(Menu menu) {
        if (menu != null && menu.getItem() != null) {
            throw new IllegalArgumentException("menu already belongs to an item.");
        }
        Menu menu2 = this.menu;
        if (menu2 != menu) {
            this.menu = menu;
            this.menuButtonListeners.menuChanged(this, menu2);
        }
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public void setRepeatable(boolean bl) {
        if (this.repeatable != bl) {
            this.repeatable = bl;
            this.menuButtonListeners.repeatableChanged(this);
        }
    }

    public ListenerList<MenuButtonListener> getMenuButtonListeners() {
        return this.menuButtonListeners;
    }

    private static class MenuButtonListenerList
    extends ListenerList<MenuButtonListener>
    implements MenuButtonListener {
        private MenuButtonListenerList() {
        }

        @Override
        public void menuChanged(MenuButton menuButton, Menu menu) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MenuButtonListener menuButtonListener = (MenuButtonListener)iterator.next();
                menuButtonListener.menuChanged(menuButton, menu);
            }
        }

        @Override
        public void repeatableChanged(MenuButton menuButton) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MenuButtonListener menuButtonListener = (MenuButtonListener)iterator.next();
                menuButtonListener.repeatableChanged(menuButton);
            }
        }
    }
}

