/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuPopupListener;
import org.apache.pivot.wtk.MenuPopupStateListener;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Window;

public class MenuPopup
extends Window {
    private Menu menu;
    private boolean contextMenu = false;
    private boolean closing = false;
    private MenuPopupListenerList menuPopupListeners = new MenuPopupListenerList();
    private MenuPopupStateListenerList menuPopupStateListeners = new MenuPopupStateListenerList();

    public MenuPopup() {
        this(null);
    }

    public MenuPopup(Menu menu) {
        this.setMenu(menu);
        this.installThemeSkin(MenuPopup.class);
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void setMenu(Menu menu) {
        Menu menu2 = this.menu;
        if (menu2 != menu) {
            this.menu = menu;
            this.menuPopupListeners.menuChanged(this, menu2);
        }
    }

    public boolean isContextMenu() {
        return this.contextMenu;
    }

    public final void open(Display display, int n, int n2) {
        this.open(display, null, n, n2);
    }

    public final void open(Display display, Point point) {
        if (point == null) {
            throw new IllegalArgumentException("location is null.");
        }
        this.open(display, null, point.x, point.y);
    }

    public final void open(Window window, int n, int n2) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.open(window.getDisplay(), window, n, n2);
    }

    public final void open(Window window, Point point) {
        if (point == null) {
            throw new IllegalArgumentException("location is null.");
        }
        this.open(window, point.x, point.y);
    }

    public void open(Display display, Window window, int n, int n2) {
        this.contextMenu = true;
        this.setLocation(n, n2);
        super.open(display, window);
    }

    @Override
    public boolean isClosing() {
        return this.closing;
    }

    @Override
    public final void close() {
        this.close(false);
    }

    public void close(boolean bl) {
        if (!this.isClosed()) {
            this.closing = true;
            Vote vote = this.menuPopupStateListeners.previewMenuPopupClose(this, bl);
            if (vote == Vote.APPROVE) {
                super.close();
                this.closing = super.isClosing();
                if (this.isClosed()) {
                    this.menuPopupStateListeners.menuPopupClosed(this);
                }
            } else if (vote == Vote.DENY) {
                this.closing = false;
                this.menuPopupStateListeners.menuPopupCloseVetoed(this, vote);
            }
        }
        if (this.isClosed()) {
            this.contextMenu = false;
        }
    }

    public ListenerList<MenuPopupListener> getMenuPopupListeners() {
        return this.menuPopupListeners;
    }

    public ListenerList<MenuPopupStateListener> getMenuPopupStateListeners() {
        return this.menuPopupStateListeners;
    }

    private static class MenuPopupStateListenerList
    extends ListenerList<MenuPopupStateListener>
    implements MenuPopupStateListener {
        private MenuPopupStateListenerList() {
        }

        @Override
        public Vote previewMenuPopupClose(MenuPopup menuPopup, boolean bl) {
            Vote vote = Vote.APPROVE;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MenuPopupStateListener menuPopupStateListener = (MenuPopupStateListener)iterator.next();
                vote = vote.tally(menuPopupStateListener.previewMenuPopupClose(menuPopup, bl));
            }
            return vote;
        }

        @Override
        public void menuPopupCloseVetoed(MenuPopup menuPopup, Vote vote) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MenuPopupStateListener menuPopupStateListener = (MenuPopupStateListener)iterator.next();
                menuPopupStateListener.menuPopupCloseVetoed(menuPopup, vote);
            }
        }

        @Override
        public void menuPopupClosed(MenuPopup menuPopup) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MenuPopupStateListener menuPopupStateListener = (MenuPopupStateListener)iterator.next();
                menuPopupStateListener.menuPopupClosed(menuPopup);
            }
        }
    }

    private static class MenuPopupListenerList
    extends ListenerList<MenuPopupListener>
    implements MenuPopupListener {
        private MenuPopupListenerList() {
        }

        @Override
        public void menuChanged(MenuPopup menuPopup, Menu menu) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MenuPopupListener menuPopupListener = (MenuPopupListener)iterator.next();
                menuPopupListener.menuChanged(menuPopup, menu);
            }
        }
    }
}

