/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.MeterListener;
import org.apache.pivot.wtk.Orientation;

public class Meter
extends Component {
    private double percentage = 0.0;
    private String text = null;
    private Orientation orientation = null;
    private MeterListenerList meterListeners = new MeterListenerList();

    public Meter() {
        this(Orientation.HORIZONTAL);
    }

    public Meter(Orientation orientation) {
        this.orientation = orientation;
        this.installThemeSkin(Meter.class);
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Percentage must be a number between 0 and 1");
        }
        double d2 = this.percentage;
        if (d2 != d) {
            this.percentage = d;
            this.meterListeners.percentageChanged(this, d2);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        String string2 = this.text;
        this.text = string;
        this.meterListeners.textChanged(this, string2);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation is null.");
        }
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.meterListeners.orientationChanged(this);
        }
    }

    public void setOrientation(String string) {
        if (string == null) {
            throw new IllegalArgumentException("orientation is null.");
        }
        this.setOrientation(Orientation.valueOf(string.toUpperCase()));
    }

    public ListenerList<MeterListener> getMeterListeners() {
        return this.meterListeners;
    }

    private static class MeterListenerList
    extends ListenerList<MeterListener>
    implements MeterListener {
        private MeterListenerList() {
        }

        @Override
        public void orientationChanged(Meter meter) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MeterListener meterListener = (MeterListener)iterator.next();
                meterListener.orientationChanged(meter);
            }
        }

        @Override
        public void percentageChanged(Meter meter, double d) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MeterListener meterListener = (MeterListener)iterator.next();
                meterListener.percentageChanged(meter, d);
            }
        }

        @Override
        public void textChanged(Meter meter, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MeterListener meterListener = (MeterListener)iterator.next();
                meterListener.textChanged(meter, string);
            }
        }
    }
}

