/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import org.apache.pivot.wtk.Keyboard;

public class Platform {
    private static Object textAntialiasingHint = null;
    private static final int DEFAULT_MULTI_CLICK_INTERVAL = 400;
    private static final int DEFAULT_CURSOR_BLINK_RATE = 600;
    private static final Keyboard.Modifier COMMAND_MODIFIER;
    private static final String KEYSTROKE_MODIFIER_SEPARATOR;

    public static Object getTextAntialiasingHint() {
        if (textAntialiasingHint == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Map map = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
            if (map == null) {
                textAntialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
            } else {
                textAntialiasingHint = map.get(RenderingHints.KEY_TEXT_ANTIALIASING);
                if (textAntialiasingHint.equals(RenderingHints.VALUE_TEXT_ANTIALIAS_OFF)) {
                    textAntialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
                }
                toolkit.addPropertyChangeListener("awt.font.desktophints", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        textAntialiasingHint = null;
                    }
                });
            }
        }
        return textAntialiasingHint;
    }

    public static int getMultiClickInterval() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Integer n = (Integer)toolkit.getDesktopProperty("awt.multiClickInterval");
        if (n == null) {
            n = 400;
        }
        return n;
    }

    public static int getCursorBlinkRate() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Integer n = (Integer)toolkit.getDesktopProperty("awt.cursorBlinkRate");
        if (n == null) {
            n = 600;
        }
        return n;
    }

    public static int getDragThreshold() {
        return DragSource.getDragThreshold();
    }

    public static Keyboard.Modifier getCommandModifier() {
        return COMMAND_MODIFIER;
    }

    public static String getKeyStrokeModifierSeparator() {
        return KEYSTROKE_MODIFIER_SEPARATOR;
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("mac os x")) {
            COMMAND_MODIFIER = Keyboard.Modifier.META;
            KEYSTROKE_MODIFIER_SEPARATOR = "";
        } else {
            COMMAND_MODIFIER = Keyboard.Modifier.CTRL;
            KEYSTROKE_MODIFIER_SEPARATOR = "-";
        }
    }
}

