/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.Serializable;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;

public final class Point
implements Serializable {
    private static final long serialVersionUID = 5193175754909343769L;
    public final int x;
    public final int y;
    public static final String X_KEY = "x";
    public static final String Y_KEY = "y";

    public Point(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public Point(Point point) {
        if (point == null) {
            throw new IllegalArgumentException("point is null.");
        }
        this.x = point.x;
        this.y = point.y;
    }

    public Point(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("point is null.");
        }
        this.x = dictionary.containsKey((Object)X_KEY) ? (Integer)dictionary.get((Object)X_KEY) : 0;
        this.y = dictionary.containsKey((Object)Y_KEY) ? (Integer)dictionary.get((Object)Y_KEY) : 0;
    }

    public Point translate(int n, int n2) {
        return new Point(this.x + n, this.y + n2);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Point) {
            Point point = (Point)object;
            bl = this.x == point.x && this.y == point.y;
        }
        return bl;
    }

    public int hashCode() {
        return this.x * this.y;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.x + "," + this.y + "]";
    }

    public static Point decode(String string) {
        Point point;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        try {
            point = new Point((Dictionary<String, ?>)JSONSerializer.parseMap((String)string));
        }
        catch (SerializationException serializationException) {
            throw new IllegalArgumentException(serializationException);
        }
        return point;
    }
}

