/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ScrollPaneListener;
import org.apache.pivot.wtk.Viewport;

public class ScrollPane
extends Viewport {
    private ScrollBarPolicy horizontalScrollBarPolicy;
    private ScrollBarPolicy verticalScrollBarPolicy;
    private Component rowHeader;
    private Component columnHeader;
    private Component corner;
    private ScrollPaneListenerList scrollPaneListeners = new ScrollPaneListenerList();

    public ScrollPane() {
        this(ScrollBarPolicy.AUTO, ScrollBarPolicy.AUTO);
    }

    public ScrollPane(ScrollBarPolicy scrollBarPolicy, ScrollBarPolicy scrollBarPolicy2) {
        if (scrollBarPolicy == null) {
            throw new IllegalArgumentException("horizontalScrollBarPolicy is null");
        }
        if (scrollBarPolicy2 == null) {
            throw new IllegalArgumentException("verticalScrollBarPolicy is null");
        }
        this.horizontalScrollBarPolicy = scrollBarPolicy;
        this.verticalScrollBarPolicy = scrollBarPolicy2;
        this.installThemeSkin(ScrollPane.class);
    }

    public ScrollBarPolicy getHorizontalScrollBarPolicy() {
        return this.horizontalScrollBarPolicy;
    }

    public void setHorizontalScrollBarPolicy(ScrollBarPolicy scrollBarPolicy) {
        if (scrollBarPolicy == null) {
            throw new IllegalArgumentException("horizontalScrollBarPolicy is null");
        }
        ScrollBarPolicy scrollBarPolicy2 = this.horizontalScrollBarPolicy;
        if (scrollBarPolicy != scrollBarPolicy2) {
            this.horizontalScrollBarPolicy = scrollBarPolicy;
            this.scrollPaneListeners.horizontalScrollBarPolicyChanged(this, scrollBarPolicy2);
        }
    }

    public void setHorizontalScrollBarPolicy(String string) {
        if (string == null) {
            throw new IllegalArgumentException("horizontalScrollBarPolicy is null.");
        }
        this.setHorizontalScrollBarPolicy(ScrollBarPolicy.valueOf(string.toUpperCase()));
    }

    public ScrollBarPolicy getVerticalScrollBarPolicy() {
        return this.verticalScrollBarPolicy;
    }

    public void setVerticalScrollBarPolicy(ScrollBarPolicy scrollBarPolicy) {
        if (scrollBarPolicy == null) {
            throw new IllegalArgumentException("verticalScrollBarPolicy is null");
        }
        ScrollBarPolicy scrollBarPolicy2 = this.verticalScrollBarPolicy;
        if (scrollBarPolicy != scrollBarPolicy2) {
            this.verticalScrollBarPolicy = scrollBarPolicy;
            this.scrollPaneListeners.verticalScrollBarPolicyChanged(this, scrollBarPolicy2);
        }
    }

    public void setVerticalScrollBarPolicy(String string) {
        if (string == null) {
            throw new IllegalArgumentException("verticalScrollBarPolicy is null.");
        }
        this.setVerticalScrollBarPolicy(ScrollBarPolicy.valueOf(string.toUpperCase()));
    }

    public Component getRowHeader() {
        return this.rowHeader;
    }

    public void setRowHeader(Component component) {
        Component component2 = this.rowHeader;
        if (component != component2) {
            if (component2 != null) {
                this.remove(component2);
            }
            this.rowHeader = null;
            if (component != null) {
                if (component.getParent() != null) {
                    throw new IllegalArgumentException("Component already has a parent.");
                }
                int n = 0;
                if (this.getView() != null) {
                    ++n;
                }
                this.insert(component, n);
            }
            this.rowHeader = component;
            this.scrollPaneListeners.rowHeaderChanged(this, component2);
        }
    }

    public Component getColumnHeader() {
        return this.columnHeader;
    }

    public void setColumnHeader(Component component) {
        Component component2 = this.columnHeader;
        if (component != component2) {
            if (component2 != null) {
                this.remove(component2);
            }
            this.columnHeader = null;
            if (component != null) {
                int n = 0;
                if (this.getView() != null) {
                    ++n;
                }
                this.insert(component, n);
            }
            this.columnHeader = component;
            this.scrollPaneListeners.columnHeaderChanged(this, component2);
        }
    }

    public Component getCorner() {
        return this.corner;
    }

    public void setCorner(Component component) {
        Component component2 = this.corner;
        if (component != this.corner) {
            if (component2 != null) {
                this.remove(component2);
            }
            this.corner = null;
            if (component != null) {
                int n = 0;
                if (this.getView() != null) {
                    ++n;
                }
                if (this.rowHeader != null) {
                    ++n;
                }
                if (this.columnHeader != null) {
                    ++n;
                }
                this.insert(component, n);
            }
            this.corner = component;
            this.scrollPaneListeners.cornerChanged(this, component2);
        }
    }

    @Override
    public Sequence<Component> remove(int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            Component component = this.get(i);
            if (component != this.rowHeader && component != this.columnHeader && component != this.corner) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(n, n2);
    }

    public ListenerList<ScrollPaneListener> getScrollPaneListeners() {
        return this.scrollPaneListeners;
    }

    public static class Corner
    extends Component {
        private Placement placement;

        public Corner(Placement placement) {
            if (placement == null) {
                throw new IllegalArgumentException("Placement is null.");
            }
            this.placement = placement;
            this.installThemeSkin(Corner.class);
        }

        public Placement getPlacement() {
            return this.placement;
        }

        public static enum Placement {
            TOP_LEFT,
            BOTTOM_LEFT,
            BOTTOM_RIGHT,
            TOP_RIGHT;

        }
    }

    private static class ScrollPaneListenerList
    extends ListenerList<ScrollPaneListener>
    implements ScrollPaneListener {
        private ScrollPaneListenerList() {
        }

        @Override
        public void horizontalScrollBarPolicyChanged(ScrollPane scrollPane, ScrollBarPolicy scrollBarPolicy) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ScrollPaneListener scrollPaneListener = (ScrollPaneListener)iterator.next();
                scrollPaneListener.horizontalScrollBarPolicyChanged(scrollPane, scrollBarPolicy);
            }
        }

        @Override
        public void verticalScrollBarPolicyChanged(ScrollPane scrollPane, ScrollBarPolicy scrollBarPolicy) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ScrollPaneListener scrollPaneListener = (ScrollPaneListener)iterator.next();
                scrollPaneListener.verticalScrollBarPolicyChanged(scrollPane, scrollBarPolicy);
            }
        }

        @Override
        public void rowHeaderChanged(ScrollPane scrollPane, Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ScrollPaneListener scrollPaneListener = (ScrollPaneListener)iterator.next();
                scrollPaneListener.rowHeaderChanged(scrollPane, component);
            }
        }

        @Override
        public void columnHeaderChanged(ScrollPane scrollPane, Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ScrollPaneListener scrollPaneListener = (ScrollPaneListener)iterator.next();
                scrollPaneListener.columnHeaderChanged(scrollPane, component);
            }
        }

        @Override
        public void cornerChanged(ScrollPane scrollPane, Component component) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ScrollPaneListener scrollPaneListener = (ScrollPaneListener)iterator.next();
                scrollPaneListener.cornerChanged(scrollPane, component);
            }
        }
    }

    public static enum ScrollBarPolicy {
        AUTO,
        NEVER,
        ALWAYS,
        FILL,
        FILL_TO_CAPACITY;

    }
}

