/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.SheetCloseListener;
import org.apache.pivot.wtk.SheetStateListener;
import org.apache.pivot.wtk.Window;

public class Sheet
extends Window {
    private SheetCloseListener sheetCloseListener = null;
    private boolean result = false;
    private boolean closing = false;
    private SheetStateListenerList sheetStateListeners = new SheetStateListenerList();

    public Sheet() {
        this(null);
    }

    public Sheet(Component component) {
        super(component);
        this.installThemeSkin(Sheet.class);
    }

    public final void open(Window window, SheetCloseListener sheetCloseListener) {
        if (window == null) {
            throw new IllegalArgumentException("owner is null");
        }
        this.open(window.getDisplay(), window, sheetCloseListener);
    }

    @Override
    public final void open(Display display, Window window) {
        this.open(display, window, null);
    }

    public void open(Display display, Window window, SheetCloseListener sheetCloseListener) {
        if (window == null) {
            throw new IllegalArgumentException("Sheets must have an owner.");
        }
        super.open(display, window);
        if (this.isOpen()) {
            this.sheetCloseListener = sheetCloseListener;
        }
    }

    @Override
    public boolean isClosing() {
        return this.closing;
    }

    @Override
    public final void close() {
        this.close(false);
    }

    public void close(boolean bl) {
        if (!this.isClosed()) {
            this.closing = true;
            Vote vote = this.sheetStateListeners.previewSheetClose(this, bl);
            if (vote == Vote.APPROVE) {
                Window window = this.getOwner();
                super.close();
                this.closing = super.isClosing();
                if (this.isClosed()) {
                    this.result = bl;
                    if (window.isOpen()) {
                        window.moveToFront();
                    }
                    this.sheetStateListeners.sheetClosed(this);
                    if (this.sheetCloseListener != null) {
                        this.sheetCloseListener.sheetClosed(this);
                        this.sheetCloseListener = null;
                    }
                }
            } else {
                if (vote == Vote.DENY) {
                    this.closing = false;
                }
                this.sheetStateListeners.sheetCloseVetoed(this, vote);
            }
        }
    }

    public SheetCloseListener getSheetCloseListener() {
        return this.sheetCloseListener;
    }

    public boolean getResult() {
        return this.result;
    }

    public ListenerList<SheetStateListener> getSheetStateListeners() {
        return this.sheetStateListeners;
    }

    private static class SheetStateListenerList
    extends ListenerList<SheetStateListener>
    implements SheetStateListener {
        private SheetStateListenerList() {
        }

        @Override
        public Vote previewSheetClose(Sheet sheet, boolean bl) {
            Vote vote = Vote.APPROVE;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SheetStateListener sheetStateListener = (SheetStateListener)iterator.next();
                vote = vote.tally(sheetStateListener.previewSheetClose(sheet, bl));
            }
            return vote;
        }

        @Override
        public void sheetCloseVetoed(Sheet sheet, Vote vote) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SheetStateListener sheetStateListener = (SheetStateListener)iterator.next();
                sheetStateListener.sheetCloseVetoed(sheet, vote);
            }
        }

        @Override
        public void sheetClosed(Sheet sheet) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SheetStateListener sheetStateListener = (SheetStateListener)iterator.next();
                sheetStateListener.sheetClosed(sheet);
            }
        }
    }
}

