/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;

public final class Span {
    public final int start;
    public final int end;
    public static final String START_KEY = "start";
    public static final String END_KEY = "end";

    public Span(int n) {
        this.start = n;
        this.end = n;
    }

    public Span(int n, int n2) {
        this.start = n;
        this.end = n2;
    }

    public Span(Span span) {
        if (span == null) {
            throw new IllegalArgumentException("span is null.");
        }
        this.start = span.start;
        this.end = span.end;
    }

    public Span(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("span is null.");
        }
        if (!dictionary.containsKey((Object)START_KEY)) {
            throw new IllegalArgumentException("start is required.");
        }
        if (!dictionary.containsKey((Object)END_KEY)) {
            throw new IllegalArgumentException("end is required.");
        }
        this.start = (Integer)dictionary.get((Object)START_KEY);
        this.end = (Integer)dictionary.get((Object)END_KEY);
    }

    public long getLength() {
        return Math.abs(this.end - this.start) + 1;
    }

    public boolean contains(Span span) {
        if (span == null) {
            throw new IllegalArgumentException("span is null.");
        }
        Span span2 = span.normalize();
        boolean bl = this.start < this.end ? this.start <= span2.start && this.end >= span2.end : this.end <= span2.start && this.start >= span2.end;
        return bl;
    }

    public boolean intersects(Span span) {
        if (span == null) {
            throw new IllegalArgumentException("span is null.");
        }
        Span span2 = span.normalize();
        boolean bl = this.start < this.end ? this.start <= span2.end && this.end >= span2.start : this.end <= span2.end && this.start >= span2.start;
        return bl;
    }

    public Span intersect(Span span) {
        if (span == null) {
            throw new IllegalArgumentException("span is null.");
        }
        Span span2 = null;
        if (this.intersects(span)) {
            span2 = new Span(Math.max(this.start, span.start), Math.min(this.end, span.end));
        }
        return span2;
    }

    public Span union(Span span) {
        if (span == null) {
            throw new IllegalArgumentException("span is null.");
        }
        return new Span(Math.min(this.start, span.start), Math.max(this.end, span.end));
    }

    public Span normalize() {
        return new Span(Math.min(this.start, this.end), Math.max(this.start, this.end));
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Span) {
            Span span = (Span)object;
            bl = this.start == span.start && this.end == span.end;
        }
        return bl;
    }

    public int hashCode() {
        return 31 * this.start + this.end;
    }

    public String toString() {
        return "{start: " + this.start + ", end: " + this.end + "}";
    }

    public static Span decode(String string) {
        Span span;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.startsWith("{")) {
            try {
                span = new Span((Dictionary<String, ?>)JSONSerializer.parseMap((String)string));
            }
            catch (SerializationException serializationException) {
                throw new IllegalArgumentException(serializationException);
            }
        } else {
            span = new Span(Integer.parseInt(string));
        }
        return span;
    }
}

